# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2017-09-25 06:46
from __future__ import unicode_literals

from django.db import migrations, models
import django.utils.timezone

from silver.utils.dates import last_day_of_month, prev_month, ONE_DAY


def fill_billing_log_billed_up_to_fields(apps, schema_editor):
    # this tries to fill a subscription's billinglogs plan_billed_up_to and
    # metered_features_billed_up_to fields with somewhat sane values

    BillingLog = apps.get_model('silver', 'BillingLog')
    db_alias = schema_editor.connection.alias

    for billing_log in BillingLog.objects.using(db_alias).all():
        subscription = billing_log.subscription
        billing_date = billing_log.billing_date

        plan_billed_up_to = last_day_of_month(billing_date)
        metered_features_billed_up_to = last_day_of_month(prev_month(billing_date))

        if subscription.trial_end:
            if billing_date == subscription.trial_end + ONE_DAY:
                if subscription.start_date.month != subscription.trial_end.month:
                    metered_features_billed_up_to = subscription.trial_end

        if subscription.cancel_date:
            if billing_date == subscription.cancel_date:
                plan_billed_up_to = subscription.cancel_date
                metered_features_billed_up_to = subscription.cancel_date

        if subscription.ended_at:
            if billing_date == subscription.ended_at:
                plan_billed_up_to = subscription.ended_at
                metered_features_billed_up_to = subscription.ended_at

        billing_log.plan_billed_up_to = plan_billed_up_to
        billing_log.metered_features_billed_up_to = metered_features_billed_up_to
        billing_log.save(using=db_alias)


class Migration(migrations.Migration):

    dependencies = [
        ('silver', '0039_auto_20170811_1101'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='paymentmethod',
            options={'ordering': ['-id']},
        ),
        migrations.AlterModelOptions(
            name='transaction',
            options={'ordering': ['-id']},
        ),
        migrations.AddField(
            model_name='billinglog',
            name='metered_features_billed_up_to',
            field=models.DateField(default=django.utils.timezone.now, help_text=b'The date up to which the metered features have been billed.'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='billinglog',
            name='plan_billed_up_to',
            field=models.DateField(default=django.utils.timezone.now, help_text=b'The date up to which the plan base amount has been billed.'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='provider',
            name='generate_documents_on_trial_end',
            field=models.BooleanField(default=True,
                                      help_text=b'If this is set to True, then billing documents will be generated when the subscription trial ends, instead of waiting for the end of the billing cycle.'),
        ),
        migrations.AddField(
            model_name='provider',
            name='prebill_plan',
            field=models.BooleanField(default=True,
                                      help_text=b'If this is set to True, then the plan base amount will be billed at thebeginning of the billing cycle rather than after the end.'),
        ),
        migrations.AddField(
            model_name='provider',
            name='separate_cycles_during_trial',
            field=models.BooleanField(default=False,
                                      help_text=b'If this is set to True, then the trial period cycle will be split if it spans across multiple billing intervals.'),
        ),
        migrations.AddField(
            model_name='plan',
            name='generate_documents_on_trial_end',
            field=models.NullBooleanField(help_text=b'If this is set to True, then billing documents will be generated when the subscription trial ends, instead of waiting for the end of the billing cycle.'),
        ),
        migrations.AddField(
            model_name='plan',
            name='separate_cycles_during_trial',
            field=models.NullBooleanField(help_text=b'If this is set to True, then the trial period cycle will be split if it spans across multiple billing intervals.'),
        ),
        migrations.AlterField(
            model_name='paymentmethod',
            name='payment_processor',
            field=models.CharField(choices=[(b'manual', b'manual'), (b'failing_void', b'failing_void'), (b'triggered', b'triggered')], max_length=256),
        ),
        migrations.AddField(
            model_name='plan',
            name='prebill_plan',
            field=models.NullBooleanField(help_text=b'If this is set to True, then the plan base amount will be billed at thebeginning of the billing cycle rather than after the end.'),
        ),
        migrations.RunPython(fill_billing_log_billed_up_to_fields, migrations.RunPython.noop)
    ]
