from setuptools import setup, find_packages
import cfl 

# TODO: right now, only cfl/ and visual_bars/ are packaged for installation 
# eventually, we may want to package more things (docs and/or examples and/or
# unit tests )
VERSION = cfl.__version__
AUTHORS = cfl.__author__
CONTACT = 'iwahle@caltech.edu'

setup(
    name='cfl', 
    version=VERSION, 
    description='Causal Feature Learning (CFL) is an unsupervised algorithm designed to construct macro-variables from low-level data, while maintaining the causal relationships between these macro-variables. ', #TODO: one sentence summary 
    long_description='See cfl.readthedocs.io for a full description', 
    url='https://github.com/eberharf/cfl',
    author=AUTHORS,
    author_email = CONTACT, 
    packages=find_packages(), #package main cfl package and visual bars (find_packages() returns a list of any folder with an __init__ file) 
    #TODO: ^ do we package other stuff too?  
    python_requires = ">=3.7",  #TODO: good? it probably works with 3.6 too ...
    install_requires=[ #TODO: this list contains semi-redundant information with requirements.yml
        'tqdm',
        'matplotlib',
        'tensorflow==2', 
        'numpy>=1.19.2', 
        'scikit-learn>=0.23',
        'jupyter', # for jupyter notebooks
        'ipykernel',
        'joblib==0.16.0'
        ], 

    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Science/Research',
        'License :: Free for non-commercial use',
        # 'Operating System  :: MacOS :: MacOS X',
        # 'Operating System :: Microsoft :: Windows :: Windows 10',
        'Programming Language :: Python :: 3.7', # TODO: other versions? 
        'Programming Language :: Python :: 3.8',  
        'Programming Language :: Python :: 3.9', 
        'Topic :: Scientific/Engineering',
        'Topic :: Scientific/Engineering :: Mathematics',
        'Topic :: Scientific/Engineering :: Artificial Intelligence' #TODO: are these topics appropriate classifiers ?
    ],
)