from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.5'
DESCRIPTION = 'Restoring MySQL Databases from their backups'
LONG_DESCRIPTION = 'Resurrector helps you to restore your backed-up MySQL Databases to any specified instance.'

# Setting up
setup(
    name="resurrector",
    version=VERSION,
    author="rexshijaku (Rexhep Shijaku)",
    author_email="<rexhepshijaku@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=['resurrector'],
    install_requires=[],
    keywords=['python', 'mysql', 'database', 'backup', 'restore'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)