"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRouteIntegration = exports.HttpIntegration = exports.PayloadFormatVersion = exports.HttpConnectionType = exports.IntegrationCredentials = exports.HttpIntegrationSubtype = exports.HttpIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is an HTTP proxy.
     *
     * For integrating the route or method request with an HTTP endpoint, with the
     * client request passed through as-is. This is also referred to as HTTP proxy
     * integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
    /**
     * Integration type is an AWS proxy.
     *
     * For integrating the route or method request with a Lambda function or other
     * AWS service action. This integration is also referred to as a Lambda proxy
     * integration.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Supported integration subtypes
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html
 */
var HttpIntegrationSubtype;
(function (HttpIntegrationSubtype) {
    /**
     * EventBridge PutEvents integration
     */
    HttpIntegrationSubtype["EVENTBRIDGE_PUT_EVENTS"] = "EventBridge-PutEvents";
    /**
     * SQS SendMessage integration
     */
    HttpIntegrationSubtype["SQS_SEND_MESSAGE"] = "SQS-SendMessage";
    /**
     * SQS ReceiveMessage integration,
     */
    HttpIntegrationSubtype["SQS_RECEIVE_MESSAGE"] = "SQS-ReceiveMessage";
    /**
     * SQS DeleteMessage integration,
     */
    HttpIntegrationSubtype["SQS_DELETE_MESSAGE"] = "SQS-DeleteMessage";
    /**
     * SQS PurgeQueue integration
     */
    HttpIntegrationSubtype["SQS_PURGE_QUEUE"] = "SQS-PurgeQueue";
    /**
     * AppConfig GetConfiguration integration
     */
    HttpIntegrationSubtype["APPCONFIG_GET_CONFIGURATION"] = "AppConfig-GetConfiguration";
    /**
     * Kinesis PutRecord integration
     */
    HttpIntegrationSubtype["KINESIS_PUT_RECORD"] = "Kinesis-PutRecord";
    /**
     * Step Functions StartExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_EXECUTION"] = "StepFunctions-StartExecution";
    /**
     * Step Functions StartSyncExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_START_SYNC_EXECUTION"] = "StepFunctions-StartSyncExecution";
    /**
     * Step Functions StopExecution integration
     */
    HttpIntegrationSubtype["STEPFUNCTIONS_STOP_EXECUTION"] = "StepFunctions-StopExecution";
})(HttpIntegrationSubtype = exports.HttpIntegrationSubtype || (exports.HttpIntegrationSubtype = {}));
/**
 * Credentials used for AWS Service integrations.
 */
class IntegrationCredentials {
    /**
     * Use the specified role for integration requests
     */
    static fromRole(role) {
        return { credentialsArn: role.roleArn };
    }
    /** Use the calling user's identity to call the integration */
    static useCallerIdentity() {
        return { credentialsArn: 'arn:aws:iam::*:user/*' };
    }
}
exports.IntegrationCredentials = IntegrationCredentials;
_a = JSII_RTTI_SYMBOL_1;
IntegrationCredentials[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.IntegrationCredentials", version: "1.148.0" };
/**
 * Supported connection types
 */
var HttpConnectionType;
(function (HttpConnectionType) {
    /**
     * For private connections between API Gateway and resources in a VPC
     */
    HttpConnectionType["VPC_LINK"] = "VPC_LINK";
    /**
     * For connections through public routable internet
     */
    HttpConnectionType["INTERNET"] = "INTERNET";
})(HttpConnectionType = exports.HttpConnectionType || (exports.HttpConnectionType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
_b = JSII_RTTI_SYMBOL_1;
PayloadFormatVersion[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.PayloadFormatVersion", version: "1.148.0" };
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        var _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpIntegrationProps(props);
        if (!props.integrationSubtype && !props.integrationUri) {
            throw new Error('Either `integrationSubtype` or `integrationUri` must be specified.');
        }
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.apiId,
            integrationType: props.integrationType,
            integrationSubtype: props.integrationSubtype,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            connectionId: props.connectionId,
            connectionType: props.connectionType,
            payloadFormatVersion: (_e = props.payloadFormatVersion) === null || _e === void 0 ? void 0 : _e.version,
            requestParameters: (_f = props.parameterMapping) === null || _f === void 0 ? void 0 : _f.mappings,
            credentialsArn: (_g = props.credentials) === null || _g === void 0 ? void 0 : _g.credentialsArn,
        });
        if (props.secureServerName) {
            integ.tlsConfig = {
                serverNameToVerify: props.secureServerName,
            };
        }
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
_c = JSII_RTTI_SYMBOL_1;
HttpIntegration[_c] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpIntegration", version: "1.148.0" };
/**
 * The interface that various route integration classes will inherit.
 */
class HttpRouteIntegration {
    /**
     * Initialize an integration for a route on http api.
     * @param id id of the underlying `HttpIntegration` construct.
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.httpApi.node.addr !== options.route.httpApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new HttpIntegration(options.scope, this.id, {
                httpApi: options.route.httpApi,
                integrationType: config.type,
                integrationSubtype: config.subtype,
                integrationUri: config.uri,
                method: config.method,
                connectionId: config.connectionId,
                connectionType: config.connectionType,
                payloadFormatVersion: config.payloadFormatVersion,
                secureServerName: config.secureServerName,
                parameterMapping: config.parameterMapping,
                credentials: config.credentials,
            });
        }
        this.completeBind(options);
        return { integrationId: this.integration.integrationId };
    }
    /**
     * Complete the binding of the integration to the route. In some cases, there is
     * some additional work to do, such as adding permissions for the API to access
     * the target. This work is necessary whether the integration has just been
     * created for this route or it is an existing one, previously created for other
     * routes. In most cases, however, concrete implementations do not need to
     * override this method.
     */
    completeBind(_options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_HttpRouteIntegrationBindOptions(_options);
    }
}
exports.HttpRouteIntegration = HttpRouteIntegration;
_d = JSII_RTTI_SYMBOL_1;
HttpRouteIntegration[_d] = { fqn: "@aws-cdk/aws-apigatewayv2.HttpRouteIntegration", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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