"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3EventSource = void 0;
const notifs = require("@aws-cdk/aws-s3-notifications");
/**
 * Use S3 bucket notifications as an event source for AWS Lambda.
 *
 * @stability stable
 */
class S3EventSource {
    /**
     * @stability stable
     */
    constructor(bucket, props) {
        this.bucket = bucket;
        this.props = props;
    }
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target) {
        const filters = this.props.filters || [];
        for (const event of this.props.events) {
            this.bucket.addEventNotification(event, new notifs.LambdaDestination(target), ...filters);
        }
    }
}
exports.S3EventSource = S3EventSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzMy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSx3REFBd0Q7Ozs7OztBQW9CeEQsTUFBYSxhQUFhOzs7O0lBQ3hCLFlBQXFCLE1BQWlCLEVBQW1CLEtBQXlCO1FBQTdELFdBQU0sR0FBTixNQUFNLENBQVc7UUFBbUIsVUFBSyxHQUFMLEtBQUssQ0FBb0I7SUFFbEYsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE1BQXdCO1FBQ2xDLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxJQUFJLEVBQUUsQ0FBQztRQUN6QyxLQUFLLE1BQU0sS0FBSyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFO1lBQ3JDLElBQUksQ0FBQyxNQUFNLENBQUMsb0JBQW9CLENBQUMsS0FBSyxFQUFFLElBQUksTUFBTSxDQUFDLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxFQUFFLEdBQUcsT0FBTyxDQUFDLENBQUM7U0FDM0Y7SUFDSCxDQUFDO0NBQ0Y7QUFYRCxzQ0FXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHMzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQgKiBhcyBub3RpZnMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzLW5vdGlmaWNhdGlvbnMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFMzRXZlbnRTb3VyY2VQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBldmVudHM6IHMzLkV2ZW50VHlwZVtdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZpbHRlcnM/OiBzMy5Ob3RpZmljYXRpb25LZXlGaWx0ZXJbXTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFMzRXZlbnRTb3VyY2UgaW1wbGVtZW50cyBsYW1iZGEuSUV2ZW50U291cmNlIHtcbiAgY29uc3RydWN0b3IocmVhZG9ubHkgYnVja2V0OiBzMy5CdWNrZXQsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFMzRXZlbnRTb3VyY2VQcm9wcykge1xuXG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgICBjb25zdCBmaWx0ZXJzID0gdGhpcy5wcm9wcy5maWx0ZXJzIHx8IFtdO1xuICAgIGZvciAoY29uc3QgZXZlbnQgb2YgdGhpcy5wcm9wcy5ldmVudHMpIHtcbiAgICAgIHRoaXMuYnVja2V0LmFkZEV2ZW50Tm90aWZpY2F0aW9uKGV2ZW50LCBuZXcgbm90aWZzLkxhbWJkYURlc3RpbmF0aW9uKHRhcmdldCksIC4uLmZpbHRlcnMpO1xuICAgIH1cbiAgfVxufVxuIl19