"""Diagnostic equipments configuration."""
from copy import deepcopy as _dcopy


def get_dict():
    """Return configuration type dictionary."""
    module_name = __name__.split('.')[-1]
    _dict = {
        'config_type_name': module_name,
        'value': _dcopy(_template_dict),
        'check': False
    }
    return _dict


_li_diags = [
    # Screens
    ['LA-BI:PRF1:CAM:AcquireTime', 0.001, 0],
    ['LA-BI:PRF1:CAM:Gain', 0, 0],
    ['LA-BI:PRF1:CAL:CentroidThreshold', 0, 0],
    ['LA-BI:PRF1:ROI:MinX_', 0, 0],
    ['LA-BI:PRF1:ROI:MinY_', 0, 0],
    ['LA-BI:PRF1:X:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF1:Y:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF2:CAM:AcquireTime', 0.001, 0],
    ['LA-BI:PRF2:CAM:Gain', 0, 0],
    ['LA-BI:PRF2:CAL:CentroidThreshold', 0, 0],
    ['LA-BI:PRF2:ROI:MinX_', 0, 0],
    ['LA-BI:PRF2:ROI:MinY_', 0, 0],
    ['LA-BI:PRF2:X:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF2:Y:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF3:CAM:AcquireTime', 0.001, 0],
    ['LA-BI:PRF3:CAM:Gain', 0, 0],
    ['LA-BI:PRF3:CAL:CentroidThreshold', 0, 0],
    ['LA-BI:PRF3:ROI:MinX_', 0, 0],
    ['LA-BI:PRF3:ROI:MinY_', 0, 0],
    ['LA-BI:PRF3:X:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF3:Y:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF4:CAM:AcquireTime', 0.001, 0],
    ['LA-BI:PRF4:CAM:Gain', 0, 0],
    ['LA-BI:PRF4:CAL:CentroidThreshold', 0, 0],
    ['LA-BI:PRF4:ROI:MinX_', 0, 0],
    ['LA-BI:PRF4:ROI:MinY_', 0, 0],
    ['LA-BI:PRF4:X:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF4:Y:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF5:CAM:AcquireTime', 0.001, 0],
    ['LA-BI:PRF5:CAM:Gain', 0, 0],
    ['LA-BI:PRF5:CAL:CentroidThreshold', 0, 0],
    ['LA-BI:PRF5:ROI:MinX_', 0, 0],
    ['LA-BI:PRF5:ROI:MinY_', 0, 0],
    ['LA-BI:PRF5:X:Gauss:Coef', 0.0, 0],
    ['LA-BI:PRF5:Y:Gauss:Coef', 0.0, 0],

    # BPMs
    ['LA-BI:BPM2:FFT_CENTER', 0, 0],
    ['LA-BI:BPM2:FFT_WIDTH', 0, 0],
    ['LA-BI:BPM2:HIB_CENTER', 0, 0],
    ['LA-BI:BPM2:HIB_WIDTH', 0, 0],
    ['LA-BI:BPM2:POS_KX', 0, 0],
    ['LA-BI:BPM2:POS_KY', 0, 0],
    ['LA-BI:BPM2:POS_KS', 0, 0],
    ['LA-BI:BPM2:POS_OX', 0, 0],
    ['LA-BI:BPM2:POS_OY', 0, 0],
    ['LA-BI:BPM2:FE_ATTEN_SP', 0, 0],
    ['LA-BI:BPM2:ADC_THD', 0, 0],
    ['LA-BI:BPM2:ACQ_TRIGGER', 0, 0],
    ['LA-BI:BPM2:POS_ALG', 0, 0],
    ['LA-BI:BPM2:BPM_STRIP', 0, 0],
    ['LA-BI:BPM2:OPI:SEL', 0, 0],
    # ['LA-BI:BPM3:FFT_CENTER', 0, 0],
    # ['LA-BI:BPM3:FFT_WIDTH', 0, 0],
    # ['LA-BI:BPM3:HIB_CENTER', 0, 0],
    # ['LA-BI:BPM3:HIB_WIDTH', 0, 0],
    # ['LA-BI:BPM3:POS_KX', 0, 0],
    # ['LA-BI:BPM3:POS_KY', 0, 0],
    # ['LA-BI:BPM3:POS_KS', 0, 0],
    # ['LA-BI:BPM3:POS_OX', 0, 0],
    # ['LA-BI:BPM3:POS_OY', 0, 0],
    # ['LA-BI:BPM3:FE_ATTEN_SP', 0, 0],
    # ['LA-BI:BPM3:ADC_THD', 0, 0],
    # ['LA-BI:BPM3:ACQ_TRIGGER', 0, 0],
    # ['LA-BI:BPM3:POS_ALG', 0, 0],
    # ['LA-BI:BPM3:BPM_STRIP', 0, 0],
    # ['LA-BI:BPM3:OPI:SEL', 0, 0],
]

_amcfpgaevrs = [
    'IA-01RaBPM:TI-AMCFPGAEVR:',
    'IA-02RaBPM:TI-AMCFPGAEVR:',
    'IA-03RaBPM:TI-AMCFPGAEVR:',
    'IA-04RaBPM:TI-AMCFPGAEVR:',
    'IA-05RaBPM:TI-AMCFPGAEVR:',
    'IA-06RaBPM:TI-AMCFPGAEVR:',
    'IA-07RaBPM:TI-AMCFPGAEVR:',
    'IA-08RaBPM:TI-AMCFPGAEVR:',
    'IA-09RaBPM:TI-AMCFPGAEVR:',
    'IA-10RaBPM:TI-AMCFPGAEVR:',
    'IA-11RaBPM:TI-AMCFPGAEVR:',
    'IA-12RaBPM:TI-AMCFPGAEVR:',
    'IA-13RaBPM:TI-AMCFPGAEVR:',
    'IA-14RaBPM:TI-AMCFPGAEVR:',
    'IA-15RaBPM:TI-AMCFPGAEVR:',
    'IA-16RaBPM:TI-AMCFPGAEVR:',
    'IA-17RaBPM:TI-AMCFPGAEVR:',
    'IA-18RaBPM:TI-AMCFPGAEVR:',
    'IA-19RaBPM:TI-AMCFPGAEVR:',
    'IA-20RaBPM:TI-AMCFPGAEVR:',
    'IA-20RaBPMTL:TI-AMCFPGAEVR:',
    ]
_amcfpgaevr_amcs = ['AMC2', 'AMC3', 'AMC4', 'AMC5', 'AMC6', 'AMC7']
_amcfpgaevr_propts = [
    ['State-Sel', 1, 0.0],
    ['Src-Sel', 3, 0.0],
    ['Dir-Sel', 0, 0.0],
    ['Evt-SP', 0, 0.0],
    ['WidthRaw-SP', 1, 0.0],
    ['Polarity-Sel', 0, 0.0],
    ['NrPulses-SP', 1, 0.0],
    ['DelayRaw-SP', 1, 0.0],
    ]
_amcfpgaevr_pvs = list()
for dev in _amcfpgaevrs:
    for amc in _amcfpgaevr_amcs:
        for ppt, val, dly in _amcfpgaevr_propts:
            _amcfpgaevr_pvs.append([dev+amc+ppt, val, dly])

_bpms = [
    'TB-01:DI-BPM-1',
    'TB-01:DI-BPM-2',
    'TB-02:DI-BPM-1',
    'TB-02:DI-BPM-2',
    'TB-03:DI-BPM',
    'TB-04:DI-BPM',
    'BO-02U:DI-BPM',
    'BO-03U:DI-BPM',
    'BO-04U:DI-BPM',
    'BO-05U:DI-BPM',
    'BO-06U:DI-BPM',
    'BO-07U:DI-BPM',
    'BO-08U:DI-BPM',
    'BO-09U:DI-BPM',
    'BO-10U:DI-BPM',
    'BO-11U:DI-BPM',
    'BO-12U:DI-BPM',
    'BO-13U:DI-BPM',
    'BO-14U:DI-BPM',
    'BO-15U:DI-BPM',
    'BO-16U:DI-BPM',
    'BO-17U:DI-BPM',
    'BO-18U:DI-BPM',
    'BO-19U:DI-BPM',
    'BO-20U:DI-BPM',
    'BO-21U:DI-BPM',
    'BO-22U:DI-BPM',
    'BO-23U:DI-BPM',
    'BO-24U:DI-BPM',
    'BO-25U:DI-BPM',
    'BO-26U:DI-BPM',
    'BO-27U:DI-BPM',
    'BO-28U:DI-BPM',
    'BO-29U:DI-BPM',
    'BO-30U:DI-BPM',
    'BO-31U:DI-BPM',
    'BO-32U:DI-BPM',
    'BO-33U:DI-BPM',
    'BO-34U:DI-BPM',
    'BO-35U:DI-BPM',
    'BO-36U:DI-BPM',
    'BO-37U:DI-BPM',
    'BO-38U:DI-BPM',
    'BO-39U:DI-BPM',
    'BO-40U:DI-BPM',
    'BO-41U:DI-BPM',
    'BO-42U:DI-BPM',
    'BO-43U:DI-BPM',
    'BO-44U:DI-BPM',
    'BO-45U:DI-BPM',
    'BO-46U:DI-BPM',
    'BO-47U:DI-BPM',
    'BO-48U:DI-BPM',
    'BO-49U:DI-BPM',
    'BO-50U:DI-BPM',
    'BO-01U:DI-BPM',
    'TS-01:DI-BPM',
    'TS-02:DI-BPM',
    'TS-03:DI-BPM',
    'TS-04:DI-BPM-1',
    'TS-04:DI-BPM-2',
    'SI-01M2:DI-BPM',
    'SI-01C1:DI-BPM-1',
    'SI-01C1:DI-BPM-2',
    'SI-01C2:DI-BPM',
    'SI-01C3:DI-BPM-1',
    'SI-01C3:DI-BPM-2',
    'SI-01C4:DI-BPM',
    'SI-02M1:DI-BPM',
    'SI-02M2:DI-BPM',
    'SI-02C1:DI-BPM-1',
    'SI-02C1:DI-BPM-2',
    'SI-02C2:DI-BPM',
    'SI-02C3:DI-BPM-1',
    'SI-02C3:DI-BPM-2',
    'SI-02C4:DI-BPM',
    'SI-03M1:DI-BPM',
    'SI-03M2:DI-BPM',
    'SI-03C1:DI-BPM-1',
    'SI-03C1:DI-BPM-2',
    'SI-03C2:DI-BPM',
    'SI-03C3:DI-BPM-1',
    'SI-03C3:DI-BPM-2',
    'SI-03C4:DI-BPM',
    'SI-04M1:DI-BPM',
    'SI-04M2:DI-BPM',
    'SI-04C1:DI-BPM-1',
    'SI-04C1:DI-BPM-2',
    'SI-04C2:DI-BPM',
    'SI-04C3:DI-BPM-1',
    'SI-04C3:DI-BPM-2',
    'SI-04C4:DI-BPM',
    'SI-05M1:DI-BPM',
    'SI-05M2:DI-BPM',
    'SI-05C1:DI-BPM-1',
    'SI-05C1:DI-BPM-2',
    'SI-05C2:DI-BPM',
    'SI-05C3:DI-BPM-1',
    'SI-05C3:DI-BPM-2',
    'SI-05C4:DI-BPM',
    'SI-06M1:DI-BPM',
    'SI-06M2:DI-BPM',
    'SI-06C1:DI-BPM-1',
    'SI-06C1:DI-BPM-2',
    'SI-06C2:DI-BPM',
    'SI-06C3:DI-BPM-1',
    'SI-06C3:DI-BPM-2',
    'SI-06C4:DI-BPM',
    'SI-07M1:DI-BPM',
    'SI-07M2:DI-BPM',
    'SI-07C1:DI-BPM-1',
    'SI-07C1:DI-BPM-2',
    'SI-07C2:DI-BPM',
    'SI-07C3:DI-BPM-1',
    'SI-07C3:DI-BPM-2',
    'SI-07C4:DI-BPM',
    'SI-08M1:DI-BPM',
    'SI-08M2:DI-BPM',
    'SI-08C1:DI-BPM-1',
    'SI-08C1:DI-BPM-2',
    'SI-08C2:DI-BPM',
    'SI-08C3:DI-BPM-1',
    'SI-08C3:DI-BPM-2',
    'SI-08C4:DI-BPM',
    'SI-09M1:DI-BPM',
    'SI-09M2:DI-BPM',
    'SI-09C1:DI-BPM-1',
    'SI-09C1:DI-BPM-2',
    'SI-09C2:DI-BPM',
    'SI-09C3:DI-BPM-1',
    'SI-09C3:DI-BPM-2',
    'SI-09C4:DI-BPM',
    'SI-10M1:DI-BPM',
    'SI-10M2:DI-BPM',
    'SI-10C1:DI-BPM-1',
    'SI-10C1:DI-BPM-2',
    'SI-10C2:DI-BPM',
    'SI-10C3:DI-BPM-1',
    'SI-10C3:DI-BPM-2',
    'SI-10C4:DI-BPM',
    'SI-11M1:DI-BPM',
    'SI-11M2:DI-BPM',
    'SI-11C1:DI-BPM-1',
    'SI-11C1:DI-BPM-2',
    'SI-11C2:DI-BPM',
    'SI-11C3:DI-BPM-1',
    'SI-11C3:DI-BPM-2',
    'SI-11C4:DI-BPM',
    'SI-12M1:DI-BPM',
    'SI-12M2:DI-BPM',
    'SI-12C1:DI-BPM-1',
    'SI-12C1:DI-BPM-2',
    'SI-12C2:DI-BPM',
    'SI-12C3:DI-BPM-1',
    'SI-12C3:DI-BPM-2',
    'SI-12C4:DI-BPM',
    'SI-13M1:DI-BPM',
    'SI-13M2:DI-BPM',
    'SI-13C1:DI-BPM-1',
    'SI-13C1:DI-BPM-2',
    'SI-13C2:DI-BPM',
    'SI-13C3:DI-BPM-1',
    'SI-13C3:DI-BPM-2',
    'SI-13C4:DI-BPM',
    'SI-14M1:DI-BPM',
    'SI-14M2:DI-BPM',
    'SI-14C1:DI-BPM-1',
    'SI-14C1:DI-BPM-2',
    'SI-14C2:DI-BPM',
    'SI-14C3:DI-BPM-1',
    'SI-14C3:DI-BPM-2',
    'SI-14C4:DI-BPM',
    'SI-15M1:DI-BPM',
    'SI-15M2:DI-BPM',
    'SI-15C1:DI-BPM-1',
    'SI-15C1:DI-BPM-2',
    'SI-15C2:DI-BPM',
    'SI-15C3:DI-BPM-1',
    'SI-15C3:DI-BPM-2',
    'SI-15C4:DI-BPM',
    'SI-16M1:DI-BPM',
    'SI-16M2:DI-BPM',
    'SI-16C1:DI-BPM-1',
    'SI-16C1:DI-BPM-2',
    'SI-16C2:DI-BPM',
    'SI-16C3:DI-BPM-1',
    'SI-16C3:DI-BPM-2',
    'SI-16C4:DI-BPM',
    'SI-17M1:DI-BPM',
    'SI-17M2:DI-BPM',
    'SI-17C1:DI-BPM-1',
    'SI-17C1:DI-BPM-2',
    'SI-17C2:DI-BPM',
    'SI-17C3:DI-BPM-1',
    'SI-17C3:DI-BPM-2',
    'SI-17C4:DI-BPM',
    'SI-18M1:DI-BPM',
    'SI-18M2:DI-BPM',
    'SI-18C1:DI-BPM-1',
    'SI-18C1:DI-BPM-2',
    'SI-18C2:DI-BPM',
    'SI-18C3:DI-BPM-1',
    'SI-18C3:DI-BPM-2',
    'SI-18C4:DI-BPM',
    'SI-19M1:DI-BPM',
    'SI-19M2:DI-BPM',
    'SI-19C1:DI-BPM-1',
    'SI-19C1:DI-BPM-2',
    'SI-19C2:DI-BPM',
    'SI-19C3:DI-BPM-1',
    'SI-19C3:DI-BPM-2',
    'SI-19C4:DI-BPM',
    'SI-20M1:DI-BPM',
    'SI-20M2:DI-BPM',
    'SI-20C1:DI-BPM-1',
    'SI-20C1:DI-BPM-2',
    'SI-20C2:DI-BPM',
    'SI-20C3:DI-BPM-1',
    'SI-20C3:DI-BPM-2',
    'SI-20C4:DI-BPM',
    'SI-01M1:DI-BPM',
    ]
_bpm_propts = [
    [':INFOClkProp-Sel', 0, 0.0],
    [':ADCSi57xOe-Sel', 1, 0.0],
    [':ADCClkSel-Sel', 1, 0.0],
    [':INFOADCRate-SP', 1, 0.0],
    [':ADCAD9510PllFunc-SP', 1, 0.0],
    [':ADCAD9510Outputs-SP', 31, 0.0],
    [':ADCAD9510ClkSel-Sel', 1, 0.0],
    [':ADCAD9510CpCurrent-Sel', 7, 0.0],
    [':ADCTrigDir-Sel', 0, 0.0],
    [':ADCTrigTerm-Sel', 0, 0.0],
    [':RFFEPidSpAC-SP', 45.0, 0.0],
    [':RFFEPidSpBD-SP', 45.0, 0.0],
    [':RFFETempCtl-SP', 0, 0.0],
    [':RFFEPidACKp-SP', 10.5, 0.0],
    [':RFFEPidACTi-SP', 12.0, 0.0],
    [':RFFEPidACTd-SP', 2.0, 0.0],
    [':RFFEPidBDKp-SP', 10.5, 0.0],
    [':RFFEPidBDTi-SP', 12.0, 0.0],
    [':RFFEPidBDTd-SP', 2.0, 0.0],
    [':RFFEHeaterAC-SP', 0.0, 0.0],
    [':RFFEHeaterBD-SP', 0.0, 0.0],
    [':ADC0RstModes-Sel', 1, 0.0],
    [':ADC1RstModes-Sel', 1, 0.0],
    [':ADC2RstModes-Sel', 1, 0.0],
    [':ADC3RstModes-Sel', 1, 0.0],
    [':TRIGGER0Dir-Sel', 1, 0.0],
    [':TRIGGER0DirPol-Sel', 1, 0.0],
    [':TRIGGER0RcvLen-SP', 1, 0.0],
    [':TRIGGER0TrnLen-SP', 1, 0.0],
    [':TRIGGER1Dir-Sel', 1, 0.0],
    [':TRIGGER1DirPol-Sel', 1, 0.0],
    [':TRIGGER1RcvLen-SP', 1, 0.0],
    [':TRIGGER1TrnLen-SP', 1, 0.0],
    [':TRIGGER2Dir-Sel', 0, 0.0],
    [':TRIGGER2DirPol-Sel', 1, 0.0],
    [':TRIGGER2RcvLen-SP', 1, 0.0],
    [':TRIGGER2TrnLen-SP', 1, 0.0],
    [':TRIGGER3Dir-Sel', 0, 0.0],
    [':TRIGGER3DirPol-Sel', 1, 0.0],
    [':TRIGGER3RcvLen-SP', 1, 0.0],
    [':TRIGGER3TrnLen-SP', 1, 0.0],
    [':TRIGGER4Dir-Sel', 1, 0.0],
    [':TRIGGER4DirPol-Sel', 1, 0.0],
    [':TRIGGER4RcvLen-SP', 1, 0.0],
    [':TRIGGER4TrnLen-SP', 1, 0.0],
    [':TRIGGER5Dir-Sel', 1, 0.0],
    [':TRIGGER5DirPol-Sel', 1, 0.0],
    [':TRIGGER5RcvLen-SP', 1, 0.0],
    [':TRIGGER5TrnLen-SP', 1, 0.0],
    [':TRIGGER6Dir-Sel', 1, 0.0],
    [':TRIGGER6DirPol-Sel', 1, 0.0],
    [':TRIGGER6RcvLen-SP', 1, 0.0],
    [':TRIGGER6TrnLen-SP', 1, 0.0],
    [':TRIGGER7Dir-Sel', 1, 0.0],
    [':TRIGGER7DirPol-Sel', 1, 0.0],
    [':TRIGGER7RcvLen-SP', 1, 0.0],
    [':TRIGGER7TrnLen-SP', 1, 0.0],
    [':TRIGGER0RcvInSel-SP', 0, 0.0],
    [':TRIGGER0RcvSrc-Sel', 0, 0.0],
    [':TRIGGER0TrnOutSel-SP', 0, 0.0],
    [':TRIGGER0TrnSrc-Sel', 0, 0.0],
    [':TRIGGER1RcvInSel-SP', 0, 0.0],
    [':TRIGGER1RcvSrc-Sel', 0, 0.0],
    [':TRIGGER1TrnOutSel-SP', 0, 0.0],
    [':TRIGGER1TrnSrc-Sel', 0, 0.0],
    [':TRIGGER2RcvInSel-SP', 0, 0.0],
    [':TRIGGER2RcvSrc-Sel', 0, 0.0],
    [':TRIGGER2TrnOutSel-SP', 0, 0.0],
    [':TRIGGER2TrnSrc-Sel', 0, 0.0],
    [':TRIGGER3RcvInSel-SP', 0, 0.0],
    [':TRIGGER3RcvSrc-Sel', 0, 0.0],
    [':TRIGGER3TrnOutSel-SP', 0, 0.0],
    [':TRIGGER3TrnSrc-Sel', 0, 0.0],
    [':TRIGGER4RcvInSel-SP', 0, 0.0],
    [':TRIGGER4RcvSrc-Sel', 0, 0.0],
    [':TRIGGER4TrnOutSel-SP', 0, 0.0],
    [':TRIGGER4TrnSrc-Sel', 0, 0.0],
    [':TRIGGER5RcvInSel-SP', 0, 0.0],
    [':TRIGGER5RcvSrc-Sel', 0, 0.0],
    [':TRIGGER5TrnOutSel-SP', 0, 0.0],
    [':TRIGGER5TrnSrc-Sel', 0, 0.0],
    [':TRIGGER6RcvInSel-SP', 0, 0.0],
    [':TRIGGER6RcvSrc-Sel', 0, 0.0],
    [':TRIGGER6TrnOutSel-SP', 0, 0.0],
    [':TRIGGER6TrnSrc-Sel', 0, 0.0],
    [':TRIGGER7RcvInSel-SP', 0, 0.0],
    [':TRIGGER7RcvSrc-Sel', 0, 0.0],
    [':TRIGGER7TrnOutSel-SP', 0, 0.0],
    [':TRIGGER7TrnSrc-Sel', 0, 0.0],
    [':TRIGGER8RcvInSel-SP', 0, 0.0],
    [':TRIGGER8RcvSrc-Sel', 0, 0.0],
    [':TRIGGER8TrnOutSel-SP', 0, 0.0],
    [':TRIGGER8TrnSrc-Sel', 0, 0.0],
    [':TRIGGER9RcvInSel-SP', 0, 0.0],
    [':TRIGGER9RcvSrc-Sel', 0, 0.0],
    [':TRIGGER9TrnOutSel-SP', 0, 0.0],
    [':TRIGGER9TrnSrc-Sel', 0, 0.0],
    [':TRIGGER10RcvInSel-SP', 0, 0.0],
    [':TRIGGER10RcvSrc-Sel', 0, 0.0],
    [':TRIGGER10TrnOutSel-SP', 0, 0.0],
    [':TRIGGER10TrnSrc-Sel', 0, 0.0],
    [':TRIGGER11RcvInSel-SP', 0, 0.0],
    [':TRIGGER11RcvSrc-Sel', 0, 0.0],
    [':TRIGGER11TrnOutSel-SP', 0, 0.0],
    [':TRIGGER11TrnSrc-Sel', 0, 0.0],
    [':TRIGGER12RcvInSel-SP', 0, 0.0],
    [':TRIGGER12RcvSrc-Sel', 0, 0.0],
    [':TRIGGER12TrnOutSel-SP', 0, 0.0],
    [':TRIGGER12TrnSrc-Sel', 0, 0.0],
    [':TRIGGER13RcvInSel-SP', 0, 0.0],
    [':TRIGGER13RcvSrc-Sel', 0, 0.0],
    [':TRIGGER13TrnOutSel-SP', 0, 0.0],
    [':TRIGGER13TrnSrc-Sel', 0, 0.0],
    [':TRIGGER14RcvInSel-SP', 0, 0.0],
    [':TRIGGER14RcvSrc-Sel', 0, 0.0],
    [':TRIGGER14TrnOutSel-SP', 0, 0.0],
    [':TRIGGER14TrnSrc-Sel', 0, 0.0],
    [':TRIGGER15RcvInSel-SP', 0, 0.0],
    [':TRIGGER15RcvSrc-Sel', 0, 0.0],
    [':TRIGGER15TrnOutSel-SP', 0, 0.0],
    [':TRIGGER15TrnSrc-Sel', 0, 0.0],
    [':TRIGGER16RcvInSel-SP', 0, 0.0],
    [':TRIGGER16RcvSrc-Sel', 0, 0.0],
    [':TRIGGER16TrnOutSel-SP', 0, 0.0],
    [':TRIGGER16TrnSrc-Sel', 0, 0.0],
    [':TRIGGER17RcvInSel-SP', 0, 0.0],
    [':TRIGGER17RcvSrc-Sel', 0, 0.0],
    [':TRIGGER17TrnOutSel-SP', 0, 0.0],
    [':TRIGGER17TrnSrc-Sel', 0, 0.0],
    [':TRIGGER18RcvInSel-SP', 1, 0.0],
    [':TRIGGER18RcvSrc-Sel', 1, 0.0],
    [':TRIGGER18TrnOutSel-SP', 0, 0.0],
    [':TRIGGER18TrnSrc-Sel', 0, 0.0],
    [':TRIGGER19RcvInSel-SP', 0, 0.0],
    [':TRIGGER19RcvSrc-Sel', 0, 0.0],
    [':TRIGGER19TrnOutSel-SP', 0, 0.0],
    [':TRIGGER19TrnSrc-Sel', 0, 0.0],
    [':TRIGGER20RcvInSel-SP', 0, 0.0],
    [':TRIGGER20RcvSrc-Sel', 0, 0.0],
    [':TRIGGER20TrnOutSel-SP', 0, 0.0],
    [':TRIGGER20TrnSrc-Sel', 0, 0.0],
    [':TRIGGER21RcvInSel-SP', 0, 0.0],
    [':TRIGGER21RcvSrc-Sel', 0, 0.0],
    [':TRIGGER21TrnOutSel-SP', 0, 0.0],
    [':TRIGGER21TrnSrc-Sel', 0, 0.0],
    [':TRIGGER22RcvInSel-SP', 0, 0.0],
    [':TRIGGER22RcvSrc-Sel', 0, 0.0],
    [':TRIGGER22TrnOutSel-SP', 0, 0.0],
    [':TRIGGER22TrnSrc-Sel', 0, 0.0],
    [':TRIGGER23RcvInSel-SP', 0, 0.0],
    [':TRIGGER23RcvSrc-Sel', 0, 0.0],
    [':TRIGGER23TrnOutSel-SP', 0, 0.0],
    [':TRIGGER23TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM0RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM0RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM0TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM0TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM1RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM1RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM1TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM1TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM2RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM2RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM2TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM2TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM3RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM3RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM3TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM3TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM4RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM4RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM4TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM4TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM5RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM5RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM5TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM5TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM6RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM6RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM6TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM6TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM7RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM7RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM7TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM7TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM8RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM8RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM8TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM8TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM9RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM9RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM9TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM9TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM10RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM10RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM10TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM10TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM11RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM11RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM11TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM11TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM12RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM12RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM12TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM12TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM13RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM13RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM13TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM13TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM14RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM14RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM14TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM14TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM15RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM15RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM15TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM15TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM16RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM16RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM16TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM16TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM17RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM17RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM17TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM17TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM18RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM18RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM18TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM18TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM19RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM19RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM19TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM19TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM20RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM20RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM20TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM20TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM21RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM21RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM21TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM21TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM22RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM22RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM22TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM22TrnSrc-Sel', 0, 0.0],
    [':TRIGGER_PM23RcvInSel-SP', 0, 0.0],
    [':TRIGGER_PM23RcvSrc-Sel', 0, 0.0],
    [':TRIGGER_PM23TrnOutSel-SP', 0, 0.0],
    [':TRIGGER_PM23TrnSrc-Sel', 0, 0.0],
    [':ACQChannel-Sel', 0, 0.0],
    [':ACQSamplesPre-SP', 100, 0.0],
    [':ACQSamplesPost-SP', 50, 0.0],
    [':ACQTrigger-Sel', 1, 0.0],
    [':ACQShots-SP', 1, 0.0],
    [':ACQTriggerRep-Sel', 0, 0.0],
    [':ACQBPMMode-Sel', 1, 0.0],
    [':TbTTagEn-Sel', 1, 0.0],
    [':TbTTagDly-SP', 0.0, 0.0],
    [':TbTDataMaskEn-Sel', 1, 0.0],
    [':TbTDataMaskSamplesBeg-SP', 0.0, 0.0],
    [':TbTDataMaskSamplesEnd-SP', 0.0, 0.0],
    [':RFFEAtt-SP', 31.5, 0.0],
    [':PosKsum-SP', 1, 0.0],
    [':PosXOffset-SP', 0, 0.0],
    [':PosYOffset-SP', 0, 0.0],
    [':PosQOffset-SP', 0, 0.0],
    [':ACQTriggerHwDly-SP', 0, 0.0],
    [':INFOClkFreq-SP', 220910069.0, 0.0],
    [':INFOHarmonicNumber-SP', 864, 0.0],
    [':INFOTbTRate-SP', 382, 0.0],
    [':INFOFOFBRate-SP', 8786, 0.0],
    [':INFOMONITRate-SP', 21929856, 0.0],
    [':INFOFAcqRate-SP', 230346, 0.0],
    [':PosKx-SP', 21389980, 0.0],
    [':PosKy-SP', 21389980, 0.0],
    [':PosKq-SP', 21389980, 0.0],
    [':ADCAD9510ADiv-SP', 0, 0.0],
    [':ADCAD9510BDiv-SP', 382, 0.0],
    [':ADCAD9510Prescaler-SP', 0, 0.0],
    [':ADCAD9510RDiv-SP', 120, 0.0],
    [':ADCSi57xFreq-SP', 220910069.0, 0.0],
    [':SwMode-Sel', 1, 0.0],
    [':SwDivClk-SP', 8786, 0.0],
    [':SwDly-SP', 29, 0.0],
    [':SwTagEn-Sel', 0, 0.0],
    [':SwDataMaskEn-Sel', 0, 0.0],
    [':SwDataMaskSamples-SP', 1910, 0.0],
    [':SwDirGainA-SP', 1.0, 0.0],
    [':SwDirGainB-SP', 1.0, 0.0],
    [':SwDirGainC-SP', 1.0, 0.0],
    [':SwDirGainD-SP', 1.0, 0.0],
    [':SwInvGainA-SP', 1.0, 0.0],
    [':SwInvGainB-SP', 1.0, 0.0],
    [':SwInvGainC-SP', 1.0, 0.0],
    [':SwInvGainD-SP', 1.0, 0.0],
]
_bpm_pvs = list()
for dev in _bpms:
    for ppt, val, dly in _bpm_propts:
        _bpm_pvs.append([dev+ppt, val, dly])

_scrns = [
    'TB-01:DI-{0:s}-1',
    'TB-01:DI-{0:s}-2',
    'TB-02:DI-{0:s}-1',
    'TB-02:DI-{0:s}-2',
    'TB-03:DI-{0:s}',
    'TB-04:DI-{0:s}',
    'BO-01D:DI-{0:s}-1',
    'BO-01D:DI-{0:s}-2',
    'BO-02U:DI-{0:s}',
    'TS-01:DI-{0:s}',
    'TS-02:DI-{0:s}',
    'TS-03:DI-{0:s}',
    'TS-04:DI-{0:s}-1',
    'TS-04:DI-{0:s}-2',
    'TS-04:DI-{0:s}-3',
    ]
_scrn_devs = [
    'ScrnCam',
    'Scrn',
    'ScrnCtrl'
    ]
_scrn_propts = [
    [
        [':ScaleFactorX-SP', -1, 0.0],
        [':ScaleFactorY-SP', -1, 0.0],
        [':CenterOffsetX-SP', 0, 0.0],
        [':CenterOffsetY-SP', 0, 0.0],
        [':ThetaOffset-SP', 0, 0.0],
        [':Enbl-Sel', 0, 0.0],
        [':AcqMode-Sel', 0, 0.0],
        [':AcqPeriod-SP', 0.4, 0.0],
        [':AcqPeriodLowLim-SP', 0.083, 0.0],
        [':ExposureMode-Sel', 0, 0.0],
        [':ExposureTime-SP', 5000, 0.0],
        [':Gain-SP', 0, 0.0],
        [':BlackLevel-SP', 0, 0.0],
        [':DebouncerPeriod-SP', 0, 0.0],
        [':DataType-Sel', 0, 0.0],
        [':TransformType-Sel', 0, 0.0],
        [':AOIOffsetX-SP', 0, 0.0],
        [':AOIOffsetY-SP', 0, 0.0],
        [':AOIWidth-SP', 1280, 0.0],
        [':AOIHeight-SP', 1024, 0.0],
        [':AOIAutoCenterX-Sel', 0, 0.0],
        [':AOIAutoCenterY-Sel', 0, 0.0],
        [':PacketSize-SP', 1500, 0.0],
        [':InterPacketDelay-SP', 1000, 0.0],
        [':TransmDelay-SP', 0, 0.0],
        [':BwReserve-SP', 10, 0.0],
        [':BwReserveAccum-SP', 1, 0.0],
        [':EnblBGSubtraction-Sel', 0, 0.0],
        [':EnblOffsetScale-Sel', 0, 0.0],
        [':PixelScale-SP', 1, 0.0],
        [':PixelOffset-SP', 0, 0.0],
        [':EnblHighClip-Sel', 0, 0.0],
        [':EnblLowClip-Sel', 0, 0.0],
        [':HighClip-SP', 65535, 0.0],
        [':LowClip-SP', 0, 0.0],
        [':CalPosCenterX-SP', 0, 0.0],
        [':CalPosCenterY-SP', 0, 0.0],
        [':DimFeiMarkEnbl-Sel', 0, 0.0],
        [':NDStatsMarkEnbl-Sel', 0, 0.0],
        [':CalCenterMarkEnbl-Sel', 0, 0.0],
        [':RealCenterMarkEnbl-Sel', 0, 0.0],
        [':DimFeiMarkColor-SP', 255, 0.0],
        [':DimFeiMarkSize-SP', 10, 0.0],
        [':NDStatsMarkColor-SP', 255, 0.0],
        [':NDStatsMarkSize-SP', 10, 0.0],
        [':CalCenterMarkColor-SP', 255, 0.0],
        [':CalCenterMarkSize-SP', 10, 0.0],
        [':RealCenterMarkColor-SP', 255, 0.0],
        [':RealCenterMarkSize-SP', 10, 0.0],
    ], [
        [':CalScrnPos-SP', 1, 0.0],
        [':FluorScrnPos-SP', 2, 0.0],
        [':NoneScrnPos-SP', 0, 0.0],
        [':AcceptedErr-SP', 1, 0.0],
        [':LEDPwrLvl-SP', 0, 0.0],
        [':LEDThold-SP', 2.5, 0.0],
        [':LEDPwrScaleFactor-SP', 0.011, 0.0],
    ], [
        [':AmpEnbl-Sel', 0, 0.0],
        [':AmpGain-Sel', 0, 0.0],
        [':AmpCurrLoopGain-Sel', 0, 0.0],
        [':LowCurrMode-SP', 1, 0.0],
        [':Mtr.SET', 0, 0.0],
        [':Mtr.MRES', 1, 0.0],
        [':Mtr.SREV', 51200, 0.0],
        [':Mtr.VMAX', 1.4, 0.0],
        [':Mtr.VELO', 1.3, 0.0],
        [':Mtr.ACCL', 2, 0.0],
        [':Mtr.HLM', 100, 0.0],
        [':Mtr.LLM', 0, 0.0],
        [':Mtr.DIR', 0, 0.0],
        [':Mtr.OFF', 0, 0.0],
        [':Mtr.BDST', 0, 0.0],
        [':Mtr.BVEL', 0, 0.0],
        [':Mtr.BACC', 0, 0.0],
        [':Mtr.EGU', 'mm', 0.0],
        [':Mtr.NTM', 1, 0.0],
        [':Mtr.RTRY', 0, 0.0],
        [':Mtr.RDBD', 1, 0.0],
        [':Mtr.RMOD', 0, 0.0],
        [':MtrType-Sel', 2, 0.0],
        [':LimSwType-Sel', 1, 0.0],
        [':MainEncType-Sel', 0, 0.0],
        [':Mtr.ERES', 1, 0.0],
        [':EstallTime-SP', 0.2, 0.0],
        [':PollPeriod-SP', 1, 0.0],
        [':Mtr.UEIP', 0, 0.0],
        [':RefHomePos-SP', 0, 0.0],
        [':RstPosAfterHome-Sel', 0, 0.0],
        [':JogAfterHome-SP', 0, 0.0],
        [':HomeEnblDir-Sel', 0, 0.0],
        [':Mtr.HVEL', 1.4, 0.0],
        [':DigOut0-Sel', 0, 0.0],
        [':DigOut1-Sel', 0, 0.0],
        [':DigOut2-Sel', 0, 0.0],
        [':DigOut3-Sel', 0, 0.0],
        [':AnalogOut0DeadBand-SP', 0.002, 0.0],
        [':AnalogOut1DeadBand-SP', 0.002, 0.0],
        [':BiSSIn-Sel', 0, 0.0],
        [':BiSSLvl-Sel', 0, 0.0],
        [':BiSSPoll-Sel', 0, 0.0],
        [':BiSSClkDiv-SP', 9, 0.0],
        [':BiSSNumBits1-SP', 33, 0.0],
        [':BiSSNumBits2-SP', 33, 0.0],
        [':BiSSNumZeroPad-SP', 0, 0.0],
        [':LimSwDsbl-Sel', 0, 0.0],
        [':LimProtectEnbl-Sel', 1, 0.0],
        [':AuxEncType-Sel', 1, 0.0],
        [':ErrLimType-Sel', 0, 0.0],
        [':PosErrLim-SP', 16384, 0.0],
        [':StopDelay-SP', 0, 0.0],
        [':UseIdx-Sel', 1, 0.0],
        [':UseSw-Sel', 1, 0.0],
    ]]
_scrn_pvs = list()
for dev in _scrns:
    for pre, propts in zip(_scrn_devs, _scrn_propts):
        dev2 = dev.format(pre)
        for ppt, val, dly in propts:
            _scrn_pvs.append([dev2+ppt, val, dly])

_scrns = [
    'TS-01:DI-ScrnCam',
    'TS-02:DI-ScrnCam',
    'TS-03:DI-ScrnCam',
    'TS-04:DI-ScrnCam-1',
    'TS-04:DI-ScrnCam-2',
    'TS-04:DI-ScrnCam-3',
    ]
_scrn_propts = [
    [':ColorConv-Sel', 0, 0.0],
    [':EnblMJPEG-Sel', 0, 0.0],
    [':FastAcq-Sel', 0, 0.0],
    [':SoftROIAutoCenterX-Sel', 0, 0.0],
    [':SoftROIAutoCenterY-Sel', 0, 0.0],
    [':SoftROIHeight-SP', 1024, 0.0],
    [':SoftROIOffsetX-SP', 0, 0.0],
    [':SoftROIOffsetY-SP', 0, 0.0],
    [':SoftROIWidth-SP', 1280, 0.0],
    ]
for dev in _scrns:
    for ppt, val, dly in _scrn_propts:
        _scrn_pvs.append([dev+ppt, val, dly])

_vlightcam_pvs = [
    ['BO-50U:DI-VLightCam:Enbl-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:Gain-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:AcqMode-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:AcqPeriod-SP', 0.4, 0.0],
    ['BO-50U:DI-VLightCam:AcqPeriodLowLim-SP', 0.083, 0.0],
    ['BO-50U:DI-VLightCam:ExposureMode-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:ExposureTime-SP', 5000, 0.0],
    ['BO-50U:DI-VLightCam:DataType-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:BlackLevel-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:TransformType-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:DebouncerPeriod-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:BwReserve-SP', 10, 0.0],
    ['BO-50U:DI-VLightCam:BwReserveAccum-SP', 1, 0.0],
    ['BO-50U:DI-VLightCam:TransmDelay-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:PacketSize-SP', 1500, 0.0],
    ['BO-50U:DI-VLightCam:InterPacketDelay-SP', 1000, 0.0],
    ['BO-50U:DI-VLightCam:SoftROIAutoCenterX-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:SoftROIAutoCenterY-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:SoftROIHeight-SP', 1024, 0.0],
    ['BO-50U:DI-VLightCam:SoftROIOffsetX-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:SoftROIOffsetY-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:SoftROIWidth-SP', 1280, 0.0],
    ['BO-50U:DI-VLightCam:AOIAutoCenterX-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:AOIAutoCenterY-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:AOIHeight-SP', 1024, 0.0],
    ['BO-50U:DI-VLightCam:AOIOffsetX-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:AOIOffsetY-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:AOIWidth-SP', 1280, 0.0],
    ['BO-50U:DI-VLightCam:CalPosCenterX-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:CalPosCenterY-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:CenterOffsetX-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:CenterOffsetY-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:ThetaOffset-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:ScaleFactorX-SP', 1, 0.0],
    ['BO-50U:DI-VLightCam:ScaleFactorY-SP', 1, 0.0],
    ['BO-50U:DI-VLightCam:EnblBGSubtraction-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:EnblOffsetScale-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:PixelOffset-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:PixelScale-SP', 1, 0.0],
    ['BO-50U:DI-VLightCam:HighClip-SP', 65535, 0.0],
    ['BO-50U:DI-VLightCam:LowClip-SP', 0, 0.0],
    ['BO-50U:DI-VLightCam:EnblHighClip-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:EnblLowClip-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:DimFeiMarkEnbl-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:NDStatsMarkEnbl-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:CalCenterMarkEnbl-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:RealCenterMarkEnbl-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:EnblMJPEG-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:ColorConv-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:FastAcq-Sel', 0, 0.0],
    ['BO-50U:DI-VLightCam:DimFeiMarkColor-SP', 255, 0.0],
    ['BO-50U:DI-VLightCam:DimFeiMarkSize-SP', 10, 0.0],
    ['BO-50U:DI-VLightCam:NDStatsMarkColor-SP', 255, 0.0],
    ['BO-50U:DI-VLightCam:NDStatsMarkSize-SP', 10, 0.0],
    ['BO-50U:DI-VLightCam:CalCenterMarkColor-SP', 255, 0.0],
    ['BO-50U:DI-VLightCam:CalCenterMarkSize-SP', 10, 0.0],
    ['BO-50U:DI-VLightCam:RealCenterMarkColor-SP', 255, 0.0],
    ['BO-50U:DI-VLightCam:RealCenterMarkSize-SP', 10, 0.0],

    ['SI-01C2FE:DI-VLightCam:Enbl-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:Gain-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:AcqMode-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:AcqPeriod-SP', 0.4, 0.0],
    ['SI-01C2FE:DI-VLightCam:AcqPeriodLowLim-SP', 0.083, 0.0],
    ['SI-01C2FE:DI-VLightCam:ExposureMode-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:ExposureTime-SP', 5000, 0.0],
    ['SI-01C2FE:DI-VLightCam:DataType-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:BlackLevel-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:TransformType-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:DebouncerPeriod-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:BwReserve-SP', 10, 0.0],
    ['SI-01C2FE:DI-VLightCam:BwReserveAccum-SP', 1, 0.0],
    ['SI-01C2FE:DI-VLightCam:TransmDelay-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:PacketSize-SP', 1500, 0.0],
    ['SI-01C2FE:DI-VLightCam:InterPacketDelay-SP', 1000, 0.0],
    ['SI-01C2FE:DI-VLightCam:SoftROIAutoCenterX-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:SoftROIAutoCenterY-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:SoftROIHeight-SP', 1024, 0.0],
    ['SI-01C2FE:DI-VLightCam:SoftROIOffsetX-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:SoftROIOffsetY-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:SoftROIWidth-SP', 1280, 0.0],
    ['SI-01C2FE:DI-VLightCam:AOIAutoCenterX-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:AOIAutoCenterY-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:AOIHeight-SP', 1024, 0.0],
    ['SI-01C2FE:DI-VLightCam:AOIOffsetX-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:AOIOffsetY-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:AOIWidth-SP', 1280, 0.0],
    ['SI-01C2FE:DI-VLightCam:CalPosCenterX-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:CalPosCenterY-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:CenterOffsetX-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:CenterOffsetY-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:ThetaOffset-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:ScaleFactorX-SP', 1, 0.0],
    ['SI-01C2FE:DI-VLightCam:ScaleFactorY-SP', 1, 0.0],
    ['SI-01C2FE:DI-VLightCam:EnblBGSubtraction-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:EnblOffsetScale-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:PixelOffset-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:PixelScale-SP', 1, 0.0],
    ['SI-01C2FE:DI-VLightCam:HighClip-SP', 65535, 0.0],
    ['SI-01C2FE:DI-VLightCam:LowClip-SP', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:EnblHighClip-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:EnblLowClip-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:DimFeiMarkEnbl-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:NDStatsMarkEnbl-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:CalCenterMarkEnbl-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:RealCenterMarkEnbl-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:EnblMJPEG-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:ColorConv-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:FastAcq-Sel', 0, 0.0],
    ['SI-01C2FE:DI-VLightCam:DimFeiMarkColor-SP', 255, 0.0],
    ['SI-01C2FE:DI-VLightCam:DimFeiMarkSize-SP', 10, 0.0],
    ['SI-01C2FE:DI-VLightCam:NDStatsMarkColor-SP', 255, 0.0],
    ['SI-01C2FE:DI-VLightCam:NDStatsMarkSize-SP', 10, 0.0],
    ['SI-01C2FE:DI-VLightCam:CalCenterMarkColor-SP', 255, 0.0],
    ['SI-01C2FE:DI-VLightCam:CalCenterMarkSize-SP', 10, 0.0],
    ['SI-01C2FE:DI-VLightCam:RealCenterMarkColor-SP', 255, 0.0],
    ['SI-01C2FE:DI-VLightCam:RealCenterMarkSize-SP', 10, 0.0],
]

_dcct_pvs = [
    ['BO-35D:DI-DCCT:Abort-Cmd', 1, 0.0],
    ['SI-13C4:DI-DCCT:Abort-Cmd', 1, 0.0],
    ['SI-14C4:DI-DCCT:Abort-Cmd', 1, 2.0],
    ['BO-35D:DI-DCCT:MeasMode-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:MeasTrg-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:SampleCnt-SP', 1, 0.0],
    ['BO-35D:DI-DCCT:MeasPeriod-SP', 0.016667, 0.0],
    ['BO-35D:DI-DCCT:Imped-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:LineSync-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:RelEnbl-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:RelLvl-SP', 0, 0.0],
    ['BO-35D:DI-DCCT:FastSampleCnt-SP', 100, 0.0],
    ['BO-35D:DI-DCCT:FastMeasPeriod-SP', 0.016667, 0.0],
    ['BO-35D:DI-DCCT:FastImped-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:FastRelEnbl-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:FastRelLvl-SP', 0, 0.0],
    ['BO-35D:DI-DCCT:AvgFilterCnt-SP', 1, 0.0],
    ['BO-35D:DI-DCCT:AvgFilterEnbl-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:AvgFilterTyp-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:AvgFilterWind-SP', 0, 0.0],
    ['BO-35D:DI-DCCT:Range-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:Test-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:LowLimEnbl-Sel', 0, 0.0],
    ['BO-35D:DI-DCCT:CurrThold-SP', 0, 0.0],
    ['BO-35D:DI-DCCT:HFReject-Sel', 1, 0.0],
    ['BO-35D:DI-DCCT:Enbl-Sel', 1, 0.0],
    ['SI-13C4:DI-DCCT:MeasMode-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:MeasTrg-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:SampleCnt-SP', 1, 0.0],
    ['SI-13C4:DI-DCCT:MeasPeriod-SP', 0.016667, 0.0],
    ['SI-13C4:DI-DCCT:Imped-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:LineSync-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:RelEnbl-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:RelLvl-SP', 0, 0.0],
    ['SI-13C4:DI-DCCT:FastSampleCnt-SP', 100, 0.0],
    ['SI-13C4:DI-DCCT:FastMeasPeriod-SP', 0.016667, 0.0],
    ['SI-13C4:DI-DCCT:FastImped-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:FastRelEnbl-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:FastRelLvl-SP', 0, 0.0],
    ['SI-13C4:DI-DCCT:AvgFilterCnt-SP', 1, 0.0],
    ['SI-13C4:DI-DCCT:AvgFilterEnbl-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:AvgFilterTyp-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:AvgFilterWind-SP', 0, 0.0],
    ['SI-13C4:DI-DCCT:Range-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:Test-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:LowLimEnbl-Sel', 0, 0.0],
    ['SI-13C4:DI-DCCT:CurrThold-SP', 0, 0.0],
    ['SI-13C4:DI-DCCT:HFReject-Sel', 1, 0.0],
    ['SI-13C4:DI-DCCT:Enbl-Sel', 1, 0.0],
    ['SI-14C4:DI-DCCT:MeasMode-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:MeasTrg-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:SampleCnt-SP', 1, 0.0],
    ['SI-14C4:DI-DCCT:MeasPeriod-SP', 0.016667, 0.0],
    ['SI-14C4:DI-DCCT:Imped-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:LineSync-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:RelEnbl-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:RelLvl-SP', 0, 0.0],
    ['SI-14C4:DI-DCCT:FastSampleCnt-SP', 100, 0.0],
    ['SI-14C4:DI-DCCT:FastMeasPeriod-SP', 0.016667, 0.0],
    ['SI-14C4:DI-DCCT:FastImped-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:FastRelEnbl-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:FastRelLvl-SP', 0, 0.0],
    ['SI-14C4:DI-DCCT:AvgFilterCnt-SP', 1, 0.0],
    ['SI-14C4:DI-DCCT:AvgFilterEnbl-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:AvgFilterTyp-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:AvgFilterWind-SP', 0, 0.0],
    ['SI-14C4:DI-DCCT:Range-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:Test-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:LowLimEnbl-Sel', 0, 0.0],
    ['SI-14C4:DI-DCCT:CurrThold-SP', 0, 0.0],
    ['SI-14C4:DI-DCCT:HFReject-Sel', 1, 0.0],
    ['SI-14C4:DI-DCCT:Enbl-Sel', 1, 0.0],
]

_ict_pvs = [
    # ['TB-02:DI-ICT:SampleTrg-Sel', 0, 0.0],
    # ['TB-02:DI-ICT:2ndReadDly-SP', 0.016667, 0.0],
    # ['TB-02:DI-ICT:SampleCnt-SP', 200, 0.0],
    # ['TB-02:DI-ICT:Imped-Sel', 0, 0.0],
    # ['TB-02:DI-ICT:Aperture-SP', 1, 0.0],
    # ['TB-02:DI-ICT:SampleRate-SP', 1000000, 0.0],
    # ['TB-02:DI-ICT:BCMRange-SP', 8, 0.0],
    # ['TB-02:DI-ICT:Range-Sel', 0, 0.0],
    # ['TB-02:DI-ICT:CalEnbl-Sel', 0, 0.0],
    # ['TB-02:DI-ICT:CalCharge-Sel', 0, 0.0],
    # ['TB-02:DI-ICT:Threshold-SP', 0.1, 0.0],
    # ['TB-02:DI-ICT:HFReject-Sel', 1, 0.0],
    # ['TB-04:DI-ICT:SampleTrg-Sel', 0, 0.0],
    # ['TB-04:DI-ICT:2ndReadDly-SP', 0.016667, 0.0],
    # ['TB-04:DI-ICT:SampleCnt-SP', 200, 0.0],
    # ['TB-04:DI-ICT:Imped-Sel', 0, 0.0],
    # ['TB-04:DI-ICT:Aperture-SP', 1, 0.0],
    # ['TB-04:DI-ICT:SampleRate-SP', 1000000, 0.0],
    # ['TB-04:DI-ICT:BCMRange-SP', 8, 0.0],
    # ['TB-04:DI-ICT:Range-Sel', 0, 0.0],
    # ['TB-04:DI-ICT:CalEnbl-Sel', 0, 0.0],
    # ['TB-04:DI-ICT:CalCharge-Sel', 0, 0.0],
    # ['TB-04:DI-ICT:Threshold-SP', 0.1, 0.0],
    # ['TB-04:DI-ICT:HFReject-Sel', 1, 0.0],
    # ['TS-01:DI-ICT:SampleTrg-Sel', 0, 0.0],
    # ['TS-01:DI-ICT:2ndReadDly-SP', 0.016667, 0.0],
    # ['TS-01:DI-ICT:SampleCnt-SP', 200, 0.0],
    # ['TS-01:DI-ICT:Imped-Sel', 0, 0.0],
    # ['TS-01:DI-ICT:Aperture-SP', 1, 0.0],
    # ['TS-01:DI-ICT:SampleRate-SP', 1000000, 0.0],
    # ['TS-01:DI-ICT:BCMRange-SP', 8, 0.0],
    # ['TS-01:DI-ICT:Range-Sel', 0, 0.0],
    # ['TS-01:DI-ICT:CalEnbl-Sel', 0, 0.0],
    # ['TS-01:DI-ICT:CalCharge-Sel', 0, 0.0],
    # ['TS-01:DI-ICT:Threshold-SP', 0.1, 0.0],
    # ['TS-01:DI-ICT:HFReject-Sel', 1, 0.0],
    # ['TS-04:DI-ICT:SampleTrg-Sel', 0, 0.0],
    # ['TS-04:DI-ICT:2ndReadDly-SP', 0.016667, 0.0],
    # ['TS-04:DI-ICT:SampleCnt-SP', 200, 0.0],
    # ['TS-04:DI-ICT:Imped-Sel', 0, 0.0],
    # ['TS-04:DI-ICT:Aperture-SP', 1, 0.0],
    # ['TS-04:DI-ICT:SampleRate-SP', 1000000, 0.0],
    # ['TS-04:DI-ICT:BCMRange-SP', 8, 0.0],
    # ['TS-04:DI-ICT:Range-Sel', 0, 0.0],
    # ['TS-04:DI-ICT:CalEnbl-Sel', 0, 0.0],
    # ['TS-04:DI-ICT:CalCharge-Sel', 0, 0.0],
    # ['TS-04:DI-ICT:Threshold-SP', 0.1, 0.0],
    # ['TS-04:DI-ICT:HFReject-Sel', 1, 0.0],
]

_slit_pvs = [
    ['TB-01:DI-SlitH:SetMode-Sel', 0, 0.0],
    ['TB-01:DI-SlitH:NegEdgeInnerLim-SP', 0, 0.0],
    ['TB-01:DI-SlitH:PosEdgeInnerLim-SP', 0, 0.0],
    ['TB-01:DI-SlitH:LowOuterLim-SP', -100, 0.0],
    ['TB-01:DI-SlitH:HighOuterLim-SP', 100, 0.0],
    ['TB-01:DI-SlitV:SetMode-Sel', 0, 0.0],
    ['TB-01:DI-SlitV:NegEdgeInnerLim-SP', 0, 0.0],
    ['TB-01:DI-SlitV:PosEdgeInnerLim-SP', 0, 0.0],
    ['TB-01:DI-SlitV:LowOuterLim-SP', -100, 0.0],
    ['TB-01:DI-SlitV:HighOuterLim-SP', 100, 0.0],

    ['TB-01:DI-SlitHCtrl-O:AmpEnbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:AmpGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:AmpCurrLoopGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:LowCurrMode-SP', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.SET', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.MRES', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.SREV', 51200, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.VMAX', 1.4, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.VELO', 1.3, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.ACCL', 2, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.HLM', 100, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.LLM', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.DIR', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.OFF', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.BDST', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.BVEL', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.BACC', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.EGU', 'mm', 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.NTM', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.RTRY', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.RDBD', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.RMOD', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:MtrType-Sel', 2, 0.0],
    ['TB-01:DI-SlitHCtrl-O:LimSwType-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:MainEncType-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.ERES', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:EstallTime-SP', 0.2, 0.0],
    ['TB-01:DI-SlitHCtrl-O:PollPeriod-SP', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.UEIP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:RefHomePos-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:RstPosAfterHome-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:JogAfterHome-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:HomeEnblDir-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:Mtr.HVEL', 1.4, 0.0],
    ['TB-01:DI-SlitHCtrl-O:DigOut0-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:DigOut1-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:DigOut2-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:DigOut3-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:AnalogOut0DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitHCtrl-O:AnalogOut1DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSIn-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSLvl-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSPoll-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSClkDiv-SP', 9, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSNumBits1-SP', 33, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSNumBits2-SP', 33, 0.0],
    ['TB-01:DI-SlitHCtrl-O:BiSSNumZeroPad-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:LimSwDsbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:LimProtectEnbl-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:AuxEncType-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:ErrLimType-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:PosErrLim-SP', 16384, 0.0],
    ['TB-01:DI-SlitHCtrl-O:StopDelay-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-O:UseIdx-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-O:UseSw-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:AmpEnbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:AmpGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:AmpCurrLoopGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:LowCurrMode-SP', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.SET', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.MRES', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.SREV', 51200, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.VMAX', 1.4, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.VELO', 1.3, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.ACCL', 2, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.HLM', 100, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.LLM', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.DIR', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.OFF', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.BDST', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.BVEL', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.BACC', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.EGU', 'mm', 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.NTM', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.RTRY', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.RDBD', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.RMOD', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:MtrType-Sel', 2, 0.0],
    ['TB-01:DI-SlitHCtrl-I:LimSwType-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:MainEncType-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.ERES', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:EstallTime-SP', 0.2, 0.0],
    ['TB-01:DI-SlitHCtrl-I:PollPeriod-SP', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.UEIP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:RefHomePos-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:RstPosAfterHome-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:JogAfterHome-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:HomeEnblDir-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:Mtr.HVEL', 1.4, 0.0],
    ['TB-01:DI-SlitHCtrl-I:DigOut0-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:DigOut1-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:DigOut2-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:DigOut3-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:AnalogOut0DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitHCtrl-I:AnalogOut1DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSIn-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSLvl-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSPoll-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSClkDiv-SP', 9, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSNumBits1-SP', 33, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSNumBits2-SP', 33, 0.0],
    ['TB-01:DI-SlitHCtrl-I:BiSSNumZeroPad-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:LimSwDsbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:LimProtectEnbl-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:AuxEncType-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:ErrLimType-Sel', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:PosErrLim-SP', 16384, 0.0],
    ['TB-01:DI-SlitHCtrl-I:StopDelay-SP', 0, 0.0],
    ['TB-01:DI-SlitHCtrl-I:UseIdx-Sel', 1, 0.0],
    ['TB-01:DI-SlitHCtrl-I:UseSw-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:AmpEnbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:AmpGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:AmpCurrLoopGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:LowCurrMode-SP', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.SET', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.MRES', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.SREV', 51200, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.VMAX', 1.4, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.VELO', 1.3, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.ACCL', 2, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.HLM', 100, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.LLM', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.DIR', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.OFF', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.BDST', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.BVEL', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.BACC', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.EGU', 'mm', 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.NTM', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.RTRY', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.RDBD', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.RMOD', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:MtrType-Sel', 2, 0.0],
    ['TB-01:DI-SlitVCtrl-B:LimSwType-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:MainEncType-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.ERES', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:EstallTime-SP', 0.2, 0.0],
    ['TB-01:DI-SlitVCtrl-B:PollPeriod-SP', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.UEIP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:RefHomePos-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:RstPosAfterHome-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:JogAfterHome-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:HomeEnblDir-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:Mtr.HVEL', 1.4, 0.0],
    ['TB-01:DI-SlitVCtrl-B:DigOut0-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:DigOut1-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:DigOut2-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:DigOut3-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:AnalogOut0DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitVCtrl-B:AnalogOut1DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSIn-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSLvl-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSPoll-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSClkDiv-SP', 9, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSNumBits1-SP', 33, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSNumBits2-SP', 33, 0.0],
    ['TB-01:DI-SlitVCtrl-B:BiSSNumZeroPad-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:LimSwDsbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:LimProtectEnbl-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:AuxEncType-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:ErrLimType-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:PosErrLim-SP', 16384, 0.0],
    ['TB-01:DI-SlitVCtrl-B:StopDelay-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-B:UseIdx-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-B:UseSw-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:AmpEnbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:AmpGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:AmpCurrLoopGain-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:LowCurrMode-SP', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.SET', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.MRES', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.SREV', 51200, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.VMAX', 1.4, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.VELO', 1.3, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.ACCL', 2, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.HLM', 100, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.LLM', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.DIR', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.OFF', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.BDST', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.BVEL', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.BACC', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.EGU', 'mm', 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.NTM', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.RTRY', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.RDBD', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.RMOD', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:MtrType-Sel', 2, 0.0],
    ['TB-01:DI-SlitVCtrl-T:LimSwType-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:MainEncType-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.ERES', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:EstallTime-SP', 0.2, 0.0],
    ['TB-01:DI-SlitVCtrl-T:PollPeriod-SP', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.UEIP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:RefHomePos-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:RstPosAfterHome-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:JogAfterHome-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:HomeEnblDir-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:Mtr.HVEL', 1.4, 0.0],
    ['TB-01:DI-SlitVCtrl-T:DigOut0-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:DigOut1-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:DigOut2-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:DigOut3-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:AnalogOut0DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitVCtrl-T:AnalogOut1DeadBand-SP', 0.002, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSIn-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSLvl-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSPoll-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSClkDiv-SP', 9, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSNumBits1-SP', 33, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSNumBits2-SP', 33, 0.0],
    ['TB-01:DI-SlitVCtrl-T:BiSSNumZeroPad-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:LimSwDsbl-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:LimProtectEnbl-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:AuxEncType-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:ErrLimType-Sel', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:PosErrLim-SP', 16384, 0.0],
    ['TB-01:DI-SlitVCtrl-T:StopDelay-SP', 0, 0.0],
    ['TB-01:DI-SlitVCtrl-T:UseIdx-Sel', 1, 0.0],
    ['TB-01:DI-SlitVCtrl-T:UseSw-Sel', 1, 0.0],
]

_tune_pvs = [
    ['BO-Glob:DI-Tune-H:FreqOff-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:RevN-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:CenterFreq-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:CenterFreqAuto-Sel', 0, 0],
    ['BO-Glob:DI-Tune-H:SpecAnaRBW-Sel', 0, 0],
    ['BO-Glob:DI-Tune-H:SpecAnaGetSpec-Sel', 0, 0],
    ['BO-Glob:DI-Tune-H:ROIOffsetX-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:ROIOffsetY-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:ROIWidth-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:ROIHeight-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:ROIAuto-Sel', 0, 0],
    ['BO-Glob:DI-Tune-H:AmpGain-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:RFFreq-Mon.INP', '', 0],
    ['BO-Glob:DI-Tune-H:SIH-Cte.INP', '', 0],
    ['BO-Glob:DI-Tune-H:BOH-Cte.INP', '', 0],
    ['BO-Glob:DI-Tune-H:CarFreqThold-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-H:DriveAuto-Sel', 0, 0],
    ['BO-Glob:DI-Tune-H:NoiseAmpl-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-H:EnblTrkGen-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:AttIn-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:EnblAttAuto-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:ImpdIn-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:RoscSrc-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:TrkGenLvl-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-H:TrkGenLvlOffset-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-H:GetSpectrum-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:TrigSrc-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-H:DispRange-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-H:FiltType-Sel', 0, 0],

    ['BO-Glob:DI-Tune-V:FreqOff-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:RevN-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:CenterFreq-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:CenterFreqAuto-Sel', 0, 0],
    ['BO-Glob:DI-Tune-V:SpecAnaRBW-Sel', 0, 0],
    ['BO-Glob:DI-Tune-V:SpecAnaGetSpec-Sel', 0, 0],
    ['BO-Glob:DI-Tune-V:ROIOffsetX-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:ROIOffsetY-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:ROIWidth-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:ROIHeight-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:ROIAuto-Sel', 0, 0],
    ['BO-Glob:DI-Tune-V:AmpGain-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:RFFreq-Mon.INP', '', 0],
    ['BO-Glob:DI-Tune-V:SIH-Cte.INP', '', 0],
    ['BO-Glob:DI-Tune-V:BOH-Cte.INP', '', 0],
    ['BO-Glob:DI-Tune-V:CarFreqThold-SP', 0.0, 0],
    ['BO-Glob:DI-Tune-V:DriveAuto-Sel', 0, 0],
    ['BO-Glob:DI-Tune-V:NoiseAmpl-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-V:EnblTrkGen-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:AttIn-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:EnblAttAuto-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:ImpdIn-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:RoscSrc-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:TrkGenLvl-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-V:TrkGenLvlOffset-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-V:GetSpectrum-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:TrigSrc-Sel', 0, 0],
    ['BO-Glob:DI-TuneProc-V:DispRange-SP', 0.0, 0],
    ['BO-Glob:DI-TuneProc-V:FiltType-Sel', 0, 0],

    ['SI-Glob:DI-Tune-H:FreqOff-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:RevN-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:CenterFreq-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:CenterFreqAuto-Sel', 0, 0],
    ['SI-Glob:DI-Tune-H:SpecAnaRBW-Sel', 0, 0],
    ['SI-Glob:DI-Tune-H:SpecAnaGetSpec-Sel', 0, 0],
    ['SI-Glob:DI-Tune-H:ROIOffsetX-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:ROIOffsetY-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:ROIWidth-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:ROIHeight-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:ROIAuto-Sel', 0, 0],
    ['SI-Glob:DI-Tune-H:AmpGain-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-H:RFFreq-Mon.INP', '', 0],
    ['SI-Glob:DI-Tune-H:SIH-Cte.INP', '', 0],
    ['SI-Glob:DI-Tune-H:BOH-Cte.INP', '', 0],
    ['SI-Glob:DI-Tune-H:SpecAnaTrkGenLvl-SP', 0.0, 0],
    ['SI-Glob:DI-TuneProc-H:EnblTrkGen-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:AttIn-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:EnblAttAuto-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:ImpdIn-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:RoscSrc-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:TrkGenLvlOffset-SP', 0.0, 0],
    ['SI-Glob:DI-TuneProc-H:GetSpectrum-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:TrigSrc-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-H:DispRange-SP', 0.0, 0],
    ['SI-Glob:DI-TuneProc-H:FiltType-Sel', 0, 0],

    ['SI-Glob:DI-Tune-V:FreqOff-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:RevN-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:CenterFreq-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:CenterFreqAuto-Sel', 0, 0],
    ['SI-Glob:DI-Tune-V:SpecAnaRBW-Sel', 0, 0],
    ['SI-Glob:DI-Tune-V:SpecAnaGetSpec-Sel', 0, 0],
    ['SI-Glob:DI-Tune-V:ROIOffsetX-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:ROIOffsetY-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:ROIWidth-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:ROIHeight-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:ROIAuto-Sel', 0, 0],
    ['SI-Glob:DI-Tune-V:AmpGain-SP', 0.0, 0],
    ['SI-Glob:DI-Tune-V:RFFreq-Mon.INP', '', 0],
    ['SI-Glob:DI-Tune-V:SIH-Cte.INP', '', 0],
    ['SI-Glob:DI-Tune-V:BOH-Cte.INP', '', 0],
    ['SI-Glob:DI-Tune-V:SpecAnaTrkGenLvl-SP', 0.0, 0],
    ['SI-Glob:DI-TuneProc-V:EnblTrkGen-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:AttIn-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:EnblAttAuto-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:ImpdIn-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:RoscSrc-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:TrkGenLvlOffset-SP', 0.0, 0],
    ['SI-Glob:DI-TuneProc-V:GetSpectrum-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:TrigSrc-Sel', 0, 0],
    ['SI-Glob:DI-TuneProc-V:DispRange-SP', 0.0, 0],
    ['SI-Glob:DI-TuneProc-V:FiltType-Sel', 0, 0],
    ]

# When using this type of configuration to set the machine,
# the list of PVs should be processed in the same order they are stored
# in the configuration. The second numeric parameter in the pair is the
# delay [s] the client should wait before setting the next PV.

_template_dict = {
    'pvs':
        _li_diags + _amcfpgaevr_pvs + _bpm_pvs + _scrn_pvs + _vlightcam_pvs +
        _dcct_pvs + _slit_pvs + _tune_pvs
        # + _ict_pvs  # commented out becaus IOC is down.
        }
