# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nodeum_sdk.configuration import Configuration


class MountInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'major_minor': 'str',
        'target': 'str',
        'source': 'str',
        'options': 'str',
        'type': 'str',
        'pool_id': 'int',
        'pool_name': 'str',
        'nas_id': 'int',
        'nas_name': 'str',
        'nas_share_id': 'int',
        'nas_share_name': 'str',
        'cloud_connector_id': 'int',
        'cloud_connector_name': 'str',
        'cloud_bucket_id': 'int',
        'cloud_bucket_name': 'str',
        'tape_id': 'int',
        'tape_barcode': 'str',
        'tape_library_id': 'int',
        'tape_library_name': 'str',
        'tape_library_serial': 'str'
    }

    attribute_map = {
        'id': 'id',
        'major_minor': 'major_minor',
        'target': 'target',
        'source': 'source',
        'options': 'options',
        'type': 'type',
        'pool_id': 'pool_id',
        'pool_name': 'pool_name',
        'nas_id': 'nas_id',
        'nas_name': 'nas_name',
        'nas_share_id': 'nas_share_id',
        'nas_share_name': 'nas_share_name',
        'cloud_connector_id': 'cloud_connector_id',
        'cloud_connector_name': 'cloud_connector_name',
        'cloud_bucket_id': 'cloud_bucket_id',
        'cloud_bucket_name': 'cloud_bucket_name',
        'tape_id': 'tape_id',
        'tape_barcode': 'tape_barcode',
        'tape_library_id': 'tape_library_id',
        'tape_library_name': 'tape_library_name',
        'tape_library_serial': 'tape_library_serial'
    }

    def __init__(self, id=None, major_minor=None, target=None, source=None, options=None, type=None, pool_id=None, pool_name=None, nas_id=None, nas_name=None, nas_share_id=None, nas_share_name=None, cloud_connector_id=None, cloud_connector_name=None, cloud_bucket_id=None, cloud_bucket_name=None, tape_id=None, tape_barcode=None, tape_library_id=None, tape_library_name=None, tape_library_serial=None, local_vars_configuration=None):  # noqa: E501
        """MountInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._major_minor = None
        self._target = None
        self._source = None
        self._options = None
        self._type = None
        self._pool_id = None
        self._pool_name = None
        self._nas_id = None
        self._nas_name = None
        self._nas_share_id = None
        self._nas_share_name = None
        self._cloud_connector_id = None
        self._cloud_connector_name = None
        self._cloud_bucket_id = None
        self._cloud_bucket_name = None
        self._tape_id = None
        self._tape_barcode = None
        self._tape_library_id = None
        self._tape_library_name = None
        self._tape_library_serial = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if major_minor is not None:
            self.major_minor = major_minor
        if target is not None:
            self.target = target
        if source is not None:
            self.source = source
        if options is not None:
            self.options = options
        if type is not None:
            self.type = type
        if pool_id is not None:
            self.pool_id = pool_id
        if pool_name is not None:
            self.pool_name = pool_name
        if nas_id is not None:
            self.nas_id = nas_id
        if nas_name is not None:
            self.nas_name = nas_name
        if nas_share_id is not None:
            self.nas_share_id = nas_share_id
        if nas_share_name is not None:
            self.nas_share_name = nas_share_name
        if cloud_connector_id is not None:
            self.cloud_connector_id = cloud_connector_id
        if cloud_connector_name is not None:
            self.cloud_connector_name = cloud_connector_name
        if cloud_bucket_id is not None:
            self.cloud_bucket_id = cloud_bucket_id
        if cloud_bucket_name is not None:
            self.cloud_bucket_name = cloud_bucket_name
        if tape_id is not None:
            self.tape_id = tape_id
        if tape_barcode is not None:
            self.tape_barcode = tape_barcode
        if tape_library_id is not None:
            self.tape_library_id = tape_library_id
        if tape_library_name is not None:
            self.tape_library_name = tape_library_name
        if tape_library_serial is not None:
            self.tape_library_serial = tape_library_serial

    @property
    def id(self):
        """Gets the id of this MountInfo.  # noqa: E501


        :return: The id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MountInfo.


        :param id: The id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def major_minor(self):
        """Gets the major_minor of this MountInfo.  # noqa: E501


        :return: The major_minor of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._major_minor

    @major_minor.setter
    def major_minor(self, major_minor):
        """Sets the major_minor of this MountInfo.


        :param major_minor: The major_minor of this MountInfo.  # noqa: E501
        :type: str
        """

        self._major_minor = major_minor

    @property
    def target(self):
        """Gets the target of this MountInfo.  # noqa: E501


        :return: The target of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this MountInfo.


        :param target: The target of this MountInfo.  # noqa: E501
        :type: str
        """

        self._target = target

    @property
    def source(self):
        """Gets the source of this MountInfo.  # noqa: E501


        :return: The source of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this MountInfo.


        :param source: The source of this MountInfo.  # noqa: E501
        :type: str
        """

        self._source = source

    @property
    def options(self):
        """Gets the options of this MountInfo.  # noqa: E501


        :return: The options of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this MountInfo.


        :param options: The options of this MountInfo.  # noqa: E501
        :type: str
        """

        self._options = options

    @property
    def type(self):
        """Gets the type of this MountInfo.  # noqa: E501


        :return: The type of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this MountInfo.


        :param type: The type of this MountInfo.  # noqa: E501
        :type: str
        """
        allowed_values = ["cifs", "nfs", "fuse.s3fs", "fuse.core_fuse", "fuse"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def pool_id(self):
        """Gets the pool_id of this MountInfo.  # noqa: E501


        :return: The pool_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._pool_id

    @pool_id.setter
    def pool_id(self, pool_id):
        """Sets the pool_id of this MountInfo.


        :param pool_id: The pool_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._pool_id = pool_id

    @property
    def pool_name(self):
        """Gets the pool_name of this MountInfo.  # noqa: E501


        :return: The pool_name of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._pool_name

    @pool_name.setter
    def pool_name(self, pool_name):
        """Sets the pool_name of this MountInfo.


        :param pool_name: The pool_name of this MountInfo.  # noqa: E501
        :type: str
        """

        self._pool_name = pool_name

    @property
    def nas_id(self):
        """Gets the nas_id of this MountInfo.  # noqa: E501


        :return: The nas_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._nas_id

    @nas_id.setter
    def nas_id(self, nas_id):
        """Sets the nas_id of this MountInfo.


        :param nas_id: The nas_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._nas_id = nas_id

    @property
    def nas_name(self):
        """Gets the nas_name of this MountInfo.  # noqa: E501


        :return: The nas_name of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._nas_name

    @nas_name.setter
    def nas_name(self, nas_name):
        """Sets the nas_name of this MountInfo.


        :param nas_name: The nas_name of this MountInfo.  # noqa: E501
        :type: str
        """

        self._nas_name = nas_name

    @property
    def nas_share_id(self):
        """Gets the nas_share_id of this MountInfo.  # noqa: E501


        :return: The nas_share_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._nas_share_id

    @nas_share_id.setter
    def nas_share_id(self, nas_share_id):
        """Sets the nas_share_id of this MountInfo.


        :param nas_share_id: The nas_share_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._nas_share_id = nas_share_id

    @property
    def nas_share_name(self):
        """Gets the nas_share_name of this MountInfo.  # noqa: E501


        :return: The nas_share_name of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._nas_share_name

    @nas_share_name.setter
    def nas_share_name(self, nas_share_name):
        """Sets the nas_share_name of this MountInfo.


        :param nas_share_name: The nas_share_name of this MountInfo.  # noqa: E501
        :type: str
        """

        self._nas_share_name = nas_share_name

    @property
    def cloud_connector_id(self):
        """Gets the cloud_connector_id of this MountInfo.  # noqa: E501


        :return: The cloud_connector_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._cloud_connector_id

    @cloud_connector_id.setter
    def cloud_connector_id(self, cloud_connector_id):
        """Sets the cloud_connector_id of this MountInfo.


        :param cloud_connector_id: The cloud_connector_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._cloud_connector_id = cloud_connector_id

    @property
    def cloud_connector_name(self):
        """Gets the cloud_connector_name of this MountInfo.  # noqa: E501


        :return: The cloud_connector_name of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._cloud_connector_name

    @cloud_connector_name.setter
    def cloud_connector_name(self, cloud_connector_name):
        """Sets the cloud_connector_name of this MountInfo.


        :param cloud_connector_name: The cloud_connector_name of this MountInfo.  # noqa: E501
        :type: str
        """

        self._cloud_connector_name = cloud_connector_name

    @property
    def cloud_bucket_id(self):
        """Gets the cloud_bucket_id of this MountInfo.  # noqa: E501


        :return: The cloud_bucket_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._cloud_bucket_id

    @cloud_bucket_id.setter
    def cloud_bucket_id(self, cloud_bucket_id):
        """Sets the cloud_bucket_id of this MountInfo.


        :param cloud_bucket_id: The cloud_bucket_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._cloud_bucket_id = cloud_bucket_id

    @property
    def cloud_bucket_name(self):
        """Gets the cloud_bucket_name of this MountInfo.  # noqa: E501


        :return: The cloud_bucket_name of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._cloud_bucket_name

    @cloud_bucket_name.setter
    def cloud_bucket_name(self, cloud_bucket_name):
        """Sets the cloud_bucket_name of this MountInfo.


        :param cloud_bucket_name: The cloud_bucket_name of this MountInfo.  # noqa: E501
        :type: str
        """

        self._cloud_bucket_name = cloud_bucket_name

    @property
    def tape_id(self):
        """Gets the tape_id of this MountInfo.  # noqa: E501


        :return: The tape_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._tape_id

    @tape_id.setter
    def tape_id(self, tape_id):
        """Sets the tape_id of this MountInfo.


        :param tape_id: The tape_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._tape_id = tape_id

    @property
    def tape_barcode(self):
        """Gets the tape_barcode of this MountInfo.  # noqa: E501


        :return: The tape_barcode of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._tape_barcode

    @tape_barcode.setter
    def tape_barcode(self, tape_barcode):
        """Sets the tape_barcode of this MountInfo.


        :param tape_barcode: The tape_barcode of this MountInfo.  # noqa: E501
        :type: str
        """

        self._tape_barcode = tape_barcode

    @property
    def tape_library_id(self):
        """Gets the tape_library_id of this MountInfo.  # noqa: E501


        :return: The tape_library_id of this MountInfo.  # noqa: E501
        :rtype: int
        """
        return self._tape_library_id

    @tape_library_id.setter
    def tape_library_id(self, tape_library_id):
        """Sets the tape_library_id of this MountInfo.


        :param tape_library_id: The tape_library_id of this MountInfo.  # noqa: E501
        :type: int
        """

        self._tape_library_id = tape_library_id

    @property
    def tape_library_name(self):
        """Gets the tape_library_name of this MountInfo.  # noqa: E501


        :return: The tape_library_name of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._tape_library_name

    @tape_library_name.setter
    def tape_library_name(self, tape_library_name):
        """Sets the tape_library_name of this MountInfo.


        :param tape_library_name: The tape_library_name of this MountInfo.  # noqa: E501
        :type: str
        """

        self._tape_library_name = tape_library_name

    @property
    def tape_library_serial(self):
        """Gets the tape_library_serial of this MountInfo.  # noqa: E501


        :return: The tape_library_serial of this MountInfo.  # noqa: E501
        :rtype: str
        """
        return self._tape_library_serial

    @tape_library_serial.setter
    def tape_library_serial(self, tape_library_serial):
        """Sets the tape_library_serial of this MountInfo.


        :param tape_library_serial: The tape_library_serial of this MountInfo.  # noqa: E501
        :type: str
        """

        self._tape_library_serial = tape_library_serial

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MountInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MountInfo):
            return True

        return self.to_dict() != other.to_dict()
