# -*- coding: utf-8 -*-
"""Count related attribute container definitions."""

from plaso.containers import interface
from plaso.containers import manager


class EventLabelCount(interface.AttributeContainer):
  """Event label count attribute container.

  Attributes:
    label (str): event label.
    number_of_events (int): number of events with label.
  """

  CONTAINER_TYPE = 'event_label_count'

  SCHEMA = {
      'label': 'str',
      'number_of_events': 'int'}

  def __init__(self, label=None, number_of_events=None):
    """Initializes an event label count attribute container.

    Args:
      label (Optional[str]): event label.
      number_of_events (Optional[int]): number of events with label.
          the parser or parser plugin.
    """
    super(EventLabelCount, self).__init__()
    self.label = label
    self.number_of_events = number_of_events


class ParserCount(interface.AttributeContainer):
  """Parser count attribute container.

  Attributes:
    name (str): name of the parser or parser plugin.
    number_of_events (int): number of events generated by the parser or
        parser plugin.
  """

  CONTAINER_TYPE = 'parser_count'

  SCHEMA = {
      'name': 'str',
      'number_of_events': 'int'}

  def __init__(self, name=None, number_of_events=None):
    """Initializes a parser count attribute container.

    Args:
      name (Optional[str]): name of the parser or parser plugin.
      number_of_events (Optional[int]): number of events generated by
          the parser or parser plugin.
    """
    super(ParserCount, self).__init__()
    self.name = name
    self.number_of_events = number_of_events


manager.AttributeContainersManager.RegisterAttributeContainers([
    EventLabelCount, ParserCount])
