import { ISecurityGroup, SubnetSelection } from '@aws-cdk/aws-ec2';
import { FargatePlatformVersion, FargateService, FargateTaskDefinition } from '@aws-cdk/aws-ecs';
import { Construct } from 'constructs';
import { ApplicationLoadBalancedServiceBase, ApplicationLoadBalancedServiceBaseProps } from '../base/application-load-balanced-service-base';
/**
 * The properties for the ApplicationLoadBalancedFargateService service.
 *
 * @stability stable
 */
export interface ApplicationLoadBalancedFargateServiceProps extends ApplicationLoadBalancedServiceBaseProps {
    /**
     * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @default - none
     * @stability stable
     */
    readonly taskDefinition?: FargateTaskDefinition;
    /**
     * The number of cpu units used by the task.
     *
     * Valid values, which determines your range of valid values for the memory parameter:
     *
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     *
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     *
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     *
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     *
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     *
     * This default is set in the underlying FargateTaskDefinition construct.
     *
     * @default 256
     * @stability stable
     */
    readonly cpu?: number;
    /**
     * The amount (in MiB) of memory used by the task.
     *
     * This field is required and you must use one of the following values, which determines your range of valid values
     * for the cpu parameter:
     *
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     *
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     *
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     *
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     *
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     *
     * This default is set in the underlying FargateTaskDefinition construct.
     *
     * @default 512
     * @stability stable
     */
    readonly memoryLimitMiB?: number;
    /**
     * Determines whether the service will be assigned a public IP address.
     *
     * @default false
     * @stability stable
     */
    readonly assignPublicIp?: boolean;
    /**
     * The subnets to associate with the service.
     *
     * @default - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
     * @stability stable
     */
    readonly taskSubnets?: SubnetSelection;
    /**
     * The platform version on which to run your service.
     *
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
     * in the Amazon Elastic Container Service Developer Guide.
     *
     * @default Latest
     * @stability stable
     */
    readonly platformVersion?: FargatePlatformVersion;
    /**
     * The security groups to associate with the service.
     *
     * If you do not specify a security group, a new security group is created.
     *
     * @default - A new security group is created.
     * @stability stable
     */
    readonly securityGroups?: ISecurityGroup[];
}
/**
 * A Fargate service running on an ECS cluster fronted by an application load balancer.
 *
 * @stability stable
 */
export declare class ApplicationLoadBalancedFargateService extends ApplicationLoadBalancedServiceBase {
    /**
     * Determines whether the service will be assigned a public IP address.
     *
     * @stability stable
     */
    readonly assignPublicIp: boolean;
    /**
     * The Fargate service in this construct.
     *
     * @stability stable
     */
    readonly service: FargateService;
    /**
     * The Fargate task definition in this construct.
     *
     * @stability stable
     */
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * Constructs a new instance of the ApplicationLoadBalancedFargateService class.
     *
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ApplicationLoadBalancedFargateServiceProps);
}
