# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input['RepositoryPagesArgs']] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['RepositoryTemplateArgs']] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[str] default_branch: Can only be set after initial repository creation, and only if the target branch exists
        """
        if allow_auto_merge is not None:
            pulumi.set(__self__, "allow_auto_merge", allow_auto_merge)
        if allow_merge_commit is not None:
            pulumi.set(__self__, "allow_merge_commit", allow_merge_commit)
        if allow_rebase_merge is not None:
            pulumi.set(__self__, "allow_rebase_merge", allow_rebase_merge)
        if allow_squash_merge is not None:
            pulumi.set(__self__, "allow_squash_merge", allow_squash_merge)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_init is not None:
            pulumi.set(__self__, "auto_init", auto_init)
        if default_branch is not None:
            warnings.warn("""Use the github_branch_default resource instead""", DeprecationWarning)
            pulumi.log.warn("""default_branch is deprecated: Use the github_branch_default resource instead""")
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if delete_branch_on_merge is not None:
            pulumi.set(__self__, "delete_branch_on_merge", delete_branch_on_merge)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gitignore_template is not None:
            pulumi.set(__self__, "gitignore_template", gitignore_template)
        if has_downloads is not None:
            pulumi.set(__self__, "has_downloads", has_downloads)
        if has_issues is not None:
            pulumi.set(__self__, "has_issues", has_issues)
        if has_projects is not None:
            pulumi.set(__self__, "has_projects", has_projects)
        if has_wiki is not None:
            pulumi.set(__self__, "has_wiki", has_wiki)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if ignore_vulnerability_alerts_during_read is not None:
            pulumi.set(__self__, "ignore_vulnerability_alerts_during_read", ignore_vulnerability_alerts_during_read)
        if is_template is not None:
            pulumi.set(__self__, "is_template", is_template)
        if license_template is not None:
            pulumi.set(__self__, "license_template", license_template)
        if merge_commit_message is not None:
            pulumi.set(__self__, "merge_commit_message", merge_commit_message)
        if merge_commit_title is not None:
            pulumi.set(__self__, "merge_commit_title", merge_commit_title)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)
        if private is not None:
            warnings.warn("""use visibility instead""", DeprecationWarning)
            pulumi.log.warn("""private is deprecated: use visibility instead""")
        if private is not None:
            pulumi.set(__self__, "private", private)
        if squash_merge_commit_message is not None:
            pulumi.set(__self__, "squash_merge_commit_message", squash_merge_commit_message)
        if squash_merge_commit_title is not None:
            pulumi.set(__self__, "squash_merge_commit_title", squash_merge_commit_title)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if vulnerability_alerts is not None:
            pulumi.set(__self__, "vulnerability_alerts", vulnerability_alerts)

    @property
    @pulumi.getter(name="allowAutoMerge")
    def allow_auto_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_auto_merge")

    @allow_auto_merge.setter
    def allow_auto_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_auto_merge", value)

    @property
    @pulumi.getter(name="allowMergeCommit")
    def allow_merge_commit(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_merge_commit")

    @allow_merge_commit.setter
    def allow_merge_commit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_merge_commit", value)

    @property
    @pulumi.getter(name="allowRebaseMerge")
    def allow_rebase_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_rebase_merge")

    @allow_rebase_merge.setter
    def allow_rebase_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_rebase_merge", value)

    @property
    @pulumi.getter(name="allowSquashMerge")
    def allow_squash_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_squash_merge")

    @allow_squash_merge.setter
    def allow_squash_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_squash_merge", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoInit")
    def auto_init(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "auto_init")

    @auto_init.setter
    def auto_init(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_init", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Can only be set after initial repository creation, and only if the target branch exists
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter(name="deleteBranchOnMerge")
    def delete_branch_on_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_branch_on_merge")

    @delete_branch_on_merge.setter
    def delete_branch_on_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_branch_on_merge", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gitignoreTemplate")
    def gitignore_template(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "gitignore_template")

    @gitignore_template.setter
    def gitignore_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gitignore_template", value)

    @property
    @pulumi.getter(name="hasDownloads")
    def has_downloads(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_downloads")

    @has_downloads.setter
    def has_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_downloads", value)

    @property
    @pulumi.getter(name="hasIssues")
    def has_issues(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_issues")

    @has_issues.setter
    def has_issues(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_issues", value)

    @property
    @pulumi.getter(name="hasProjects")
    def has_projects(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_projects")

    @has_projects.setter
    def has_projects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_projects", value)

    @property
    @pulumi.getter(name="hasWiki")
    def has_wiki(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_wiki")

    @has_wiki.setter
    def has_wiki(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_wiki", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="ignoreVulnerabilityAlertsDuringRead")
    def ignore_vulnerability_alerts_during_read(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ignore_vulnerability_alerts_during_read")

    @ignore_vulnerability_alerts_during_read.setter
    def ignore_vulnerability_alerts_during_read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_vulnerability_alerts_during_read", value)

    @property
    @pulumi.getter(name="isTemplate")
    def is_template(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_template")

    @is_template.setter
    def is_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_template", value)

    @property
    @pulumi.getter(name="licenseTemplate")
    def license_template(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "license_template")

    @license_template.setter
    def license_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_template", value)

    @property
    @pulumi.getter(name="mergeCommitMessage")
    def merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "merge_commit_message")

    @merge_commit_message.setter
    def merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_message", value)

    @property
    @pulumi.getter(name="mergeCommitTitle")
    def merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "merge_commit_title")

    @merge_commit_title.setter
    def merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_title", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input['RepositoryPagesArgs']]:
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input['RepositoryPagesArgs']]):
        pulumi.set(self, "pages", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter(name="squashMergeCommitMessage")
    def squash_merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "squash_merge_commit_message")

    @squash_merge_commit_message.setter
    def squash_merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_message", value)

    @property
    @pulumi.getter(name="squashMergeCommitTitle")
    def squash_merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "squash_merge_commit_title")

    @squash_merge_commit_title.setter
    def squash_merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_title", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['RepositoryTemplateArgs']]:
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['RepositoryTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="vulnerabilityAlerts")
    def vulnerability_alerts(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "vulnerability_alerts")

    @vulnerability_alerts.setter
    def vulnerability_alerts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vulnerability_alerts", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 git_clone_url: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 html_url: Optional[pulumi.Input[str]] = None,
                 http_clone_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_id: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input['RepositoryPagesArgs']] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 repo_id: Optional[pulumi.Input[int]] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 ssh_clone_url: Optional[pulumi.Input[str]] = None,
                 svn_url: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['RepositoryTemplateArgs']] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[str] default_branch: Can only be set after initial repository creation, and only if the target branch exists
        """
        if allow_auto_merge is not None:
            pulumi.set(__self__, "allow_auto_merge", allow_auto_merge)
        if allow_merge_commit is not None:
            pulumi.set(__self__, "allow_merge_commit", allow_merge_commit)
        if allow_rebase_merge is not None:
            pulumi.set(__self__, "allow_rebase_merge", allow_rebase_merge)
        if allow_squash_merge is not None:
            pulumi.set(__self__, "allow_squash_merge", allow_squash_merge)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_init is not None:
            pulumi.set(__self__, "auto_init", auto_init)
        if default_branch is not None:
            warnings.warn("""Use the github_branch_default resource instead""", DeprecationWarning)
            pulumi.log.warn("""default_branch is deprecated: Use the github_branch_default resource instead""")
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if delete_branch_on_merge is not None:
            pulumi.set(__self__, "delete_branch_on_merge", delete_branch_on_merge)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if git_clone_url is not None:
            pulumi.set(__self__, "git_clone_url", git_clone_url)
        if gitignore_template is not None:
            pulumi.set(__self__, "gitignore_template", gitignore_template)
        if has_downloads is not None:
            pulumi.set(__self__, "has_downloads", has_downloads)
        if has_issues is not None:
            pulumi.set(__self__, "has_issues", has_issues)
        if has_projects is not None:
            pulumi.set(__self__, "has_projects", has_projects)
        if has_wiki is not None:
            pulumi.set(__self__, "has_wiki", has_wiki)
        if homepage_url is not None:
            pulumi.set(__self__, "homepage_url", homepage_url)
        if html_url is not None:
            pulumi.set(__self__, "html_url", html_url)
        if http_clone_url is not None:
            pulumi.set(__self__, "http_clone_url", http_clone_url)
        if ignore_vulnerability_alerts_during_read is not None:
            pulumi.set(__self__, "ignore_vulnerability_alerts_during_read", ignore_vulnerability_alerts_during_read)
        if is_template is not None:
            pulumi.set(__self__, "is_template", is_template)
        if license_template is not None:
            pulumi.set(__self__, "license_template", license_template)
        if merge_commit_message is not None:
            pulumi.set(__self__, "merge_commit_message", merge_commit_message)
        if merge_commit_title is not None:
            pulumi.set(__self__, "merge_commit_title", merge_commit_title)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)
        if private is not None:
            warnings.warn("""use visibility instead""", DeprecationWarning)
            pulumi.log.warn("""private is deprecated: use visibility instead""")
        if private is not None:
            pulumi.set(__self__, "private", private)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if squash_merge_commit_message is not None:
            pulumi.set(__self__, "squash_merge_commit_message", squash_merge_commit_message)
        if squash_merge_commit_title is not None:
            pulumi.set(__self__, "squash_merge_commit_title", squash_merge_commit_title)
        if ssh_clone_url is not None:
            pulumi.set(__self__, "ssh_clone_url", ssh_clone_url)
        if svn_url is not None:
            pulumi.set(__self__, "svn_url", svn_url)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if vulnerability_alerts is not None:
            pulumi.set(__self__, "vulnerability_alerts", vulnerability_alerts)

    @property
    @pulumi.getter(name="allowAutoMerge")
    def allow_auto_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_auto_merge")

    @allow_auto_merge.setter
    def allow_auto_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_auto_merge", value)

    @property
    @pulumi.getter(name="allowMergeCommit")
    def allow_merge_commit(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_merge_commit")

    @allow_merge_commit.setter
    def allow_merge_commit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_merge_commit", value)

    @property
    @pulumi.getter(name="allowRebaseMerge")
    def allow_rebase_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_rebase_merge")

    @allow_rebase_merge.setter
    def allow_rebase_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_rebase_merge", value)

    @property
    @pulumi.getter(name="allowSquashMerge")
    def allow_squash_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_squash_merge")

    @allow_squash_merge.setter
    def allow_squash_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_squash_merge", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoInit")
    def auto_init(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "auto_init")

    @auto_init.setter
    def auto_init(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_init", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        Can only be set after initial repository creation, and only if the target branch exists
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter(name="deleteBranchOnMerge")
    def delete_branch_on_merge(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_branch_on_merge")

    @delete_branch_on_merge.setter
    def delete_branch_on_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_branch_on_merge", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="gitCloneUrl")
    def git_clone_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "git_clone_url")

    @git_clone_url.setter
    def git_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "git_clone_url", value)

    @property
    @pulumi.getter(name="gitignoreTemplate")
    def gitignore_template(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "gitignore_template")

    @gitignore_template.setter
    def gitignore_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gitignore_template", value)

    @property
    @pulumi.getter(name="hasDownloads")
    def has_downloads(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_downloads")

    @has_downloads.setter
    def has_downloads(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_downloads", value)

    @property
    @pulumi.getter(name="hasIssues")
    def has_issues(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_issues")

    @has_issues.setter
    def has_issues(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_issues", value)

    @property
    @pulumi.getter(name="hasProjects")
    def has_projects(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_projects")

    @has_projects.setter
    def has_projects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_projects", value)

    @property
    @pulumi.getter(name="hasWiki")
    def has_wiki(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "has_wiki")

    @has_wiki.setter
    def has_wiki(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_wiki", value)

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "homepage_url")

    @homepage_url.setter
    def homepage_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "homepage_url", value)

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "html_url")

    @html_url.setter
    def html_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "html_url", value)

    @property
    @pulumi.getter(name="httpCloneUrl")
    def http_clone_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_clone_url")

    @http_clone_url.setter
    def http_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_clone_url", value)

    @property
    @pulumi.getter(name="ignoreVulnerabilityAlertsDuringRead")
    def ignore_vulnerability_alerts_during_read(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ignore_vulnerability_alerts_during_read")

    @ignore_vulnerability_alerts_during_read.setter
    def ignore_vulnerability_alerts_during_read(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_vulnerability_alerts_during_read", value)

    @property
    @pulumi.getter(name="isTemplate")
    def is_template(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_template")

    @is_template.setter
    def is_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_template", value)

    @property
    @pulumi.getter(name="licenseTemplate")
    def license_template(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "license_template")

    @license_template.setter
    def license_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_template", value)

    @property
    @pulumi.getter(name="mergeCommitMessage")
    def merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "merge_commit_message")

    @merge_commit_message.setter
    def merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_message", value)

    @property
    @pulumi.getter(name="mergeCommitTitle")
    def merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "merge_commit_title")

    @merge_commit_title.setter
    def merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_title", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_id", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input['RepositoryPagesArgs']]:
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input['RepositoryPagesArgs']]):
        pulumi.set(self, "pages", value)

    @property
    @pulumi.getter
    def private(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "private")

    @private.setter
    def private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private", value)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "repo_id", value)

    @property
    @pulumi.getter(name="squashMergeCommitMessage")
    def squash_merge_commit_message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "squash_merge_commit_message")

    @squash_merge_commit_message.setter
    def squash_merge_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_message", value)

    @property
    @pulumi.getter(name="squashMergeCommitTitle")
    def squash_merge_commit_title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "squash_merge_commit_title")

    @squash_merge_commit_title.setter
    def squash_merge_commit_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_merge_commit_title", value)

    @property
    @pulumi.getter(name="sshCloneUrl")
    def ssh_clone_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ssh_clone_url")

    @ssh_clone_url.setter
    def ssh_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_clone_url", value)

    @property
    @pulumi.getter(name="svnUrl")
    def svn_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "svn_url")

    @svn_url.setter
    def svn_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "svn_url", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['RepositoryTemplateArgs']]:
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['RepositoryTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility", value)

    @property
    @pulumi.getter(name="vulnerabilityAlerts")
    def vulnerability_alerts(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "vulnerability_alerts")

    @vulnerability_alerts.setter
    def vulnerability_alerts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vulnerability_alerts", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input[pulumi.InputType['RepositoryPagesArgs']]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a Repository resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_branch: Can only be set after initial repository creation, and only if the target branch exists
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RepositoryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Repository resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_auto_merge: Optional[pulumi.Input[bool]] = None,
                 allow_merge_commit: Optional[pulumi.Input[bool]] = None,
                 allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
                 allow_squash_merge: Optional[pulumi.Input[bool]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_init: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gitignore_template: Optional[pulumi.Input[str]] = None,
                 has_downloads: Optional[pulumi.Input[bool]] = None,
                 has_issues: Optional[pulumi.Input[bool]] = None,
                 has_projects: Optional[pulumi.Input[bool]] = None,
                 has_wiki: Optional[pulumi.Input[bool]] = None,
                 homepage_url: Optional[pulumi.Input[str]] = None,
                 ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
                 is_template: Optional[pulumi.Input[bool]] = None,
                 license_template: Optional[pulumi.Input[str]] = None,
                 merge_commit_message: Optional[pulumi.Input[str]] = None,
                 merge_commit_title: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input[pulumi.InputType['RepositoryPagesArgs']]] = None,
                 private: Optional[pulumi.Input[bool]] = None,
                 squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
                 squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 visibility: Optional[pulumi.Input[str]] = None,
                 vulnerability_alerts: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["allow_auto_merge"] = allow_auto_merge
            __props__.__dict__["allow_merge_commit"] = allow_merge_commit
            __props__.__dict__["allow_rebase_merge"] = allow_rebase_merge
            __props__.__dict__["allow_squash_merge"] = allow_squash_merge
            __props__.__dict__["archive_on_destroy"] = archive_on_destroy
            __props__.__dict__["archived"] = archived
            __props__.__dict__["auto_init"] = auto_init
            if default_branch is not None and not opts.urn:
                warnings.warn("""Use the github_branch_default resource instead""", DeprecationWarning)
                pulumi.log.warn("""default_branch is deprecated: Use the github_branch_default resource instead""")
            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["delete_branch_on_merge"] = delete_branch_on_merge
            __props__.__dict__["description"] = description
            __props__.__dict__["gitignore_template"] = gitignore_template
            __props__.__dict__["has_downloads"] = has_downloads
            __props__.__dict__["has_issues"] = has_issues
            __props__.__dict__["has_projects"] = has_projects
            __props__.__dict__["has_wiki"] = has_wiki
            __props__.__dict__["homepage_url"] = homepage_url
            __props__.__dict__["ignore_vulnerability_alerts_during_read"] = ignore_vulnerability_alerts_during_read
            __props__.__dict__["is_template"] = is_template
            __props__.__dict__["license_template"] = license_template
            __props__.__dict__["merge_commit_message"] = merge_commit_message
            __props__.__dict__["merge_commit_title"] = merge_commit_title
            __props__.__dict__["name"] = name
            __props__.__dict__["pages"] = pages
            if private is not None and not opts.urn:
                warnings.warn("""use visibility instead""", DeprecationWarning)
                pulumi.log.warn("""private is deprecated: use visibility instead""")
            __props__.__dict__["private"] = private
            __props__.__dict__["squash_merge_commit_message"] = squash_merge_commit_message
            __props__.__dict__["squash_merge_commit_title"] = squash_merge_commit_title
            __props__.__dict__["template"] = template
            __props__.__dict__["topics"] = topics
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["vulnerability_alerts"] = vulnerability_alerts
            __props__.__dict__["etag"] = None
            __props__.__dict__["full_name"] = None
            __props__.__dict__["git_clone_url"] = None
            __props__.__dict__["html_url"] = None
            __props__.__dict__["http_clone_url"] = None
            __props__.__dict__["node_id"] = None
            __props__.__dict__["repo_id"] = None
            __props__.__dict__["ssh_clone_url"] = None
            __props__.__dict__["svn_url"] = None
        super(Repository, __self__).__init__(
            'github:index/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_auto_merge: Optional[pulumi.Input[bool]] = None,
            allow_merge_commit: Optional[pulumi.Input[bool]] = None,
            allow_rebase_merge: Optional[pulumi.Input[bool]] = None,
            allow_squash_merge: Optional[pulumi.Input[bool]] = None,
            archive_on_destroy: Optional[pulumi.Input[bool]] = None,
            archived: Optional[pulumi.Input[bool]] = None,
            auto_init: Optional[pulumi.Input[bool]] = None,
            default_branch: Optional[pulumi.Input[str]] = None,
            delete_branch_on_merge: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            full_name: Optional[pulumi.Input[str]] = None,
            git_clone_url: Optional[pulumi.Input[str]] = None,
            gitignore_template: Optional[pulumi.Input[str]] = None,
            has_downloads: Optional[pulumi.Input[bool]] = None,
            has_issues: Optional[pulumi.Input[bool]] = None,
            has_projects: Optional[pulumi.Input[bool]] = None,
            has_wiki: Optional[pulumi.Input[bool]] = None,
            homepage_url: Optional[pulumi.Input[str]] = None,
            html_url: Optional[pulumi.Input[str]] = None,
            http_clone_url: Optional[pulumi.Input[str]] = None,
            ignore_vulnerability_alerts_during_read: Optional[pulumi.Input[bool]] = None,
            is_template: Optional[pulumi.Input[bool]] = None,
            license_template: Optional[pulumi.Input[str]] = None,
            merge_commit_message: Optional[pulumi.Input[str]] = None,
            merge_commit_title: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_id: Optional[pulumi.Input[str]] = None,
            pages: Optional[pulumi.Input[pulumi.InputType['RepositoryPagesArgs']]] = None,
            private: Optional[pulumi.Input[bool]] = None,
            repo_id: Optional[pulumi.Input[int]] = None,
            squash_merge_commit_message: Optional[pulumi.Input[str]] = None,
            squash_merge_commit_title: Optional[pulumi.Input[str]] = None,
            ssh_clone_url: Optional[pulumi.Input[str]] = None,
            svn_url: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['RepositoryTemplateArgs']]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            visibility: Optional[pulumi.Input[str]] = None,
            vulnerability_alerts: Optional[pulumi.Input[bool]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_branch: Can only be set after initial repository creation, and only if the target branch exists
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["allow_auto_merge"] = allow_auto_merge
        __props__.__dict__["allow_merge_commit"] = allow_merge_commit
        __props__.__dict__["allow_rebase_merge"] = allow_rebase_merge
        __props__.__dict__["allow_squash_merge"] = allow_squash_merge
        __props__.__dict__["archive_on_destroy"] = archive_on_destroy
        __props__.__dict__["archived"] = archived
        __props__.__dict__["auto_init"] = auto_init
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["delete_branch_on_merge"] = delete_branch_on_merge
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["git_clone_url"] = git_clone_url
        __props__.__dict__["gitignore_template"] = gitignore_template
        __props__.__dict__["has_downloads"] = has_downloads
        __props__.__dict__["has_issues"] = has_issues
        __props__.__dict__["has_projects"] = has_projects
        __props__.__dict__["has_wiki"] = has_wiki
        __props__.__dict__["homepage_url"] = homepage_url
        __props__.__dict__["html_url"] = html_url
        __props__.__dict__["http_clone_url"] = http_clone_url
        __props__.__dict__["ignore_vulnerability_alerts_during_read"] = ignore_vulnerability_alerts_during_read
        __props__.__dict__["is_template"] = is_template
        __props__.__dict__["license_template"] = license_template
        __props__.__dict__["merge_commit_message"] = merge_commit_message
        __props__.__dict__["merge_commit_title"] = merge_commit_title
        __props__.__dict__["name"] = name
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["pages"] = pages
        __props__.__dict__["private"] = private
        __props__.__dict__["repo_id"] = repo_id
        __props__.__dict__["squash_merge_commit_message"] = squash_merge_commit_message
        __props__.__dict__["squash_merge_commit_title"] = squash_merge_commit_title
        __props__.__dict__["ssh_clone_url"] = ssh_clone_url
        __props__.__dict__["svn_url"] = svn_url
        __props__.__dict__["template"] = template
        __props__.__dict__["topics"] = topics
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["vulnerability_alerts"] = vulnerability_alerts
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowAutoMerge")
    def allow_auto_merge(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_auto_merge")

    @property
    @pulumi.getter(name="allowMergeCommit")
    def allow_merge_commit(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_merge_commit")

    @property
    @pulumi.getter(name="allowRebaseMerge")
    def allow_rebase_merge(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_rebase_merge")

    @property
    @pulumi.getter(name="allowSquashMerge")
    def allow_squash_merge(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_squash_merge")

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "archive_on_destroy")

    @property
    @pulumi.getter
    def archived(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="autoInit")
    def auto_init(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "auto_init")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[str]:
        """
        Can only be set after initial repository creation, and only if the target branch exists
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter(name="deleteBranchOnMerge")
    def delete_branch_on_merge(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "delete_branch_on_merge")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="gitCloneUrl")
    def git_clone_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "git_clone_url")

    @property
    @pulumi.getter(name="gitignoreTemplate")
    def gitignore_template(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "gitignore_template")

    @property
    @pulumi.getter(name="hasDownloads")
    def has_downloads(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "has_downloads")

    @property
    @pulumi.getter(name="hasIssues")
    def has_issues(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "has_issues")

    @property
    @pulumi.getter(name="hasProjects")
    def has_projects(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "has_projects")

    @property
    @pulumi.getter(name="hasWiki")
    def has_wiki(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "has_wiki")

    @property
    @pulumi.getter(name="homepageUrl")
    def homepage_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "homepage_url")

    @property
    @pulumi.getter(name="htmlUrl")
    def html_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "html_url")

    @property
    @pulumi.getter(name="httpCloneUrl")
    def http_clone_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "http_clone_url")

    @property
    @pulumi.getter(name="ignoreVulnerabilityAlertsDuringRead")
    def ignore_vulnerability_alerts_during_read(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "ignore_vulnerability_alerts_during_read")

    @property
    @pulumi.getter(name="isTemplate")
    def is_template(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "is_template")

    @property
    @pulumi.getter(name="licenseTemplate")
    def license_template(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "license_template")

    @property
    @pulumi.getter(name="mergeCommitMessage")
    def merge_commit_message(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "merge_commit_message")

    @property
    @pulumi.getter(name="mergeCommitTitle")
    def merge_commit_title(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "merge_commit_title")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def pages(self) -> pulumi.Output[Optional['outputs.RepositoryPages']]:
        return pulumi.get(self, "pages")

    @property
    @pulumi.getter
    def private(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "private")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="squashMergeCommitMessage")
    def squash_merge_commit_message(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "squash_merge_commit_message")

    @property
    @pulumi.getter(name="squashMergeCommitTitle")
    def squash_merge_commit_title(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "squash_merge_commit_title")

    @property
    @pulumi.getter(name="sshCloneUrl")
    def ssh_clone_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ssh_clone_url")

    @property
    @pulumi.getter(name="svnUrl")
    def svn_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "svn_url")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.RepositoryTemplate']]:
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[str]:
        return pulumi.get(self, "visibility")

    @property
    @pulumi.getter(name="vulnerabilityAlerts")
    def vulnerability_alerts(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "vulnerability_alerts")

