##
# File:    PdbxSchemaDef.py  (Version 4)
# Author:  J. Westbrook
# Date:    12-Jan-2013
# Version: 0.001 Initial version
#
# Updates:
#
# 15-Jan-2013 jdw - simplify index for table NDB_STRUCT_NA_BASE_PAIR_STEP
# 16-Jan-2012 jdw - converted from revised schema with updated field width data
#  5-Jul-2017 jdw - add pdb_entry table -
#
#                   *** This file is going to be generally obsolete with V5 -
##
"""
Database schema definitions for PDBx data categories populated in model files.

"""
__docformat__ = "restructuredtext en"
__author__ = "John Westbrook"
__email__ = "jwest@rcsb.rutgers.edu"
__license__ = "Creative Commons Attribution 3.0 Unported"
__version__ = "V0.001"

import sys
from wwpdb.utils.db.SchemaDefBase import SchemaDefBase


class PdbxSchemaDef(SchemaDefBase):
    """ A data class containing schema definitions PDBx data categories populated in model files.
    """
    _databaseName = "pdbxv4"
    _schemaDefDict = {
        'ATOM_SITE': {'ATTRIBUTES': {'ADP_TYPE': 'adp_type',
                                     'ANISO_B_1_1': 'aniso_B_1_1',
                                     'ANISO_B_1_1_ESD': 'aniso_B_1_1_esd',
                                     'ANISO_B_1_2': 'aniso_B_1_2',
                                     'ANISO_B_1_2_ESD': 'aniso_B_1_2_esd',
                                     'ANISO_B_1_3': 'aniso_B_1_3',
                                     'ANISO_B_1_3_ESD': 'aniso_B_1_3_esd',
                                     'ANISO_B_2_2': 'aniso_B_2_2',
                                     'ANISO_B_2_2_ESD': 'aniso_B_2_2_esd',
                                     'ANISO_B_2_3': 'aniso_B_2_3',
                                     'ANISO_B_2_3_ESD': 'aniso_B_2_3_esd',
                                     'ANISO_B_3_3': 'aniso_B_3_3',
                                     'ANISO_B_3_3_ESD': 'aniso_B_3_3_esd',
                                     'ANISO_RATIO': 'aniso_ratio',
                                     'ANISO_U_1_1': 'aniso_U_1_1',
                                     'ANISO_U_1_1_ESD': 'aniso_U_1_1_esd',
                                     'ANISO_U_1_2': 'aniso_U_1_2',
                                     'ANISO_U_1_2_ESD': 'aniso_U_1_2_esd',
                                     'ANISO_U_1_3': 'aniso_U_1_3',
                                     'ANISO_U_1_3_ESD': 'aniso_U_1_3_esd',
                                     'ANISO_U_2_2': 'aniso_U_2_2',
                                     'ANISO_U_2_2_ESD': 'aniso_U_2_2_esd',
                                     'ANISO_U_2_3': 'aniso_U_2_3',
                                     'ANISO_U_2_3_ESD': 'aniso_U_2_3_esd',
                                     'ANISO_U_3_3': 'aniso_U_3_3',
                                     'ANISO_U_3_3_ESD': 'aniso_U_3_3_esd',
                                     'ATTACHED_HYDROGENS': 'attached_hydrogens',
                                     'AUTH_ASYM_ID': 'auth_asym_id',
                                     'AUTH_ATOM_ID': 'auth_atom_id',
                                     'AUTH_COMP_ID': 'auth_comp_id',
                                     'AUTH_SEQ_ID': 'auth_seq_id',
                                     'B_EQUIV_GEOM_MEAN': 'B_equiv_geom_mean',
                                     'B_EQUIV_GEOM_MEAN_ESD': 'B_equiv_geom_mean_esd',
                                     'B_ISO_OR_EQUIV': 'B_iso_or_equiv',
                                     'B_ISO_OR_EQUIV_ESD': 'B_iso_or_equiv_esd',
                                     'CALC_ATTACHED_ATOM': 'calc_attached_atom',
                                     'CALC_FLAG': 'calc_flag',
                                     'CARTN_X': 'Cartn_x',
                                     'CARTN_X_ESD': 'Cartn_x_esd',
                                     'CARTN_Y': 'Cartn_y',
                                     'CARTN_Y_ESD': 'Cartn_y_esd',
                                     'CARTN_Z': 'Cartn_z',
                                     'CARTN_Z_ESD': 'Cartn_z_esd',
                                     'CHEMICAL_CONN_NUMBER': 'chemical_conn_number',
                                     'CONSTRAINTS': 'constraints',
                                     'DETAILS': 'details',
                                     'DISORDER_ASSEMBLY': 'disorder_assembly',
                                     'DISORDER_GROUP': 'disorder_group',
                                     'FOOTNOTE_ID': 'footnote_id',
                                     'FRACT_X': 'fract_x',
                                     'FRACT_X_ESD': 'fract_x_esd',
                                     'FRACT_Y': 'fract_y',
                                     'FRACT_Y_ESD': 'fract_y_esd',
                                     'FRACT_Z': 'fract_z',
                                     'FRACT_Z_ESD': 'fract_z_esd',
                                     'GROUP_PDB': 'group_PDB',
                                     'ID': 'id',
                                     'LABEL_ALT_ID': 'label_alt_id',
                                     'LABEL_ASYM_ID': 'label_asym_id',
                                     'LABEL_ATOM_ID': 'label_atom_id',
                                     'LABEL_COMP_ID': 'label_comp_id',
                                     'LABEL_ENTITY_ID': 'label_entity_id',
                                     'LABEL_SEQ_ID': 'label_seq_id',
                                     'OCCUPANCY': 'occupancy',
                                     'OCCUPANCY_ESD': 'occupancy_esd',
                                     'PDBX_AUTH_ALT_ID': 'pdbx_auth_alt_id',
                                     'PDBX_AUTH_ASYM_ID': 'pdbx_auth_asym_id',
                                     'PDBX_AUTH_ATOM_NAME': 'pdbx_auth_atom_name',
                                     'PDBX_AUTH_COMP_ID': 'pdbx_auth_comp_id',
                                     'PDBX_AUTH_SEQ_ID': 'pdbx_auth_seq_id',
                                     'PDBX_FORMAL_CHARGE': 'pdbx_formal_charge',
                                     'PDBX_NCS_DOM_ID': 'pdbx_ncs_dom_id',
                                     'PDBX_PDB_ATOM_NAME': 'pdbx_PDB_atom_name',
                                     'PDBX_PDB_INS_CODE': 'pdbx_PDB_ins_code',
                                     'PDBX_PDB_MODEL_NUM': 'pdbx_PDB_model_num',
                                     'PDBX_PDB_RESIDUE_NAME': 'pdbx_PDB_residue_name',
                                     'PDBX_PDB_RESIDUE_NO': 'pdbx_PDB_residue_no',
                                     'PDBX_PDB_STRAND_ID': 'pdbx_PDB_strand_id',
                                     'PDBX_STRUCT_GROUP_ID': 'pdbx_struct_group_id',
                                     'PDBX_TLS_GROUP_ID': 'pdbx_tls_group_id',
                                     'REFINEMENT_FLAGS': 'refinement_flags',
                                     'REFINEMENT_FLAGS_ADP': 'refinement_flags_adp',
                                     'REFINEMENT_FLAGS_OCCUPANCY': 'refinement_flags_occupancy',
                                     'REFINEMENT_FLAGS_POSN': 'refinement_flags_posn',
                                     'RESTRAINTS': 'restraints',
                                     'STRUCTURE_ID': 'Structure_ID',
                                     'SYMMETRY_MULTIPLICITY': 'symmetry_multiplicity',
                                     'THERMAL_DISPLACE_TYPE': 'thermal_displace_type',
                                     'TYPE_SYMBOL': 'type_symbol',
                                     'U_EQUIV_GEOM_MEAN': 'U_equiv_geom_mean',
                                     'U_EQUIV_GEOM_MEAN_ESD': 'U_equiv_geom_mean_esd',
                                     'U_ISO_OR_EQUIV': 'U_iso_or_equiv',
                                     'U_ISO_OR_EQUIV_ESD': 'U_iso_or_equiv_esd',
                                     'WYCKOFF_SYMBOL': 'Wyckoff_symbol'},
                      'ATTRIBUTE_INFO': {'ADP_TYPE': {'NULLABLE': True,
                                                      'ORDER': 75,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                         'ANISO_B_1_1': {'NULLABLE': True,
                                                         'ORDER': 2,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_B_1_1_ESD': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_B_1_2': {'NULLABLE': True,
                                                         'ORDER': 4,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_B_1_2_ESD': {'NULLABLE': True,
                                                             'ORDER': 5,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_B_1_3': {'NULLABLE': True,
                                                         'ORDER': 6,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_B_1_3_ESD': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_B_2_2': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_B_2_2_ESD': {'NULLABLE': True,
                                                             'ORDER': 9,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_B_2_3': {'NULLABLE': True,
                                                         'ORDER': 10,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_B_2_3_ESD': {'NULLABLE': True,
                                                             'ORDER': 11,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_B_3_3': {'NULLABLE': True,
                                                         'ORDER': 12,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_B_3_3_ESD': {'NULLABLE': True,
                                                             'ORDER': 13,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_RATIO': {'NULLABLE': True,
                                                         'ORDER': 14,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_1_1': {'NULLABLE': True,
                                                         'ORDER': 15,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_1_1_ESD': {'NULLABLE': True,
                                                             'ORDER': 16,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_U_1_2': {'NULLABLE': True,
                                                         'ORDER': 17,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_1_2_ESD': {'NULLABLE': True,
                                                             'ORDER': 18,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_U_1_3': {'NULLABLE': True,
                                                         'ORDER': 19,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_1_3_ESD': {'NULLABLE': True,
                                                             'ORDER': 20,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_U_2_2': {'NULLABLE': True,
                                                         'ORDER': 21,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_2_2_ESD': {'NULLABLE': True,
                                                             'ORDER': 22,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_U_2_3': {'NULLABLE': True,
                                                         'ORDER': 23,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_2_3_ESD': {'NULLABLE': True,
                                                             'ORDER': 24,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ANISO_U_3_3': {'NULLABLE': True,
                                                         'ORDER': 25,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'ANISO_U_3_3_ESD': {'NULLABLE': True,
                                                             'ORDER': 26,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                         'ATTACHED_HYDROGENS': {'NULLABLE': True,
                                                                'ORDER': 27,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                         'AUTH_ASYM_ID': {'NULLABLE': True,
                                                          'ORDER': 28,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'AUTH_ATOM_ID': {'NULLABLE': True,
                                                          'ORDER': 29,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 6},
                                         'AUTH_COMP_ID': {'NULLABLE': True,
                                                          'ORDER': 30,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'AUTH_SEQ_ID': {'NULLABLE': True,
                                                         'ORDER': 31,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                         'B_EQUIV_GEOM_MEAN': {'NULLABLE': True,
                                                               'ORDER': 32,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                         'B_EQUIV_GEOM_MEAN_ESD': {'NULLABLE': True,
                                                                   'ORDER': 33,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                         'B_ISO_OR_EQUIV': {'NULLABLE': True,
                                                            'ORDER': 34,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'B_ISO_OR_EQUIV_ESD': {'NULLABLE': True,
                                                                'ORDER': 35,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                         'CALC_ATTACHED_ATOM': {'NULLABLE': True,
                                                                'ORDER': 36,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                         'CALC_FLAG': {'NULLABLE': True,
                                                       'ORDER': 37,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                         'CARTN_X': {'NULLABLE': True,
                                                     'ORDER': 38,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                         'CARTN_X_ESD': {'NULLABLE': True,
                                                         'ORDER': 39,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'CARTN_Y': {'NULLABLE': True,
                                                     'ORDER': 40,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                         'CARTN_Y_ESD': {'NULLABLE': True,
                                                         'ORDER': 41,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'CARTN_Z': {'NULLABLE': True,
                                                     'ORDER': 42,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                         'CARTN_Z_ESD': {'NULLABLE': True,
                                                         'ORDER': 43,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'CHEMICAL_CONN_NUMBER': {'NULLABLE': True,
                                                                  'ORDER': 44,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                         'CONSTRAINTS': {'NULLABLE': True,
                                                         'ORDER': 45,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 80},
                                         'DETAILS': {'NULLABLE': True,
                                                     'ORDER': 46,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'DISORDER_ASSEMBLY': {'NULLABLE': True,
                                                               'ORDER': 47,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                         'DISORDER_GROUP': {'NULLABLE': True,
                                                            'ORDER': 48,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                         'FOOTNOTE_ID': {'NULLABLE': True,
                                                         'ORDER': 49,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                         'FRACT_X': {'NULLABLE': True,
                                                     'ORDER': 50,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                         'FRACT_X_ESD': {'NULLABLE': True,
                                                         'ORDER': 51,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'FRACT_Y': {'NULLABLE': True,
                                                     'ORDER': 52,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                         'FRACT_Y_ESD': {'NULLABLE': True,
                                                         'ORDER': 53,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'FRACT_Z': {'NULLABLE': True,
                                                     'ORDER': 54,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                         'FRACT_Z_ESD': {'NULLABLE': True,
                                                         'ORDER': 55,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'GROUP_PDB': {'NULLABLE': True,
                                                       'ORDER': 56,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 57,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 10},
                                         'LABEL_ALT_ID': {'NULLABLE': True,
                                                          'ORDER': 58,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'LABEL_ASYM_ID': {'NULLABLE': True,
                                                           'ORDER': 59,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                         'LABEL_ATOM_ID': {'NULLABLE': True,
                                                           'ORDER': 60,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                         'LABEL_COMP_ID': {'NULLABLE': True,
                                                           'ORDER': 61,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                         'LABEL_ENTITY_ID': {'NULLABLE': True,
                                                             'ORDER': 62,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                         'LABEL_SEQ_ID': {'NULLABLE': True,
                                                          'ORDER': 63,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'INT',
                                                          'WIDTH': 10},
                                         'OCCUPANCY': {'NULLABLE': True,
                                                       'ORDER': 64,
                                                       'PRECISION': 6,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                         'OCCUPANCY_ESD': {'NULLABLE': True,
                                                           'ORDER': 65,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                         'PDBX_AUTH_ALT_ID': {'NULLABLE': True,
                                                              'ORDER': 80,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                         'PDBX_AUTH_ASYM_ID': {'NULLABLE': True,
                                                               'ORDER': 90,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                         'PDBX_AUTH_ATOM_NAME': {'NULLABLE': True,
                                                                 'ORDER': 87,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 6},
                                         'PDBX_AUTH_COMP_ID': {'NULLABLE': True,
                                                               'ORDER': 89,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                         'PDBX_AUTH_SEQ_ID': {'NULLABLE': True,
                                                              'ORDER': 91,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                         'PDBX_FORMAL_CHARGE': {'NULLABLE': True,
                                                                'ORDER': 88,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                         'PDBX_NCS_DOM_ID': {'NULLABLE': True,
                                                             'ORDER': 93,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                         'PDBX_PDB_ATOM_NAME': {'NULLABLE': True,
                                                                'ORDER': 86,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                         'PDBX_PDB_INS_CODE': {'NULLABLE': True,
                                                               'ORDER': 81,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                         'PDBX_PDB_MODEL_NUM': {'NULLABLE': True,
                                                                'ORDER': 82,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                         'PDBX_PDB_RESIDUE_NAME': {'NULLABLE': True,
                                                                   'ORDER': 84,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                         'PDBX_PDB_RESIDUE_NO': {'NULLABLE': True,
                                                                 'ORDER': 83,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                         'PDBX_PDB_STRAND_ID': {'NULLABLE': True,
                                                                'ORDER': 85,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                         'PDBX_STRUCT_GROUP_ID': {'NULLABLE': True,
                                                                  'ORDER': 94,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 100},
                                         'PDBX_TLS_GROUP_ID': {'NULLABLE': True,
                                                               'ORDER': 92,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                         'REFINEMENT_FLAGS': {'NULLABLE': True,
                                                              'ORDER': 76,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                         'REFINEMENT_FLAGS_ADP': {'NULLABLE': True,
                                                                  'ORDER': 77,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                         'REFINEMENT_FLAGS_OCCUPANCY': {'NULLABLE': True,
                                                                        'ORDER': 78,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                         'REFINEMENT_FLAGS_POSN': {'NULLABLE': True,
                                                                   'ORDER': 79,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                         'RESTRAINTS': {'NULLABLE': True,
                                                        'ORDER': 66,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'SYMMETRY_MULTIPLICITY': {'NULLABLE': True,
                                                                   'ORDER': 67,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                         'THERMAL_DISPLACE_TYPE': {'NULLABLE': True,
                                                                   'ORDER': 68,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                         'TYPE_SYMBOL': {'NULLABLE': True,
                                                         'ORDER': 69,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                         'U_EQUIV_GEOM_MEAN': {'NULLABLE': True,
                                                               'ORDER': 70,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                         'U_EQUIV_GEOM_MEAN_ESD': {'NULLABLE': True,
                                                                   'ORDER': 71,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                         'U_ISO_OR_EQUIV': {'NULLABLE': True,
                                                            'ORDER': 72,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'U_ISO_OR_EQUIV_ESD': {'NULLABLE': True,
                                                                'ORDER': 73,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                         'WYCKOFF_SYMBOL': {'NULLABLE': True,
                                                            'ORDER': 74,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80}},
                      'ATTRIBUTE_MAP': {'ADP_TYPE': ('atom_site', 'adp_type', None, None),
                                        'ANISO_B_1_1': ('atom_site', 'aniso_B[1][1]', None, None),
                                        'ANISO_B_1_1_ESD': ('atom_site', 'aniso_B[1][1]_esd', None, None),
                                        'ANISO_B_1_2': ('atom_site', 'aniso_B[1][2]', None, None),
                                        'ANISO_B_1_2_ESD': ('atom_site', 'aniso_B[1][2]_esd', None, None),
                                        'ANISO_B_1_3': ('atom_site', 'aniso_B[1][3]', None, None),
                                        'ANISO_B_1_3_ESD': ('atom_site', 'aniso_B[1][3]_esd', None, None),
                                        'ANISO_B_2_2': ('atom_site', 'aniso_B[2][2]', None, None),
                                        'ANISO_B_2_2_ESD': ('atom_site', 'aniso_B[2][2]_esd', None, None),
                                        'ANISO_B_2_3': ('atom_site', 'aniso_B[2][3]', None, None),
                                        'ANISO_B_2_3_ESD': ('atom_site', 'aniso_B[2][3]_esd', None, None),
                                        'ANISO_B_3_3': ('atom_site', 'aniso_B[3][3]', None, None),
                                        'ANISO_B_3_3_ESD': ('atom_site', 'aniso_B[3][3]_esd', None, None),
                                        'ANISO_RATIO': ('atom_site', 'aniso_ratio', None, None),
                                        'ANISO_U_1_1': ('atom_site', 'aniso_U[1][1]', None, None),
                                        'ANISO_U_1_1_ESD': ('atom_site', 'aniso_U[1][1]_esd', None, None),
                                        'ANISO_U_1_2': ('atom_site', 'aniso_U[1][2]', None, None),
                                        'ANISO_U_1_2_ESD': ('atom_site', 'aniso_U[1][2]_esd', None, None),
                                        'ANISO_U_1_3': ('atom_site', 'aniso_U[1][3]', None, None),
                                        'ANISO_U_1_3_ESD': ('atom_site', 'aniso_U[1][3]_esd', None, None),
                                        'ANISO_U_2_2': ('atom_site', 'aniso_U[2][2]', None, None),
                                        'ANISO_U_2_2_ESD': ('atom_site', 'aniso_U[2][2]_esd', None, None),
                                        'ANISO_U_2_3': ('atom_site', 'aniso_U[2][3]', None, None),
                                        'ANISO_U_2_3_ESD': ('atom_site', 'aniso_U[2][3]_esd', None, None),
                                        'ANISO_U_3_3': ('atom_site', 'aniso_U[3][3]', None, None),
                                        'ANISO_U_3_3_ESD': ('atom_site', 'aniso_U[3][3]_esd', None, None),
                                        'ATTACHED_HYDROGENS': ('atom_site', 'attached_hydrogens', None, None),
                                        'AUTH_ASYM_ID': ('atom_site', 'auth_asym_id', None, None),
                                        'AUTH_ATOM_ID': ('atom_site', 'auth_atom_id', None, None),
                                        'AUTH_COMP_ID': ('atom_site', 'auth_comp_id', None, None),
                                        'AUTH_SEQ_ID': ('atom_site', 'auth_seq_id', None, None),
                                        'B_EQUIV_GEOM_MEAN': ('atom_site', 'B_equiv_geom_mean', None, None),
                                        'B_EQUIV_GEOM_MEAN_ESD': ('atom_site', 'B_equiv_geom_mean_esd', None, None),
                                        'B_ISO_OR_EQUIV': ('atom_site', 'B_iso_or_equiv', None, None),
                                        'B_ISO_OR_EQUIV_ESD': ('atom_site', 'B_iso_or_equiv_esd', None, None),
                                        'CALC_ATTACHED_ATOM': ('atom_site', 'calc_attached_atom', None, None),
                                        'CALC_FLAG': ('atom_site', 'calc_flag', None, None),
                                        'CARTN_X': ('atom_site', 'Cartn_x', None, None),
                                        'CARTN_X_ESD': ('atom_site', 'Cartn_x_esd', None, None),
                                        'CARTN_Y': ('atom_site', 'Cartn_y', None, None),
                                        'CARTN_Y_ESD': ('atom_site', 'Cartn_y_esd', None, None),
                                        'CARTN_Z': ('atom_site', 'Cartn_z', None, None),
                                        'CARTN_Z_ESD': ('atom_site', 'Cartn_z_esd', None, None),
                                        'CHEMICAL_CONN_NUMBER': ('atom_site', 'chemical_conn_number', None, None),
                                        'CONSTRAINTS': ('atom_site', 'constraints', None, None),
                                        'DETAILS': ('atom_site', 'details', None, None),
                                        'DISORDER_ASSEMBLY': ('atom_site', 'disorder_assembly', None, None),
                                        'DISORDER_GROUP': ('atom_site', 'disorder_group', None, None),
                                        'FOOTNOTE_ID': ('atom_site', 'footnote_id', None, None),
                                        'FRACT_X': ('atom_site', 'fract_x', None, None),
                                        'FRACT_X_ESD': ('atom_site', 'fract_x_esd', None, None),
                                        'FRACT_Y': ('atom_site', 'fract_y', None, None),
                                        'FRACT_Y_ESD': ('atom_site', 'fract_y_esd', None, None),
                                        'FRACT_Z': ('atom_site', 'fract_z', None, None),
                                        'FRACT_Z_ESD': ('atom_site', 'fract_z_esd', None, None),
                                        'GROUP_PDB': ('atom_site', 'group_PDB', None, None),
                                        'ID': ('atom_site', 'id', None, None),
                                        'LABEL_ALT_ID': ('atom_site', 'label_alt_id', None, None),
                                        'LABEL_ASYM_ID': ('atom_site', 'label_asym_id', None, None),
                                        'LABEL_ATOM_ID': ('atom_site', 'label_atom_id', None, None),
                                        'LABEL_COMP_ID': ('atom_site', 'label_comp_id', None, None),
                                        'LABEL_ENTITY_ID': ('atom_site', 'label_entity_id', None, None),
                                        'LABEL_SEQ_ID': ('atom_site', 'label_seq_id', None, None),
                                        'OCCUPANCY': ('atom_site', 'occupancy', None, None),
                                        'OCCUPANCY_ESD': ('atom_site', 'occupancy_esd', None, None),
                                        'PDBX_AUTH_ALT_ID': ('atom_site', 'pdbx_auth_alt_id', None, None),
                                        'PDBX_AUTH_ASYM_ID': ('atom_site', 'pdbx_auth_asym_id', None, None),
                                        'PDBX_AUTH_ATOM_NAME': ('atom_site', 'pdbx_auth_atom_name', None, None),
                                        'PDBX_AUTH_COMP_ID': ('atom_site', 'pdbx_auth_comp_id', None, None),
                                        'PDBX_AUTH_SEQ_ID': ('atom_site', 'pdbx_auth_seq_id', None, None),
                                        'PDBX_FORMAL_CHARGE': ('atom_site', 'pdbx_formal_charge', None, None),
                                        'PDBX_NCS_DOM_ID': ('atom_site', 'pdbx_ncs_dom_id', None, None),
                                        'PDBX_PDB_ATOM_NAME': ('atom_site', 'pdbx_PDB_atom_name', None, None),
                                        'PDBX_PDB_INS_CODE': ('atom_site', 'pdbx_PDB_ins_code', None, None),
                                        'PDBX_PDB_MODEL_NUM': ('atom_site', 'pdbx_PDB_model_num', None, None),
                                        'PDBX_PDB_RESIDUE_NAME': ('atom_site', 'pdbx_PDB_residue_name', None, None),
                                        'PDBX_PDB_RESIDUE_NO': ('atom_site', 'pdbx_PDB_residue_no', None, None),
                                        'PDBX_PDB_STRAND_ID': ('atom_site', 'pdbx_PDB_strand_id', None, None),
                                        'PDBX_STRUCT_GROUP_ID': ('atom_site', 'pdbx_struct_group_id', None, None),
                                        'PDBX_TLS_GROUP_ID': ('atom_site', 'pdbx_tls_group_id', None, None),
                                        'REFINEMENT_FLAGS': ('atom_site', 'refinement_flags', None, None),
                                        'REFINEMENT_FLAGS_ADP': ('atom_site', 'refinement_flags_adp', None, None),
                                        'REFINEMENT_FLAGS_OCCUPANCY': ('atom_site',
                                                                       'refinement_flags_occupancy',
                                                                       None,
                                                                       None),
                                        'REFINEMENT_FLAGS_POSN': ('atom_site', 'refinement_flags_posn', None, None),
                                        'RESTRAINTS': ('atom_site', 'restraints', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                        'SYMMETRY_MULTIPLICITY': ('atom_site', 'symmetry_multiplicity', None, None),
                                        'THERMAL_DISPLACE_TYPE': ('atom_site', 'thermal_displace_type', None, None),
                                        'TYPE_SYMBOL': ('atom_site', 'type_symbol', None, None),
                                        'U_EQUIV_GEOM_MEAN': ('atom_site', 'U_equiv_geom_mean', None, None),
                                        'U_EQUIV_GEOM_MEAN_ESD': ('atom_site', 'U_equiv_geom_mean_esd', None, None),
                                        'U_ISO_OR_EQUIV': ('atom_site', 'U_iso_or_equiv', None, None),
                                        'U_ISO_OR_EQUIV_ESD': ('atom_site', 'U_iso_or_equiv_esd', None, None),
                                        'WYCKOFF_SYMBOL': ('atom_site', 'Wyckoff_symbol', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'atom_site': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'ATOM_SITE',
                      'TABLE_NAME': 'atom_site',
                      'TABLE_TYPE': 'transactional'},
        'ATOM_SITES': {'ATTRIBUTES': {'CARTN_TRANSFORM_AXES': 'Cartn_transform_axes',
                                      'CARTN_TRANSF_MATRIX_1_1': 'Cartn_transf_matrix_1_1',
                                      'CARTN_TRANSF_MATRIX_1_2': 'Cartn_transf_matrix_1_2',
                                      'CARTN_TRANSF_MATRIX_1_3': 'Cartn_transf_matrix_1_3',
                                      'CARTN_TRANSF_MATRIX_2_1': 'Cartn_transf_matrix_2_1',
                                      'CARTN_TRANSF_MATRIX_2_2': 'Cartn_transf_matrix_2_2',
                                      'CARTN_TRANSF_MATRIX_2_3': 'Cartn_transf_matrix_2_3',
                                      'CARTN_TRANSF_MATRIX_3_1': 'Cartn_transf_matrix_3_1',
                                      'CARTN_TRANSF_MATRIX_3_2': 'Cartn_transf_matrix_3_2',
                                      'CARTN_TRANSF_MATRIX_3_3': 'Cartn_transf_matrix_3_3',
                                      'CARTN_TRANSF_VECTOR_1': 'Cartn_transf_vector_1',
                                      'CARTN_TRANSF_VECTOR_2': 'Cartn_transf_vector_2',
                                      'CARTN_TRANSF_VECTOR_3': 'Cartn_transf_vector_3',
                                      'ENTRY_ID': 'entry_id',
                                      'FRACT_TRANSF_MATRIX_1_1': 'fract_transf_matrix_1_1',
                                      'FRACT_TRANSF_MATRIX_1_2': 'fract_transf_matrix_1_2',
                                      'FRACT_TRANSF_MATRIX_1_3': 'fract_transf_matrix_1_3',
                                      'FRACT_TRANSF_MATRIX_2_1': 'fract_transf_matrix_2_1',
                                      'FRACT_TRANSF_MATRIX_2_2': 'fract_transf_matrix_2_2',
                                      'FRACT_TRANSF_MATRIX_2_3': 'fract_transf_matrix_2_3',
                                      'FRACT_TRANSF_MATRIX_3_1': 'fract_transf_matrix_3_1',
                                      'FRACT_TRANSF_MATRIX_3_2': 'fract_transf_matrix_3_2',
                                      'FRACT_TRANSF_MATRIX_3_3': 'fract_transf_matrix_3_3',
                                      'FRACT_TRANSF_VECTOR_1': 'fract_transf_vector_1',
                                      'FRACT_TRANSF_VECTOR_2': 'fract_transf_vector_2',
                                      'FRACT_TRANSF_VECTOR_3': 'fract_transf_vector_3',
                                      'SOLUTION_HYDROGENS': 'solution_hydrogens',
                                      'SOLUTION_PRIMARY': 'solution_primary',
                                      'SOLUTION_SECONDARY': 'solution_secondary',
                                      'SPECIAL_DETAILS': 'special_details',
                                      'STRUCTURE_ID': 'Structure_ID'},
                       'ATTRIBUTE_INFO': {'CARTN_TRANSFORM_AXES': {'NULLABLE': True,
                                                                   'ORDER': 15,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                          'CARTN_TRANSF_MATRIX_1_1': {'NULLABLE': True,
                                                                      'ORDER': 3,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_1_2': {'NULLABLE': True,
                                                                      'ORDER': 4,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_1_3': {'NULLABLE': True,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_2_1': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_2_2': {'NULLABLE': True,
                                                                      'ORDER': 7,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_2_3': {'NULLABLE': True,
                                                                      'ORDER': 8,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_3_1': {'NULLABLE': True,
                                                                      'ORDER': 9,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_3_2': {'NULLABLE': True,
                                                                      'ORDER': 10,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_MATRIX_3_3': {'NULLABLE': True,
                                                                      'ORDER': 11,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'CARTN_TRANSF_VECTOR_1': {'NULLABLE': True,
                                                                    'ORDER': 12,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                          'CARTN_TRANSF_VECTOR_2': {'NULLABLE': True,
                                                                    'ORDER': 13,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                          'CARTN_TRANSF_VECTOR_3': {'NULLABLE': True,
                                                                    'ORDER': 14,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                          'ENTRY_ID': {'NULLABLE': False,
                                                       'ORDER': 2,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_1_1': {'NULLABLE': True,
                                                                      'ORDER': 16,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_1_2': {'NULLABLE': True,
                                                                      'ORDER': 17,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_1_3': {'NULLABLE': True,
                                                                      'ORDER': 18,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_2_1': {'NULLABLE': True,
                                                                      'ORDER': 19,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_2_2': {'NULLABLE': True,
                                                                      'ORDER': 20,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_2_3': {'NULLABLE': True,
                                                                      'ORDER': 21,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_3_1': {'NULLABLE': True,
                                                                      'ORDER': 22,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_3_2': {'NULLABLE': True,
                                                                      'ORDER': 23,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_MATRIX_3_3': {'NULLABLE': True,
                                                                      'ORDER': 24,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                          'FRACT_TRANSF_VECTOR_1': {'NULLABLE': True,
                                                                    'ORDER': 25,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                          'FRACT_TRANSF_VECTOR_2': {'NULLABLE': True,
                                                                    'ORDER': 26,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                          'FRACT_TRANSF_VECTOR_3': {'NULLABLE': True,
                                                                    'ORDER': 27,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                          'SOLUTION_HYDROGENS': {'NULLABLE': True,
                                                                 'ORDER': 30,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                          'SOLUTION_PRIMARY': {'NULLABLE': True,
                                                               'ORDER': 28,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                          'SOLUTION_SECONDARY': {'NULLABLE': True,
                                                                 'ORDER': 29,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                          'SPECIAL_DETAILS': {'NULLABLE': True,
                                                              'ORDER': 31,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10}},
                       'ATTRIBUTE_MAP': {'CARTN_TRANSFORM_AXES': ('atom_sites', 'Cartn_transform_axes', None, None),
                                         'CARTN_TRANSF_MATRIX_1_1': ('atom_sites', 'Cartn_transf_matrix[1][1]', None, None),
                                         'CARTN_TRANSF_MATRIX_1_2': ('atom_sites', 'Cartn_transf_matrix[1][2]', None, None),
                                         'CARTN_TRANSF_MATRIX_1_3': ('atom_sites', 'Cartn_transf_matrix[1][3]', None, None),
                                         'CARTN_TRANSF_MATRIX_2_1': ('atom_sites', 'Cartn_transf_matrix[2][1]', None, None),
                                         'CARTN_TRANSF_MATRIX_2_2': ('atom_sites', 'Cartn_transf_matrix[2][2]', None, None),
                                         'CARTN_TRANSF_MATRIX_2_3': ('atom_sites', 'Cartn_transf_matrix[2][3]', None, None),
                                         'CARTN_TRANSF_MATRIX_3_1': ('atom_sites', 'Cartn_transf_matrix[3][1]', None, None),
                                         'CARTN_TRANSF_MATRIX_3_2': ('atom_sites', 'Cartn_transf_matrix[3][2]', None, None),
                                         'CARTN_TRANSF_MATRIX_3_3': ('atom_sites', 'Cartn_transf_matrix[3][3]', None, None),
                                         'CARTN_TRANSF_VECTOR_1': ('atom_sites', 'Cartn_transf_vector[1]', None, None),
                                         'CARTN_TRANSF_VECTOR_2': ('atom_sites', 'Cartn_transf_vector[2]', None, None),
                                         'CARTN_TRANSF_VECTOR_3': ('atom_sites', 'Cartn_transf_vector[3]', None, None),
                                         'ENTRY_ID': ('atom_sites', 'entry_id', None, None),
                                         'FRACT_TRANSF_MATRIX_1_1': ('atom_sites', 'fract_transf_matrix[1][1]', None, None),
                                         'FRACT_TRANSF_MATRIX_1_2': ('atom_sites', 'fract_transf_matrix[1][2]', None, None),
                                         'FRACT_TRANSF_MATRIX_1_3': ('atom_sites', 'fract_transf_matrix[1][3]', None, None),
                                         'FRACT_TRANSF_MATRIX_2_1': ('atom_sites', 'fract_transf_matrix[2][1]', None, None),
                                         'FRACT_TRANSF_MATRIX_2_2': ('atom_sites', 'fract_transf_matrix[2][2]', None, None),
                                         'FRACT_TRANSF_MATRIX_2_3': ('atom_sites', 'fract_transf_matrix[2][3]', None, None),
                                         'FRACT_TRANSF_MATRIX_3_1': ('atom_sites', 'fract_transf_matrix[3][1]', None, None),
                                         'FRACT_TRANSF_MATRIX_3_2': ('atom_sites', 'fract_transf_matrix[3][2]', None, None),
                                         'FRACT_TRANSF_MATRIX_3_3': ('atom_sites', 'fract_transf_matrix[3][3]', None, None),
                                         'FRACT_TRANSF_VECTOR_1': ('atom_sites', 'fract_transf_vector[1]', None, None),
                                         'FRACT_TRANSF_VECTOR_2': ('atom_sites', 'fract_transf_vector[2]', None, None),
                                         'FRACT_TRANSF_VECTOR_3': ('atom_sites', 'fract_transf_vector[3]', None, None),
                                         'SOLUTION_HYDROGENS': ('atom_sites', 'solution_hydrogens', None, None),
                                         'SOLUTION_PRIMARY': ('atom_sites', 'solution_primary', None, None),
                                         'SOLUTION_SECONDARY': ('atom_sites', 'solution_secondary', None, None),
                                         'SPECIAL_DETAILS': ('atom_sites', 'special_details', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'atom_sites': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'ATOM_SITES',
                       'TABLE_NAME': 'atom_sites',
                       'TABLE_TYPE': 'transactional'},
        'ATOM_SITES_ALT': {'ATTRIBUTES': {'DETAILS': 'details', 'ID': 'id', 'STRUCTURE_ID': 'Structure_ID'},
                           'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'ID': {'NULLABLE': False,
                                                     'ORDER': 3,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'DETAILS': ('atom_sites_alt', 'details', None, None),
                                             'ID': ('atom_sites_alt', 'id', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'atom_sites_alt': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'ATOM_SITES_ALT',
                           'TABLE_NAME': 'atom_sites_alt',
                           'TABLE_TYPE': 'transactional'},
        'ATOM_SITES_ALT_ENS': {'ATTRIBUTES': {'DETAILS': 'details', 'ID': 'id', 'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                                  'ID': {'NULLABLE': False,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'DETAILS': ('atom_sites_alt_ens', 'details', None, None),
                                                 'ID': ('atom_sites_alt_ens', 'id', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'atom_sites_alt_ens': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'ATOM_SITES_ALT_ENS',
                               'TABLE_NAME': 'atom_sites_alt_ens',
                               'TABLE_TYPE': 'transactional'},
        'ATOM_SITES_ALT_GEN': {'ATTRIBUTES': {'ALT_ID': 'alt_id', 'ENS_ID': 'ens_id', 'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'ALT_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                  'ENS_ID': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'ALT_ID': ('atom_sites_alt_gen', 'alt_id', None, None),
                                                 'ENS_ID': ('atom_sites_alt_gen', 'ens_id', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ALT_ID', 'ENS_ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'atom_sites_alt_gen': {'ATTRIBUTES': ('alt_id', 'ens_id'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'ATOM_SITES_ALT_GEN',
                               'TABLE_NAME': 'atom_sites_alt_gen',
                               'TABLE_TYPE': 'transactional'},
        'ATOM_SITES_FOOTNOTE': {'ATTRIBUTES': {'ID': 'id', 'STRUCTURE_ID': 'Structure_ID', 'TEXT': 'text'},
                                'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'TEXT': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 511}},
                                'ATTRIBUTE_MAP': {'ID': ('atom_sites_footnote', 'id', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                  'TEXT': ('atom_sites_footnote', 'text', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'atom_sites_footnote': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'ATOM_SITES_FOOTNOTE',
                                'TABLE_NAME': 'atom_sites_footnote',
                                'TABLE_TYPE': 'transactional'},
        'ATOM_SITE_ANISOTROP': {'ATTRIBUTES': {'B_1_1': 'B_1_1',
                                               'B_1_1_ESD': 'B_1_1_esd',
                                               'B_1_2': 'B_1_2',
                                               'B_1_2_ESD': 'B_1_2_esd',
                                               'B_1_3': 'B_1_3',
                                               'B_1_3_ESD': 'B_1_3_esd',
                                               'B_2_2': 'B_2_2',
                                               'B_2_2_ESD': 'B_2_2_esd',
                                               'B_2_3': 'B_2_3',
                                               'B_2_3_ESD': 'B_2_3_esd',
                                               'B_3_3': 'B_3_3',
                                               'B_3_3_ESD': 'B_3_3_esd',
                                               'ID': 'id',
                                               'PDBX_AUTH_ALT_ID': 'pdbx_auth_alt_id',
                                               'PDBX_AUTH_ASYM_ID': 'pdbx_auth_asym_id',
                                               'PDBX_AUTH_ATOM_ID': 'pdbx_auth_atom_id',
                                               'PDBX_AUTH_COMP_ID': 'pdbx_auth_comp_id',
                                               'PDBX_AUTH_SEQ_ID': 'pdbx_auth_seq_id',
                                               'PDBX_LABEL_ALT_ID': 'pdbx_label_alt_id',
                                               'PDBX_LABEL_ASYM_ID': 'pdbx_label_asym_id',
                                               'PDBX_LABEL_ATOM_ID': 'pdbx_label_atom_id',
                                               'PDBX_LABEL_COMP_ID': 'pdbx_label_comp_id',
                                               'PDBX_LABEL_SEQ_ID': 'pdbx_label_seq_id',
                                               'PDBX_PDB_INS_CODE': 'pdbx_PDB_ins_code',
                                               'RATIO': 'ratio',
                                               'STRUCTURE_ID': 'Structure_ID',
                                               'TYPE_SYMBOL': 'type_symbol',
                                               'U_1_1': 'U_1_1',
                                               'U_1_1_ESD': 'U_1_1_esd',
                                               'U_1_2': 'U_1_2',
                                               'U_1_2_ESD': 'U_1_2_esd',
                                               'U_1_3': 'U_1_3',
                                               'U_1_3_ESD': 'U_1_3_esd',
                                               'U_2_2': 'U_2_2',
                                               'U_2_2_ESD': 'U_2_2_esd',
                                               'U_2_3': 'U_2_3',
                                               'U_2_3_ESD': 'U_2_3_esd',
                                               'U_3_3': 'U_3_3',
                                               'U_3_3_ESD': 'U_3_3_esd'},
                                'ATTRIBUTE_INFO': {'B_1_1': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'B_1_1_ESD': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'B_1_2': {'NULLABLE': True,
                                                             'ORDER': 5,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'B_1_2_ESD': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'B_1_3': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'B_1_3_ESD': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'B_2_2': {'NULLABLE': True,
                                                             'ORDER': 9,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'B_2_2_ESD': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'B_2_3': {'NULLABLE': True,
                                                             'ORDER': 11,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'B_2_3_ESD': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'B_3_3': {'NULLABLE': True,
                                                             'ORDER': 13,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'B_3_3_ESD': {'NULLABLE': True,
                                                                 'ORDER': 14,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                                   'PDBX_AUTH_ALT_ID': {'NULLABLE': True,
                                                                        'ORDER': 30,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                   'PDBX_AUTH_ASYM_ID': {'NULLABLE': True,
                                                                         'ORDER': 31,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                   'PDBX_AUTH_ATOM_ID': {'NULLABLE': True,
                                                                         'ORDER': 32,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 6},
                                                   'PDBX_AUTH_COMP_ID': {'NULLABLE': True,
                                                                         'ORDER': 33,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                   'PDBX_AUTH_SEQ_ID': {'NULLABLE': True,
                                                                        'ORDER': 29,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                   'PDBX_LABEL_ALT_ID': {'NULLABLE': True,
                                                                         'ORDER': 35,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                   'PDBX_LABEL_ASYM_ID': {'NULLABLE': True,
                                                                          'ORDER': 36,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                   'PDBX_LABEL_ATOM_ID': {'NULLABLE': True,
                                                                          'ORDER': 37,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 6},
                                                   'PDBX_LABEL_COMP_ID': {'NULLABLE': True,
                                                                          'ORDER': 38,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                   'PDBX_LABEL_SEQ_ID': {'NULLABLE': True,
                                                                         'ORDER': 34,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'INT',
                                                                         'WIDTH': 10},
                                                   'PDBX_PDB_INS_CODE': {'NULLABLE': True,
                                                                         'ORDER': 39,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                   'RATIO': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'TYPE_SYMBOL': {'NULLABLE': True,
                                                                   'ORDER': 16,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                   'U_1_1': {'NULLABLE': True,
                                                             'ORDER': 17,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'U_1_1_ESD': {'NULLABLE': True,
                                                                 'ORDER': 18,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'U_1_2': {'NULLABLE': True,
                                                             'ORDER': 19,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'U_1_2_ESD': {'NULLABLE': True,
                                                                 'ORDER': 20,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'U_1_3': {'NULLABLE': True,
                                                             'ORDER': 21,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'U_1_3_ESD': {'NULLABLE': True,
                                                                 'ORDER': 22,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'U_2_2': {'NULLABLE': True,
                                                             'ORDER': 23,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'U_2_2_ESD': {'NULLABLE': True,
                                                                 'ORDER': 24,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'U_2_3': {'NULLABLE': True,
                                                             'ORDER': 25,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'U_2_3_ESD': {'NULLABLE': True,
                                                                 'ORDER': 26,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'U_3_3': {'NULLABLE': True,
                                                             'ORDER': 27,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'U_3_3_ESD': {'NULLABLE': True,
                                                                 'ORDER': 28,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'B_1_1': ('atom_site_anisotrop', 'B[1][1]', None, None),
                                                  'B_1_1_ESD': ('atom_site_anisotrop', 'B[1][1]_esd', None, None),
                                                  'B_1_2': ('atom_site_anisotrop', 'B[1][2]', None, None),
                                                  'B_1_2_ESD': ('atom_site_anisotrop', 'B[1][2]_esd', None, None),
                                                  'B_1_3': ('atom_site_anisotrop', 'B[1][3]', None, None),
                                                  'B_1_3_ESD': ('atom_site_anisotrop', 'B[1][3]_esd', None, None),
                                                  'B_2_2': ('atom_site_anisotrop', 'B[2][2]', None, None),
                                                  'B_2_2_ESD': ('atom_site_anisotrop', 'B[2][2]_esd', None, None),
                                                  'B_2_3': ('atom_site_anisotrop', 'B[2][3]', None, None),
                                                  'B_2_3_ESD': ('atom_site_anisotrop', 'B[2][3]_esd', None, None),
                                                  'B_3_3': ('atom_site_anisotrop', 'B[3][3]', None, None),
                                                  'B_3_3_ESD': ('atom_site_anisotrop', 'B[3][3]_esd', None, None),
                                                  'ID': ('atom_site_anisotrop', 'id', None, None),
                                                  'PDBX_AUTH_ALT_ID': ('atom_site_anisotrop',
                                                                       'pdbx_auth_alt_id',
                                                                       None,
                                                                       None),
                                                  'PDBX_AUTH_ASYM_ID': ('atom_site_anisotrop',
                                                                        'pdbx_auth_asym_id',
                                                                        None,
                                                                        None),
                                                  'PDBX_AUTH_ATOM_ID': ('atom_site_anisotrop',
                                                                        'pdbx_auth_atom_id',
                                                                        None,
                                                                        None),
                                                  'PDBX_AUTH_COMP_ID': ('atom_site_anisotrop',
                                                                        'pdbx_auth_comp_id',
                                                                        None,
                                                                        None),
                                                  'PDBX_AUTH_SEQ_ID': ('atom_site_anisotrop',
                                                                       'pdbx_auth_seq_id',
                                                                       None,
                                                                       None),
                                                  'PDBX_LABEL_ALT_ID': ('atom_site_anisotrop',
                                                                        'pdbx_label_alt_id',
                                                                        None,
                                                                        None),
                                                  'PDBX_LABEL_ASYM_ID': ('atom_site_anisotrop',
                                                                         'pdbx_label_asym_id',
                                                                         None,
                                                                         None),
                                                  'PDBX_LABEL_ATOM_ID': ('atom_site_anisotrop',
                                                                         'pdbx_label_atom_id',
                                                                         None,
                                                                         None),
                                                  'PDBX_LABEL_COMP_ID': ('atom_site_anisotrop',
                                                                         'pdbx_label_comp_id',
                                                                         None,
                                                                         None),
                                                  'PDBX_LABEL_SEQ_ID': ('atom_site_anisotrop',
                                                                        'pdbx_label_seq_id',
                                                                        None,
                                                                        None),
                                                  'PDBX_PDB_INS_CODE': ('atom_site_anisotrop',
                                                                        'pdbx_PDB_ins_code',
                                                                        None,
                                                                        None),
                                                  'RATIO': ('atom_site_anisotrop', 'ratio', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                  'TYPE_SYMBOL': ('atom_site_anisotrop', 'type_symbol', None, None),
                                                  'U_1_1': ('atom_site_anisotrop', 'U[1][1]', None, None),
                                                  'U_1_1_ESD': ('atom_site_anisotrop', 'U[1][1]_esd', None, None),
                                                  'U_1_2': ('atom_site_anisotrop', 'U[1][2]', None, None),
                                                  'U_1_2_ESD': ('atom_site_anisotrop', 'U[1][2]_esd', None, None),
                                                  'U_1_3': ('atom_site_anisotrop', 'U[1][3]', None, None),
                                                  'U_1_3_ESD': ('atom_site_anisotrop', 'U[1][3]_esd', None, None),
                                                  'U_2_2': ('atom_site_anisotrop', 'U[2][2]', None, None),
                                                  'U_2_2_ESD': ('atom_site_anisotrop', 'U[2][2]_esd', None, None),
                                                  'U_2_3': ('atom_site_anisotrop', 'U[2][3]', None, None),
                                                  'U_2_3_ESD': ('atom_site_anisotrop', 'U[2][3]_esd', None, None),
                                                  'U_3_3': ('atom_site_anisotrop', 'U[3][3]', None, None),
                                                  'U_3_3_ESD': ('atom_site_anisotrop', 'U[3][3]_esd', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'atom_site_anisotrop': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'ATOM_SITE_ANISOTROP',
                                'TABLE_NAME': 'atom_site_anisotrop',
                                'TABLE_TYPE': 'transactional'},
        'ATOM_TYPE': {'ATTRIBUTES': {'ANALYTICAL_MASS_PERCENT': 'analytical_mass_percent',
                                     'DESCRIPTION': 'description',
                                     'NUMBER_IN_CELL': 'number_in_cell',
                                     'OXIDATION_NUMBER': 'oxidation_number',
                                     'RADIUS_BOND': 'radius_bond',
                                     'RADIUS_CONTACT': 'radius_contact',
                                     'SCAT_CROMER_MANN_A1': 'scat_Cromer_Mann_a1',
                                     'SCAT_CROMER_MANN_A2': 'scat_Cromer_Mann_a2',
                                     'SCAT_CROMER_MANN_A3': 'scat_Cromer_Mann_a3',
                                     'SCAT_CROMER_MANN_A4': 'scat_Cromer_Mann_a4',
                                     'SCAT_CROMER_MANN_B1': 'scat_Cromer_Mann_b1',
                                     'SCAT_CROMER_MANN_B2': 'scat_Cromer_Mann_b2',
                                     'SCAT_CROMER_MANN_B3': 'scat_Cromer_Mann_b3',
                                     'SCAT_CROMER_MANN_B4': 'scat_Cromer_Mann_b4',
                                     'SCAT_CROMER_MANN_C': 'scat_Cromer_Mann_c',
                                     'SCAT_DISPERSION_IMAG': 'scat_dispersion_imag',
                                     'SCAT_DISPERSION_REAL': 'scat_dispersion_real',
                                     'SCAT_DISPERSION_SOURCE': 'scat_dispersion_source',
                                     'SCAT_LENGTH_NEUTRON': 'scat_length_neutron',
                                     'SCAT_SOURCE': 'scat_source',
                                     'SCAT_VERSUS_STOL_LIST': 'scat_versus_stol_list',
                                     'STRUCTURE_ID': 'Structure_ID',
                                     'SYMBOL': 'symbol'},
                      'ATTRIBUTE_INFO': {'ANALYTICAL_MASS_PERCENT': {'NULLABLE': True,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 6,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                         'DESCRIPTION': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                         'NUMBER_IN_CELL': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'INT',
                                                            'WIDTH': 10},
                                         'OXIDATION_NUMBER': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                         'RADIUS_BOND': {'NULLABLE': True,
                                                         'ORDER': 6,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                         'RADIUS_CONTACT': {'NULLABLE': True,
                                                            'ORDER': 7,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'SCAT_CROMER_MANN_A1': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_A2': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_A3': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_A4': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_B1': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_B2': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_B3': {'NULLABLE': True,
                                                                 'ORDER': 14,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_B4': {'NULLABLE': True,
                                                                 'ORDER': 15,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                         'SCAT_CROMER_MANN_C': {'NULLABLE': True,
                                                                'ORDER': 16,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                         'SCAT_DISPERSION_IMAG': {'NULLABLE': True,
                                                                  'ORDER': 17,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                         'SCAT_DISPERSION_REAL': {'NULLABLE': True,
                                                                  'ORDER': 18,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                         'SCAT_DISPERSION_SOURCE': {'NULLABLE': True,
                                                                    'ORDER': 23,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                         'SCAT_LENGTH_NEUTRON': {'NULLABLE': True,
                                                                 'ORDER': 19,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                         'SCAT_SOURCE': {'NULLABLE': True,
                                                         'ORDER': 20,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                         'SCAT_VERSUS_STOL_LIST': {'NULLABLE': True,
                                                                   'ORDER': 21,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'SYMBOL': {'NULLABLE': False,
                                                    'ORDER': 22,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 10}},
                      'ATTRIBUTE_MAP': {'ANALYTICAL_MASS_PERCENT': ('atom_type', 'analytical_mass_percent', None, None),
                                        'DESCRIPTION': ('atom_type', 'description', None, None),
                                        'NUMBER_IN_CELL': ('atom_type', 'number_in_cell', None, None),
                                        'OXIDATION_NUMBER': ('atom_type', 'oxidation_number', None, None),
                                        'RADIUS_BOND': ('atom_type', 'radius_bond', None, None),
                                        'RADIUS_CONTACT': ('atom_type', 'radius_contact', None, None),
                                        'SCAT_CROMER_MANN_A1': ('atom_type', 'scat_Cromer_Mann_a1', None, None),
                                        'SCAT_CROMER_MANN_A2': ('atom_type', 'scat_Cromer_Mann_a2', None, None),
                                        'SCAT_CROMER_MANN_A3': ('atom_type', 'scat_Cromer_Mann_a3', None, None),
                                        'SCAT_CROMER_MANN_A4': ('atom_type', 'scat_Cromer_Mann_a4', None, None),
                                        'SCAT_CROMER_MANN_B1': ('atom_type', 'scat_Cromer_Mann_b1', None, None),
                                        'SCAT_CROMER_MANN_B2': ('atom_type', 'scat_Cromer_Mann_b2', None, None),
                                        'SCAT_CROMER_MANN_B3': ('atom_type', 'scat_Cromer_Mann_b3', None, None),
                                        'SCAT_CROMER_MANN_B4': ('atom_type', 'scat_Cromer_Mann_b4', None, None),
                                        'SCAT_CROMER_MANN_C': ('atom_type', 'scat_Cromer_Mann_c', None, None),
                                        'SCAT_DISPERSION_IMAG': ('atom_type', 'scat_dispersion_imag', None, None),
                                        'SCAT_DISPERSION_REAL': ('atom_type', 'scat_dispersion_real', None, None),
                                        'SCAT_DISPERSION_SOURCE': ('atom_type', 'scat_dispersion_source', None, None),
                                        'SCAT_LENGTH_NEUTRON': ('atom_type', 'scat_length_neutron', None, None),
                                        'SCAT_SOURCE': ('atom_type', 'scat_source', None, None),
                                        'SCAT_VERSUS_STOL_LIST': ('atom_type', 'scat_versus_stol_list', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                        'SYMBOL': ('atom_type', 'symbol', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'SYMBOL'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'atom_type': {'ATTRIBUTES': ('symbol',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'ATOM_TYPE',
                      'TABLE_NAME': 'atom_type',
                      'TABLE_TYPE': 'transactional'},
        'AUDIT': {'ATTRIBUTES': {'CREATION_DATE': 'creation_date',
                                 'CREATION_METHOD': 'creation_method',
                                 'REVISION_ID': 'revision_id',
                                 'STRUCTURE_ID': 'Structure_ID',
                                 'UPDATE_RECORD': 'update_record'},
                  'ATTRIBUTE_INFO': {'CREATION_DATE': {'NULLABLE': True,
                                                       'ORDER': 2,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'DATETIME',
                                                       'WIDTH': 15},
                                     'CREATION_METHOD': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                     'REVISION_ID': {'NULLABLE': False,
                                                     'ORDER': 4,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                      'ORDER': 1,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                     'UPDATE_RECORD': {'NULLABLE': True,
                                                       'ORDER': 5,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 511}},
                  'ATTRIBUTE_MAP': {'CREATION_DATE': ('audit', 'creation_date', None, None),
                                    'CREATION_METHOD': ('audit', 'creation_method', None, None),
                                    'REVISION_ID': ('audit', 'revision_id', None, None),
                                    'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                    'UPDATE_RECORD': ('audit', 'update_record', None, None)},
                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'REVISION_ID'), 'TYPE': 'UNIQUE'},
                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                  'MAP_MERGE_INDICES': {'audit': {'ATTRIBUTES': ('revision_id',), 'TYPE': 'EQUI-JOIN'}},
                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                  'TABLE_ID': 'AUDIT',
                  'TABLE_NAME': 'audit',
                  'TABLE_TYPE': 'transactional'},
        'AUDIT_AUTHOR': {'ATTRIBUTES': {'ADDRESS': 'address',
                                        'NAME': 'name',
                                        'PDBX_ORDINAL': 'pdbx_ordinal',
                                        'STRUCTURE_ID': 'Structure_ID'},
                         'ATTRIBUTE_INFO': {'ADDRESS': {'NULLABLE': True,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                            'NAME': {'NULLABLE': True,
                                                     'ORDER': 3,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 128},
                                            'PDBX_ORDINAL': {'NULLABLE': False,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                            'STRUCTURE_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10}},
                         'ATTRIBUTE_MAP': {'ADDRESS': ('audit_author', 'address', None, None),
                                           'NAME': ('audit_author', 'name', None, None),
                                           'PDBX_ORDINAL': ('audit_author', 'pdbx_ordinal', None, None),
                                           'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                         'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDBX_ORDINAL'), 'TYPE': 'UNIQUE'},
                                     's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                         'MAP_MERGE_INDICES': {'audit_author': {'ATTRIBUTES': ('pdbx_ordinal',), 'TYPE': 'EQUI-JOIN'}},
                         'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                         'TABLE_ID': 'AUDIT_AUTHOR',
                         'TABLE_NAME': 'audit_author',
                         'TABLE_TYPE': 'transactional'},
        'AUDIT_CONFORM': {'ATTRIBUTES': {'DICT_LOCATION': 'dict_location',
                                         'DICT_NAME': 'dict_name',
                                         'DICT_VERSION': 'dict_version',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'DICT_LOCATION': {'NULLABLE': True,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                             'DICT_NAME': {'NULLABLE': False,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                             'DICT_VERSION': {'NULLABLE': False,
                                                              'ORDER': 4,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'DICT_LOCATION': ('audit_conform', 'dict_location', None, None),
                                            'DICT_NAME': ('audit_conform', 'dict_name', None, None),
                                            'DICT_VERSION': ('audit_conform', 'dict_version', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DICT_NAME', 'DICT_VERSION'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'audit_conform': {'ATTRIBUTES': ('dict_name', 'dict_version'),
                                                                  'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'AUDIT_CONFORM',
                          'TABLE_NAME': 'audit_conform',
                          'TABLE_TYPE': 'transactional'},
        'AUDIT_CONTACT_AUTHOR': {'ATTRIBUTES': {'ADDRESS': 'address',
                                                'EMAIL': 'email',
                                                'FAX': 'fax',
                                                'NAME': 'name',
                                                'PHONE': 'phone',
                                                'STRUCTURE_ID': 'Structure_ID'},
                                 'ATTRIBUTE_INFO': {'ADDRESS': {'NULLABLE': True,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                    'EMAIL': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                                    'FAX': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                                    'NAME': {'NULLABLE': False,
                                                             'ORDER': 5,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                    'PHONE': {'NULLABLE': True,
                                                              'ORDER': 6,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ADDRESS': ('audit_contact_author', 'address', None, None),
                                                   'EMAIL': ('audit_contact_author', 'email', None, None),
                                                   'FAX': ('audit_contact_author', 'fax', None, None),
                                                   'NAME': ('audit_contact_author', 'name', None, None),
                                                   'PHONE': ('audit_contact_author', 'phone', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'NAME'), 'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'audit_contact_author': {'ATTRIBUTES': ('name',),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'AUDIT_CONTACT_AUTHOR',
                                 'TABLE_NAME': 'audit_contact_author',
                                 'TABLE_TYPE': 'transactional'},
        'AUDIT_LINK': {'ATTRIBUTES': {'BLOCK_CODE': 'block_code',
                                      'BLOCK_DESCRIPTION': 'block_description',
                                      'STRUCTURE_ID': 'Structure_ID'},
                       'ATTRIBUTE_INFO': {'BLOCK_CODE': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                          'BLOCK_DESCRIPTION': {'NULLABLE': False,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10}},
                       'ATTRIBUTE_MAP': {'BLOCK_CODE': ('audit_link', 'block_code', None, None),
                                         'BLOCK_DESCRIPTION': ('audit_link', 'block_description', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'BLOCK_CODE', 'BLOCK_DESCRIPTION'),
                                          'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'audit_link': {'ATTRIBUTES': ('block_code', 'block_description'),
                                                            'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'AUDIT_LINK',
                       'TABLE_NAME': 'audit_link',
                       'TABLE_TYPE': 'transactional'},
        'CELL1': {'ATTRIBUTES': {'ANGLE_ALPHA': 'angle_alpha',
                                 'ANGLE_ALPHA_ESD': 'angle_alpha_esd',
                                 'ANGLE_BETA': 'angle_beta',
                                 'ANGLE_BETA_ESD': 'angle_beta_esd',
                                 'ANGLE_GAMMA': 'angle_gamma',
                                 'ANGLE_GAMMA_ESD': 'angle_gamma_esd',
                                 'DETAILS': 'details',
                                 'ENTRY_ID': 'entry_id',
                                 'FORMULA_UNITS_Z': 'formula_units_Z',
                                 'LENGTH_A': 'length_a',
                                 'LENGTH_A_ESD': 'length_a_esd',
                                 'LENGTH_B': 'length_b',
                                 'LENGTH_B_ESD': 'length_b_esd',
                                 'LENGTH_C': 'length_c',
                                 'LENGTH_C_ESD': 'length_c_esd',
                                 'PDBX_UNIQUE_AXIS': 'pdbx_unique_axis',
                                 'RECIPROCAL_ANGLE_ALPHA': 'reciprocal_angle_alpha',
                                 'RECIPROCAL_ANGLE_ALPHA_ESD': 'reciprocal_angle_alpha_esd',
                                 'RECIPROCAL_ANGLE_BETA': 'reciprocal_angle_beta',
                                 'RECIPROCAL_ANGLE_BETA_ESD': 'reciprocal_angle_beta_esd',
                                 'RECIPROCAL_ANGLE_GAMMA': 'reciprocal_angle_gamma',
                                 'RECIPROCAL_ANGLE_GAMMA_ESD': 'reciprocal_angle_gamma_esd',
                                 'RECIPROCAL_LENGTH_A': 'reciprocal_length_a',
                                 'RECIPROCAL_LENGTH_A_ESD': 'reciprocal_length_a_esd',
                                 'RECIPROCAL_LENGTH_B': 'reciprocal_length_b',
                                 'RECIPROCAL_LENGTH_B_ESD': 'reciprocal_length_b_esd',
                                 'RECIPROCAL_LENGTH_C': 'reciprocal_length_c',
                                 'RECIPROCAL_LENGTH_C_ESD': 'reciprocal_length_c_esd',
                                 'STRUCTURE_ID': 'Structure_ID',
                                 'VOLUME': 'volume',
                                 'VOLUME_ESD': 'volume_esd',
                                 'Z_PDB': 'Z_PDB'},
                  'ATTRIBUTE_INFO': {'ANGLE_ALPHA': {'NULLABLE': True,
                                                     'ORDER': 2,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                     'ANGLE_ALPHA_ESD': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                     'ANGLE_BETA': {'NULLABLE': True,
                                                    'ORDER': 4,
                                                    'PRECISION': 6,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                     'ANGLE_BETA_ESD': {'NULLABLE': True,
                                                        'ORDER': 5,
                                                        'PRECISION': 6,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10},
                                     'ANGLE_GAMMA': {'NULLABLE': True,
                                                     'ORDER': 6,
                                                     'PRECISION': 6,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'FLOAT',
                                                     'WIDTH': 10},
                                     'ANGLE_GAMMA_ESD': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                     'DETAILS': {'NULLABLE': True,
                                                 'ORDER': 9,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 200},
                                     'ENTRY_ID': {'NULLABLE': False,
                                                  'ORDER': 8,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': True,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 10},
                                     'FORMULA_UNITS_Z': {'NULLABLE': True,
                                                         'ORDER': 10,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                     'LENGTH_A': {'NULLABLE': True,
                                                  'ORDER': 11,
                                                  'PRECISION': 6,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'FLOAT',
                                                  'WIDTH': 10},
                                     'LENGTH_A_ESD': {'NULLABLE': True,
                                                      'ORDER': 12,
                                                      'PRECISION': 6,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                     'LENGTH_B': {'NULLABLE': True,
                                                  'ORDER': 13,
                                                  'PRECISION': 6,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'FLOAT',
                                                  'WIDTH': 10},
                                     'LENGTH_B_ESD': {'NULLABLE': True,
                                                      'ORDER': 14,
                                                      'PRECISION': 6,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                     'LENGTH_C': {'NULLABLE': True,
                                                  'ORDER': 15,
                                                  'PRECISION': 6,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'FLOAT',
                                                  'WIDTH': 10},
                                     'LENGTH_C_ESD': {'NULLABLE': True,
                                                      'ORDER': 16,
                                                      'PRECISION': 6,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'FLOAT',
                                                      'WIDTH': 10},
                                     'PDBX_UNIQUE_AXIS': {'NULLABLE': True,
                                                          'ORDER': 32,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                     'RECIPROCAL_ANGLE_ALPHA': {'NULLABLE': True,
                                                                'ORDER': 20,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                     'RECIPROCAL_ANGLE_ALPHA_ESD': {'NULLABLE': True,
                                                                    'ORDER': 23,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                     'RECIPROCAL_ANGLE_BETA': {'NULLABLE': True,
                                                               'ORDER': 21,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                     'RECIPROCAL_ANGLE_BETA_ESD': {'NULLABLE': True,
                                                                   'ORDER': 24,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                     'RECIPROCAL_ANGLE_GAMMA': {'NULLABLE': True,
                                                                'ORDER': 22,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                     'RECIPROCAL_ANGLE_GAMMA_ESD': {'NULLABLE': True,
                                                                    'ORDER': 25,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                     'RECIPROCAL_LENGTH_A': {'NULLABLE': True,
                                                             'ORDER': 26,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                     'RECIPROCAL_LENGTH_A_ESD': {'NULLABLE': True,
                                                                 'ORDER': 29,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                     'RECIPROCAL_LENGTH_B': {'NULLABLE': True,
                                                             'ORDER': 27,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                     'RECIPROCAL_LENGTH_B_ESD': {'NULLABLE': True,
                                                                 'ORDER': 30,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                     'RECIPROCAL_LENGTH_C': {'NULLABLE': True,
                                                             'ORDER': 28,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                     'RECIPROCAL_LENGTH_C_ESD': {'NULLABLE': True,
                                                                 'ORDER': 31,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                      'ORDER': 1,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                     'VOLUME': {'NULLABLE': True,
                                                'ORDER': 17,
                                                'PRECISION': 6,
                                                'PRIMARY_KEY': False,
                                                'SQL_TYPE': 'FLOAT',
                                                'WIDTH': 10},
                                     'VOLUME_ESD': {'NULLABLE': True,
                                                    'ORDER': 18,
                                                    'PRECISION': 6,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                     'Z_PDB': {'NULLABLE': True,
                                               'ORDER': 19,
                                               'PRECISION': 0,
                                               'PRIMARY_KEY': False,
                                               'SQL_TYPE': 'INT',
                                               'WIDTH': 10}},
                  'ATTRIBUTE_MAP': {'ANGLE_ALPHA': ('cell', 'angle_alpha', None, None),
                                    'ANGLE_ALPHA_ESD': ('cell', 'angle_alpha_esd', None, None),
                                    'ANGLE_BETA': ('cell', 'angle_beta', None, None),
                                    'ANGLE_BETA_ESD': ('cell', 'angle_beta_esd', None, None),
                                    'ANGLE_GAMMA': ('cell', 'angle_gamma', None, None),
                                    'ANGLE_GAMMA_ESD': ('cell', 'angle_gamma_esd', None, None),
                                    'DETAILS': ('cell', 'details', None, None),
                                    'ENTRY_ID': ('cell', 'entry_id', None, None),
                                    'FORMULA_UNITS_Z': ('cell', 'formula_units_Z', None, None),
                                    'LENGTH_A': ('cell', 'length_a', None, None),
                                    'LENGTH_A_ESD': ('cell', 'length_a_esd', None, None),
                                    'LENGTH_B': ('cell', 'length_b', None, None),
                                    'LENGTH_B_ESD': ('cell', 'length_b_esd', None, None),
                                    'LENGTH_C': ('cell', 'length_c', None, None),
                                    'LENGTH_C_ESD': ('cell', 'length_c_esd', None, None),
                                    'PDBX_UNIQUE_AXIS': ('cell', 'pdbx_unique_axis', None, None),
                                    'RECIPROCAL_ANGLE_ALPHA': ('cell', 'reciprocal_angle_alpha', None, None),
                                    'RECIPROCAL_ANGLE_ALPHA_ESD': ('cell', 'reciprocal_angle_alpha_esd', None, None),
                                    'RECIPROCAL_ANGLE_BETA': ('cell', 'reciprocal_angle_beta', None, None),
                                    'RECIPROCAL_ANGLE_BETA_ESD': ('cell', 'reciprocal_angle_beta_esd', None, None),
                                    'RECIPROCAL_ANGLE_GAMMA': ('cell', 'reciprocal_angle_gamma', None, None),
                                    'RECIPROCAL_ANGLE_GAMMA_ESD': ('cell', 'reciprocal_angle_gamma_esd', None, None),
                                    'RECIPROCAL_LENGTH_A': ('cell', 'reciprocal_length_a', None, None),
                                    'RECIPROCAL_LENGTH_A_ESD': ('cell', 'reciprocal_length_a_esd', None, None),
                                    'RECIPROCAL_LENGTH_B': ('cell', 'reciprocal_length_b', None, None),
                                    'RECIPROCAL_LENGTH_B_ESD': ('cell', 'reciprocal_length_b_esd', None, None),
                                    'RECIPROCAL_LENGTH_C': ('cell', 'reciprocal_length_c', None, None),
                                    'RECIPROCAL_LENGTH_C_ESD': ('cell', 'reciprocal_length_c_esd', None, None),
                                    'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                    'VOLUME': ('cell', 'volume', None, None),
                                    'VOLUME_ESD': ('cell', 'volume_esd', None, None),
                                    'Z_PDB': ('cell', 'Z_PDB', None, None)},
                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                  'MAP_MERGE_INDICES': {'cell': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                  'TABLE_ID': 'CELL1',
                  'TABLE_NAME': 'cell1',
                  'TABLE_TYPE': 'transactional'},
        'CELL_MEASUREMENT': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                            'PRESSURE': 'pressure',
                                            'PRESSURE_ESD': 'pressure_esd',
                                            'RADIATION': 'radiation',
                                            'REFLNS_USED': 'reflns_used',
                                            'STRUCTURE_ID': 'Structure_ID',
                                            'TEMP': 'temp',
                                            'TEMP_ESD': 'temp_esd',
                                            'THETA_MAX': 'theta_max',
                                            'THETA_MIN': 'theta_min',
                                            'WAVELENGTH': 'wavelength'},
                             'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                'PRESSURE': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                'PRESSURE_ESD': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                'RADIATION': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                                'REFLNS_USED': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                'TEMP': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                                'TEMP_ESD': {'NULLABLE': True,
                                                             'ORDER': 8,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                'THETA_MAX': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                                'THETA_MIN': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                                'WAVELENGTH': {'NULLABLE': True,
                                                               'ORDER': 11,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10}},
                             'ATTRIBUTE_MAP': {'ENTRY_ID': ('cell_measurement', 'entry_id', None, None),
                                               'PRESSURE': ('cell_measurement', 'pressure', None, None),
                                               'PRESSURE_ESD': ('cell_measurement', 'pressure_esd', None, None),
                                               'RADIATION': ('cell_measurement', 'radiation', None, None),
                                               'REFLNS_USED': ('cell_measurement', 'reflns_used', None, None),
                                               'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                               'TEMP': ('cell_measurement', 'temp', None, None),
                                               'TEMP_ESD': ('cell_measurement', 'temp_esd', None, None),
                                               'THETA_MAX': ('cell_measurement', 'theta_max', None, None),
                                               'THETA_MIN': ('cell_measurement', 'theta_min', None, None),
                                               'WAVELENGTH': ('cell_measurement', 'wavelength', None, None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'cell_measurement': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'CELL_MEASUREMENT',
                             'TABLE_NAME': 'cell_measurement',
                             'TABLE_TYPE': 'transactional'},
        'CELL_MEASUREMENT_REFLN': {'ATTRIBUTES': {'INDEX_H': 'index_h',
                                                  'INDEX_K': 'index_k',
                                                  'INDEX_L': 'index_l',
                                                  'STRUCTURE_ID': 'Structure_ID',
                                                  'THETA': 'theta'},
                                   'ATTRIBUTE_INFO': {'INDEX_H': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                                      'INDEX_K': {'NULLABLE': False,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                                      'INDEX_L': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                      'THETA': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10}},
                                   'ATTRIBUTE_MAP': {'INDEX_H': ('cell_measurement_refln', 'index_h', None, None),
                                                     'INDEX_K': ('cell_measurement_refln', 'index_k', None, None),
                                                     'INDEX_L': ('cell_measurement_refln', 'index_l', None, None),
                                                     'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                     'THETA': ('cell_measurement_refln', 'theta', None, None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'INDEX_H', 'INDEX_K', 'INDEX_L'),
                                                      'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'cell_measurement_refln': {'ATTRIBUTES': ('index_h',
                                                                                                   'index_k',
                                                                                                   'index_l'),
                                                                                    'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                   'TABLE_ID': 'CELL_MEASUREMENT_REFLN',
                                   'TABLE_NAME': 'cell_measurement_refln',
                                   'TABLE_TYPE': 'transactional'},
        'CHEMICAL': {'ATTRIBUTES': {'ABSOLUTE_CONFIGURATION': 'absolute_configuration',
                                    'COMPOUND_SOURCE': 'compound_source',
                                    'ENTRY_ID': 'entry_id',
                                    'MELTING_POINT': 'melting_point',
                                    'MELTING_POINT_GT': 'melting_point_gt',
                                    'MELTING_POINT_LT': 'melting_point_lt',
                                    'NAME_COMMON': 'name_common',
                                    'NAME_MINERAL': 'name_mineral',
                                    'NAME_STRUCTURE_TYPE': 'name_structure_type',
                                    'NAME_SYSTEMATIC': 'name_systematic',
                                    'OPTICAL_ROTATION': 'optical_rotation',
                                    'PROPERTIES_BIOLOGICAL': 'properties_biological',
                                    'PROPERTIES_PHYSICAL': 'properties_physical',
                                    'STRUCTURE_ID': 'Structure_ID',
                                    'TEMPERATURE_DECOMPOSITION': 'temperature_decomposition',
                                    'TEMPERATURE_DECOMPOSITION_ESD': 'temperature_decomposition_esd',
                                    'TEMPERATURE_DECOMPOSITION_GT': 'temperature_decomposition_gt',
                                    'TEMPERATURE_DECOMPOSITION_LT': 'temperature_decomposition_lt',
                                    'TEMPERATURE_SUBLIMATION': 'temperature_sublimation',
                                    'TEMPERATURE_SUBLIMATION_ESD': 'temperature_sublimation_esd',
                                    'TEMPERATURE_SUBLIMATION_GT': 'temperature_sublimation_gt',
                                    'TEMPERATURE_SUBLIMATION_LT': 'temperature_sublimation_lt'},
                     'ATTRIBUTE_INFO': {'ABSOLUTE_CONFIGURATION': {'NULLABLE': True,
                                                                   'ORDER': 9,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                        'COMPOUND_SOURCE': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                        'ENTRY_ID': {'NULLABLE': False,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                        'MELTING_POINT': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                        'MELTING_POINT_GT': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'MELTING_POINT_LT': {'NULLABLE': True,
                                                             'ORDER': 11,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                        'NAME_COMMON': {'NULLABLE': True,
                                                        'ORDER': 5,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                        'NAME_MINERAL': {'NULLABLE': True,
                                                         'ORDER': 6,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                        'NAME_STRUCTURE_TYPE': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                        'NAME_SYSTEMATIC': {'NULLABLE': True,
                                                            'ORDER': 8,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                        'OPTICAL_ROTATION': {'NULLABLE': True,
                                                             'ORDER': 12,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                        'PROPERTIES_BIOLOGICAL': {'NULLABLE': True,
                                                                  'ORDER': 13,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                        'PROPERTIES_PHYSICAL': {'NULLABLE': True,
                                                                'ORDER': 14,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                         'ORDER': 1,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                        'TEMPERATURE_DECOMPOSITION': {'NULLABLE': True,
                                                                      'ORDER': 15,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                        'TEMPERATURE_DECOMPOSITION_ESD': {'NULLABLE': True,
                                                                          'ORDER': 16,
                                                                          'PRECISION': 6,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                        'TEMPERATURE_DECOMPOSITION_GT': {'NULLABLE': True,
                                                                         'ORDER': 17,
                                                                         'PRECISION': 6,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                        'TEMPERATURE_DECOMPOSITION_LT': {'NULLABLE': True,
                                                                         'ORDER': 18,
                                                                         'PRECISION': 6,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                        'TEMPERATURE_SUBLIMATION': {'NULLABLE': True,
                                                                    'ORDER': 19,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                        'TEMPERATURE_SUBLIMATION_ESD': {'NULLABLE': True,
                                                                        'ORDER': 20,
                                                                        'PRECISION': 6,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'FLOAT',
                                                                        'WIDTH': 10},
                                        'TEMPERATURE_SUBLIMATION_GT': {'NULLABLE': True,
                                                                       'ORDER': 21,
                                                                       'PRECISION': 6,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                        'TEMPERATURE_SUBLIMATION_LT': {'NULLABLE': True,
                                                                       'ORDER': 22,
                                                                       'PRECISION': 6,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10}},
                     'ATTRIBUTE_MAP': {'ABSOLUTE_CONFIGURATION': ('chemical', 'absolute_configuration', None, None),
                                       'COMPOUND_SOURCE': ('chemical', 'compound_source', None, None),
                                       'ENTRY_ID': ('chemical', 'entry_id', None, None),
                                       'MELTING_POINT': ('chemical', 'melting_point', None, None),
                                       'MELTING_POINT_GT': ('chemical', 'melting_point_gt', None, None),
                                       'MELTING_POINT_LT': ('chemical', 'melting_point_lt', None, None),
                                       'NAME_COMMON': ('chemical', 'name_common', None, None),
                                       'NAME_MINERAL': ('chemical', 'name_mineral', None, None),
                                       'NAME_STRUCTURE_TYPE': ('chemical', 'name_structure_type', None, None),
                                       'NAME_SYSTEMATIC': ('chemical', 'name_systematic', None, None),
                                       'OPTICAL_ROTATION': ('chemical', 'optical_rotation', None, None),
                                       'PROPERTIES_BIOLOGICAL': ('chemical', 'properties_biological', None, None),
                                       'PROPERTIES_PHYSICAL': ('chemical', 'properties_physical', None, None),
                                       'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                       'TEMPERATURE_DECOMPOSITION': ('chemical', 'temperature_decomposition', None, None),
                                       'TEMPERATURE_DECOMPOSITION_ESD': ('chemical',
                                                                         'temperature_decomposition_esd',
                                                                         None,
                                                                         None),
                                       'TEMPERATURE_DECOMPOSITION_GT': ('chemical',
                                                                        'temperature_decomposition_gt',
                                                                        None,
                                                                        None),
                                       'TEMPERATURE_DECOMPOSITION_LT': ('chemical',
                                                                        'temperature_decomposition_lt',
                                                                        None,
                                                                        None),
                                       'TEMPERATURE_SUBLIMATION': ('chemical', 'temperature_sublimation', None, None),
                                       'TEMPERATURE_SUBLIMATION_ESD': ('chemical',
                                                                       'temperature_sublimation_esd',
                                                                       None,
                                                                       None),
                                       'TEMPERATURE_SUBLIMATION_GT': ('chemical', 'temperature_sublimation_gt', None, None),
                                       'TEMPERATURE_SUBLIMATION_LT': ('chemical', 'temperature_sublimation_lt', None, None)},
                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                 's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                     'MAP_MERGE_INDICES': {'chemical': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                     'TABLE_ID': 'CHEMICAL',
                     'TABLE_NAME': 'chemical',
                     'TABLE_TYPE': 'transactional'},
        'CHEMICAL_CONN_ATOM': {'ATTRIBUTES': {'CHARGE': 'charge',
                                              'DISPLAY_X': 'display_x',
                                              'DISPLAY_Y': 'display_y',
                                              'NCA': 'NCA',
                                              'NH': 'NH',
                                              'NUMBER': 'number',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'TYPE_SYMBOL': 'type_symbol'},
                               'ATTRIBUTE_INFO': {'CHARGE': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                                  'DISPLAY_X': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                  'DISPLAY_Y': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                  'NCA': {'NULLABLE': True,
                                                          'ORDER': 6,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'INT',
                                                          'WIDTH': 10},
                                                  'NH': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                                  'NUMBER': {'NULLABLE': False,
                                                             'ORDER': 8,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'TYPE_SYMBOL': {'NULLABLE': True,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'CHARGE': ('chemical_conn_atom', 'charge', None, None),
                                                 'DISPLAY_X': ('chemical_conn_atom', 'display_x', None, None),
                                                 'DISPLAY_Y': ('chemical_conn_atom', 'display_y', None, None),
                                                 'NCA': ('chemical_conn_atom', 'NCA', None, None),
                                                 'NH': ('chemical_conn_atom', 'NH', None, None),
                                                 'NUMBER': ('chemical_conn_atom', 'number', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                 'TYPE_SYMBOL': ('chemical_conn_atom', 'type_symbol', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'NUMBER'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'chemical_conn_atom': {'ATTRIBUTES': ('number',), 'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'CHEMICAL_CONN_ATOM',
                               'TABLE_NAME': 'chemical_conn_atom',
                               'TABLE_TYPE': 'transactional'},
        'CHEMICAL_CONN_BOND': {'ATTRIBUTES': {'ATOM_1': 'atom_1',
                                              'ATOM_2': 'atom_2',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'TYPE': 'type'},
                               'ATTRIBUTE_INFO': {'ATOM_1': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                                  'ATOM_2': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'TYPE': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'ATOM_1': ('chemical_conn_bond', 'atom_1', None, None),
                                                 'ATOM_2': ('chemical_conn_bond', 'atom_2', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                 'TYPE': ('chemical_conn_bond', 'type', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ATOM_1', 'ATOM_2'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'chemical_conn_bond': {'ATTRIBUTES': ('atom_1', 'atom_2'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'CHEMICAL_CONN_BOND',
                               'TABLE_NAME': 'chemical_conn_bond',
                               'TABLE_TYPE': 'transactional'},
        'CHEMICAL_FORMULA': {'ATTRIBUTES': {'ANALYTICAL': 'analytical',
                                            'ENTRY_ID': 'entry_id',
                                            'IUPAC': 'iupac',
                                            'MOIETY': 'moiety',
                                            'STRUCTURAL': 'structural',
                                            'STRUCTURE_ID': 'Structure_ID',
                                            'SUM': 'sum',
                                            'WEIGHT': 'weight',
                                            'WEIGHT_MEAS': 'weight_meas'},
                             'ATTRIBUTE_INFO': {'ANALYTICAL': {'NULLABLE': True,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                'ENTRY_ID': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                'IUPAC': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                                'MOIETY': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                                'STRUCTURAL': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                'SUM': {'NULLABLE': True,
                                                        'ORDER': 7,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                                'WEIGHT': {'NULLABLE': True,
                                                           'ORDER': 8,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                'WEIGHT_MEAS': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10}},
                             'ATTRIBUTE_MAP': {'ANALYTICAL': ('chemical_formula', 'analytical', None, None),
                                               'ENTRY_ID': ('chemical_formula', 'entry_id', None, None),
                                               'IUPAC': ('chemical_formula', 'iupac', None, None),
                                               'MOIETY': ('chemical_formula', 'moiety', None, None),
                                               'STRUCTURAL': ('chemical_formula', 'structural', None, None),
                                               'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                               'SUM': ('chemical_formula', 'sum', None, None),
                                               'WEIGHT': ('chemical_formula', 'weight', None, None),
                                               'WEIGHT_MEAS': ('chemical_formula', 'weight_meas', None, None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'chemical_formula': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'CHEMICAL_FORMULA',
                             'TABLE_NAME': 'chemical_formula',
                             'TABLE_TYPE': 'transactional'},
        'CHEM_COMP': {'ATTRIBUTES': {'FORMULA': 'formula',
                                     'FORMULA_WEIGHT': 'formula_weight',
                                     'ID': 'id',
                                     'MODEL_DETAILS': 'model_details',
                                     'MODEL_ERF': 'model_erf',
                                     'MODEL_SOURCE': 'model_source',
                                     'MON_NSTD_CLASS': 'mon_nstd_class',
                                     'MON_NSTD_DETAILS': 'mon_nstd_details',
                                     'MON_NSTD_FLAG': 'mon_nstd_flag',
                                     'MON_NSTD_PARENT': 'mon_nstd_parent',
                                     'MON_NSTD_PARENT_COMP_ID': 'mon_nstd_parent_comp_id',
                                     'NAME': 'name',
                                     'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                     'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                     'ONE_LETTER_CODE': 'one_letter_code',
                                     'PDBX_AMBIGUOUS_FLAG': 'pdbx_ambiguous_flag',
                                     'PDBX_COMPONENT_NO': 'pdbx_component_no',
                                     'PDBX_FORMAL_CHARGE': 'pdbx_formal_charge',
                                     'PDBX_IDEAL_COORDINATES_DETAILS': 'pdbx_ideal_coordinates_details',
                                     'PDBX_IDEAL_COORDINATES_MISSING_FLAG': 'pdbx_ideal_coordinates_missing_flag',
                                     'PDBX_INITIAL_DATE': 'pdbx_initial_date',
                                     'PDBX_MODEL_COORDINATES_DB_CODE': 'pdbx_model_coordinates_db_code',
                                     'PDBX_MODEL_COORDINATES_DETAILS': 'pdbx_model_coordinates_details',
                                     'PDBX_MODEL_COORDINATES_MISSING_FLAG': 'pdbx_model_coordinates_missing_flag',
                                     'PDBX_MODIFICATION_DETAILS': 'pdbx_modification_details',
                                     'PDBX_MODIFIED_DATE': 'pdbx_modified_date',
                                     'PDBX_PROCESSING_SITE': 'pdbx_processing_site',
                                     'PDBX_RELEASE_STATUS': 'pdbx_release_status',
                                     'PDBX_REPLACED_BY': 'pdbx_replaced_by',
                                     'PDBX_REPLACES': 'pdbx_replaces',
                                     'PDBX_SUBCOMPONENT_LIST': 'pdbx_subcomponent_list',
                                     'PDBX_SYNONYMS': 'pdbx_synonyms',
                                     'PDBX_TYPE': 'pdbx_type',
                                     'STRUCTURE_ID': 'Structure_ID',
                                     'THREE_LETTER_CODE': 'three_letter_code',
                                     'TYPE': 'type'},
                      'ATTRIBUTE_INFO': {'FORMULA': {'NULLABLE': True,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'FORMULA_WEIGHT': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 4,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 10},
                                         'MODEL_DETAILS': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                         'MODEL_ERF': {'NULLABLE': True,
                                                       'ORDER': 6,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'MODEL_SOURCE': {'NULLABLE': True,
                                                          'ORDER': 7,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                         'MON_NSTD_CLASS': {'NULLABLE': True,
                                                            'ORDER': 8,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                         'MON_NSTD_DETAILS': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                         'MON_NSTD_FLAG': {'NULLABLE': True,
                                                           'ORDER': 10,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                         'MON_NSTD_PARENT': {'NULLABLE': True,
                                                             'ORDER': 11,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                         'MON_NSTD_PARENT_COMP_ID': {'NULLABLE': True,
                                                                     'ORDER': 12,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                         'NAME': {'NULLABLE': True,
                                                  'ORDER': 13,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 1023},
                                         'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                         'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                         'ONE_LETTER_CODE': {'NULLABLE': True,
                                                             'ORDER': 16,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                         'PDBX_AMBIGUOUS_FLAG': {'NULLABLE': True,
                                                                 'ORDER': 23,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                         'PDBX_COMPONENT_NO': {'NULLABLE': True,
                                                               'ORDER': 21,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                         'PDBX_FORMAL_CHARGE': {'NULLABLE': True,
                                                                'ORDER': 26,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                         'PDBX_IDEAL_COORDINATES_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 30,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                         'PDBX_IDEAL_COORDINATES_MISSING_FLAG': {'NULLABLE': True,
                                                                                 'ORDER': 31,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                         'PDBX_INITIAL_DATE': {'NULLABLE': True,
                                                               'ORDER': 33,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'DATETIME',
                                                               'WIDTH': 15},
                                         'PDBX_MODEL_COORDINATES_DB_CODE': {'NULLABLE': True,
                                                                            'ORDER': 29,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80},
                                         'PDBX_MODEL_COORDINATES_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 28,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                         'PDBX_MODEL_COORDINATES_MISSING_FLAG': {'NULLABLE': True,
                                                                                 'ORDER': 32,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                         'PDBX_MODIFICATION_DETAILS': {'NULLABLE': True,
                                                                       'ORDER': 20,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                         'PDBX_MODIFIED_DATE': {'NULLABLE': True,
                                                                'ORDER': 34,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATETIME',
                                                                'WIDTH': 15},
                                         'PDBX_PROCESSING_SITE': {'NULLABLE': True,
                                                                  'ORDER': 36,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                         'PDBX_RELEASE_STATUS': {'NULLABLE': True,
                                                                 'ORDER': 35,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                         'PDBX_REPLACED_BY': {'NULLABLE': True,
                                                              'ORDER': 24,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                         'PDBX_REPLACES': {'NULLABLE': True,
                                                           'ORDER': 25,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                         'PDBX_SUBCOMPONENT_LIST': {'NULLABLE': True,
                                                                    'ORDER': 27,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                         'PDBX_SYNONYMS': {'NULLABLE': True,
                                                           'ORDER': 19,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 511},
                                         'PDBX_TYPE': {'NULLABLE': True,
                                                       'ORDER': 22,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'THREE_LETTER_CODE': {'NULLABLE': True,
                                                               'ORDER': 17,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 4},
                                         'TYPE': {'NULLABLE': True,
                                                  'ORDER': 18,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 80}},
                      'ATTRIBUTE_MAP': {'FORMULA': ('chem_comp', 'formula', None, None),
                                        'FORMULA_WEIGHT': ('chem_comp', 'formula_weight', None, None),
                                        'ID': ('chem_comp', 'id', None, None),
                                        'MODEL_DETAILS': ('chem_comp', 'model_details', None, None),
                                        'MODEL_ERF': ('chem_comp', 'model_erf', None, None),
                                        'MODEL_SOURCE': ('chem_comp', 'model_source', None, None),
                                        'MON_NSTD_CLASS': ('chem_comp', 'mon_nstd_class', None, None),
                                        'MON_NSTD_DETAILS': ('chem_comp', 'mon_nstd_details', None, None),
                                        'MON_NSTD_FLAG': ('chem_comp', 'mon_nstd_flag', None, None),
                                        'MON_NSTD_PARENT': ('chem_comp', 'mon_nstd_parent', None, None),
                                        'MON_NSTD_PARENT_COMP_ID': ('chem_comp', 'mon_nstd_parent_comp_id', None, None),
                                        'NAME': ('chem_comp', 'name', None, None),
                                        'NUMBER_ATOMS_ALL': ('chem_comp', 'number_atoms_all', None, None),
                                        'NUMBER_ATOMS_NH': ('chem_comp', 'number_atoms_nh', None, None),
                                        'ONE_LETTER_CODE': ('chem_comp', 'one_letter_code', None, None),
                                        'PDBX_AMBIGUOUS_FLAG': ('chem_comp', 'pdbx_ambiguous_flag', None, None),
                                        'PDBX_COMPONENT_NO': ('chem_comp', 'pdbx_component_no', None, None),
                                        'PDBX_FORMAL_CHARGE': ('chem_comp', 'pdbx_formal_charge', None, None),
                                        'PDBX_IDEAL_COORDINATES_DETAILS': ('chem_comp',
                                                                           'pdbx_ideal_coordinates_details',
                                                                           None,
                                                                           None),
                                        'PDBX_IDEAL_COORDINATES_MISSING_FLAG': ('chem_comp',
                                                                                'pdbx_ideal_coordinates_missing_flag',
                                                                                None,
                                                                                None),
                                        'PDBX_INITIAL_DATE': ('chem_comp', 'pdbx_initial_date', None, None),
                                        'PDBX_MODEL_COORDINATES_DB_CODE': ('chem_comp',
                                                                           'pdbx_model_coordinates_db_code',
                                                                           None,
                                                                           None),
                                        'PDBX_MODEL_COORDINATES_DETAILS': ('chem_comp',
                                                                           'pdbx_model_coordinates_details',
                                                                           None,
                                                                           None),
                                        'PDBX_MODEL_COORDINATES_MISSING_FLAG': ('chem_comp',
                                                                                'pdbx_model_coordinates_missing_flag',
                                                                                None,
                                                                                None),
                                        'PDBX_MODIFICATION_DETAILS': ('chem_comp', 'pdbx_modification_details', None, None),
                                        'PDBX_MODIFIED_DATE': ('chem_comp', 'pdbx_modified_date', None, None),
                                        'PDBX_PROCESSING_SITE': ('chem_comp', 'pdbx_processing_site', None, None),
                                        'PDBX_RELEASE_STATUS': ('chem_comp', 'pdbx_release_status', None, None),
                                        'PDBX_REPLACED_BY': ('chem_comp', 'pdbx_replaced_by', None, None),
                                        'PDBX_REPLACES': ('chem_comp', 'pdbx_replaces', None, None),
                                        'PDBX_SUBCOMPONENT_LIST': ('chem_comp', 'pdbx_subcomponent_list', None, None),
                                        'PDBX_SYNONYMS': ('chem_comp', 'pdbx_synonyms', None, None),
                                        'PDBX_TYPE': ('chem_comp', 'pdbx_type', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                        'THREE_LETTER_CODE': ('chem_comp', 'three_letter_code', None, None),
                                        'TYPE': ('chem_comp', 'type', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'chem_comp': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'CHEM_COMP',
                      'TABLE_NAME': 'chem_comp',
                      'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_ANGLE': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                           'ATOM_ID_2': 'atom_id_2',
                                           'ATOM_ID_3': 'atom_id_3',
                                           'COMP_ID': 'comp_id',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'VALUE_ANGLE': 'value_angle',
                                           'VALUE_ANGLE_ESD': 'value_angle_esd',
                                           'VALUE_DIST': 'value_dist',
                                           'VALUE_DIST_ESD': 'value_dist_esd'},
                            'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 6},
                                               'ATOM_ID_2': {'NULLABLE': False,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 6},
                                               'ATOM_ID_3': {'NULLABLE': False,
                                                             'ORDER': 5,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 6},
                                               'COMP_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'VALUE_ANGLE': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                               'VALUE_ANGLE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 7,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                               'VALUE_DIST': {'NULLABLE': True,
                                                              'ORDER': 8,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                               'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                  'ORDER': 9,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_angle', 'atom_id_1', None, None),
                                              'ATOM_ID_2': ('chem_comp_angle', 'atom_id_2', None, None),
                                              'ATOM_ID_3': ('chem_comp_angle', 'atom_id_3', None, None),
                                              'COMP_ID': ('chem_comp_angle', 'comp_id', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'VALUE_ANGLE': ('chem_comp_angle', 'value_angle', None, None),
                                              'VALUE_ANGLE_ESD': ('chem_comp_angle', 'value_angle_esd', None, None),
                                              'VALUE_DIST': ('chem_comp_angle', 'value_dist', None, None),
                                              'VALUE_DIST_ESD': ('chem_comp_angle', 'value_dist_esd', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                              'COMP_ID',
                                                              'ATOM_ID_1',
                                                              'ATOM_ID_2',
                                                              'ATOM_ID_3'),
                                               'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'chem_comp_angle': {'ATTRIBUTES': ('comp_id',
                                                                                     'atom_id_1',
                                                                                     'atom_id_2',
                                                                                     'atom_id_3'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CHEM_COMP_ANGLE',
                            'TABLE_NAME': 'chem_comp_angle',
                            'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_ATOM': {'ATTRIBUTES': {'ALT_ATOM_ID': 'alt_atom_id',
                                          'ATOM_ID': 'atom_id',
                                          'CHARGE': 'charge',
                                          'COMP_ID': 'comp_id',
                                          'MODEL_CARTN_X': 'model_Cartn_x',
                                          'MODEL_CARTN_X_ESD': 'model_Cartn_x_esd',
                                          'MODEL_CARTN_Y': 'model_Cartn_y',
                                          'MODEL_CARTN_Y_ESD': 'model_Cartn_y_esd',
                                          'MODEL_CARTN_Z': 'model_Cartn_z',
                                          'MODEL_CARTN_Z_ESD': 'model_Cartn_z_esd',
                                          'PARTIAL_CHARGE': 'partial_charge',
                                          'PDBX_ALIGN': 'pdbx_align',
                                          'PDBX_ALT_ATOM_ID': 'pdbx_alt_atom_id',
                                          'PDBX_ALT_COMP_ID': 'pdbx_alt_comp_id',
                                          'PDBX_AROMATIC_FLAG': 'pdbx_aromatic_flag',
                                          'PDBX_COMPONENT_ATOM_ID': 'pdbx_component_atom_id',
                                          'PDBX_COMPONENT_COMP_ID': 'pdbx_component_comp_id',
                                          'PDBX_LEAVING_ATOM_FLAG': 'pdbx_leaving_atom_flag',
                                          'PDBX_MODEL_CARTN_X_IDEAL': 'pdbx_model_Cartn_x_ideal',
                                          'PDBX_MODEL_CARTN_Y_IDEAL': 'pdbx_model_Cartn_y_ideal',
                                          'PDBX_MODEL_CARTN_Z_IDEAL': 'pdbx_model_Cartn_z_ideal',
                                          'PDBX_ORDINAL': 'pdbx_ordinal',
                                          'PDBX_STEREO_CONFIG': 'pdbx_stereo_config',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'SUBSTRUCT_CODE': 'substruct_code',
                                          'TYPE_SYMBOL': 'type_symbol'},
                           'ATTRIBUTE_INFO': {'ALT_ATOM_ID': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                              'ATOM_ID': {'NULLABLE': False,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 6},
                                              'CHARGE': {'NULLABLE': True,
                                                         'ORDER': 5,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'MODEL_CARTN_X': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_X_ESD': {'NULLABLE': True,
                                                                    'ORDER': 7,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'MODEL_CARTN_Y': {'NULLABLE': True,
                                                                'ORDER': 8,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_Y_ESD': {'NULLABLE': True,
                                                                    'ORDER': 9,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'MODEL_CARTN_Z': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_Z_ESD': {'NULLABLE': True,
                                                                    'ORDER': 11,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'PARTIAL_CHARGE': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'PDBX_ALIGN': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                              'PDBX_ALT_ATOM_ID': {'NULLABLE': True,
                                                                   'ORDER': 19,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 6},
                                              'PDBX_ALT_COMP_ID': {'NULLABLE': True,
                                                                   'ORDER': 20,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                              'PDBX_AROMATIC_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 25,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_COMPONENT_ATOM_ID': {'NULLABLE': True,
                                                                         'ORDER': 17,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 6},
                                              'PDBX_COMPONENT_COMP_ID': {'NULLABLE': True,
                                                                         'ORDER': 18,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                              'PDBX_LEAVING_ATOM_FLAG': {'NULLABLE': True,
                                                                         'ORDER': 26,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_X_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 21,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_Y_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 22,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_Z_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 23,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_ORDINAL': {'NULLABLE': True,
                                                               'ORDER': 16,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                              'PDBX_STEREO_CONFIG': {'NULLABLE': True,
                                                                     'ORDER': 24,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'SUBSTRUCT_CODE': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                              'TYPE_SYMBOL': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ALT_ATOM_ID': ('chem_comp_atom', 'alt_atom_id', None, None),
                                             'ATOM_ID': ('chem_comp_atom', 'atom_id', None, None),
                                             'CHARGE': ('chem_comp_atom', 'charge', None, None),
                                             'COMP_ID': ('chem_comp_atom', 'comp_id', None, None),
                                             'MODEL_CARTN_X': ('chem_comp_atom', 'model_Cartn_x', None, None),
                                             'MODEL_CARTN_X_ESD': ('chem_comp_atom', 'model_Cartn_x_esd', None, None),
                                             'MODEL_CARTN_Y': ('chem_comp_atom', 'model_Cartn_y', None, None),
                                             'MODEL_CARTN_Y_ESD': ('chem_comp_atom', 'model_Cartn_y_esd', None, None),
                                             'MODEL_CARTN_Z': ('chem_comp_atom', 'model_Cartn_z', None, None),
                                             'MODEL_CARTN_Z_ESD': ('chem_comp_atom', 'model_Cartn_z_esd', None, None),
                                             'PARTIAL_CHARGE': ('chem_comp_atom', 'partial_charge', None, None),
                                             'PDBX_ALIGN': ('chem_comp_atom', 'pdbx_align', None, None),
                                             'PDBX_ALT_ATOM_ID': ('chem_comp_atom', 'pdbx_alt_atom_id', None, None),
                                             'PDBX_ALT_COMP_ID': ('chem_comp_atom', 'pdbx_alt_comp_id', None, None),
                                             'PDBX_AROMATIC_FLAG': ('chem_comp_atom', 'pdbx_aromatic_flag', None, None),
                                             'PDBX_COMPONENT_ATOM_ID': ('chem_comp_atom',
                                                                        'pdbx_component_atom_id',
                                                                        None,
                                                                        None),
                                             'PDBX_COMPONENT_COMP_ID': ('chem_comp_atom',
                                                                        'pdbx_component_comp_id',
                                                                        None,
                                                                        None),
                                             'PDBX_LEAVING_ATOM_FLAG': ('chem_comp_atom',
                                                                        'pdbx_leaving_atom_flag',
                                                                        None,
                                                                        None),
                                             'PDBX_MODEL_CARTN_X_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_x_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_MODEL_CARTN_Y_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_y_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_MODEL_CARTN_Z_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_z_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_ORDINAL': ('chem_comp_atom', 'pdbx_ordinal', None, None),
                                             'PDBX_STEREO_CONFIG': ('chem_comp_atom', 'pdbx_stereo_config', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'SUBSTRUCT_CODE': ('chem_comp_atom', 'substruct_code', None, None),
                                             'TYPE_SYMBOL': ('chem_comp_atom', 'type_symbol', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ATOM_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_atom': {'ATTRIBUTES': ('comp_id', 'atom_id'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'CHEM_COMP_ATOM',
                           'TABLE_NAME': 'chem_comp_atom',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_BOND': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                          'ATOM_ID_2': 'atom_id_2',
                                          'COMP_ID': 'comp_id',
                                          'PDBX_AROMATIC_FLAG': 'pdbx_aromatic_flag',
                                          'PDBX_ORDINAL': 'pdbx_ordinal',
                                          'PDBX_STEREO_CONFIG': 'pdbx_stereo_config',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'VALUE_DIST': 'value_dist',
                                          'VALUE_DIST_ESD': 'value_dist_esd',
                                          'VALUE_ORDER': 'value_order'},
                           'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': False,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 6},
                                              'ATOM_ID_2': {'NULLABLE': False,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 6},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'PDBX_AROMATIC_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 10,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_ORDINAL': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                              'PDBX_STEREO_CONFIG': {'NULLABLE': True,
                                                                     'ORDER': 9,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'VALUE_DIST': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                              'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'VALUE_ORDER': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_bond', 'atom_id_1', None, None),
                                             'ATOM_ID_2': ('chem_comp_bond', 'atom_id_2', None, None),
                                             'COMP_ID': ('chem_comp_bond', 'comp_id', None, None),
                                             'PDBX_AROMATIC_FLAG': ('chem_comp_bond', 'pdbx_aromatic_flag', None, None),
                                             'PDBX_ORDINAL': ('chem_comp_bond', 'pdbx_ordinal', None, None),
                                             'PDBX_STEREO_CONFIG': ('chem_comp_bond', 'pdbx_stereo_config', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'VALUE_DIST': ('chem_comp_bond', 'value_dist', None, None),
                                             'VALUE_DIST_ESD': ('chem_comp_bond', 'value_dist_esd', None, None),
                                             'VALUE_ORDER': ('chem_comp_bond', 'value_order', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ATOM_ID_1', 'ATOM_ID_2'),
                                              'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_bond': {'ATTRIBUTES': ('comp_id', 'atom_id_1', 'atom_id_2'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'CHEM_COMP_BOND',
                           'TABLE_NAME': 'chem_comp_bond',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_CHIR': {'ATTRIBUTES': {'ATOM_CONFIG': 'atom_config',
                                          'ATOM_ID': 'atom_id',
                                          'COMP_ID': 'comp_id',
                                          'ID': 'id',
                                          'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                          'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'VOLUME_FLAG': 'volume_flag',
                                          'VOLUME_THREE': 'volume_three',
                                          'VOLUME_THREE_ESD': 'volume_three_esd'},
                           'ATTRIBUTE_INFO': {'ATOM_CONFIG': {'NULLABLE': True,
                                                              'ORDER': 4,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'ATOM_ID': {'NULLABLE': True,
                                                          'ORDER': 3,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 6},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'ID': {'NULLABLE': False,
                                                     'ORDER': 5,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                              'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                              'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'VOLUME_FLAG': {'NULLABLE': True,
                                                              'ORDER': 8,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'VOLUME_THREE': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                              'VOLUME_THREE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 10,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_CONFIG': ('chem_comp_chir', 'atom_config', None, None),
                                             'ATOM_ID': ('chem_comp_chir', 'atom_id', None, None),
                                             'COMP_ID': ('chem_comp_chir', 'comp_id', None, None),
                                             'ID': ('chem_comp_chir', 'id', None, None),
                                             'NUMBER_ATOMS_ALL': ('chem_comp_chir', 'number_atoms_all', None, None),
                                             'NUMBER_ATOMS_NH': ('chem_comp_chir', 'number_atoms_nh', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'VOLUME_FLAG': ('chem_comp_chir', 'volume_flag', None, None),
                                             'VOLUME_THREE': ('chem_comp_chir', 'volume_three', None, None),
                                             'VOLUME_THREE_ESD': ('chem_comp_chir', 'volume_three_esd', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_chir': {'ATTRIBUTES': ('comp_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'CHEM_COMP_CHIR',
                           'TABLE_NAME': 'chem_comp_chir',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_CHIR_ATOM': {'ATTRIBUTES': {'ATOM_ID': 'atom_id',
                                               'CHIR_ID': 'chir_id',
                                               'COMP_ID': 'comp_id',
                                               'DEV': 'dev',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'ATOM_ID': {'NULLABLE': False,
                                                               'ORDER': 3,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 6},
                                                   'CHIR_ID': {'NULLABLE': False,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'COMP_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'DEV': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ATOM_ID': ('chem_comp_chir_atom', 'atom_id', None, None),
                                                  'CHIR_ID': ('chem_comp_chir_atom', 'chir_id', None, None),
                                                  'COMP_ID': ('chem_comp_chir_atom', 'comp_id', None, None),
                                                  'DEV': ('chem_comp_chir_atom', 'dev', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ATOM_ID', 'CHIR_ID'),
                                                   'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'chem_comp_chir_atom': {'ATTRIBUTES': ('comp_id',
                                                                                             'atom_id',
                                                                                             'chir_id'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'CHEM_COMP_CHIR_ATOM',
                                'TABLE_NAME': 'chem_comp_chir_atom',
                                'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_LINK': {'ATTRIBUTES': {'DETAILS': 'details',
                                          'LINK_ID': 'link_id',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'TYPE_COMP_1': 'type_comp_1',
                                          'TYPE_COMP_2': 'type_comp_2'},
                           'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 5,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'LINK_ID': {'NULLABLE': False,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'TYPE_COMP_1': {'NULLABLE': True,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                              'TYPE_COMP_2': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80}},
                           'ATTRIBUTE_MAP': {'DETAILS': ('chem_comp_link', 'details', None, None),
                                             'LINK_ID': ('chem_comp_link', 'link_id', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'TYPE_COMP_1': ('chem_comp_link', 'type_comp_1', None, None),
                                             'TYPE_COMP_2': ('chem_comp_link', 'type_comp_2', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'LINK_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_link': {'ATTRIBUTES': ('link_id',), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'CHEM_COMP_LINK',
                           'TABLE_NAME': 'chem_comp_link',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_PLANE': {'ATTRIBUTES': {'COMP_ID': 'comp_id',
                                           'ID': 'id',
                                           'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                           'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                           'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'COMP_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                               'ID': {'NULLABLE': False,
                                                      'ORDER': 3,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                               'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                               'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'COMP_ID': ('chem_comp_plane', 'comp_id', None, None),
                                              'ID': ('chem_comp_plane', 'id', None, None),
                                              'NUMBER_ATOMS_ALL': ('chem_comp_plane', 'number_atoms_all', None, None),
                                              'NUMBER_ATOMS_NH': ('chem_comp_plane', 'number_atoms_nh', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'chem_comp_plane': {'ATTRIBUTES': ('comp_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CHEM_COMP_PLANE',
                            'TABLE_NAME': 'chem_comp_plane',
                            'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_PLANE_ATOM': {'ATTRIBUTES': {'ATOM_ID': 'atom_id',
                                                'COMP_ID': 'comp_id',
                                                'DIST_ESD': 'dist_esd',
                                                'PLANE_ID': 'plane_id',
                                                'STRUCTURE_ID': 'Structure_ID'},
                                 'ATTRIBUTE_INFO': {'ATOM_ID': {'NULLABLE': False,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 6},
                                                    'COMP_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                    'DIST_ESD': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                    'PLANE_ID': {'NULLABLE': False,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ATOM_ID': ('chem_comp_plane_atom', 'atom_id', None, None),
                                                   'COMP_ID': ('chem_comp_plane_atom', 'comp_id', None, None),
                                                   'DIST_ESD': ('chem_comp_plane_atom', 'dist_esd', None, None),
                                                   'PLANE_ID': ('chem_comp_plane_atom', 'plane_id', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ATOM_ID', 'PLANE_ID'),
                                                    'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'chem_comp_plane_atom': {'ATTRIBUTES': ('comp_id',
                                                                                               'atom_id',
                                                                                               'plane_id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'CHEM_COMP_PLANE_ATOM',
                                 'TABLE_NAME': 'chem_comp_plane_atom',
                                 'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_TOR': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                         'ATOM_ID_2': 'atom_id_2',
                                         'ATOM_ID_3': 'atom_id_3',
                                         'ATOM_ID_4': 'atom_id_4',
                                         'COMP_ID': 'comp_id',
                                         'ID': 'id',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': True,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'ATOM_ID_2': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'ATOM_ID_3': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'ATOM_ID_4': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'COMP_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                             'ID': {'NULLABLE': False,
                                                    'ORDER': 7,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 10},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_tor', 'atom_id_1', None, None),
                                            'ATOM_ID_2': ('chem_comp_tor', 'atom_id_2', None, None),
                                            'ATOM_ID_3': ('chem_comp_tor', 'atom_id_3', None, None),
                                            'ATOM_ID_4': ('chem_comp_tor', 'atom_id_4', None, None),
                                            'COMP_ID': ('chem_comp_tor', 'comp_id', None, None),
                                            'ID': ('chem_comp_tor', 'id', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'chem_comp_tor': {'ATTRIBUTES': ('comp_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'CHEM_COMP_TOR',
                          'TABLE_NAME': 'chem_comp_tor',
                          'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_TOR_VALUE': {'ATTRIBUTES': {'ANGLE': 'angle',
                                               'ANGLE_ESD': 'angle_esd',
                                               'COMP_ID': 'comp_id',
                                               'DIST': 'dist',
                                               'DIST_ESD': 'dist_esd',
                                               'STRUCTURE_ID': 'Structure_ID',
                                               'TOR_ID': 'tor_id'},
                                'ATTRIBUTE_INFO': {'ANGLE': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'ANGLE_ESD': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'COMP_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'DIST': {'NULLABLE': True,
                                                            'ORDER': 6,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                   'DIST_ESD': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'TOR_ID': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ANGLE': ('chem_comp_tor_value', 'angle', None, None),
                                                  'ANGLE_ESD': ('chem_comp_tor_value', 'angle_esd', None, None),
                                                  'COMP_ID': ('chem_comp_tor_value', 'comp_id', None, None),
                                                  'DIST': ('chem_comp_tor_value', 'dist', None, None),
                                                  'DIST_ESD': ('chem_comp_tor_value', 'dist_esd', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                  'TOR_ID': ('chem_comp_tor_value', 'tor_id', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'COMP_ID', 'TOR_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'chem_comp_tor_value': {'ATTRIBUTES': ('comp_id', 'tor_id'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'CHEM_COMP_TOR_VALUE',
                                'TABLE_NAME': 'chem_comp_tor_value',
                                'TABLE_TYPE': 'transactional'},
        'CHEM_LINK': {'ATTRIBUTES': {'DETAILS': 'details', 'ID': 'id', 'STRUCTURE_ID': 'Structure_ID'},
                      'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                     'ORDER': 3,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 2,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 10},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10}},
                      'ATTRIBUTE_MAP': {'DETAILS': ('chem_link', 'details', None, None),
                                        'ID': ('chem_link', 'id', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'chem_link': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'CHEM_LINK',
                      'TABLE_NAME': 'chem_link',
                      'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_ANGLE': {'ATTRIBUTES': {'ATOM_1_COMP_ID': 'atom_1_comp_id',
                                           'ATOM_2_COMP_ID': 'atom_2_comp_id',
                                           'ATOM_3_COMP_ID': 'atom_3_comp_id',
                                           'ATOM_ID_1': 'atom_id_1',
                                           'ATOM_ID_2': 'atom_id_2',
                                           'ATOM_ID_3': 'atom_id_3',
                                           'LINK_ID': 'link_id',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'VALUE_ANGLE': 'value_angle',
                                           'VALUE_ANGLE_ESD': 'value_angle_esd',
                                           'VALUE_DIST': 'value_dist',
                                           'VALUE_DIST_ESD': 'value_dist_esd'},
                            'ATTRIBUTE_INFO': {'ATOM_1_COMP_ID': {'NULLABLE': True,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                               'ATOM_2_COMP_ID': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                               'ATOM_3_COMP_ID': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                               'ATOM_ID_1': {'NULLABLE': False,
                                                             'ORDER': 6,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'ATOM_ID_2': {'NULLABLE': False,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'ATOM_ID_3': {'NULLABLE': False,
                                                             'ORDER': 8,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'LINK_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'VALUE_ANGLE': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                               'VALUE_ANGLE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 10,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                               'VALUE_DIST': {'NULLABLE': True,
                                                              'ORDER': 11,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                               'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                  'ORDER': 12,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'ATOM_1_COMP_ID': ('chem_link_angle', 'atom_1_comp_id', None, None),
                                              'ATOM_2_COMP_ID': ('chem_link_angle', 'atom_2_comp_id', None, None),
                                              'ATOM_3_COMP_ID': ('chem_link_angle', 'atom_3_comp_id', None, None),
                                              'ATOM_ID_1': ('chem_link_angle', 'atom_id_1', None, None),
                                              'ATOM_ID_2': ('chem_link_angle', 'atom_id_2', None, None),
                                              'ATOM_ID_3': ('chem_link_angle', 'atom_id_3', None, None),
                                              'LINK_ID': ('chem_link_angle', 'link_id', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'VALUE_ANGLE': ('chem_link_angle', 'value_angle', None, None),
                                              'VALUE_ANGLE_ESD': ('chem_link_angle', 'value_angle_esd', None, None),
                                              'VALUE_DIST': ('chem_link_angle', 'value_dist', None, None),
                                              'VALUE_DIST_ESD': ('chem_link_angle', 'value_dist_esd', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                              'LINK_ID',
                                                              'ATOM_ID_1',
                                                              'ATOM_ID_2',
                                                              'ATOM_ID_3'),
                                               'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'chem_link_angle': {'ATTRIBUTES': ('link_id',
                                                                                     'atom_id_1',
                                                                                     'atom_id_2',
                                                                                     'atom_id_3'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CHEM_LINK_ANGLE',
                            'TABLE_NAME': 'chem_link_angle',
                            'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_BOND': {'ATTRIBUTES': {'ATOM_1_COMP_ID': 'atom_1_comp_id',
                                          'ATOM_2_COMP_ID': 'atom_2_comp_id',
                                          'ATOM_ID_1': 'atom_id_1',
                                          'ATOM_ID_2': 'atom_id_2',
                                          'LINK_ID': 'link_id',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'VALUE_DIST': 'value_dist',
                                          'VALUE_DIST_ESD': 'value_dist_esd',
                                          'VALUE_ORDER': 'value_order'},
                           'ATTRIBUTE_INFO': {'ATOM_1_COMP_ID': {'NULLABLE': True,
                                                                 'ORDER': 3,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                              'ATOM_2_COMP_ID': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                              'ATOM_ID_1': {'NULLABLE': False,
                                                            'ORDER': 5,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                              'ATOM_ID_2': {'NULLABLE': False,
                                                            'ORDER': 6,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                              'LINK_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'VALUE_DIST': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                              'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'VALUE_ORDER': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_1_COMP_ID': ('chem_link_bond', 'atom_1_comp_id', None, None),
                                             'ATOM_2_COMP_ID': ('chem_link_bond', 'atom_2_comp_id', None, None),
                                             'ATOM_ID_1': ('chem_link_bond', 'atom_id_1', None, None),
                                             'ATOM_ID_2': ('chem_link_bond', 'atom_id_2', None, None),
                                             'LINK_ID': ('chem_link_bond', 'link_id', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'VALUE_DIST': ('chem_link_bond', 'value_dist', None, None),
                                             'VALUE_DIST_ESD': ('chem_link_bond', 'value_dist_esd', None, None),
                                             'VALUE_ORDER': ('chem_link_bond', 'value_order', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'LINK_ID', 'ATOM_ID_1', 'ATOM_ID_2'),
                                              'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_link_bond': {'ATTRIBUTES': ('link_id', 'atom_id_1', 'atom_id_2'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'CHEM_LINK_BOND',
                           'TABLE_NAME': 'chem_link_bond',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_CHIR': {'ATTRIBUTES': {'ATOM_COMP_ID': 'atom_comp_id',
                                          'ATOM_CONFIG': 'atom_config',
                                          'ATOM_ID': 'atom_id',
                                          'ID': 'id',
                                          'LINK_ID': 'link_id',
                                          'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                          'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'VOLUME_FLAG': 'volume_flag',
                                          'VOLUME_THREE': 'volume_three',
                                          'VOLUME_THREE_ESD': 'volume_three_esd'},
                           'ATTRIBUTE_INFO': {'ATOM_COMP_ID': {'NULLABLE': True,
                                                               'ORDER': 3,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'ATOM_CONFIG': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'ATOM_ID': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'ID': {'NULLABLE': False,
                                                     'ORDER': 6,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                              'LINK_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                                   'ORDER': 7,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                              'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'VOLUME_FLAG': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'VOLUME_THREE': {'NULLABLE': True,
                                                               'ORDER': 10,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                              'VOLUME_THREE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 11,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_COMP_ID': ('chem_link_chir', 'atom_comp_id', None, None),
                                             'ATOM_CONFIG': ('chem_link_chir', 'atom_config', None, None),
                                             'ATOM_ID': ('chem_link_chir', 'atom_id', None, None),
                                             'ID': ('chem_link_chir', 'id', None, None),
                                             'LINK_ID': ('chem_link_chir', 'link_id', None, None),
                                             'NUMBER_ATOMS_ALL': ('chem_link_chir', 'number_atoms_all', None, None),
                                             'NUMBER_ATOMS_NH': ('chem_link_chir', 'number_atoms_nh', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'VOLUME_FLAG': ('chem_link_chir', 'volume_flag', None, None),
                                             'VOLUME_THREE': ('chem_link_chir', 'volume_three', None, None),
                                             'VOLUME_THREE_ESD': ('chem_link_chir', 'volume_three_esd', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'LINK_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_link_chir': {'ATTRIBUTES': ('link_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'CHEM_LINK_CHIR',
                           'TABLE_NAME': 'chem_link_chir',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_CHIR_ATOM': {'ATTRIBUTES': {'ATOM_COMP_ID': 'atom_comp_id',
                                               'ATOM_ID': 'atom_id',
                                               'CHIR_ID': 'chir_id',
                                               'DEV': 'dev',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'ATOM_COMP_ID': {'NULLABLE': True,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'ATOM_ID': {'NULLABLE': False,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'CHIR_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'DEV': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ATOM_COMP_ID': ('chem_link_chir_atom', 'atom_comp_id', None, None),
                                                  'ATOM_ID': ('chem_link_chir_atom', 'atom_id', None, None),
                                                  'CHIR_ID': ('chem_link_chir_atom', 'chir_id', None, None),
                                                  'DEV': ('chem_link_chir_atom', 'dev', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CHIR_ID', 'ATOM_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'chem_link_chir_atom': {'ATTRIBUTES': ('chir_id', 'atom_id'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'CHEM_LINK_CHIR_ATOM',
                                'TABLE_NAME': 'chem_link_chir_atom',
                                'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_PLANE': {'ATTRIBUTES': {'ID': 'id',
                                           'LINK_ID': 'link_id',
                                           'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                           'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                           'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                      'ORDER': 3,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                               'LINK_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                               'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                               'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'ID': ('chem_link_plane', 'id', None, None),
                                              'LINK_ID': ('chem_link_plane', 'link_id', None, None),
                                              'NUMBER_ATOMS_ALL': ('chem_link_plane', 'number_atoms_all', None, None),
                                              'NUMBER_ATOMS_NH': ('chem_link_plane', 'number_atoms_nh', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'LINK_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'chem_link_plane': {'ATTRIBUTES': ('link_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CHEM_LINK_PLANE',
                            'TABLE_NAME': 'chem_link_plane',
                            'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_PLANE_ATOM': {'ATTRIBUTES': {'ATOM_COMP_ID': 'atom_comp_id',
                                                'ATOM_ID': 'atom_id',
                                                'PLANE_ID': 'plane_id',
                                                'STRUCTURE_ID': 'Structure_ID'},
                                 'ATTRIBUTE_INFO': {'ATOM_COMP_ID': {'NULLABLE': True,
                                                                     'ORDER': 3,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                    'ATOM_ID': {'NULLABLE': False,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                    'PLANE_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ATOM_COMP_ID': ('chem_link_plane_atom', 'atom_comp_id', None, None),
                                                   'ATOM_ID': ('chem_link_plane_atom', 'atom_id', None, None),
                                                   'PLANE_ID': ('chem_link_plane_atom', 'plane_id', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PLANE_ID', 'ATOM_ID'),
                                                    'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'chem_link_plane_atom': {'ATTRIBUTES': ('plane_id', 'atom_id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'CHEM_LINK_PLANE_ATOM',
                                 'TABLE_NAME': 'chem_link_plane_atom',
                                 'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_TOR': {'ATTRIBUTES': {'ATOM_1_COMP_ID': 'atom_1_comp_id',
                                         'ATOM_2_COMP_ID': 'atom_2_comp_id',
                                         'ATOM_3_COMP_ID': 'atom_3_comp_id',
                                         'ATOM_4_COMP_ID': 'atom_4_comp_id',
                                         'ATOM_ID_1': 'atom_id_1',
                                         'ATOM_ID_2': 'atom_id_2',
                                         'ATOM_ID_3': 'atom_id_3',
                                         'ATOM_ID_4': 'atom_id_4',
                                         'ID': 'id',
                                         'LINK_ID': 'link_id',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'ATOM_1_COMP_ID': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                             'ATOM_2_COMP_ID': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                             'ATOM_3_COMP_ID': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                             'ATOM_4_COMP_ID': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                             'ATOM_ID_1': {'NULLABLE': True,
                                                           'ORDER': 7,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'ATOM_ID_2': {'NULLABLE': True,
                                                           'ORDER': 8,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'ATOM_ID_3': {'NULLABLE': True,
                                                           'ORDER': 9,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'ATOM_ID_4': {'NULLABLE': True,
                                                           'ORDER': 10,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'ID': {'NULLABLE': False,
                                                    'ORDER': 11,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 10},
                                             'LINK_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'ATOM_1_COMP_ID': ('chem_link_tor', 'atom_1_comp_id', None, None),
                                            'ATOM_2_COMP_ID': ('chem_link_tor', 'atom_2_comp_id', None, None),
                                            'ATOM_3_COMP_ID': ('chem_link_tor', 'atom_3_comp_id', None, None),
                                            'ATOM_4_COMP_ID': ('chem_link_tor', 'atom_4_comp_id', None, None),
                                            'ATOM_ID_1': ('chem_link_tor', 'atom_id_1', None, None),
                                            'ATOM_ID_2': ('chem_link_tor', 'atom_id_2', None, None),
                                            'ATOM_ID_3': ('chem_link_tor', 'atom_id_3', None, None),
                                            'ATOM_ID_4': ('chem_link_tor', 'atom_id_4', None, None),
                                            'ID': ('chem_link_tor', 'id', None, None),
                                            'LINK_ID': ('chem_link_tor', 'link_id', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'LINK_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'chem_link_tor': {'ATTRIBUTES': ('link_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'CHEM_LINK_TOR',
                          'TABLE_NAME': 'chem_link_tor',
                          'TABLE_TYPE': 'transactional'},
        'CHEM_LINK_TOR_VALUE': {'ATTRIBUTES': {'ANGLE': 'angle',
                                               'ANGLE_ESD': 'angle_esd',
                                               'DIST': 'dist',
                                               'DIST_ESD': 'dist_esd',
                                               'STRUCTURE_ID': 'Structure_ID',
                                               'TOR_ID': 'tor_id'},
                                'ATTRIBUTE_INFO': {'ANGLE': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'ANGLE_ESD': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'DIST': {'NULLABLE': True,
                                                            'ORDER': 5,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                   'DIST_ESD': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'TOR_ID': {'NULLABLE': False,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ANGLE': ('chem_link_tor_value', 'angle', None, None),
                                                  'ANGLE_ESD': ('chem_link_tor_value', 'angle_esd', None, None),
                                                  'DIST': ('chem_link_tor_value', 'dist', None, None),
                                                  'DIST_ESD': ('chem_link_tor_value', 'dist_esd', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                  'TOR_ID': ('chem_link_tor_value', 'tor_id', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'TOR_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'chem_link_tor_value': {'ATTRIBUTES': ('tor_id',),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'CHEM_LINK_TOR_VALUE',
                                'TABLE_NAME': 'chem_link_tor_value',
                                'TABLE_TYPE': 'transactional'},
        'CITATION': {'ATTRIBUTES': {'ABSTRACT': 'abstract',
                                    'ABSTRACT_ID_CAS': 'abstract_id_CAS',
                                    'BOOK_ID_ISBN': 'book_id_ISBN',
                                    'BOOK_PUBLISHER': 'book_publisher',
                                    'BOOK_PUBLISHER_CITY': 'book_publisher_city',
                                    'BOOK_TITLE': 'book_title',
                                    'COORDINATE_LINKAGE': 'coordinate_linkage',
                                    'COUNTRY': 'country',
                                    'DATABASE_ID_CSD': 'database_id_CSD',
                                    'DATABASE_ID_MEDLINE': 'database_id_Medline',
                                    'DETAILS': 'details',
                                    'ID': 'id',
                                    'JOURNAL_ABBREV': 'journal_abbrev',
                                    'JOURNAL_FULL': 'journal_full',
                                    'JOURNAL_ID_ASTM': 'journal_id_ASTM',
                                    'JOURNAL_ID_CSD': 'journal_id_CSD',
                                    'JOURNAL_ID_ISSN': 'journal_id_ISSN',
                                    'JOURNAL_ISSUE': 'journal_issue',
                                    'JOURNAL_VOLUME': 'journal_volume',
                                    'LANGUAGE': 'language',
                                    'PAGE_FIRST': 'page_first',
                                    'PAGE_LAST': 'page_last',
                                    'PDBX_DATABASE_ID_DOI': 'pdbx_database_id_DOI',
                                    'PDBX_DATABASE_ID_PUBMED': 'pdbx_database_id_PubMed',
                                    'STRUCTURE_ID': 'Structure_ID',
                                    'TITLE': 'title',
                                    'UNPUBLISHED_FLAG': 'unpublished_flag',
                                    'YEAR': 'year'},
                     'ATTRIBUTE_INFO': {'ABSTRACT': {'NULLABLE': True,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                        'ABSTRACT_ID_CAS': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                        'BOOK_ID_ISBN': {'NULLABLE': True,
                                                         'ORDER': 4,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 80},
                                        'BOOK_PUBLISHER': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                        'BOOK_PUBLISHER_CITY': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                        'BOOK_TITLE': {'NULLABLE': True,
                                                       'ORDER': 7,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 200},
                                        'COORDINATE_LINKAGE': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                        'COUNTRY': {'NULLABLE': True,
                                                    'ORDER': 9,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 80},
                                        'DATABASE_ID_CSD': {'NULLABLE': True,
                                                            'ORDER': 25,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                        'DATABASE_ID_MEDLINE': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                        'DETAILS': {'NULLABLE': True,
                                                    'ORDER': 11,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 200},
                                        'ID': {'NULLABLE': False,
                                               'ORDER': 12,
                                               'PRECISION': 0,
                                               'PRIMARY_KEY': True,
                                               'SQL_TYPE': 'VARCHAR',
                                               'WIDTH': 16},
                                        'JOURNAL_ABBREV': {'NULLABLE': True,
                                                           'ORDER': 13,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 255},
                                        'JOURNAL_FULL': {'NULLABLE': True,
                                                         'ORDER': 17,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                        'JOURNAL_ID_ASTM': {'NULLABLE': True,
                                                            'ORDER': 14,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                        'JOURNAL_ID_CSD': {'NULLABLE': True,
                                                           'ORDER': 15,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                        'JOURNAL_ID_ISSN': {'NULLABLE': True,
                                                            'ORDER': 16,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                        'JOURNAL_ISSUE': {'NULLABLE': True,
                                                          'ORDER': 18,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 80},
                                        'JOURNAL_VOLUME': {'NULLABLE': True,
                                                           'ORDER': 19,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                        'LANGUAGE': {'NULLABLE': True,
                                                     'ORDER': 20,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 80},
                                        'PAGE_FIRST': {'NULLABLE': True,
                                                       'ORDER': 21,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                        'PAGE_LAST': {'NULLABLE': True,
                                                      'ORDER': 22,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                        'PDBX_DATABASE_ID_DOI': {'NULLABLE': True,
                                                                 'ORDER': 26,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 69},
                                        'PDBX_DATABASE_ID_PUBMED': {'NULLABLE': True,
                                                                    'ORDER': 27,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                         'ORDER': 1,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                        'TITLE': {'NULLABLE': True,
                                                  'ORDER': 23,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 1023},
                                        'UNPUBLISHED_FLAG': {'NULLABLE': True,
                                                             'ORDER': 28,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                        'YEAR': {'NULLABLE': True,
                                                 'ORDER': 24,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'INT',
                                                 'WIDTH': 10}},
                     'ATTRIBUTE_MAP': {'ABSTRACT': ('citation', 'abstract', None, None),
                                       'ABSTRACT_ID_CAS': ('citation', 'abstract_id_CAS', None, None),
                                       'BOOK_ID_ISBN': ('citation', 'book_id_ISBN', None, None),
                                       'BOOK_PUBLISHER': ('citation', 'book_publisher', None, None),
                                       'BOOK_PUBLISHER_CITY': ('citation', 'book_publisher_city', None, None),
                                       'BOOK_TITLE': ('citation', 'book_title', None, None),
                                       'COORDINATE_LINKAGE': ('citation', 'coordinate_linkage', None, None),
                                       'COUNTRY': ('citation', 'country', None, None),
                                       'DATABASE_ID_CSD': ('citation', 'database_id_CSD', None, None),
                                       'DATABASE_ID_MEDLINE': ('citation', 'database_id_Medline', None, None),
                                       'DETAILS': ('citation', 'details', None, None),
                                       'ID': ('citation', 'id', None, None),
                                       'JOURNAL_ABBREV': ('citation', 'journal_abbrev', None, None),
                                       'JOURNAL_FULL': ('citation', 'journal_full', None, None),
                                       'JOURNAL_ID_ASTM': ('citation', 'journal_id_ASTM', None, None),
                                       'JOURNAL_ID_CSD': ('citation', 'journal_id_CSD', None, None),
                                       'JOURNAL_ID_ISSN': ('citation', 'journal_id_ISSN', None, None),
                                       'JOURNAL_ISSUE': ('citation', 'journal_issue', None, None),
                                       'JOURNAL_VOLUME': ('citation', 'journal_volume', None, None),
                                       'LANGUAGE': ('citation', 'language', None, None),
                                       'PAGE_FIRST': ('citation', 'page_first', None, None),
                                       'PAGE_LAST': ('citation', 'page_last', None, None),
                                       'PDBX_DATABASE_ID_DOI': ('citation', 'pdbx_database_id_DOI', None, None),
                                       'PDBX_DATABASE_ID_PUBMED': ('citation', 'pdbx_database_id_PubMed', None, None),
                                       'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                       'TITLE': ('citation', 'title', None, None),
                                       'UNPUBLISHED_FLAG': ('citation', 'unpublished_flag', None, None),
                                       'YEAR': ('citation', 'year', None, None)},
                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                 's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                     'MAP_MERGE_INDICES': {'citation': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                     'TABLE_ID': 'CITATION',
                     'TABLE_NAME': 'citation',
                     'TABLE_TYPE': 'transactional'},
        'CITATION_AUTHOR': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                           'NAME': 'name',
                                           'ORDINAL': 'ordinal',
                                           'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 16},
                                               'NAME': {'NULLABLE': False,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 128},
                                               'ORDINAL': {'NULLABLE': False,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'INT',
                                                           'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'CITATION_ID': ('citation_author', 'citation_id', None, None),
                                              'NAME': ('citation_author', 'name', None, None),
                                              'ORDINAL': ('citation_author', 'ordinal', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CITATION_ID', 'NAME', 'ORDINAL'),
                                               'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'citation_author': {'ATTRIBUTES': ('citation_id', 'name', 'ordinal'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CITATION_AUTHOR',
                            'TABLE_NAME': 'citation_author',
                            'TABLE_TYPE': 'transactional'},
        'CITATION_EDITOR': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                           'NAME': 'name',
                                           'ORDINAL': 'ordinal',
                                           'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                               'NAME': {'NULLABLE': False,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 80},
                                               'ORDINAL': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'INT',
                                                           'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'CITATION_ID': ('citation_editor', 'citation_id', None, None),
                                              'NAME': ('citation_editor', 'name', None, None),
                                              'ORDINAL': ('citation_editor', 'ordinal', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CITATION_ID', 'NAME'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'citation_editor': {'ATTRIBUTES': ('citation_id', 'name'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CITATION_EDITOR',
                            'TABLE_NAME': 'citation_editor',
                            'TABLE_TYPE': 'transactional'},
        'COMPUTING': {'ATTRIBUTES': {'CELL_REFINEMENT': 'cell_refinement',
                                     'DATA_COLLECTION': 'data_collection',
                                     'DATA_REDUCTION': 'data_reduction',
                                     'ENTRY_ID': 'entry_id',
                                     'MOLECULAR_GRAPHICS': 'molecular_graphics',
                                     'PDBX_DATA_REDUCTION_DS': 'pdbx_data_reduction_ds',
                                     'PDBX_DATA_REDUCTION_II': 'pdbx_data_reduction_ii',
                                     'PDBX_STRUCTURE_REFINEMENT_METHOD': 'pdbx_structure_refinement_method',
                                     'PUBLICATION_MATERIAL': 'publication_material',
                                     'STRUCTURE_ID': 'Structure_ID',
                                     'STRUCTURE_REFINEMENT': 'structure_refinement',
                                     'STRUCTURE_SOLUTION': 'structure_solution'},
                      'ATTRIBUTE_INFO': {'CELL_REFINEMENT': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                         'DATA_COLLECTION': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                         'DATA_REDUCTION': {'NULLABLE': True,
                                                            'ORDER': 5,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                         'ENTRY_ID': {'NULLABLE': False,
                                                      'ORDER': 2,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                         'MOLECULAR_GRAPHICS': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                         'PDBX_DATA_REDUCTION_DS': {'NULLABLE': True,
                                                                    'ORDER': 12,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                         'PDBX_DATA_REDUCTION_II': {'NULLABLE': True,
                                                                    'ORDER': 11,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                         'PDBX_STRUCTURE_REFINEMENT_METHOD': {'NULLABLE': True,
                                                                              'ORDER': 10,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 200},
                                         'PUBLICATION_MATERIAL': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'STRUCTURE_REFINEMENT': {'NULLABLE': True,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                         'STRUCTURE_SOLUTION': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200}},
                      'ATTRIBUTE_MAP': {'CELL_REFINEMENT': ('computing', 'cell_refinement', None, None),
                                        'DATA_COLLECTION': ('computing', 'data_collection', None, None),
                                        'DATA_REDUCTION': ('computing', 'data_reduction', None, None),
                                        'ENTRY_ID': ('computing', 'entry_id', None, None),
                                        'MOLECULAR_GRAPHICS': ('computing', 'molecular_graphics', None, None),
                                        'PDBX_DATA_REDUCTION_DS': ('computing', 'pdbx_data_reduction_ds', None, None),
                                        'PDBX_DATA_REDUCTION_II': ('computing', 'pdbx_data_reduction_ii', None, None),
                                        'PDBX_STRUCTURE_REFINEMENT_METHOD': ('computing',
                                                                             'pdbx_structure_refinement_method',
                                                                             None,
                                                                             None),
                                        'PUBLICATION_MATERIAL': ('computing', 'publication_material', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                        'STRUCTURE_REFINEMENT': ('computing', 'structure_refinement', None, None),
                                        'STRUCTURE_SOLUTION': ('computing', 'structure_solution', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'computing': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'COMPUTING',
                      'TABLE_NAME': 'computing',
                      'TABLE_TYPE': 'transactional'},
        'DATABASE1': {'ATTRIBUTES': {'CODE_CAS': 'code_CAS',
                                     'CODE_CSD': 'code_CSD',
                                     'CODE_DEPNUM_CCDC_ARCHIVE': 'code_depnum_ccdc_archive',
                                     'CODE_DEPNUM_CCDC_FIZ': 'code_depnum_ccdc_fiz',
                                     'CODE_DEPNUM_CCDC_JOURNAL': 'code_depnum_ccdc_journal',
                                     'CODE_ICSD': 'code_ICSD',
                                     'CODE_MDF': 'code_MDF',
                                     'CODE_NBS': 'code_NBS',
                                     'CODE_PDB': 'code_PDB',
                                     'CODE_PDF': 'code_PDF',
                                     'CSD_HISTORY': 'CSD_history',
                                     'ENTRY_ID': 'entry_id',
                                     'JOURNAL_ASTM': 'journal_ASTM',
                                     'JOURNAL_CSD': 'journal_CSD',
                                     'STRUCTURE_ID': 'Structure_ID'},
                      'ATTRIBUTE_INFO': {'CODE_CAS': {'NULLABLE': True,
                                                      'ORDER': 6,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                         'CODE_CSD': {'NULLABLE': True,
                                                      'ORDER': 7,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                         'CODE_DEPNUM_CCDC_ARCHIVE': {'NULLABLE': True,
                                                                      'ORDER': 15,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                         'CODE_DEPNUM_CCDC_FIZ': {'NULLABLE': True,
                                                                  'ORDER': 13,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80},
                                         'CODE_DEPNUM_CCDC_JOURNAL': {'NULLABLE': True,
                                                                      'ORDER': 14,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                         'CODE_ICSD': {'NULLABLE': True,
                                                       'ORDER': 8,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'CODE_MDF': {'NULLABLE': True,
                                                      'ORDER': 9,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                         'CODE_NBS': {'NULLABLE': True,
                                                      'ORDER': 10,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                         'CODE_PDB': {'NULLABLE': True,
                                                      'ORDER': 11,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                         'CODE_PDF': {'NULLABLE': True,
                                                      'ORDER': 12,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                         'CSD_HISTORY': {'NULLABLE': True,
                                                         'ORDER': 5,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                         'ENTRY_ID': {'NULLABLE': False,
                                                      'ORDER': 2,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                         'JOURNAL_ASTM': {'NULLABLE': True,
                                                          'ORDER': 3,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 80},
                                         'JOURNAL_CSD': {'NULLABLE': True,
                                                         'ORDER': 4,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 80},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10}},
                      'ATTRIBUTE_MAP': {'CODE_CAS': ('database', 'code_CAS', None, None),
                                        'CODE_CSD': ('database', 'code_CSD', None, None),
                                        'CODE_DEPNUM_CCDC_ARCHIVE': ('database', 'code_depnum_ccdc_archive', None, None),
                                        'CODE_DEPNUM_CCDC_FIZ': ('database', 'code_depnum_ccdc_fiz', None, None),
                                        'CODE_DEPNUM_CCDC_JOURNAL': ('database', 'code_depnum_ccdc_journal', None, None),
                                        'CODE_ICSD': ('database', 'code_ICSD', None, None),
                                        'CODE_MDF': ('database', 'code_MDF', None, None),
                                        'CODE_NBS': ('database', 'code_NBS', None, None),
                                        'CODE_PDB': ('database', 'code_PDB', None, None),
                                        'CODE_PDF': ('database', 'code_PDF', None, None),
                                        'CSD_HISTORY': ('database', 'CSD_history', None, None),
                                        'ENTRY_ID': ('database', 'entry_id', None, None),
                                        'JOURNAL_ASTM': ('database', 'journal_ASTM', None, None),
                                        'JOURNAL_CSD': ('database', 'journal_CSD', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'database': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'DATABASE1',
                      'TABLE_NAME': 'database1',
                      'TABLE_TYPE': 'transactional'},
        'DATABASE_2': {'ATTRIBUTES': {'DATABASE_CODE': 'database_code',
                                      'DATABASE_ID': 'database_id',
                                      'STRUCTURE_ID': 'Structure_ID'},
                       'ATTRIBUTE_INFO': {'DATABASE_CODE': {'NULLABLE': False,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                          'DATABASE_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10}},
                       'ATTRIBUTE_MAP': {'DATABASE_CODE': ('database_2', 'database_code', None, None),
                                         'DATABASE_ID': ('database_2', 'database_id', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DATABASE_ID', 'DATABASE_CODE'), 'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'database_2': {'ATTRIBUTES': ('database_id', 'database_code'),
                                                            'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'DATABASE_2',
                       'TABLE_NAME': 'database_2',
                       'TABLE_TYPE': 'transactional'},
        'DATABASE_PDB_CAVEAT': {'ATTRIBUTES': {'ID': 'id', 'STRUCTURE_ID': 'Structure_ID', 'TEXT': 'text'},
                                'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'INT',
                                                          'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'TEXT': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 1023}},
                                'ATTRIBUTE_MAP': {'ID': ('database_PDB_caveat', 'id', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                  'TEXT': ('database_PDB_caveat', 'text', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'database_PDB_caveat': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'DATABASE_PDB_CAVEAT',
                                'TABLE_NAME': 'database_PDB_caveat',
                                'TABLE_TYPE': 'transactional'},
        'DATABASE_PDB_MATRIX': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                               'ORIGX_1_1': 'origx_1_1',
                                               'ORIGX_1_2': 'origx_1_2',
                                               'ORIGX_1_3': 'origx_1_3',
                                               'ORIGX_2_1': 'origx_2_1',
                                               'ORIGX_2_2': 'origx_2_2',
                                               'ORIGX_2_3': 'origx_2_3',
                                               'ORIGX_3_1': 'origx_3_1',
                                               'ORIGX_3_2': 'origx_3_2',
                                               'ORIGX_3_3': 'origx_3_3',
                                               'ORIGX_VECTOR_1': 'origx_vector_1',
                                               'ORIGX_VECTOR_2': 'origx_vector_2',
                                               'ORIGX_VECTOR_3': 'origx_vector_3',
                                               'SCALE_1_1': 'scale_1_1',
                                               'SCALE_1_2': 'scale_1_2',
                                               'SCALE_1_3': 'scale_1_3',
                                               'SCALE_2_1': 'scale_2_1',
                                               'SCALE_2_2': 'scale_2_2',
                                               'SCALE_2_3': 'scale_2_3',
                                               'SCALE_3_1': 'scale_3_1',
                                               'SCALE_3_2': 'scale_3_2',
                                               'SCALE_3_3': 'scale_3_3',
                                               'SCALE_VECTOR_1': 'scale_vector_1',
                                               'SCALE_VECTOR_2': 'scale_vector_2',
                                               'SCALE_VECTOR_3': 'scale_vector_3',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                   'ORIGX_1_1': {'NULLABLE': True,
                                                                 'ORDER': 3,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_1_2': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_1_3': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_2_1': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_2_2': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_2_3': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_3_1': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_3_2': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_3_3': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ORIGX_VECTOR_1': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                   'ORIGX_VECTOR_2': {'NULLABLE': True,
                                                                      'ORDER': 13,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                   'ORIGX_VECTOR_3': {'NULLABLE': True,
                                                                      'ORDER': 14,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                   'SCALE_1_1': {'NULLABLE': True,
                                                                 'ORDER': 15,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_1_2': {'NULLABLE': True,
                                                                 'ORDER': 16,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_1_3': {'NULLABLE': True,
                                                                 'ORDER': 17,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_2_1': {'NULLABLE': True,
                                                                 'ORDER': 18,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_2_2': {'NULLABLE': True,
                                                                 'ORDER': 19,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_2_3': {'NULLABLE': True,
                                                                 'ORDER': 20,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_3_1': {'NULLABLE': True,
                                                                 'ORDER': 21,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_3_2': {'NULLABLE': True,
                                                                 'ORDER': 22,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_3_3': {'NULLABLE': True,
                                                                 'ORDER': 23,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'SCALE_VECTOR_1': {'NULLABLE': True,
                                                                      'ORDER': 24,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                   'SCALE_VECTOR_2': {'NULLABLE': True,
                                                                      'ORDER': 25,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                   'SCALE_VECTOR_3': {'NULLABLE': True,
                                                                      'ORDER': 26,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ENTRY_ID': ('database_PDB_matrix', 'entry_id', None, None),
                                                  'ORIGX_1_1': ('database_PDB_matrix', 'origx[1][1]', None, None),
                                                  'ORIGX_1_2': ('database_PDB_matrix', 'origx[1][2]', None, None),
                                                  'ORIGX_1_3': ('database_PDB_matrix', 'origx[1][3]', None, None),
                                                  'ORIGX_2_1': ('database_PDB_matrix', 'origx[2][1]', None, None),
                                                  'ORIGX_2_2': ('database_PDB_matrix', 'origx[2][2]', None, None),
                                                  'ORIGX_2_3': ('database_PDB_matrix', 'origx[2][3]', None, None),
                                                  'ORIGX_3_1': ('database_PDB_matrix', 'origx[3][1]', None, None),
                                                  'ORIGX_3_2': ('database_PDB_matrix', 'origx[3][2]', None, None),
                                                  'ORIGX_3_3': ('database_PDB_matrix', 'origx[3][3]', None, None),
                                                  'ORIGX_VECTOR_1': ('database_PDB_matrix', 'origx_vector[1]', None, None),
                                                  'ORIGX_VECTOR_2': ('database_PDB_matrix', 'origx_vector[2]', None, None),
                                                  'ORIGX_VECTOR_3': ('database_PDB_matrix', 'origx_vector[3]', None, None),
                                                  'SCALE_1_1': ('database_PDB_matrix', 'scale[1][1]', None, None),
                                                  'SCALE_1_2': ('database_PDB_matrix', 'scale[1][2]', None, None),
                                                  'SCALE_1_3': ('database_PDB_matrix', 'scale[1][3]', None, None),
                                                  'SCALE_2_1': ('database_PDB_matrix', 'scale[2][1]', None, None),
                                                  'SCALE_2_2': ('database_PDB_matrix', 'scale[2][2]', None, None),
                                                  'SCALE_2_3': ('database_PDB_matrix', 'scale[2][3]', None, None),
                                                  'SCALE_3_1': ('database_PDB_matrix', 'scale[3][1]', None, None),
                                                  'SCALE_3_2': ('database_PDB_matrix', 'scale[3][2]', None, None),
                                                  'SCALE_3_3': ('database_PDB_matrix', 'scale[3][3]', None, None),
                                                  'SCALE_VECTOR_1': ('database_PDB_matrix', 'scale_vector[1]', None, None),
                                                  'SCALE_VECTOR_2': ('database_PDB_matrix', 'scale_vector[2]', None, None),
                                                  'SCALE_VECTOR_3': ('database_PDB_matrix', 'scale_vector[3]', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'database_PDB_matrix': {'ATTRIBUTES': ('entry_id',),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'DATABASE_PDB_MATRIX',
                                'TABLE_NAME': 'database_PDB_matrix',
                                'TABLE_TYPE': 'transactional'},
        'DATABASE_PDB_REMARK': {'ATTRIBUTES': {'ID': 'id', 'STRUCTURE_ID': 'Structure_ID', 'TEXT': 'text'},
                                'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'INT',
                                                          'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'TEXT': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'TEXT',
                                                            'WIDTH': 118199}},
                                'ATTRIBUTE_MAP': {'ID': ('database_PDB_remark', 'id', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                  'TEXT': ('database_PDB_remark', 'text', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'database_PDB_remark': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'DATABASE_PDB_REMARK',
                                'TABLE_NAME': 'database_PDB_remark',
                                'TABLE_TYPE': 'transactional'},
        'DATABASE_PDB_REV': {'ATTRIBUTES': {'AUTHOR_NAME': 'author_name',
                                            'DATE': 'date',
                                            'DATE_ORIGINAL': 'date_original',
                                            'MOD_TYPE': 'mod_type',
                                            'NUM': 'num',
                                            'REPLACED_BY': 'replaced_by',
                                            'REPLACES': 'replaces',
                                            'STATUS': 'status',
                                            'STRUCTURE_ID': 'Structure_ID'},
                             'ATTRIBUTE_INFO': {'AUTHOR_NAME': {'NULLABLE': True,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                'DATE': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'DATETIME',
                                                         'WIDTH': 15},
                                                'DATE_ORIGINAL': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATETIME',
                                                                  'WIDTH': 15},
                                                'MOD_TYPE': {'NULLABLE': True,
                                                             'ORDER': 5,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                                'NUM': {'NULLABLE': False,
                                                        'ORDER': 6,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'INT',
                                                        'WIDTH': 10},
                                                'REPLACED_BY': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                'REPLACES': {'NULLABLE': True,
                                                             'ORDER': 8,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                'STATUS': {'NULLABLE': True,
                                                           'ORDER': 9,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10}},
                             'ATTRIBUTE_MAP': {'AUTHOR_NAME': ('database_PDB_rev', 'author_name', None, None),
                                               'DATE': ('database_PDB_rev', 'date', None, None),
                                               'DATE_ORIGINAL': ('database_PDB_rev', 'date_original', None, None),
                                               'MOD_TYPE': ('database_PDB_rev', 'mod_type', None, None),
                                               'NUM': ('database_PDB_rev', 'num', None, None),
                                               'REPLACED_BY': ('database_PDB_rev', 'replaced_by', None, None),
                                               'REPLACES': ('database_PDB_rev', 'replaces', None, None),
                                               'STATUS': ('database_PDB_rev', 'status', None, None),
                                               'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'NUM'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'database_PDB_rev': {'ATTRIBUTES': ('num',), 'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'DATABASE_PDB_REV',
                             'TABLE_NAME': 'database_PDB_rev',
                             'TABLE_TYPE': 'transactional'},
        'DATABASE_PDB_REV_RECORD': {'ATTRIBUTES': {'DETAILS': 'details',
                                                   'REV_NUM': 'rev_num',
                                                   'STRUCTURE_ID': 'Structure_ID',
                                                   'TYPE': 'type'},
                                    'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 3,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                       'REV_NUM': {'NULLABLE': False,
                                                                   'ORDER': 2,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                                       'STRUCTURE_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                       'TYPE': {'NULLABLE': False,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80}},
                                    'ATTRIBUTE_MAP': {'DETAILS': ('database_PDB_rev_record', 'details', None, None),
                                                      'REV_NUM': ('database_PDB_rev_record', 'rev_num', None, None),
                                                      'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                      'TYPE': ('database_PDB_rev_record', 'type', None, None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'REV_NUM', 'TYPE'), 'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'database_PDB_rev_record': {'ATTRIBUTES': ('rev_num', 'type'),
                                                                                      'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                    'TABLE_ID': 'DATABASE_PDB_REV_RECORD',
                                    'TABLE_NAME': 'database_PDB_rev_record',
                                    'TABLE_TYPE': 'transactional'},
        'DATABASE_PDB_TVECT': {'ATTRIBUTES': {'DETAILS': 'details',
                                              'ID': 'id',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'VECTOR_1': 'vector_1',
                                              'VECTOR_2': 'vector_2',
                                              'VECTOR_3': 'vector_3'},
                               'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                                  'ID': {'NULLABLE': False,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'VECTOR_1': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                  'VECTOR_2': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                  'VECTOR_3': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'DETAILS': ('database_PDB_tvect', 'details', None, None),
                                                 'ID': ('database_PDB_tvect', 'id', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                 'VECTOR_1': ('database_PDB_tvect', 'vector[1]', None, None),
                                                 'VECTOR_2': ('database_PDB_tvect', 'vector[2]', None, None),
                                                 'VECTOR_3': ('database_PDB_tvect', 'vector[3]', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'database_PDB_tvect': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'DATABASE_PDB_TVECT',
                               'TABLE_NAME': 'database_PDB_tvect',
                               'TABLE_TYPE': 'transactional'},
        'DIFFRN': {'ATTRIBUTES': {'AMBIENT_ENVIRONMENT': 'ambient_environment',
                                  'AMBIENT_PRESSURE': 'ambient_pressure',
                                  'AMBIENT_PRESSURE_ESD': 'ambient_pressure_esd',
                                  'AMBIENT_PRESSURE_GT': 'ambient_pressure_gt',
                                  'AMBIENT_PRESSURE_LT': 'ambient_pressure_lt',
                                  'AMBIENT_TEMP': 'ambient_temp',
                                  'AMBIENT_TEMP_DETAILS': 'ambient_temp_details',
                                  'AMBIENT_TEMP_ESD': 'ambient_temp_esd',
                                  'AMBIENT_TEMP_GT': 'ambient_temp_gt',
                                  'AMBIENT_TEMP_LT': 'ambient_temp_lt',
                                  'CRYSTAL_ID': 'crystal_id',
                                  'CRYSTAL_SUPPORT': 'crystal_support',
                                  'CRYSTAL_TREATMENT': 'crystal_treatment',
                                  'DETAILS': 'details',
                                  'ID': 'id',
                                  'STRUCTURE_ID': 'Structure_ID'},
                   'ATTRIBUTE_INFO': {'AMBIENT_ENVIRONMENT': {'NULLABLE': True,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                      'AMBIENT_PRESSURE': {'NULLABLE': True,
                                                           'ORDER': 11,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'AMBIENT_PRESSURE_ESD': {'NULLABLE': True,
                                                               'ORDER': 12,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                      'AMBIENT_PRESSURE_GT': {'NULLABLE': True,
                                                              'ORDER': 13,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'AMBIENT_PRESSURE_LT': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                      'AMBIENT_TEMP': {'NULLABLE': True,
                                                       'ORDER': 3,
                                                       'PRECISION': 6,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                      'AMBIENT_TEMP_DETAILS': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                      'AMBIENT_TEMP_ESD': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                      'AMBIENT_TEMP_GT': {'NULLABLE': True,
                                                          'ORDER': 15,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'AMBIENT_TEMP_LT': {'NULLABLE': True,
                                                          'ORDER': 16,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                      'CRYSTAL_ID': {'NULLABLE': True,
                                                     'ORDER': 6,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                      'CRYSTAL_SUPPORT': {'NULLABLE': True,
                                                          'ORDER': 7,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                      'CRYSTAL_TREATMENT': {'NULLABLE': True,
                                                            'ORDER': 8,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                      'DETAILS': {'NULLABLE': True,
                                                  'ORDER': 9,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 511},
                                      'ID': {'NULLABLE': False,
                                             'ORDER': 10,
                                             'PRECISION': 0,
                                             'PRIMARY_KEY': True,
                                             'SQL_TYPE': 'VARCHAR',
                                             'WIDTH': 10},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10}},
                   'ATTRIBUTE_MAP': {'AMBIENT_ENVIRONMENT': ('diffrn', 'ambient_environment', None, None),
                                     'AMBIENT_PRESSURE': ('diffrn', 'ambient_pressure', None, None),
                                     'AMBIENT_PRESSURE_ESD': ('diffrn', 'ambient_pressure_esd', None, None),
                                     'AMBIENT_PRESSURE_GT': ('diffrn', 'ambient_pressure_gt', None, None),
                                     'AMBIENT_PRESSURE_LT': ('diffrn', 'ambient_pressure_lt', None, None),
                                     'AMBIENT_TEMP': ('diffrn', 'ambient_temp', None, None),
                                     'AMBIENT_TEMP_DETAILS': ('diffrn', 'ambient_temp_details', None, None),
                                     'AMBIENT_TEMP_ESD': ('diffrn', 'ambient_temp_esd', None, None),
                                     'AMBIENT_TEMP_GT': ('diffrn', 'ambient_temp_gt', None, None),
                                     'AMBIENT_TEMP_LT': ('diffrn', 'ambient_temp_lt', None, None),
                                     'CRYSTAL_ID': ('diffrn', 'crystal_id', None, None),
                                     'CRYSTAL_SUPPORT': ('diffrn', 'crystal_support', None, None),
                                     'CRYSTAL_TREATMENT': ('diffrn', 'crystal_treatment', None, None),
                                     'DETAILS': ('diffrn', 'details', None, None),
                                     'ID': ('diffrn', 'id', None, None),
                                     'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                   'MAP_MERGE_INDICES': {'diffrn': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'DIFFRN',
                   'TABLE_NAME': 'diffrn',
                   'TABLE_TYPE': 'transactional'},
        'DIFFRN_ATTENUATOR': {'ATTRIBUTES': {'CODE': 'code',
                                             'MATERIAL': 'material',
                                             'SCALE': 'scale',
                                             'STRUCTURE_ID': 'Structure_ID'},
                              'ATTRIBUTE_INFO': {'CODE': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                                 'MATERIAL': {'NULLABLE': True,
                                                              'ORDER': 4,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                                 'SCALE': {'NULLABLE': True,
                                                           'ORDER': 3,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                 'STRUCTURE_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10}},
                              'ATTRIBUTE_MAP': {'CODE': ('diffrn_attenuator', 'code', None, None),
                                                'MATERIAL': ('diffrn_attenuator', 'material', None, None),
                                                'SCALE': ('diffrn_attenuator', 'scale', None, None),
                                                'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                              'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CODE'), 'TYPE': 'UNIQUE'},
                                          's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                              'MAP_MERGE_INDICES': {'diffrn_attenuator': {'ATTRIBUTES': ('code',), 'TYPE': 'EQUI-JOIN'}},
                              'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                              'TABLE_ID': 'DIFFRN_ATTENUATOR',
                              'TABLE_NAME': 'diffrn_attenuator',
                              'TABLE_TYPE': 'transactional'},
        'DIFFRN_DETECTOR': {'ATTRIBUTES': {'AREA_RESOL_MEAN': 'area_resol_mean',
                                           'DETAILS': 'details',
                                           'DETECTOR': 'detector',
                                           'DIFFRN_ID': 'diffrn_id',
                                           'DTIME': 'dtime',
                                           'PDBX_COLLECTION_DATE': 'pdbx_collection_date',
                                           'PDBX_COLLECTION_TIME_TOTAL': 'pdbx_collection_time_total',
                                           'PDBX_FRAMES_TOTAL': 'pdbx_frames_total',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'TYPE': 'type'},
                            'ATTRIBUTE_INFO': {'AREA_RESOL_MEAN': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                               'DETAILS': {'NULLABLE': True,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 511},
                                               'DETECTOR': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                               'DIFFRN_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'DTIME': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                               'PDBX_COLLECTION_DATE': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'DATETIME',
                                                                        'WIDTH': 20},
                                               'PDBX_COLLECTION_TIME_TOTAL': {'NULLABLE': True,
                                                                              'ORDER': 9,
                                                                              'PRECISION': 6,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'FLOAT',
                                                                              'WIDTH': 10},
                                               'PDBX_FRAMES_TOTAL': {'NULLABLE': True,
                                                                     'ORDER': 8,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'TYPE': {'NULLABLE': True,
                                                        'ORDER': 5,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 511}},
                            'ATTRIBUTE_MAP': {'AREA_RESOL_MEAN': ('diffrn_detector', 'area_resol_mean', None, None),
                                              'DETAILS': ('diffrn_detector', 'details', None, None),
                                              'DETECTOR': ('diffrn_detector', 'detector', None, None),
                                              'DIFFRN_ID': ('diffrn_detector', 'diffrn_id', None, None),
                                              'DTIME': ('diffrn_detector', 'dtime', None, None),
                                              'PDBX_COLLECTION_DATE': ('diffrn_detector',
                                                                       'pdbx_collection_date',
                                                                       None,
                                                                       None),
                                              'PDBX_COLLECTION_TIME_TOTAL': ('diffrn_detector',
                                                                             'pdbx_collection_time_total',
                                                                             None,
                                                                             None),
                                              'PDBX_FRAMES_TOTAL': ('diffrn_detector', 'pdbx_frames_total', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'TYPE': ('diffrn_detector', 'type', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'diffrn_detector': {'ATTRIBUTES': ('diffrn_id',), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'DIFFRN_DETECTOR',
                            'TABLE_NAME': 'diffrn_detector',
                            'TABLE_TYPE': 'transactional'},
        'DIFFRN_MEASUREMENT': {'ATTRIBUTES': {'DETAILS': 'details',
                                              'DEVICE': 'device',
                                              'DEVICE_DETAILS': 'device_details',
                                              'DEVICE_TYPE': 'device_type',
                                              'DIFFRN_ID': 'diffrn_id',
                                              'METHOD': 'method',
                                              'SPECIMEN_SUPPORT': 'specimen_support',
                                              'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                                  'DEVICE': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                                  'DEVICE_DETAILS': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                                  'DEVICE_TYPE': {'NULLABLE': True,
                                                                  'ORDER': 6,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                  'DIFFRN_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                  'METHOD': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                                  'SPECIMEN_SUPPORT': {'NULLABLE': True,
                                                                       'ORDER': 8,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'DETAILS': ('diffrn_measurement', 'details', None, None),
                                                 'DEVICE': ('diffrn_measurement', 'device', None, None),
                                                 'DEVICE_DETAILS': ('diffrn_measurement', 'device_details', None, None),
                                                 'DEVICE_TYPE': ('diffrn_measurement', 'device_type', None, None),
                                                 'DIFFRN_ID': ('diffrn_measurement', 'diffrn_id', None, None),
                                                 'METHOD': ('diffrn_measurement', 'method', None, None),
                                                 'SPECIMEN_SUPPORT': ('diffrn_measurement', 'specimen_support', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'diffrn_measurement': {'ATTRIBUTES': ('diffrn_id',),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'DIFFRN_MEASUREMENT',
                               'TABLE_NAME': 'diffrn_measurement',
                               'TABLE_TYPE': 'transactional'},
        'DIFFRN_ORIENT_MATRIX': {'ATTRIBUTES': {'DIFFRN_ID': 'diffrn_id',
                                                'STRUCTURE_ID': 'Structure_ID',
                                                'TYPE': 'type',
                                                'UB_1_1': 'UB_1_1',
                                                'UB_1_2': 'UB_1_2',
                                                'UB_1_3': 'UB_1_3',
                                                'UB_2_1': 'UB_2_1',
                                                'UB_2_2': 'UB_2_2',
                                                'UB_2_3': 'UB_2_3',
                                                'UB_3_1': 'UB_3_1',
                                                'UB_3_2': 'UB_3_2',
                                                'UB_3_3': 'UB_3_3'},
                                 'ATTRIBUTE_INFO': {'DIFFRN_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                    'TYPE': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                                    'UB_1_1': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_1_2': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_1_3': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_2_1': {'NULLABLE': True,
                                                               'ORDER': 7,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_2_2': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_2_3': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_3_1': {'NULLABLE': True,
                                                               'ORDER': 10,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_3_2': {'NULLABLE': True,
                                                               'ORDER': 11,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                    'UB_3_3': {'NULLABLE': True,
                                                               'ORDER': 12,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'DIFFRN_ID': ('diffrn_orient_matrix', 'diffrn_id', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                   'TYPE': ('diffrn_orient_matrix', 'type', None, None),
                                                   'UB_1_1': ('diffrn_orient_matrix', 'UB[1][1]', None, None),
                                                   'UB_1_2': ('diffrn_orient_matrix', 'UB[1][2]', None, None),
                                                   'UB_1_3': ('diffrn_orient_matrix', 'UB[1][3]', None, None),
                                                   'UB_2_1': ('diffrn_orient_matrix', 'UB[2][1]', None, None),
                                                   'UB_2_2': ('diffrn_orient_matrix', 'UB[2][2]', None, None),
                                                   'UB_2_3': ('diffrn_orient_matrix', 'UB[2][3]', None, None),
                                                   'UB_3_1': ('diffrn_orient_matrix', 'UB[3][1]', None, None),
                                                   'UB_3_2': ('diffrn_orient_matrix', 'UB[3][2]', None, None),
                                                   'UB_3_3': ('diffrn_orient_matrix', 'UB[3][3]', None, None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'diffrn_orient_matrix': {'ATTRIBUTES': ('diffrn_id',),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'DIFFRN_ORIENT_MATRIX',
                                 'TABLE_NAME': 'diffrn_orient_matrix',
                                 'TABLE_TYPE': 'transactional'},
        'DIFFRN_ORIENT_REFLN': {'ATTRIBUTES': {'ANGLE_CHI': 'angle_chi',
                                               'ANGLE_KAPPA': 'angle_kappa',
                                               'ANGLE_OMEGA': 'angle_omega',
                                               'ANGLE_PHI': 'angle_phi',
                                               'ANGLE_PSI': 'angle_psi',
                                               'ANGLE_THETA': 'angle_theta',
                                               'DIFFRN_ID': 'diffrn_id',
                                               'INDEX_H': 'index_h',
                                               'INDEX_K': 'index_k',
                                               'INDEX_L': 'index_l',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'ANGLE_CHI': {'NULLABLE': True,
                                                                 'ORDER': 3,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ANGLE_KAPPA': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                   'ANGLE_OMEGA': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                   'ANGLE_PHI': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ANGLE_PSI': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'ANGLE_THETA': {'NULLABLE': True,
                                                                   'ORDER': 8,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                   'DIFFRN_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                   'INDEX_H': {'NULLABLE': False,
                                                               'ORDER': 9,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                                   'INDEX_K': {'NULLABLE': False,
                                                               'ORDER': 10,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                                   'INDEX_L': {'NULLABLE': False,
                                                               'ORDER': 11,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ANGLE_CHI': ('diffrn_orient_refln', 'angle_chi', None, None),
                                                  'ANGLE_KAPPA': ('diffrn_orient_refln', 'angle_kappa', None, None),
                                                  'ANGLE_OMEGA': ('diffrn_orient_refln', 'angle_omega', None, None),
                                                  'ANGLE_PHI': ('diffrn_orient_refln', 'angle_phi', None, None),
                                                  'ANGLE_PSI': ('diffrn_orient_refln', 'angle_psi', None, None),
                                                  'ANGLE_THETA': ('diffrn_orient_refln', 'angle_theta', None, None),
                                                  'DIFFRN_ID': ('diffrn_orient_refln', 'diffrn_id', None, None),
                                                  'INDEX_H': ('diffrn_orient_refln', 'index_h', None, None),
                                                  'INDEX_K': ('diffrn_orient_refln', 'index_k', None, None),
                                                  'INDEX_L': ('diffrn_orient_refln', 'index_l', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                  'DIFFRN_ID',
                                                                  'INDEX_H',
                                                                  'INDEX_K',
                                                                  'INDEX_L'),
                                                   'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'diffrn_orient_refln': {'ATTRIBUTES': ('diffrn_id',
                                                                                             'index_h',
                                                                                             'index_k',
                                                                                             'index_l'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'DIFFRN_ORIENT_REFLN',
                                'TABLE_NAME': 'diffrn_orient_refln',
                                'TABLE_TYPE': 'transactional'},
        'DIFFRN_RADIATION': {'ATTRIBUTES': {'COLLIMATION': 'collimation',
                                            'DIFFRN_ID': 'diffrn_id',
                                            'FILTER_EDGE': 'filter_edge',
                                            'INHOMOGENEITY': 'inhomogeneity',
                                            'MONOCHROMATOR': 'monochromator',
                                            'PDBX_ANALYZER': 'pdbx_analyzer',
                                            'PDBX_DIFFRN_PROTOCOL': 'pdbx_diffrn_protocol',
                                            'PDBX_MONOCHROMATIC_OR_LAUE_M_L': 'pdbx_monochromatic_or_laue_m_l',
                                            'PDBX_SCATTERING_TYPE': 'pdbx_scattering_type',
                                            'PDBX_WAVELENGTH': 'pdbx_wavelength',
                                            'PDBX_WAVELENGTH_LIST': 'pdbx_wavelength_list',
                                            'POLARISN_NORM': 'polarisn_norm',
                                            'POLARISN_RATIO': 'polarisn_ratio',
                                            'PROBE': 'probe',
                                            'STRUCTURE_ID': 'Structure_ID',
                                            'TYPE': 'type',
                                            'WAVELENGTH_ID': 'wavelength_id',
                                            'XRAY_SYMBOL': 'xray_symbol'},
                             'ATTRIBUTE_INFO': {'COLLIMATION': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                'DIFFRN_ID': {'NULLABLE': False,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                'FILTER_EDGE': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                'INHOMOGENEITY': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                'MONOCHROMATOR': {'NULLABLE': True,
                                                                  'ORDER': 6,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 511},
                                                'PDBX_ANALYZER': {'NULLABLE': True,
                                                                  'ORDER': 17,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                'PDBX_DIFFRN_PROTOCOL': {'NULLABLE': True,
                                                                         'ORDER': 16,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 128},
                                                'PDBX_MONOCHROMATIC_OR_LAUE_M_L': {'NULLABLE': True,
                                                                                   'ORDER': 13,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 10},
                                                'PDBX_SCATTERING_TYPE': {'NULLABLE': True,
                                                                         'ORDER': 18,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 80},
                                                'PDBX_WAVELENGTH': {'NULLABLE': True,
                                                                    'ORDER': 15,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                                'PDBX_WAVELENGTH_LIST': {'NULLABLE': True,
                                                                         'ORDER': 14,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 80},
                                                'POLARISN_NORM': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                'POLARISN_RATIO': {'NULLABLE': True,
                                                                   'ORDER': 8,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                'PROBE': {'NULLABLE': True,
                                                          'ORDER': 9,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 80},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                'TYPE': {'NULLABLE': True,
                                                         'ORDER': 10,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 80},
                                                'WAVELENGTH_ID': {'NULLABLE': True,
                                                                  'ORDER': 12,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                'XRAY_SYMBOL': {'NULLABLE': True,
                                                                'ORDER': 11,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80}},
                             'ATTRIBUTE_MAP': {'COLLIMATION': ('diffrn_radiation', 'collimation', None, None),
                                               'DIFFRN_ID': ('diffrn_radiation', 'diffrn_id', None, None),
                                               'FILTER_EDGE': ('diffrn_radiation', 'filter_edge', None, None),
                                               'INHOMOGENEITY': ('diffrn_radiation', 'inhomogeneity', None, None),
                                               'MONOCHROMATOR': ('diffrn_radiation', 'monochromator', None, None),
                                               'PDBX_ANALYZER': ('diffrn_radiation', 'pdbx_analyzer', None, None),
                                               'PDBX_DIFFRN_PROTOCOL': ('diffrn_radiation',
                                                                        'pdbx_diffrn_protocol',
                                                                        None,
                                                                        None),
                                               'PDBX_MONOCHROMATIC_OR_LAUE_M_L': ('diffrn_radiation',
                                                                                  'pdbx_monochromatic_or_laue_m_l',
                                                                                  None,
                                                                                  None),
                                               'PDBX_SCATTERING_TYPE': ('diffrn_radiation',
                                                                        'pdbx_scattering_type',
                                                                        None,
                                                                        None),
                                               'PDBX_WAVELENGTH': ('diffrn_radiation', 'pdbx_wavelength', None, None),
                                               'PDBX_WAVELENGTH_LIST': ('diffrn_radiation',
                                                                        'pdbx_wavelength_list',
                                                                        None,
                                                                        None),
                                               'POLARISN_NORM': ('diffrn_radiation', 'polarisn_norm', None, None),
                                               'POLARISN_RATIO': ('diffrn_radiation', 'polarisn_ratio', None, None),
                                               'PROBE': ('diffrn_radiation', 'probe', None, None),
                                               'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                               'TYPE': ('diffrn_radiation', 'type', None, None),
                                               'WAVELENGTH_ID': ('diffrn_radiation', 'wavelength_id', None, None),
                                               'XRAY_SYMBOL': ('diffrn_radiation', 'xray_symbol', None, None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'diffrn_radiation': {'ATTRIBUTES': ('diffrn_id',), 'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'DIFFRN_RADIATION',
                             'TABLE_NAME': 'diffrn_radiation',
                             'TABLE_TYPE': 'transactional'},
        'DIFFRN_RADIATION_WAVELENGTH': {'ATTRIBUTES': {'ID': 'id',
                                                       'STRUCTURE_ID': 'Structure_ID',
                                                       'WAVELENGTH': 'wavelength',
                                                       'WT': 'wt'},
                                        'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                           'WAVELENGTH': {'NULLABLE': True,
                                                                          'ORDER': 3,
                                                                          'PRECISION': 6,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                                           'WT': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10}},
                                        'ATTRIBUTE_MAP': {'ID': ('diffrn_radiation_wavelength', 'id', None, None),
                                                          'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                          'WAVELENGTH': ('diffrn_radiation_wavelength',
                                                                         'wavelength',
                                                                         None,
                                                                         None),
                                                          'WT': ('diffrn_radiation_wavelength', 'wt', None, None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                        'MAP_MERGE_INDICES': {'diffrn_radiation_wavelength': {'ATTRIBUTES': ('id',),
                                                                                              'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                        'TABLE_ID': 'DIFFRN_RADIATION_WAVELENGTH',
                                        'TABLE_NAME': 'diffrn_radiation_wavelength',
                                        'TABLE_TYPE': 'transactional'},
        'DIFFRN_REFLN': {'ATTRIBUTES': {'ANGLE_CHI': 'angle_chi',
                                        'ANGLE_KAPPA': 'angle_kappa',
                                        'ANGLE_OMEGA': 'angle_omega',
                                        'ANGLE_PHI': 'angle_phi',
                                        'ANGLE_PSI': 'angle_psi',
                                        'ANGLE_THETA': 'angle_theta',
                                        'ATTENUATOR_CODE': 'attenuator_code',
                                        'CLASS_CODE': 'class_code',
                                        'COUNTS_BG_1': 'counts_bg_1',
                                        'COUNTS_BG_2': 'counts_bg_2',
                                        'COUNTS_NET': 'counts_net',
                                        'COUNTS_PEAK': 'counts_peak',
                                        'COUNTS_TOTAL': 'counts_total',
                                        'DETECT_SLIT_HORIZ': 'detect_slit_horiz',
                                        'DETECT_SLIT_VERT': 'detect_slit_vert',
                                        'DIFFRN_ID': 'diffrn_id',
                                        'ELAPSED_TIME': 'elapsed_time',
                                        'ID': 'id',
                                        'INDEX_H': 'index_h',
                                        'INDEX_K': 'index_k',
                                        'INDEX_L': 'index_l',
                                        'INTENSITY_NET': 'intensity_net',
                                        'INTENSITY_SIGMA': 'intensity_sigma',
                                        'INTENSITY_U': 'intensity_u',
                                        'SCALE_GROUP_CODE': 'scale_group_code',
                                        'SCAN_MODE': 'scan_mode',
                                        'SCAN_MODE_BACKGD': 'scan_mode_backgd',
                                        'SCAN_RATE': 'scan_rate',
                                        'SCAN_TIME_BACKGD': 'scan_time_backgd',
                                        'SCAN_WIDTH': 'scan_width',
                                        'SINT_OVER_LAMBDA': 'sint_over_lambda',
                                        'STANDARD_CODE': 'standard_code',
                                        'STRUCTURE_ID': 'Structure_ID',
                                        'WAVELENGTH': 'wavelength',
                                        'WAVELENGTH_ID': 'wavelength_id'},
                         'ATTRIBUTE_INFO': {'ANGLE_CHI': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'ANGLE_KAPPA': {'NULLABLE': True,
                                                            'ORDER': 5,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                            'ANGLE_OMEGA': {'NULLABLE': True,
                                                            'ORDER': 6,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                            'ANGLE_PHI': {'NULLABLE': True,
                                                          'ORDER': 7,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'ANGLE_PSI': {'NULLABLE': True,
                                                          'ORDER': 8,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'ANGLE_THETA': {'NULLABLE': True,
                                                            'ORDER': 9,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                            'ATTENUATOR_CODE': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                            'CLASS_CODE': {'NULLABLE': True,
                                                           'ORDER': 34,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                            'COUNTS_BG_1': {'NULLABLE': True,
                                                            'ORDER': 11,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'INT',
                                                            'WIDTH': 10},
                                            'COUNTS_BG_2': {'NULLABLE': True,
                                                            'ORDER': 12,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'INT',
                                                            'WIDTH': 10},
                                            'COUNTS_NET': {'NULLABLE': True,
                                                           'ORDER': 13,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'INT',
                                                           'WIDTH': 10},
                                            'COUNTS_PEAK': {'NULLABLE': True,
                                                            'ORDER': 14,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'INT',
                                                            'WIDTH': 10},
                                            'COUNTS_TOTAL': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                            'DETECT_SLIT_HORIZ': {'NULLABLE': True,
                                                                  'ORDER': 16,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                            'DETECT_SLIT_VERT': {'NULLABLE': True,
                                                                 'ORDER': 17,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'DIFFRN_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                            'ELAPSED_TIME': {'NULLABLE': True,
                                                             'ORDER': 18,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                            'ID': {'NULLABLE': False,
                                                   'ORDER': 19,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': True,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': 10},
                                            'INDEX_H': {'NULLABLE': True,
                                                        'ORDER': 20,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'INT',
                                                        'WIDTH': 10},
                                            'INDEX_K': {'NULLABLE': True,
                                                        'ORDER': 21,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'INT',
                                                        'WIDTH': 10},
                                            'INDEX_L': {'NULLABLE': True,
                                                        'ORDER': 22,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'INT',
                                                        'WIDTH': 10},
                                            'INTENSITY_NET': {'NULLABLE': True,
                                                              'ORDER': 23,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                            'INTENSITY_SIGMA': {'NULLABLE': True,
                                                                'ORDER': 24,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                            'INTENSITY_U': {'NULLABLE': True,
                                                            'ORDER': 35,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                            'SCALE_GROUP_CODE': {'NULLABLE': True,
                                                                 'ORDER': 25,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                            'SCAN_MODE': {'NULLABLE': True,
                                                          'ORDER': 26,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                            'SCAN_MODE_BACKGD': {'NULLABLE': True,
                                                                 'ORDER': 27,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                            'SCAN_RATE': {'NULLABLE': True,
                                                          'ORDER': 28,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                            'SCAN_TIME_BACKGD': {'NULLABLE': True,
                                                                 'ORDER': 29,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'SCAN_WIDTH': {'NULLABLE': True,
                                                           'ORDER': 30,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                            'SINT_OVER_LAMBDA': {'NULLABLE': True,
                                                                 'ORDER': 31,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                            'STANDARD_CODE': {'NULLABLE': True,
                                                              'ORDER': 32,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                            'STRUCTURE_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                            'WAVELENGTH': {'NULLABLE': True,
                                                           'ORDER': 33,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                            'WAVELENGTH_ID': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                         'ATTRIBUTE_MAP': {'ANGLE_CHI': ('diffrn_refln', 'angle_chi', None, None),
                                           'ANGLE_KAPPA': ('diffrn_refln', 'angle_kappa', None, None),
                                           'ANGLE_OMEGA': ('diffrn_refln', 'angle_omega', None, None),
                                           'ANGLE_PHI': ('diffrn_refln', 'angle_phi', None, None),
                                           'ANGLE_PSI': ('diffrn_refln', 'angle_psi', None, None),
                                           'ANGLE_THETA': ('diffrn_refln', 'angle_theta', None, None),
                                           'ATTENUATOR_CODE': ('diffrn_refln', 'attenuator_code', None, None),
                                           'CLASS_CODE': ('diffrn_refln', 'class_code', None, None),
                                           'COUNTS_BG_1': ('diffrn_refln', 'counts_bg_1', None, None),
                                           'COUNTS_BG_2': ('diffrn_refln', 'counts_bg_2', None, None),
                                           'COUNTS_NET': ('diffrn_refln', 'counts_net', None, None),
                                           'COUNTS_PEAK': ('diffrn_refln', 'counts_peak', None, None),
                                           'COUNTS_TOTAL': ('diffrn_refln', 'counts_total', None, None),
                                           'DETECT_SLIT_HORIZ': ('diffrn_refln', 'detect_slit_horiz', None, None),
                                           'DETECT_SLIT_VERT': ('diffrn_refln', 'detect_slit_vert', None, None),
                                           'DIFFRN_ID': ('diffrn_refln', 'diffrn_id', None, None),
                                           'ELAPSED_TIME': ('diffrn_refln', 'elapsed_time', None, None),
                                           'ID': ('diffrn_refln', 'id', None, None),
                                           'INDEX_H': ('diffrn_refln', 'index_h', None, None),
                                           'INDEX_K': ('diffrn_refln', 'index_k', None, None),
                                           'INDEX_L': ('diffrn_refln', 'index_l', None, None),
                                           'INTENSITY_NET': ('diffrn_refln', 'intensity_net', None, None),
                                           'INTENSITY_SIGMA': ('diffrn_refln', 'intensity_sigma', None, None),
                                           'INTENSITY_U': ('diffrn_refln', 'intensity_u', None, None),
                                           'SCALE_GROUP_CODE': ('diffrn_refln', 'scale_group_code', None, None),
                                           'SCAN_MODE': ('diffrn_refln', 'scan_mode', None, None),
                                           'SCAN_MODE_BACKGD': ('diffrn_refln', 'scan_mode_backgd', None, None),
                                           'SCAN_RATE': ('diffrn_refln', 'scan_rate', None, None),
                                           'SCAN_TIME_BACKGD': ('diffrn_refln', 'scan_time_backgd', None, None),
                                           'SCAN_WIDTH': ('diffrn_refln', 'scan_width', None, None),
                                           'SINT_OVER_LAMBDA': ('diffrn_refln', 'sint_over_lambda', None, None),
                                           'STANDARD_CODE': ('diffrn_refln', 'standard_code', None, None),
                                           'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                           'WAVELENGTH': ('diffrn_refln', 'wavelength', None, None),
                                           'WAVELENGTH_ID': ('diffrn_refln', 'wavelength_id', None, None)},
                         'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                     's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                         'MAP_MERGE_INDICES': {'diffrn_refln': {'ATTRIBUTES': ('diffrn_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                         'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                         'TABLE_ID': 'DIFFRN_REFLN',
                         'TABLE_NAME': 'diffrn_refln',
                         'TABLE_TYPE': 'transactional'},
        'DIFFRN_REFLNS': {'ATTRIBUTES': {'AV_R_EQUIVALENTS': 'av_R_equivalents',
                                         'AV_SIGMAI_OVER_NETI': 'av_sigmaI_over_netI',
                                         'AV_UNETI_NETI': 'av_unetI_netI',
                                         'DIFFRN_ID': 'diffrn_id',
                                         'LIMIT_H_MAX': 'limit_h_max',
                                         'LIMIT_H_MIN': 'limit_h_min',
                                         'LIMIT_K_MAX': 'limit_k_max',
                                         'LIMIT_K_MIN': 'limit_k_min',
                                         'LIMIT_L_MAX': 'limit_l_max',
                                         'LIMIT_L_MIN': 'limit_l_min',
                                         'NUMBER': 'number',
                                         'PDBX_CHI_SQUARED': 'pdbx_chi_squared',
                                         'PDBX_D_RES_HIGH': 'pdbx_d_res_high',
                                         'PDBX_D_RES_LOW': 'pdbx_d_res_low',
                                         'PDBX_NUMBER_OBS': 'pdbx_number_obs',
                                         'PDBX_OBSERVED_CRITERION': 'pdbx_observed_criterion',
                                         'PDBX_PERCENT_POSSIBLE_OBS': 'pdbx_percent_possible_obs',
                                         'PDBX_REDUNDANCY': 'pdbx_redundancy',
                                         'PDBX_REJECTS': 'pdbx_rejects',
                                         'PDBX_RMERGE_I_OBS': 'pdbx_Rmerge_I_obs',
                                         'PDBX_RSYM_VALUE': 'pdbx_Rsym_value',
                                         'REDUCTION_PROCESS': 'reduction_process',
                                         'STRUCTURE_ID': 'Structure_ID',
                                         'THETA_MAX': 'theta_max',
                                         'THETA_MIN': 'theta_min',
                                         'TRANSF_MATRIX_1_1': 'transf_matrix_1_1',
                                         'TRANSF_MATRIX_1_2': 'transf_matrix_1_2',
                                         'TRANSF_MATRIX_1_3': 'transf_matrix_1_3',
                                         'TRANSF_MATRIX_2_1': 'transf_matrix_2_1',
                                         'TRANSF_MATRIX_2_2': 'transf_matrix_2_2',
                                         'TRANSF_MATRIX_2_3': 'transf_matrix_2_3',
                                         'TRANSF_MATRIX_3_1': 'transf_matrix_3_1',
                                         'TRANSF_MATRIX_3_2': 'transf_matrix_3_2',
                                         'TRANSF_MATRIX_3_3': 'transf_matrix_3_3'},
                          'ATTRIBUTE_INFO': {'AV_R_EQUIVALENTS': {'NULLABLE': True,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                             'AV_SIGMAI_OVER_NETI': {'NULLABLE': True,
                                                                     'ORDER': 4,
                                                                     'PRECISION': 6,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                             'AV_UNETI_NETI': {'NULLABLE': True,
                                                               'ORDER': 24,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                             'DIFFRN_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'LIMIT_H_MAX': {'NULLABLE': True,
                                                             'ORDER': 5,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'LIMIT_H_MIN': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'LIMIT_K_MAX': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'LIMIT_K_MIN': {'NULLABLE': True,
                                                             'ORDER': 8,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'LIMIT_L_MAX': {'NULLABLE': True,
                                                             'ORDER': 9,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'LIMIT_L_MIN': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'NUMBER': {'NULLABLE': True,
                                                        'ORDER': 11,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'INT',
                                                        'WIDTH': 10},
                                             'PDBX_CHI_SQUARED': {'NULLABLE': True,
                                                                  'ORDER': 30,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                             'PDBX_D_RES_HIGH': {'NULLABLE': True,
                                                                 'ORDER': 26,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'PDBX_D_RES_LOW': {'NULLABLE': True,
                                                                'ORDER': 25,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'PDBX_NUMBER_OBS': {'NULLABLE': True,
                                                                 'ORDER': 34,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': 10},
                                             'PDBX_OBSERVED_CRITERION': {'NULLABLE': True,
                                                                         'ORDER': 33,
                                                                         'PRECISION': 6,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'FLOAT',
                                                                         'WIDTH': 10},
                                             'PDBX_PERCENT_POSSIBLE_OBS': {'NULLABLE': True,
                                                                           'ORDER': 27,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                             'PDBX_REDUNDANCY': {'NULLABLE': True,
                                                                 'ORDER': 31,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'PDBX_REJECTS': {'NULLABLE': True,
                                                              'ORDER': 32,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                             'PDBX_RMERGE_I_OBS': {'NULLABLE': True,
                                                                   'ORDER': 28,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'PDBX_RSYM_VALUE': {'NULLABLE': True,
                                                                 'ORDER': 29,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'REDUCTION_PROCESS': {'NULLABLE': True,
                                                                   'ORDER': 12,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                             'THETA_MAX': {'NULLABLE': True,
                                                           'ORDER': 13,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                             'THETA_MIN': {'NULLABLE': True,
                                                           'ORDER': 14,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                             'TRANSF_MATRIX_1_1': {'NULLABLE': True,
                                                                   'ORDER': 15,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_1_2': {'NULLABLE': True,
                                                                   'ORDER': 16,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_1_3': {'NULLABLE': True,
                                                                   'ORDER': 17,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_2_1': {'NULLABLE': True,
                                                                   'ORDER': 18,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_2_2': {'NULLABLE': True,
                                                                   'ORDER': 19,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_2_3': {'NULLABLE': True,
                                                                   'ORDER': 20,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_3_1': {'NULLABLE': True,
                                                                   'ORDER': 21,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_3_2': {'NULLABLE': True,
                                                                   'ORDER': 22,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'TRANSF_MATRIX_3_3': {'NULLABLE': True,
                                                                   'ORDER': 23,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'AV_R_EQUIVALENTS': ('diffrn_reflns', 'av_R_equivalents', None, None),
                                            'AV_SIGMAI_OVER_NETI': ('diffrn_reflns', 'av_sigmaI_over_netI', None, None),
                                            'AV_UNETI_NETI': ('diffrn_reflns', 'av_unetI/netI', None, None),
                                            'DIFFRN_ID': ('diffrn_reflns', 'diffrn_id', None, None),
                                            'LIMIT_H_MAX': ('diffrn_reflns', 'limit_h_max', None, None),
                                            'LIMIT_H_MIN': ('diffrn_reflns', 'limit_h_min', None, None),
                                            'LIMIT_K_MAX': ('diffrn_reflns', 'limit_k_max', None, None),
                                            'LIMIT_K_MIN': ('diffrn_reflns', 'limit_k_min', None, None),
                                            'LIMIT_L_MAX': ('diffrn_reflns', 'limit_l_max', None, None),
                                            'LIMIT_L_MIN': ('diffrn_reflns', 'limit_l_min', None, None),
                                            'NUMBER': ('diffrn_reflns', 'number', None, None),
                                            'PDBX_CHI_SQUARED': ('diffrn_reflns', 'pdbx_chi_squared', None, None),
                                            'PDBX_D_RES_HIGH': ('diffrn_reflns', 'pdbx_d_res_high', None, None),
                                            'PDBX_D_RES_LOW': ('diffrn_reflns', 'pdbx_d_res_low', None, None),
                                            'PDBX_NUMBER_OBS': ('diffrn_reflns', 'pdbx_number_obs', None, None),
                                            'PDBX_OBSERVED_CRITERION': ('diffrn_reflns',
                                                                        'pdbx_observed_criterion',
                                                                        None,
                                                                        None),
                                            'PDBX_PERCENT_POSSIBLE_OBS': ('diffrn_reflns',
                                                                          'pdbx_percent_possible_obs',
                                                                          None,
                                                                          None),
                                            'PDBX_REDUNDANCY': ('diffrn_reflns', 'pdbx_redundancy', None, None),
                                            'PDBX_REJECTS': ('diffrn_reflns', 'pdbx_rejects', None, None),
                                            'PDBX_RMERGE_I_OBS': ('diffrn_reflns', 'pdbx_Rmerge_I_obs', None, None),
                                            'PDBX_RSYM_VALUE': ('diffrn_reflns', 'pdbx_Rsym_value', None, None),
                                            'REDUCTION_PROCESS': ('diffrn_reflns', 'reduction_process', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                            'THETA_MAX': ('diffrn_reflns', 'theta_max', None, None),
                                            'THETA_MIN': ('diffrn_reflns', 'theta_min', None, None),
                                            'TRANSF_MATRIX_1_1': ('diffrn_reflns', 'transf_matrix[1][1]', None, None),
                                            'TRANSF_MATRIX_1_2': ('diffrn_reflns', 'transf_matrix[1][2]', None, None),
                                            'TRANSF_MATRIX_1_3': ('diffrn_reflns', 'transf_matrix[1][3]', None, None),
                                            'TRANSF_MATRIX_2_1': ('diffrn_reflns', 'transf_matrix[2][1]', None, None),
                                            'TRANSF_MATRIX_2_2': ('diffrn_reflns', 'transf_matrix[2][2]', None, None),
                                            'TRANSF_MATRIX_2_3': ('diffrn_reflns', 'transf_matrix[2][3]', None, None),
                                            'TRANSF_MATRIX_3_1': ('diffrn_reflns', 'transf_matrix[3][1]', None, None),
                                            'TRANSF_MATRIX_3_2': ('diffrn_reflns', 'transf_matrix[3][2]', None, None),
                                            'TRANSF_MATRIX_3_3': ('diffrn_reflns', 'transf_matrix[3][3]', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'diffrn_reflns': {'ATTRIBUTES': ('diffrn_id',), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'DIFFRN_REFLNS',
                          'TABLE_NAME': 'diffrn_reflns',
                          'TABLE_TYPE': 'transactional'},
        'DIFFRN_REFLNS_CLASS': {'ATTRIBUTES': {'AV_R_EQ': 'av_R_eq',
                                               'AV_SGI_I': 'av_sgI_I',
                                               'AV_UI_I': 'av_uI_I',
                                               'CODE': 'code',
                                               'DESCRIPTION': 'description',
                                               'D_RES_HIGH': 'd_res_high',
                                               'D_RES_LOW': 'd_res_low',
                                               'NUMBER': 'number',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'AV_R_EQ': {'NULLABLE': True,
                                                               'ORDER': 2,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                   'AV_SGI_I': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                   'AV_UI_I': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                   'CODE': {'NULLABLE': False,
                                                            'ORDER': 5,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                                   'DESCRIPTION': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                   'D_RES_HIGH': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                   'D_RES_LOW': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'NUMBER': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'AV_R_EQ': ('diffrn_reflns_class', 'av_R_eq', None, None),
                                                  'AV_SGI_I': ('diffrn_reflns_class', 'av_sgI/I', None, None),
                                                  'AV_UI_I': ('diffrn_reflns_class', 'av_uI/I', None, None),
                                                  'CODE': ('diffrn_reflns_class', 'code', None, None),
                                                  'DESCRIPTION': ('diffrn_reflns_class', 'description', None, None),
                                                  'D_RES_HIGH': ('diffrn_reflns_class', 'd_res_high', None, None),
                                                  'D_RES_LOW': ('diffrn_reflns_class', 'd_res_low', None, None),
                                                  'NUMBER': ('diffrn_reflns_class', 'number', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CODE'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'diffrn_reflns_class': {'ATTRIBUTES': ('code',), 'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'DIFFRN_REFLNS_CLASS',
                                'TABLE_NAME': 'diffrn_reflns_class',
                                'TABLE_TYPE': 'transactional'},
        'DIFFRN_SCALE_GROUP': {'ATTRIBUTES': {'CODE': 'code', 'I_NET': 'I_net', 'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'CODE': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                                  'I_NET': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'CODE': ('diffrn_scale_group', 'code', None, None),
                                                 'I_NET': ('diffrn_scale_group', 'I_net', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CODE'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'diffrn_scale_group': {'ATTRIBUTES': ('code',), 'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'DIFFRN_SCALE_GROUP',
                               'TABLE_NAME': 'diffrn_scale_group',
                               'TABLE_TYPE': 'transactional'},
        'DIFFRN_SOURCE': {'ATTRIBUTES': {'CURRENT': 'current',
                                         'DETAILS': 'details',
                                         'DIFFRN_ID': 'diffrn_id',
                                         'PDBX_SYNCHROTRON_BEAMLINE': 'pdbx_synchrotron_beamline',
                                         'PDBX_SYNCHROTRON_SITE': 'pdbx_synchrotron_site',
                                         'PDBX_WAVELENGTH': 'pdbx_wavelength',
                                         'PDBX_WAVELENGTH_LIST': 'pdbx_wavelength_list',
                                         'POWER': 'power',
                                         'SIZE': 'size',
                                         'SOURCE': 'source',
                                         'STRUCTURE_ID': 'Structure_ID',
                                         'TAKE_OFF_ANGLE': 'take_off_angle',
                                         'TARGET': 'target',
                                         'TYPE': 'type',
                                         'VOLTAGE': 'voltage'},
                          'ATTRIBUTE_INFO': {'CURRENT': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                             'DETAILS': {'NULLABLE': True,
                                                         'ORDER': 4,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                             'DIFFRN_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'PDBX_SYNCHROTRON_BEAMLINE': {'NULLABLE': True,
                                                                           'ORDER': 14,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80},
                                             'PDBX_SYNCHROTRON_SITE': {'NULLABLE': True,
                                                                       'ORDER': 15,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                             'PDBX_WAVELENGTH': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                             'PDBX_WAVELENGTH_LIST': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                             'POWER': {'NULLABLE': True,
                                                       'ORDER': 5,
                                                       'PRECISION': 6,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                             'SIZE': {'NULLABLE': True,
                                                      'ORDER': 6,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 200},
                                             'SOURCE': {'NULLABLE': True,
                                                        'ORDER': 7,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                             'TAKE_OFF_ANGLE': {'NULLABLE': True,
                                                                'ORDER': 11,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'TARGET': {'NULLABLE': True,
                                                        'ORDER': 8,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                             'TYPE': {'NULLABLE': True,
                                                      'ORDER': 9,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 200},
                                             'VOLTAGE': {'NULLABLE': True,
                                                         'ORDER': 10,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'CURRENT': ('diffrn_source', 'current', None, None),
                                            'DETAILS': ('diffrn_source', 'details', None, None),
                                            'DIFFRN_ID': ('diffrn_source', 'diffrn_id', None, None),
                                            'PDBX_SYNCHROTRON_BEAMLINE': ('diffrn_source',
                                                                          'pdbx_synchrotron_beamline',
                                                                          None,
                                                                          None),
                                            'PDBX_SYNCHROTRON_SITE': ('diffrn_source', 'pdbx_synchrotron_site', None, None),
                                            'PDBX_WAVELENGTH': ('diffrn_source', 'pdbx_wavelength', None, None),
                                            'PDBX_WAVELENGTH_LIST': ('diffrn_source', 'pdbx_wavelength_list', None, None),
                                            'POWER': ('diffrn_source', 'power', None, None),
                                            'SIZE': ('diffrn_source', 'size', None, None),
                                            'SOURCE': ('diffrn_source', 'source', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                            'TAKE_OFF_ANGLE': ('diffrn_source', 'take-off_angle', None, None),
                                            'TARGET': ('diffrn_source', 'target', None, None),
                                            'TYPE': ('diffrn_source', 'type', None, None),
                                            'VOLTAGE': ('diffrn_source', 'voltage', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'diffrn_source': {'ATTRIBUTES': ('diffrn_id',), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'DIFFRN_SOURCE',
                          'TABLE_NAME': 'diffrn_source',
                          'TABLE_TYPE': 'transactional'},
        'DIFFRN_STANDARDS': {'ATTRIBUTES': {'DECAY__': 'decay__',
                                            'DIFFRN_ID': 'diffrn_id',
                                            'INTERVAL_COUNT': 'interval_count',
                                            'INTERVAL_TIME': 'interval_time',
                                            'NUMBER': 'number',
                                            'SCALE_SIGMA': 'scale_sigma',
                                            'SCALE_U': 'scale_u',
                                            'STRUCTURE_ID': 'Structure_ID'},
                             'ATTRIBUTE_INFO': {'DECAY__': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                'DIFFRN_ID': {'NULLABLE': False,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                'INTERVAL_COUNT': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                                'INTERVAL_TIME': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                'NUMBER': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'INT',
                                                           'WIDTH': 10},
                                                'SCALE_SIGMA': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                'SCALE_U': {'NULLABLE': True,
                                                            'ORDER': 8,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10}},
                             'ATTRIBUTE_MAP': {'DECAY__': ('diffrn_standards', 'decay_%', None, None),
                                               'DIFFRN_ID': ('diffrn_standards', 'diffrn_id', None, None),
                                               'INTERVAL_COUNT': ('diffrn_standards', 'interval_count', None, None),
                                               'INTERVAL_TIME': ('diffrn_standards', 'interval_time', None, None),
                                               'NUMBER': ('diffrn_standards', 'number', None, None),
                                               'SCALE_SIGMA': ('diffrn_standards', 'scale_sigma', None, None),
                                               'SCALE_U': ('diffrn_standards', 'scale_u', None, None),
                                               'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'diffrn_standards': {'ATTRIBUTES': ('diffrn_id',), 'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'DIFFRN_STANDARDS',
                             'TABLE_NAME': 'diffrn_standards',
                             'TABLE_TYPE': 'transactional'},
        'DIFFRN_STANDARD_REFLN': {'ATTRIBUTES': {'CODE': 'code',
                                                 'DIFFRN_ID': 'diffrn_id',
                                                 'INDEX_H': 'index_h',
                                                 'INDEX_K': 'index_k',
                                                 'INDEX_L': 'index_l',
                                                 'STRUCTURE_ID': 'Structure_ID'},
                                  'ATTRIBUTE_INFO': {'CODE': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                     'DIFFRN_ID': {'NULLABLE': False,
                                                                   'ORDER': 2,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                     'INDEX_H': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': 10},
                                                     'INDEX_K': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': 10},
                                                     'INDEX_L': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': 10},
                                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10}},
                                  'ATTRIBUTE_MAP': {'CODE': ('diffrn_standard_refln', 'code', None, None),
                                                    'DIFFRN_ID': ('diffrn_standard_refln', 'diffrn_id', None, None),
                                                    'INDEX_H': ('diffrn_standard_refln', 'index_h', None, None),
                                                    'INDEX_K': ('diffrn_standard_refln', 'index_k', None, None),
                                                    'INDEX_L': ('diffrn_standard_refln', 'index_l', None, None),
                                                    'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID', 'CODE'), 'TYPE': 'UNIQUE'},
                                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                  'MAP_MERGE_INDICES': {'diffrn_standard_refln': {'ATTRIBUTES': ('diffrn_id', 'code'),
                                                                                  'TYPE': 'EQUI-JOIN'}},
                                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                  'TABLE_ID': 'DIFFRN_STANDARD_REFLN',
                                  'TABLE_NAME': 'diffrn_standard_refln',
                                  'TABLE_TYPE': 'transactional'},
        'EM_2D_CRYSTAL_ENTITY': {'ATTRIBUTES': {'ANGLE_ALPHA': 'angle_alpha',
                                                'ANGLE_BETA': 'angle_beta',
                                                'ANGLE_GAMMA': 'angle_gamma',
                                                'DETAILS': 'details',
                                                'ENTITY_ASSEMBLY_ID': 'entity_assembly_id',
                                                'ID': 'id',
                                                'LENGTH_A': 'length_a',
                                                'LENGTH_B': 'length_b',
                                                'LENGTH_C': 'length_c',
                                                'SPACE_GROUP_NAME_H_M': 'space_group_name_H_M',
                                                'STRUCTURE_ID': 'Structure_ID'},
                                 'ATTRIBUTE_INFO': {'ANGLE_ALPHA': {'NULLABLE': True,
                                                                    'ORDER': 8,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                                    'ANGLE_BETA': {'NULLABLE': True,
                                                                   'ORDER': 9,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                    'ANGLE_GAMMA': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                                    'DETAILS': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                    'ENTITY_ASSEMBLY_ID': {'NULLABLE': False,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10},
                                                    'ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                                    'LENGTH_A': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                    'LENGTH_B': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                    'LENGTH_C': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                    'SPACE_GROUP_NAME_H_M': {'NULLABLE': True,
                                                                             'ORDER': 11,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 80},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ANGLE_ALPHA': ('em_2d_crystal_entity', 'angle_alpha', None, None),
                                                   'ANGLE_BETA': ('em_2d_crystal_entity', 'angle_beta', None, None),
                                                   'ANGLE_GAMMA': ('em_2d_crystal_entity', 'angle_gamma', None, None),
                                                   'DETAILS': ('em_2d_crystal_entity', 'details', None, None),
                                                   'ENTITY_ASSEMBLY_ID': ('em_2d_crystal_entity',
                                                                          'entity_assembly_id',
                                                                          None,
                                                                          None),
                                                   'ID': ('em_2d_crystal_entity', 'id', None, None),
                                                   'LENGTH_A': ('em_2d_crystal_entity', 'length_a', None, None),
                                                   'LENGTH_B': ('em_2d_crystal_entity', 'length_b', None, None),
                                                   'LENGTH_C': ('em_2d_crystal_entity', 'length_c', None, None),
                                                   'SPACE_GROUP_NAME_H_M': ('em_2d_crystal_entity',
                                                                            'space_group_name_H-M',
                                                                            None,
                                                                            None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ENTITY_ASSEMBLY_ID'),
                                                    'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'em_2d_crystal_entity': {'ATTRIBUTES': ('id', 'entity_assembly_id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'EM_2D_CRYSTAL_ENTITY',
                                 'TABLE_NAME': 'em_2d_crystal_entity',
                                 'TABLE_TYPE': 'transactional'},
        'EM_2D_CRYSTAL_GROW': {'ATTRIBUTES': {'APPARATUS': 'apparatus',
                                              'ATMOSPHERE': 'atmosphere',
                                              'BUFFER_ID': 'buffer_id',
                                              'CITATION_ID': 'citation_id',
                                              'DETAILS': 'details',
                                              'ID': 'id',
                                              'MEAN_2D_CRYSTAL_SIZE': 'mean_2d_crystal_size',
                                              'METHOD': 'method',
                                              'NUMBER_2D_CRYSTALS': 'number_2d_crystals',
                                              'PH': 'pH',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'TEMP': 'temp',
                                              'TIME': 'time'},
                               'ATTRIBUTE_INFO': {'APPARATUS': {'NULLABLE': True,
                                                                'ORDER': 4,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                  'ATMOSPHERE': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                                  'BUFFER_ID': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                  'CITATION_ID': {'NULLABLE': True,
                                                                  'ORDER': 13,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                  'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 1023},
                                                  'ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                                  'MEAN_2D_CRYSTAL_SIZE': {'NULLABLE': True,
                                                                           'ORDER': 12,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                                  'METHOD': {'NULLABLE': True,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                  'NUMBER_2D_CRYSTALS': {'NULLABLE': True,
                                                                         'ORDER': 11,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'INT',
                                                                         'WIDTH': 10},
                                                  'PH': {'NULLABLE': True,
                                                         'ORDER': 6,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'TEMP': {'NULLABLE': True,
                                                           'ORDER': 7,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                  'TIME': {'NULLABLE': True,
                                                           'ORDER': 8,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80}},
                               'ATTRIBUTE_MAP': {'APPARATUS': ('em_2d_crystal_grow', 'apparatus', None, None),
                                                 'ATMOSPHERE': ('em_2d_crystal_grow', 'atmosphere', None, None),
                                                 'BUFFER_ID': ('em_2d_crystal_grow', 'buffer_id', None, None),
                                                 'CITATION_ID': ('em_2d_crystal_grow', 'citation_id', None, None),
                                                 'DETAILS': ('em_2d_crystal_grow', 'details', None, None),
                                                 'ID': ('em_2d_crystal_grow', 'id', None, None),
                                                 'MEAN_2D_CRYSTAL_SIZE': ('em_2d_crystal_grow',
                                                                          'mean_2d_crystal_size',
                                                                          None,
                                                                          None),
                                                 'METHOD': ('em_2d_crystal_grow', 'method', None, None),
                                                 'NUMBER_2D_CRYSTALS': ('em_2d_crystal_grow',
                                                                        'number_2d_crystals',
                                                                        None,
                                                                        None),
                                                 'PH': ('em_2d_crystal_grow', 'pH', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                 'TEMP': ('em_2d_crystal_grow', 'temp', None, None),
                                                 'TIME': ('em_2d_crystal_grow', 'time', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'em_2d_crystal_grow': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'EM_2D_CRYSTAL_GROW',
                               'TABLE_NAME': 'em_2d_crystal_grow',
                               'TABLE_TYPE': 'transactional'},
        'EM_2D_PROJECTION_SELECTION': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                                      'DETAILS': 'details',
                                                      'ENTRY_ID': 'entry_id',
                                                      'METHOD': 'method',
                                                      'NUM_PARTICLES': 'num_particles',
                                                      'SOFTWARE_NAME': 'software_name',
                                                      'STRUCTURE_ID': 'Structure_ID'},
                                       'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': True,
                                                                          'ORDER': 7,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                          'DETAILS': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                                          'ENTRY_ID': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                          'METHOD': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                                          'NUM_PARTICLES': {'NULLABLE': True,
                                                                            'ORDER': 3,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': 10},
                                                          'SOFTWARE_NAME': {'NULLABLE': True,
                                                                            'ORDER': 4,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 128},
                                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                                           'ORDER': 1,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': True,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 10}},
                                       'ATTRIBUTE_MAP': {'CITATION_ID': ('em_2d_projection_selection',
                                                                         'citation_id',
                                                                         None,
                                                                         None),
                                                         'DETAILS': ('em_2d_projection_selection', 'details', None, None),
                                                         'ENTRY_ID': ('em_2d_projection_selection', 'entry_id', None, None),
                                                         'METHOD': ('em_2d_projection_selection', 'method', None, None),
                                                         'NUM_PARTICLES': ('em_2d_projection_selection',
                                                                           'num_particles',
                                                                           None,
                                                                           None),
                                                         'SOFTWARE_NAME': ('em_2d_projection_selection',
                                                                           'software_name',
                                                                           None,
                                                                           None),
                                                         'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                       'MAP_MERGE_INDICES': {'em_2d_projection_selection': {'ATTRIBUTES': ('entry_id',),
                                                                                            'TYPE': 'EQUI-JOIN'}},
                                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                       'TABLE_ID': 'EM_2D_PROJECTION_SELECTION',
                                       'TABLE_NAME': 'em_2d_projection_selection',
                                       'TABLE_TYPE': 'transactional'},
        'EM_3D_FITTING': {'ATTRIBUTES': {'DETAILS': 'details',
                                         'ENTRY_ID': 'entry_id',
                                         'ID': 'id',
                                         'METHOD': 'method',
                                         'OVERALL_B_VALUE': 'overall_b_value',
                                         'REF_PROTOCOL': 'ref_protocol',
                                         'REF_SPACE': 'ref_space',
                                         'SOFTWARE_NAME': 'software_name',
                                         'STRUCTURE_ID': 'Structure_ID',
                                         'TARGET_CRITERIA': 'target_criteria'},
                          'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 4095},
                                             'ENTRY_ID': {'NULLABLE': False,
                                                          'ORDER': 3,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                             'ID': {'NULLABLE': False,
                                                    'ORDER': 2,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 10},
                                             'METHOD': {'NULLABLE': True,
                                                        'ORDER': 4,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 4095},
                                             'OVERALL_B_VALUE': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'REF_PROTOCOL': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 1023},
                                             'REF_SPACE': {'NULLABLE': True,
                                                           'ORDER': 9,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                             'SOFTWARE_NAME': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                             'TARGET_CRITERIA': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 1023}},
                          'ATTRIBUTE_MAP': {'DETAILS': ('em_3d_fitting', 'details', None, None),
                                            'ENTRY_ID': ('em_3d_fitting', 'entry_id', None, None),
                                            'ID': ('em_3d_fitting', 'id', None, None),
                                            'METHOD': ('em_3d_fitting', 'method', None, None),
                                            'OVERALL_B_VALUE': ('em_3d_fitting', 'overall_b_value', None, None),
                                            'REF_PROTOCOL': ('em_3d_fitting', 'ref_protocol', None, None),
                                            'REF_SPACE': ('em_3d_fitting', 'ref_space', None, None),
                                            'SOFTWARE_NAME': ('em_3d_fitting', 'software_name', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                            'TARGET_CRITERIA': ('em_3d_fitting', 'target_criteria', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'em_3d_fitting': {'ATTRIBUTES': ('id', 'entry_id'), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'EM_3D_FITTING',
                          'TABLE_NAME': 'em_3d_fitting',
                          'TABLE_TYPE': 'transactional'},
        'EM_3D_FITTING_LIST': {'ATTRIBUTES': {'3D_FITTING_ID': '3d_fitting_id',
                                              'ID': 'id',
                                              'PDB_CHAIN_ID': 'pdb_chain_id',
                                              'PDB_ENTRY_ID': 'pdb_entry_id',
                                              'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'3D_FITTING_ID': {'NULLABLE': False,
                                                                    'ORDER': 2,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                  'ID': {'NULLABLE': False,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                                  'PDB_CHAIN_ID': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'PDB_ENTRY_ID': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 80},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'3D_FITTING_ID': ('em_3d_fitting_list', '3d_fitting_id', None, None),
                                                 'ID': ('em_3d_fitting_list', 'id', None, None),
                                                 'PDB_CHAIN_ID': ('em_3d_fitting_list', 'pdb_chain_id', None, None),
                                                 'PDB_ENTRY_ID': ('em_3d_fitting_list', 'pdb_entry_id', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', '3D_FITTING_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'em_3d_fitting_list': {'ATTRIBUTES': ('3d_fitting_id', 'id'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'EM_3D_FITTING_LIST',
                               'TABLE_NAME': 'em_3d_fitting_list',
                               'TABLE_TYPE': 'transactional'},
        'EM_3D_RECONSTRUCTION': {'ATTRIBUTES': {'ACTUAL_PIXEL_SIZE': 'actual_pixel_size',
                                                'CITATION_ID': 'citation_id',
                                                'CTF_CORRECTION_METHOD': 'ctf_correction_method',
                                                'DETAILS': 'details',
                                                'ENTRY_ID': 'entry_id',
                                                'EULER_ANGLES_DETAILS': 'euler_angles_details',
                                                'ID': 'id',
                                                'MAGNIFICATION_CALIBRATION': 'magnification_calibration',
                                                'METHOD': 'method',
                                                'NOMINAL_PIXEL_SIZE': 'nominal_pixel_size',
                                                'NUM_CLASS_AVERAGES': 'num_class_averages',
                                                'NUM_PARTICLES': 'num_particles',
                                                'RESOLUTION': 'resolution',
                                                'RESOLUTION_METHOD': 'resolution_method',
                                                'SOFTWARE': 'software',
                                                'STRUCTURE_ID': 'Structure_ID'},
                                 'ATTRIBUTE_INFO': {'ACTUAL_PIXEL_SIZE': {'NULLABLE': True,
                                                                          'ORDER': 12,
                                                                          'PRECISION': 6,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'FLOAT',
                                                                          'WIDTH': 10},
                                                    'CITATION_ID': {'NULLABLE': True,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                    'CTF_CORRECTION_METHOD': {'NULLABLE': True,
                                                                              'ORDER': 10,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 200},
                                                    'DETAILS': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 4095},
                                                    'ENTRY_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                    'EULER_ANGLES_DETAILS': {'NULLABLE': True,
                                                                             'ORDER': 14,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 200},
                                                    'ID': {'NULLABLE': False,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                                    'MAGNIFICATION_CALIBRATION': {'NULLABLE': True,
                                                                                  'ORDER': 9,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 511},
                                                    'METHOD': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 511},
                                                    'NOMINAL_PIXEL_SIZE': {'NULLABLE': True,
                                                                           'ORDER': 11,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                                    'NUM_CLASS_AVERAGES': {'NULLABLE': True,
                                                                           'ORDER': 15,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'INT',
                                                                           'WIDTH': 10},
                                                    'NUM_PARTICLES': {'NULLABLE': True,
                                                                      'ORDER': 13,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'INT',
                                                                      'WIDTH': 10},
                                                    'RESOLUTION': {'NULLABLE': True,
                                                                   'ORDER': 7,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                    'RESOLUTION_METHOD': {'NULLABLE': True,
                                                                          'ORDER': 8,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 511},
                                                    'SOFTWARE': {'NULLABLE': True,
                                                                 'ORDER': 16,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ACTUAL_PIXEL_SIZE': ('em_3d_reconstruction',
                                                                         'actual_pixel_size',
                                                                         None,
                                                                         None),
                                                   'CITATION_ID': ('em_3d_reconstruction', 'citation_id', None, None),
                                                   'CTF_CORRECTION_METHOD': ('em_3d_reconstruction',
                                                                             'ctf_correction_method',
                                                                             None,
                                                                             None),
                                                   'DETAILS': ('em_3d_reconstruction', 'details', None, None),
                                                   'ENTRY_ID': ('em_3d_reconstruction', 'entry_id', None, None),
                                                   'EULER_ANGLES_DETAILS': ('em_3d_reconstruction',
                                                                            'euler_angles_details',
                                                                            None,
                                                                            None),
                                                   'ID': ('em_3d_reconstruction', 'id', None, None),
                                                   'MAGNIFICATION_CALIBRATION': ('em_3d_reconstruction',
                                                                                 'magnification_calibration',
                                                                                 None,
                                                                                 None),
                                                   'METHOD': ('em_3d_reconstruction', 'method', None, None),
                                                   'NOMINAL_PIXEL_SIZE': ('em_3d_reconstruction',
                                                                          'nominal_pixel_size',
                                                                          None,
                                                                          None),
                                                   'NUM_CLASS_AVERAGES': ('em_3d_reconstruction',
                                                                          'num_class_averages',
                                                                          None,
                                                                          None),
                                                   'NUM_PARTICLES': ('em_3d_reconstruction', 'num_particles', None, None),
                                                   'RESOLUTION': ('em_3d_reconstruction', 'resolution', None, None),
                                                   'RESOLUTION_METHOD': ('em_3d_reconstruction',
                                                                         'resolution_method',
                                                                         None,
                                                                         None),
                                                   'SOFTWARE': ('em_3d_reconstruction', 'software', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'em_3d_reconstruction': {'ATTRIBUTES': ('entry_id', 'id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'EM_3D_RECONSTRUCTION',
                                 'TABLE_NAME': 'em_3d_reconstruction',
                                 'TABLE_TYPE': 'transactional'},
        'EM_ASSEMBLY': {'ATTRIBUTES': {'AGGREGATION_STATE': 'aggregation_state',
                                       'COMPOSITION': 'composition',
                                       'DETAILS': 'details',
                                       'ENTRY_ID': 'entry_id',
                                       'ID': 'id',
                                       'MOL_WT_EXP': 'mol_wt_exp',
                                       'MOL_WT_METHOD': 'mol_wt_method',
                                       'MOL_WT_THEO': 'mol_wt_theo',
                                       'NAME': 'name',
                                       'NUM_COMPONENTS': 'num_components',
                                       'STRUCTURE_ID': 'Structure_ID'},
                        'ATTRIBUTE_INFO': {'AGGREGATION_STATE': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                           'COMPOSITION': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                           'DETAILS': {'NULLABLE': True,
                                                       'ORDER': 11,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 1023},
                                           'ENTRY_ID': {'NULLABLE': False,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                           'ID': {'NULLABLE': False,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': True,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 10},
                                           'MOL_WT_EXP': {'NULLABLE': True,
                                                          'ORDER': 8,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                           'MOL_WT_METHOD': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                           'MOL_WT_THEO': {'NULLABLE': True,
                                                           'ORDER': 9,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                           'NAME': {'NULLABLE': True,
                                                    'ORDER': 4,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 511},
                                           'NUM_COMPONENTS': {'NULLABLE': True,
                                                              'ORDER': 7,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10}},
                        'ATTRIBUTE_MAP': {'AGGREGATION_STATE': ('em_assembly', 'aggregation_state', None, None),
                                          'COMPOSITION': ('em_assembly', 'composition', None, None),
                                          'DETAILS': ('em_assembly', 'details', None, None),
                                          'ENTRY_ID': ('em_assembly', 'entry_id', None, None),
                                          'ID': ('em_assembly', 'id', None, None),
                                          'MOL_WT_EXP': ('em_assembly', 'mol_wt_exp', None, None),
                                          'MOL_WT_METHOD': ('em_assembly', 'mol_wt_method', None, None),
                                          'MOL_WT_THEO': ('em_assembly', 'mol_wt_theo', None, None),
                                          'NAME': ('em_assembly', 'name', None, None),
                                          'NUM_COMPONENTS': ('em_assembly', 'num_components', None, None),
                                          'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                        'MAP_MERGE_INDICES': {'em_assembly': {'ATTRIBUTES': ('id', 'entry_id'), 'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'EM_ASSEMBLY',
                        'TABLE_NAME': 'em_assembly',
                        'TABLE_TYPE': 'transactional'},
        'EM_BUFFER': {'ATTRIBUTES': {'DETAILS': 'details', 'ID': 'id', 'NAME': 'name', 'STRUCTURE_ID': 'Structure_ID'},
                      'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                     'ORDER': 4,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 2,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 10},
                                         'NAME': {'NULLABLE': True,
                                                  'ORDER': 3,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 255},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10}},
                      'ATTRIBUTE_MAP': {'DETAILS': ('em_buffer', 'details', None, None),
                                        'ID': ('em_buffer', 'id', None, None),
                                        'NAME': ('em_buffer', 'name', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'em_buffer': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'EM_BUFFER',
                      'TABLE_NAME': 'em_buffer',
                      'TABLE_TYPE': 'transactional'},
        'EM_BUFFER_COMPONENTS': {'ATTRIBUTES': {'BUFFER_ID': 'buffer_id',
                                                'CONC': 'conc',
                                                'DETAILS': 'details',
                                                'ID': 'id',
                                                'NAME': 'name',
                                                'STRUCTURE_ID': 'Structure_ID',
                                                'VOLUME': 'volume'},
                                 'ATTRIBUTE_INFO': {'BUFFER_ID': {'NULLABLE': False,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                    'CONC': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                    'DETAILS': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                    'ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                                    'NAME': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                    'VOLUME': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'BUFFER_ID': ('em_buffer_components', 'buffer_id', None, None),
                                                   'CONC': ('em_buffer_components', 'conc', None, None),
                                                   'DETAILS': ('em_buffer_components', 'details', None, None),
                                                   'ID': ('em_buffer_components', 'id', None, None),
                                                   'NAME': ('em_buffer_components', 'name', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                   'VOLUME': ('em_buffer_components', 'volume', None, None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'BUFFER_ID'), 'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'em_buffer_components': {'ATTRIBUTES': ('id', 'buffer_id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'EM_BUFFER_COMPONENTS',
                                 'TABLE_NAME': 'em_buffer_components',
                                 'TABLE_TYPE': 'transactional'},
        'EM_DETECTOR': {'ATTRIBUTES': {'DETAILS': 'details',
                                       'DETECTIVE_QUANTUM_EFFICIENCY': 'detective_quantum_efficiency',
                                       'ENTRY_ID': 'entry_id',
                                       'ID': 'id',
                                       'STRUCTURE_ID': 'Structure_ID',
                                       'TYPE': 'type'},
                        'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                       'ORDER': 4,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 200},
                                           'DETECTIVE_QUANTUM_EFFICIENCY': {'NULLABLE': True,
                                                                            'ORDER': 6,
                                                                            'PRECISION': 6,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'FLOAT',
                                                                            'WIDTH': 10},
                                           'ENTRY_ID': {'NULLABLE': False,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                           'ID': {'NULLABLE': False,
                                                  'ORDER': 3,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': True,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 10},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                           'TYPE': {'NULLABLE': True,
                                                    'ORDER': 5,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 80}},
                        'ATTRIBUTE_MAP': {'DETAILS': ('em_detector', 'details', None, None),
                                          'DETECTIVE_QUANTUM_EFFICIENCY': ('em_detector',
                                                                           'detective_quantum_efficiency',
                                                                           None,
                                                                           None),
                                          'ENTRY_ID': ('em_detector', 'entry_id', None, None),
                                          'ID': ('em_detector', 'id', None, None),
                                          'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                          'TYPE': ('em_detector', 'type', None, None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                        'MAP_MERGE_INDICES': {'em_detector': {'ATTRIBUTES': ('entry_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'EM_DETECTOR',
                        'TABLE_NAME': 'em_detector',
                        'TABLE_TYPE': 'transactional'},
        'EM_ELECTRON_DIFFRACTION': {'ATTRIBUTES': {'DETAILS': 'details',
                                                   'ENTRY_ID': 'entry_id',
                                                   'ID': 'id',
                                                   'NUM_DIFF_PATTERNS': 'num_diff_patterns',
                                                   'NUM_STRUCTURE_FACTORS': 'num_structure_factors',
                                                   'STRUCTURE_ID': 'Structure_ID'},
                                    'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                       'ENTRY_ID': {'NULLABLE': False,
                                                                    'ORDER': 2,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                       'ID': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                       'NUM_DIFF_PATTERNS': {'NULLABLE': True,
                                                                             'ORDER': 5,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'INT',
                                                                             'WIDTH': 10},
                                                       'NUM_STRUCTURE_FACTORS': {'NULLABLE': True,
                                                                                 'ORDER': 4,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'INT',
                                                                                 'WIDTH': 10},
                                                       'STRUCTURE_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10}},
                                    'ATTRIBUTE_MAP': {'DETAILS': ('em_electron_diffraction', 'details', None, None),
                                                      'ENTRY_ID': ('em_electron_diffraction', 'entry_id', None, None),
                                                      'ID': ('em_electron_diffraction', 'id', None, None),
                                                      'NUM_DIFF_PATTERNS': ('em_electron_diffraction',
                                                                            'num_diff_patterns',
                                                                            None,
                                                                            None),
                                                      'NUM_STRUCTURE_FACTORS': ('em_electron_diffraction',
                                                                                'num_structure_factors',
                                                                                None,
                                                                                None),
                                                      'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'em_electron_diffraction': {'ATTRIBUTES': ('entry_id', 'id'),
                                                                                      'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                    'TABLE_ID': 'EM_ELECTRON_DIFFRACTION',
                                    'TABLE_NAME': 'em_electron_diffraction',
                                    'TABLE_TYPE': 'transactional'},
        'EM_ELECTRON_DIFFRACTION_PATTERN': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                                           'ID': 'id',
                                                           'NUM_IMAGES_BY_TILT_ANGLE': 'num_images_by_tilt_angle',
                                                           'NUM_PATTERNS_BY_TILT_ANGLE': 'num_patterns_by_tilt_angle',
                                                           'STRUCTURE_ID': 'Structure_ID',
                                                           'TILT_ANGLE': 'tilt_angle'},
                                            'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                                            'ORDER': 2,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                               'ID': {'NULLABLE': False,
                                                                      'ORDER': 3,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                               'NUM_IMAGES_BY_TILT_ANGLE': {'NULLABLE': True,
                                                                                            'ORDER': 5,
                                                                                            'PRECISION': 0,
                                                                                            'PRIMARY_KEY': False,
                                                                                            'SQL_TYPE': 'INT',
                                                                                            'WIDTH': 10},
                                                               'NUM_PATTERNS_BY_TILT_ANGLE': {'NULLABLE': True,
                                                                                              'ORDER': 4,
                                                                                              'PRECISION': 0,
                                                                                              'PRIMARY_KEY': False,
                                                                                              'SQL_TYPE': 'INT',
                                                                                              'WIDTH': 10},
                                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                                'ORDER': 1,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': True,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 10},
                                                               'TILT_ANGLE': {'NULLABLE': True,
                                                                              'ORDER': 6,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'INT',
                                                                              'WIDTH': 10}},
                                            'ATTRIBUTE_MAP': {'ENTRY_ID': ('em_electron_diffraction_pattern',
                                                                           'entry_id',
                                                                           None,
                                                                           None),
                                                              'ID': ('em_electron_diffraction_pattern', 'id', None, None),
                                                              'NUM_IMAGES_BY_TILT_ANGLE': ('em_electron_diffraction_pattern',
                                                                                           'num_images_by_tilt_angle',
                                                                                           None,
                                                                                           None),
                                                              'NUM_PATTERNS_BY_TILT_ANGLE': ('em_electron_diffraction_pattern',
                                                                                             'num_patterns_by_tilt_angle',
                                                                                             None,
                                                                                             None),
                                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                              'TILT_ANGLE': ('em_electron_diffraction_pattern',
                                                                             'tilt_angle',
                                                                             None,
                                                                             None)},
                                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'),
                                                               'TYPE': 'UNIQUE'},
                                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                            'MAP_MERGE_INDICES': {'em_electron_diffraction_pattern': {'ATTRIBUTES': ('entry_id',
                                                                                                                     'id'),
                                                                                                      'TYPE': 'EQUI-JOIN'}},
                                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                            'TABLE_ID': 'EM_ELECTRON_DIFFRACTION_PATTERN',
                                            'TABLE_NAME': 'em_electron_diffraction_pattern',
                                            'TABLE_TYPE': 'transactional'},
        'EM_ELECTRON_DIFFRACTION_PHASE': {'ATTRIBUTES': {'D_RES_HIGH': 'd_res_high',
                                                         'ENTRY_ID': 'entry_id',
                                                         'HIGHEST_RESOLUTION_SHELL_ERROR': 'highest_resolution_shell_error',
                                                         'ID': 'id',
                                                         'OVERALL_ERROR': 'overall_error',
                                                         'REJECTION_CRITERIA_ERROR': 'rejection_criteria_error',
                                                         'RESIDUAL': 'residual',
                                                         'STRUCTURE_ID': 'Structure_ID'},
                                          'ATTRIBUTE_INFO': {'D_RES_HIGH': {'NULLABLE': True,
                                                                            'ORDER': 4,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': 10},
                                                             'ENTRY_ID': {'NULLABLE': False,
                                                                          'ORDER': 2,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                             'HIGHEST_RESOLUTION_SHELL_ERROR': {'NULLABLE': True,
                                                                                                'ORDER': 6,
                                                                                                'PRECISION': 0,
                                                                                                'PRIMARY_KEY': False,
                                                                                                'SQL_TYPE': 'INT',
                                                                                                'WIDTH': 10},
                                                             'ID': {'NULLABLE': False,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                             'OVERALL_ERROR': {'NULLABLE': True,
                                                                               'ORDER': 7,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'INT',
                                                                               'WIDTH': 10},
                                                             'REJECTION_CRITERIA_ERROR': {'NULLABLE': True,
                                                                                          'ORDER': 8,
                                                                                          'PRECISION': 0,
                                                                                          'PRIMARY_KEY': False,
                                                                                          'SQL_TYPE': 'INT',
                                                                                          'WIDTH': 10},
                                                             'RESIDUAL': {'NULLABLE': True,
                                                                          'ORDER': 5,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'INT',
                                                                          'WIDTH': 10},
                                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                                              'ORDER': 1,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10}},
                                          'ATTRIBUTE_MAP': {'D_RES_HIGH': ('em_electron_diffraction_phase',
                                                                           'd_res_high',
                                                                           None,
                                                                           None),
                                                            'ENTRY_ID': ('em_electron_diffraction_phase',
                                                                         'entry_id',
                                                                         None,
                                                                         None),
                                                            'HIGHEST_RESOLUTION_SHELL_ERROR': ('em_electron_diffraction_phase',
                                                                                               'highest_resolution_shell_error',
                                                                                               None,
                                                                                               None),
                                                            'ID': ('em_electron_diffraction_phase', 'id', None, None),
                                                            'OVERALL_ERROR': ('em_electron_diffraction_phase',
                                                                              'overall_error',
                                                                              None,
                                                                              None),
                                                            'REJECTION_CRITERIA_ERROR': ('em_electron_diffraction_phase',
                                                                                         'rejection_criteria_error',
                                                                                         None,
                                                                                         None),
                                                            'RESIDUAL': ('em_electron_diffraction_phase',
                                                                         'residual',
                                                                         None,
                                                                         None),
                                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'),
                                                             'TYPE': 'UNIQUE'},
                                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                          'MAP_MERGE_INDICES': {'em_electron_diffraction_phase': {'ATTRIBUTES': ('entry_id',
                                                                                                                 'id'),
                                                                                                  'TYPE': 'EQUI-JOIN'}},
                                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                          'TABLE_ID': 'EM_ELECTRON_DIFFRACTION_PHASE',
                                          'TABLE_NAME': 'em_electron_diffraction_phase',
                                          'TABLE_TYPE': 'transactional'},
        'EM_ENTITY_ASSEMBLY': {'ATTRIBUTES': {'ASSEMBLY_ID': 'assembly_id',
                                              'DETAILS': 'details',
                                              'EBI_CELL': 'ebi_cell',
                                              'EBI_CELLULAR_LOCATION': 'ebi_cellular_location',
                                              'EBI_ENGINEERED': 'ebi_engineered',
                                              'EBI_EXPRESSION_SYSTEM': 'ebi_expression_system',
                                              'EBI_EXPRESSION_SYSTEM_PLASMID': 'ebi_expression_system_plasmid',
                                              'EBI_ORGANELLE': 'ebi_organelle',
                                              'EBI_ORGANISM_COMMON': 'ebi_organism_common',
                                              'EBI_ORGANISM_SCIENTIFIC': 'ebi_organism_scientific',
                                              'EBI_STRAIN': 'ebi_strain',
                                              'EBI_TISSUE': 'ebi_tissue',
                                              'GO_ID': 'go_id',
                                              'ID': 'id',
                                              'IPR_ID': 'ipr_id',
                                              'MUTANT_FLAG': 'mutant_flag',
                                              'NAME': 'name',
                                              'NUMBER_OF_COPIES': 'number_of_copies',
                                              'OLIGOMERIC_DETAILS': 'oligomeric_details',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'SYNONYM': 'synonym',
                                              'TYPE': 'type'},
                               'ATTRIBUTE_INFO': {'ASSEMBLY_ID': {'NULLABLE': False,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                  'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 6,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 511},
                                                  'EBI_CELL': {'NULLABLE': True,
                                                               'ORDER': 11,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                  'EBI_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                            'ORDER': 13,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                                  'EBI_ENGINEERED': {'NULLABLE': True,
                                                                     'ORDER': 14,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                                  'EBI_EXPRESSION_SYSTEM': {'NULLABLE': True,
                                                                            'ORDER': 15,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                                  'EBI_EXPRESSION_SYSTEM_PLASMID': {'NULLABLE': True,
                                                                                    'ORDER': 16,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': False,
                                                                                    'SQL_TYPE': 'VARCHAR',
                                                                                    'WIDTH': 80},
                                                  'EBI_ORGANELLE': {'NULLABLE': True,
                                                                    'ORDER': 12,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                                  'EBI_ORGANISM_COMMON': {'NULLABLE': True,
                                                                          'ORDER': 8,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 200},
                                                  'EBI_ORGANISM_SCIENTIFIC': {'NULLABLE': True,
                                                                              'ORDER': 7,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 200},
                                                  'EBI_STRAIN': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                  'EBI_TISSUE': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                  'GO_ID': {'NULLABLE': True,
                                                            'ORDER': 17,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                                  'ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                                  'IPR_ID': {'NULLABLE': True,
                                                             'ORDER': 18,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                  'MUTANT_FLAG': {'NULLABLE': True,
                                                                  'ORDER': 20,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80},
                                                  'NAME': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 255},
                                                  'NUMBER_OF_COPIES': {'NULLABLE': True,
                                                                       'ORDER': 21,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                                  'OLIGOMERIC_DETAILS': {'NULLABLE': True,
                                                                         'ORDER': 22,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 200},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'SYNONYM': {'NULLABLE': True,
                                                              'ORDER': 19,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                                  'TYPE': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80}},
                               'ATTRIBUTE_MAP': {'ASSEMBLY_ID': ('em_entity_assembly', 'assembly_id', None, None),
                                                 'DETAILS': ('em_entity_assembly', 'details', None, None),
                                                 'EBI_CELL': ('em_entity_assembly', 'ebi_cell', None, None),
                                                 'EBI_CELLULAR_LOCATION': ('em_entity_assembly',
                                                                           'ebi_cellular_location',
                                                                           None,
                                                                           None),
                                                 'EBI_ENGINEERED': ('em_entity_assembly', 'ebi_engineered', None, None),
                                                 'EBI_EXPRESSION_SYSTEM': ('em_entity_assembly',
                                                                           'ebi_expression_system',
                                                                           None,
                                                                           None),
                                                 'EBI_EXPRESSION_SYSTEM_PLASMID': ('em_entity_assembly',
                                                                                   'ebi_expression_system_plasmid',
                                                                                   None,
                                                                                   None),
                                                 'EBI_ORGANELLE': ('em_entity_assembly', 'ebi_organelle', None, None),
                                                 'EBI_ORGANISM_COMMON': ('em_entity_assembly',
                                                                         'ebi_organism_common',
                                                                         None,
                                                                         None),
                                                 'EBI_ORGANISM_SCIENTIFIC': ('em_entity_assembly',
                                                                             'ebi_organism_scientific',
                                                                             None,
                                                                             None),
                                                 'EBI_STRAIN': ('em_entity_assembly', 'ebi_strain', None, None),
                                                 'EBI_TISSUE': ('em_entity_assembly', 'ebi_tissue', None, None),
                                                 'GO_ID': ('em_entity_assembly', 'go_id', None, None),
                                                 'ID': ('em_entity_assembly', 'id', None, None),
                                                 'IPR_ID': ('em_entity_assembly', 'ipr_id', None, None),
                                                 'MUTANT_FLAG': ('em_entity_assembly', 'mutant_flag', None, None),
                                                 'NAME': ('em_entity_assembly', 'name', None, None),
                                                 'NUMBER_OF_COPIES': ('em_entity_assembly', 'number_of_copies', None, None),
                                                 'OLIGOMERIC_DETAILS': ('em_entity_assembly',
                                                                        'oligomeric_details',
                                                                        None,
                                                                        None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                 'SYNONYM': ('em_entity_assembly', 'synonym', None, None),
                                                 'TYPE': ('em_entity_assembly', 'type', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ASSEMBLY_ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'em_entity_assembly': {'ATTRIBUTES': ('id', 'assembly_id'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'EM_ENTITY_ASSEMBLY',
                               'TABLE_NAME': 'em_entity_assembly',
                               'TABLE_TYPE': 'transactional'},
        'EM_ENTITY_ASSEMBLY_LIST': {'ATTRIBUTES': {'ENTITY_ASSEMBLY_ID': 'entity_assembly_id',
                                                   'ENTITY_ID': 'entity_id',
                                                   'ID': 'id',
                                                   'NUMBER_OF_COPIES': 'number_of_copies',
                                                   'OLIGOMERIC_DETAILS': 'oligomeric_details',
                                                   'STRUCTURE_ID': 'Structure_ID'},
                                    'ATTRIBUTE_INFO': {'ENTITY_ASSEMBLY_ID': {'NULLABLE': False,
                                                                              'ORDER': 4,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 10},
                                                       'ENTITY_ID': {'NULLABLE': False,
                                                                     'ORDER': 3,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                       'ID': {'NULLABLE': False,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                                       'NUMBER_OF_COPIES': {'NULLABLE': True,
                                                                            'ORDER': 6,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'INT',
                                                                            'WIDTH': 10},
                                                       'OLIGOMERIC_DETAILS': {'NULLABLE': True,
                                                                              'ORDER': 5,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 80},
                                                       'STRUCTURE_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10}},
                                    'ATTRIBUTE_MAP': {'ENTITY_ASSEMBLY_ID': ('em_entity_assembly_list',
                                                                             'entity_assembly_id',
                                                                             None,
                                                                             None),
                                                      'ENTITY_ID': ('em_entity_assembly_list', 'entity_id', None, None),
                                                      'ID': ('em_entity_assembly_list', 'id', None, None),
                                                      'NUMBER_OF_COPIES': ('em_entity_assembly_list',
                                                                           'number_of_copies',
                                                                           None,
                                                                           None),
                                                      'OLIGOMERIC_DETAILS': ('em_entity_assembly_list',
                                                                             'oligomeric_details',
                                                                             None,
                                                                             None),
                                                      'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                      'ID',
                                                                      'ENTITY_ID',
                                                                      'ENTITY_ASSEMBLY_ID'),
                                                       'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'em_entity_assembly_list': {'ATTRIBUTES': ('id',
                                                                                                     'entity_id',
                                                                                                     'entity_assembly_id'),
                                                                                      'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                    'TABLE_ID': 'EM_ENTITY_ASSEMBLY_LIST',
                                    'TABLE_NAME': 'em_entity_assembly_list',
                                    'TABLE_TYPE': 'transactional'},
        'EM_EULER_ANGLE_DISTRIBUTION': {'ATTRIBUTES': {'ALPHA': 'alpha',
                                                       'BETA': 'beta',
                                                       'DETAILS': 'details',
                                                       'ENTRY_ID': 'entry_id',
                                                       'GAMMA': 'gamma',
                                                       'ID': 'id',
                                                       'STRUCTURE_ID': 'Structure_ID'},
                                        'ATTRIBUTE_INFO': {'ALPHA': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 6,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                                           'BETA': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                                           'DETAILS': {'NULLABLE': True,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                                           'ENTRY_ID': {'NULLABLE': False,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                           'GAMMA': {'NULLABLE': True,
                                                                     'ORDER': 7,
                                                                     'PRECISION': 6,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                                           'ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10}},
                                        'ATTRIBUTE_MAP': {'ALPHA': ('em_euler_angle_distribution', 'alpha', None, None),
                                                          'BETA': ('em_euler_angle_distribution', 'beta', None, None),
                                                          'DETAILS': ('em_euler_angle_distribution', 'details', None, None),
                                                          'ENTRY_ID': ('em_euler_angle_distribution',
                                                                       'entry_id',
                                                                       None,
                                                                       None),
                                                          'GAMMA': ('em_euler_angle_distribution', 'gamma', None, None),
                                                          'ID': ('em_euler_angle_distribution', 'id', None, None),
                                                          'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ENTRY_ID'),
                                                           'TYPE': 'UNIQUE'},
                                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                        'MAP_MERGE_INDICES': {'em_euler_angle_distribution': {'ATTRIBUTES': ('id',
                                                                                                             'entry_id'),
                                                                                              'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                        'TABLE_ID': 'EM_EULER_ANGLE_DISTRIBUTION',
                                        'TABLE_NAME': 'em_euler_angle_distribution',
                                        'TABLE_TYPE': 'transactional'},
        'EM_EXPERIMENT': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                         'RECONSTRUCTION_METHOD': 'reconstruction_method',
                                         'SPECIMEN_TYPE': 'specimen_type',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                             'RECONSTRUCTION_METHOD': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                             'SPECIMEN_TYPE': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'ENTRY_ID': ('em_experiment', 'entry_id', None, None),
                                            'RECONSTRUCTION_METHOD': ('em_experiment', 'reconstruction_method', None, None),
                                            'SPECIMEN_TYPE': ('em_experiment', 'specimen_type', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'em_experiment': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'EM_EXPERIMENT',
                          'TABLE_NAME': 'em_experiment',
                          'TABLE_TYPE': 'transactional'},
        'EM_HELICAL_ENTITY': {'ATTRIBUTES': {'ANGULAR_ROTATION_PER_SUBUNIT': 'angular_rotation_per_subunit',
                                             'AXIAL_RISE_PER_SUBUNIT': 'axial_rise_per_subunit',
                                             'AXIAL_SYMMETRY': 'axial_symmetry',
                                             'DETAILS': 'details',
                                             'DYAD': 'dyad',
                                             'ENTITY_ASSEMBLY_ID': 'entity_assembly_id',
                                             'HAND': 'hand',
                                             'ID': 'id',
                                             'STRUCTURE_ID': 'Structure_ID'},
                              'ATTRIBUTE_INFO': {'ANGULAR_ROTATION_PER_SUBUNIT': {'NULLABLE': True,
                                                                                  'ORDER': 7,
                                                                                  'PRECISION': 6,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'FLOAT',
                                                                                  'WIDTH': 10},
                                                 'AXIAL_RISE_PER_SUBUNIT': {'NULLABLE': True,
                                                                            'ORDER': 8,
                                                                            'PRECISION': 6,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'FLOAT',
                                                                            'WIDTH': 10},
                                                 'AXIAL_SYMMETRY': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                                 'DETAILS': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                                 'DYAD': {'NULLABLE': True,
                                                          'ORDER': 5,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 80},
                                                 'ENTITY_ASSEMBLY_ID': {'NULLABLE': False,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                 'HAND': {'NULLABLE': True,
                                                          'ORDER': 9,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                                 'ID': {'NULLABLE': False,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                                 'STRUCTURE_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10}},
                              'ATTRIBUTE_MAP': {'ANGULAR_ROTATION_PER_SUBUNIT': ('em_helical_entity',
                                                                                 'angular_rotation_per_subunit',
                                                                                 None,
                                                                                 None),
                                                'AXIAL_RISE_PER_SUBUNIT': ('em_helical_entity',
                                                                           'axial_rise_per_subunit',
                                                                           None,
                                                                           None),
                                                'AXIAL_SYMMETRY': ('em_helical_entity', 'axial_symmetry', None, None),
                                                'DETAILS': ('em_helical_entity', 'details', None, None),
                                                'DYAD': ('em_helical_entity', 'dyad', None, None),
                                                'ENTITY_ASSEMBLY_ID': ('em_helical_entity',
                                                                       'entity_assembly_id',
                                                                       None,
                                                                       None),
                                                'HAND': ('em_helical_entity', 'hand', None, None),
                                                'ID': ('em_helical_entity', 'id', None, None),
                                                'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                              'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ENTITY_ASSEMBLY_ID'),
                                                 'TYPE': 'UNIQUE'},
                                          's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                              'MAP_MERGE_INDICES': {'em_helical_entity': {'ATTRIBUTES': ('id', 'entity_assembly_id'),
                                                                          'TYPE': 'EQUI-JOIN'}},
                              'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                              'TABLE_ID': 'EM_HELICAL_ENTITY',
                              'TABLE_NAME': 'em_helical_entity',
                              'TABLE_TYPE': 'transactional'},
        'EM_ICOS_VIRUS_SHELLS': {'ATTRIBUTES': {'ID': 'id',
                                                'SHELL_DIAMETER': 'shell_diameter',
                                                'STRUCTURE_ID': 'Structure_ID',
                                                'TRIANGULATION_NUM': 'triangulation_num',
                                                'VIRUS_ENTITY_ID': 'virus_entity_id'},
                                 'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                                    'SHELL_DIAMETER': {'NULLABLE': True,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 6,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                    'TRIANGULATION_NUM': {'NULLABLE': True,
                                                                          'ORDER': 5,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'INT',
                                                                          'WIDTH': 10},
                                                    'VIRUS_ENTITY_ID': {'NULLABLE': False,
                                                                        'ORDER': 2,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ID': ('em_icos_virus_shells', 'id', None, None),
                                                   'SHELL_DIAMETER': ('em_icos_virus_shells', 'shell_diameter', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                   'TRIANGULATION_NUM': ('em_icos_virus_shells',
                                                                         'triangulation_num',
                                                                         None,
                                                                         None),
                                                   'VIRUS_ENTITY_ID': ('em_icos_virus_shells',
                                                                       'virus_entity_id',
                                                                       None,
                                                                       None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'VIRUS_ENTITY_ID', 'ID'),
                                                    'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'em_icos_virus_shells': {'ATTRIBUTES': ('virus_entity_id', 'id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'EM_ICOS_VIRUS_SHELLS',
                                 'TABLE_NAME': 'em_icos_virus_shells',
                                 'TABLE_TYPE': 'transactional'},
        'EM_IMAGE_SCANS': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                          'DETAILS': 'details',
                                          'ENTRY_ID': 'entry_id',
                                          'ID': 'id',
                                          'NUMBER_DIGITAL_IMAGES': 'number_digital_images',
                                          'OD_RANGE': 'od_range',
                                          'QUANT_BIT_SIZE': 'quant_bit_size',
                                          'SAMPLING_SIZE': 'sampling_size',
                                          'SCANNER_MODEL': 'scanner_model',
                                          'STRUCTURE_ID': 'Structure_ID'},
                           'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 5,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'ENTRY_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                              'ID': {'NULLABLE': False,
                                                     'ORDER': 3,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                              'NUMBER_DIGITAL_IMAGES': {'NULLABLE': True,
                                                                        'ORDER': 4,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': 10},
                                              'OD_RANGE': {'NULLABLE': True,
                                                           'ORDER': 8,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                              'QUANT_BIT_SIZE': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': 10},
                                              'SAMPLING_SIZE': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'SCANNER_MODEL': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'CITATION_ID': ('em_image_scans', 'citation_id', None, None),
                                             'DETAILS': ('em_image_scans', 'details', None, None),
                                             'ENTRY_ID': ('em_image_scans', 'entry_id', None, None),
                                             'ID': ('em_image_scans', 'id', None, None),
                                             'NUMBER_DIGITAL_IMAGES': ('em_image_scans',
                                                                       'number_digital_images',
                                                                       None,
                                                                       None),
                                             'OD_RANGE': ('em_image_scans', 'od_range', None, None),
                                             'QUANT_BIT_SIZE': ('em_image_scans', 'quant_bit_size', None, None),
                                             'SAMPLING_SIZE': ('em_image_scans', 'sampling_size', None, None),
                                             'SCANNER_MODEL': ('em_image_scans', 'scanner_model', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'em_image_scans': {'ATTRIBUTES': ('entry_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'EM_IMAGE_SCANS',
                           'TABLE_NAME': 'em_image_scans',
                           'TABLE_TYPE': 'transactional'},
        'EM_IMAGING': {'ATTRIBUTES': {'ACCELERATING_VOLTAGE': 'accelerating_voltage',
                                      'ASTIGMATISM': 'astigmatism',
                                      'CALIBRATED_MAGNIFICATION': 'calibrated_magnification',
                                      'CITATION_ID': 'citation_id',
                                      'DATE': 'date',
                                      'DETAILS': 'details',
                                      'DETECTOR_DISTANCE': 'detector_distance',
                                      'DETECTOR_ID': 'detector_id',
                                      'ELECTRON_BEAM_TILT_PARAMS': 'electron_beam_tilt_params',
                                      'ELECTRON_DOSE': 'electron_dose',
                                      'ELECTRON_SOURCE': 'electron_source',
                                      'ENERGY_FILTER': 'energy_filter',
                                      'ENERGY_WINDOW': 'energy_window',
                                      'ENTRY_ID': 'entry_id',
                                      'ID': 'id',
                                      'ILLUMINATION_MODE': 'illumination_mode',
                                      'MICROSCOPE_ID': 'microscope_id',
                                      'MICROSCOPE_MODEL': 'microscope_model',
                                      'MODE': 'mode',
                                      'NOMINAL_CS': 'nominal_cs',
                                      'NOMINAL_DEFOCUS_MAX': 'nominal_defocus_max',
                                      'NOMINAL_DEFOCUS_MIN': 'nominal_defocus_min',
                                      'NOMINAL_MAGNIFICATION': 'nominal_magnification',
                                      'RECORDING_TEMPERATURE_MAXIMUM': 'recording_temperature_maximum',
                                      'RECORDING_TEMPERATURE_MINIMUM': 'recording_temperature_minimum',
                                      'SAMPLE_SUPPORT_ID': 'sample_support_id',
                                      'SCANS_ID': 'scans_id',
                                      'SPECIMEN_HOLDER_MODEL': 'specimen_holder_model',
                                      'SPECIMEN_HOLDER_TYPE': 'specimen_holder_type',
                                      'STRUCTURE_ID': 'Structure_ID',
                                      'TEMPERATURE': 'temperature',
                                      'TILT_ANGLE_MAX': 'tilt_angle_max',
                                      'TILT_ANGLE_MIN': 'tilt_angle_min'},
                       'ATTRIBUTE_INFO': {'ACCELERATING_VOLTAGE': {'NULLABLE': True,
                                                                   'ORDER': 15,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                          'ASTIGMATISM': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                          'CALIBRATED_MAGNIFICATION': {'NULLABLE': True,
                                                                       'ORDER': 24,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                          'CITATION_ID': {'NULLABLE': True,
                                                          'ORDER': 29,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                          'DATE': {'NULLABLE': True,
                                                   'ORDER': 14,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': 80},
                                          'DETAILS': {'NULLABLE': True,
                                                      'ORDER': 13,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 1023},
                                          'DETECTOR_DISTANCE': {'NULLABLE': True,
                                                                'ORDER': 31,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                          'DETECTOR_ID': {'NULLABLE': True,
                                                          'ORDER': 7,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                          'ELECTRON_BEAM_TILT_PARAMS': {'NULLABLE': True,
                                                                        'ORDER': 5,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                          'ELECTRON_DOSE': {'NULLABLE': True,
                                                            'ORDER': 26,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                          'ELECTRON_SOURCE': {'NULLABLE': True,
                                                              'ORDER': 25,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                          'ENERGY_FILTER': {'NULLABLE': True,
                                                            'ORDER': 27,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                          'ENERGY_WINDOW': {'NULLABLE': True,
                                                            'ORDER': 28,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                          'ENTRY_ID': {'NULLABLE': False,
                                                       'ORDER': 2,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                          'ID': {'NULLABLE': False,
                                                 'ORDER': 3,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': True,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 10},
                                          'ILLUMINATION_MODE': {'NULLABLE': True,
                                                                'ORDER': 16,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                          'MICROSCOPE_ID': {'NULLABLE': True,
                                                            'ORDER': 9,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                          'MICROSCOPE_MODEL': {'NULLABLE': True,
                                                               'ORDER': 10,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 80},
                                          'MODE': {'NULLABLE': True,
                                                   'ORDER': 17,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': 80},
                                          'NOMINAL_CS': {'NULLABLE': True,
                                                         'ORDER': 18,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                          'NOMINAL_DEFOCUS_MAX': {'NULLABLE': True,
                                                                  'ORDER': 20,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                          'NOMINAL_DEFOCUS_MIN': {'NULLABLE': True,
                                                                  'ORDER': 19,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                          'NOMINAL_MAGNIFICATION': {'NULLABLE': True,
                                                                    'ORDER': 23,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                          'RECORDING_TEMPERATURE_MAXIMUM': {'NULLABLE': True,
                                                                            'ORDER': 33,
                                                                            'PRECISION': 6,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'FLOAT',
                                                                            'WIDTH': 10},
                                          'RECORDING_TEMPERATURE_MINIMUM': {'NULLABLE': True,
                                                                            'ORDER': 32,
                                                                            'PRECISION': 6,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'FLOAT',
                                                                            'WIDTH': 10},
                                          'SAMPLE_SUPPORT_ID': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                          'SCANS_ID': {'NULLABLE': True,
                                                       'ORDER': 8,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                          'SPECIMEN_HOLDER_MODEL': {'NULLABLE': True,
                                                                    'ORDER': 12,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                          'SPECIMEN_HOLDER_TYPE': {'NULLABLE': True,
                                                                   'ORDER': 11,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                          'TEMPERATURE': {'NULLABLE': True,
                                                          'ORDER': 30,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                          'TILT_ANGLE_MAX': {'NULLABLE': True,
                                                             'ORDER': 22,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                          'TILT_ANGLE_MIN': {'NULLABLE': True,
                                                             'ORDER': 21,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10}},
                       'ATTRIBUTE_MAP': {'ACCELERATING_VOLTAGE': ('em_imaging', 'accelerating_voltage', None, None),
                                         'ASTIGMATISM': ('em_imaging', 'astigmatism', None, None),
                                         'CALIBRATED_MAGNIFICATION': ('em_imaging', 'calibrated_magnification', None, None),
                                         'CITATION_ID': ('em_imaging', 'citation_id', None, None),
                                         'DATE': ('em_imaging', 'date', None, None),
                                         'DETAILS': ('em_imaging', 'details', None, None),
                                         'DETECTOR_DISTANCE': ('em_imaging', 'detector_distance', None, None),
                                         'DETECTOR_ID': ('em_imaging', 'detector_id', None, None),
                                         'ELECTRON_BEAM_TILT_PARAMS': ('em_imaging',
                                                                       'electron_beam_tilt_params',
                                                                       None,
                                                                       None),
                                         'ELECTRON_DOSE': ('em_imaging', 'electron_dose', None, None),
                                         'ELECTRON_SOURCE': ('em_imaging', 'electron_source', None, None),
                                         'ENERGY_FILTER': ('em_imaging', 'energy_filter', None, None),
                                         'ENERGY_WINDOW': ('em_imaging', 'energy_window', None, None),
                                         'ENTRY_ID': ('em_imaging', 'entry_id', None, None),
                                         'ID': ('em_imaging', 'id', None, None),
                                         'ILLUMINATION_MODE': ('em_imaging', 'illumination_mode', None, None),
                                         'MICROSCOPE_ID': ('em_imaging', 'microscope_id', None, None),
                                         'MICROSCOPE_MODEL': ('em_imaging', 'microscope_model', None, None),
                                         'MODE': ('em_imaging', 'mode', None, None),
                                         'NOMINAL_CS': ('em_imaging', 'nominal_cs', None, None),
                                         'NOMINAL_DEFOCUS_MAX': ('em_imaging', 'nominal_defocus_max', None, None),
                                         'NOMINAL_DEFOCUS_MIN': ('em_imaging', 'nominal_defocus_min', None, None),
                                         'NOMINAL_MAGNIFICATION': ('em_imaging', 'nominal_magnification', None, None),
                                         'RECORDING_TEMPERATURE_MAXIMUM': ('em_imaging',
                                                                           'recording_temperature_maximum',
                                                                           None,
                                                                           None),
                                         'RECORDING_TEMPERATURE_MINIMUM': ('em_imaging',
                                                                           'recording_temperature_minimum',
                                                                           None,
                                                                           None),
                                         'SAMPLE_SUPPORT_ID': ('em_imaging', 'sample_support_id', None, None),
                                         'SCANS_ID': ('em_imaging', 'scans_id', None, None),
                                         'SPECIMEN_HOLDER_MODEL': ('em_imaging', 'specimen_holder_model', None, None),
                                         'SPECIMEN_HOLDER_TYPE': ('em_imaging', 'specimen_holder_type', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                         'TEMPERATURE': ('em_imaging', 'temperature', None, None),
                                         'TILT_ANGLE_MAX': ('em_imaging', 'tilt_angle_max', None, None),
                                         'TILT_ANGLE_MIN': ('em_imaging', 'tilt_angle_min', None, None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'em_imaging': {'ATTRIBUTES': ('entry_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'EM_IMAGING',
                       'TABLE_NAME': 'em_imaging',
                       'TABLE_TYPE': 'transactional'},
        'EM_SAMPLE_PREPARATION': {'ATTRIBUTES': {'2D_CRYSTAL_GROW_ID': '2d_crystal_grow_id',
                                                 'BUFFER_ID': 'buffer_id',
                                                 'DETAILS': 'details',
                                                 'ENTITY_ASSEMBLY_ID': 'entity_assembly_id',
                                                 'ENTRY_ID': 'entry_id',
                                                 'ID': 'id',
                                                 'PH': 'ph',
                                                 'SAMPLE_CONCENTRATION': 'sample_concentration',
                                                 'STRUCTURE_ID': 'Structure_ID',
                                                 'SUPPORT_ID': 'support_id'},
                                  'ATTRIBUTE_INFO': {'2D_CRYSTAL_GROW_ID': {'NULLABLE': True,
                                                                            'ORDER': 7,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                     'BUFFER_ID': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                     'DETAILS': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                     'ENTITY_ASSEMBLY_ID': {'NULLABLE': True,
                                                                            'ORDER': 9,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                     'ENTRY_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                     'ID': {'NULLABLE': False,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                                     'PH': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                     'SAMPLE_CONCENTRATION': {'NULLABLE': True,
                                                                              'ORDER': 6,
                                                                              'PRECISION': 6,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'FLOAT',
                                                                              'WIDTH': 10},
                                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                     'SUPPORT_ID': {'NULLABLE': True,
                                                                    'ORDER': 8,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10}},
                                  'ATTRIBUTE_MAP': {'2D_CRYSTAL_GROW_ID': ('em_sample_preparation',
                                                                           '2d_crystal_grow_id',
                                                                           None,
                                                                           None),
                                                    'BUFFER_ID': ('em_sample_preparation', 'buffer_id', None, None),
                                                    'DETAILS': ('em_sample_preparation', 'details', None, None),
                                                    'ENTITY_ASSEMBLY_ID': ('em_sample_preparation',
                                                                           'entity_assembly_id',
                                                                           None,
                                                                           None),
                                                    'ENTRY_ID': ('em_sample_preparation', 'entry_id', None, None),
                                                    'ID': ('em_sample_preparation', 'id', None, None),
                                                    'PH': ('em_sample_preparation', 'ph', None, None),
                                                    'SAMPLE_CONCENTRATION': ('em_sample_preparation',
                                                                             'sample_concentration',
                                                                             None,
                                                                             None),
                                                    'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                    'SUPPORT_ID': ('em_sample_preparation', 'support_id', None, None)},
                                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                  'MAP_MERGE_INDICES': {'em_sample_preparation': {'ATTRIBUTES': ('entry_id', 'id'),
                                                                                  'TYPE': 'EQUI-JOIN'}},
                                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                  'TABLE_ID': 'EM_SAMPLE_PREPARATION',
                                  'TABLE_NAME': 'em_sample_preparation',
                                  'TABLE_TYPE': 'transactional'},
        'EM_SAMPLE_SUPPORT': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                             'DETAILS': 'details',
                                             'FILM_MATERIAL': 'film_material',
                                             'GRID_MATERIAL': 'grid_material',
                                             'GRID_MESH_SIZE': 'grid_mesh_size',
                                             'GRID_TYPE': 'grid_type',
                                             'ID': 'id',
                                             'METHOD': 'method',
                                             'PRETREATMENT': 'pretreatment',
                                             'STRUCTURE_ID': 'Structure_ID'},
                              'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                 'DETAILS': {'NULLABLE': True,
                                                             'ORDER': 9,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                                 'FILM_MATERIAL': {'NULLABLE': True,
                                                                   'ORDER': 3,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 80},
                                                 'GRID_MATERIAL': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 80},
                                                 'GRID_MESH_SIZE': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                                 'GRID_TYPE': {'NULLABLE': True,
                                                               'ORDER': 7,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 80},
                                                 'ID': {'NULLABLE': False,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                                 'METHOD': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                                 'PRETREATMENT': {'NULLABLE': True,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                 'STRUCTURE_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10}},
                              'ATTRIBUTE_MAP': {'CITATION_ID': ('em_sample_support', 'citation_id', None, None),
                                                'DETAILS': ('em_sample_support', 'details', None, None),
                                                'FILM_MATERIAL': ('em_sample_support', 'film_material', None, None),
                                                'GRID_MATERIAL': ('em_sample_support', 'grid_material', None, None),
                                                'GRID_MESH_SIZE': ('em_sample_support', 'grid_mesh_size', None, None),
                                                'GRID_TYPE': ('em_sample_support', 'grid_type', None, None),
                                                'ID': ('em_sample_support', 'id', None, None),
                                                'METHOD': ('em_sample_support', 'method', None, None),
                                                'PRETREATMENT': ('em_sample_support', 'pretreatment', None, None),
                                                'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                              'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                          's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                              'MAP_MERGE_INDICES': {'em_sample_support': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                              'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                              'TABLE_ID': 'EM_SAMPLE_SUPPORT',
                              'TABLE_NAME': 'em_sample_support',
                              'TABLE_TYPE': 'transactional'},
        'EM_SINGLE_PARTICLE_ENTITY': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                                     'STRUCTURE_ID': 'Structure_ID',
                                                     'SYMMETRY_TYPE': 'symmetry_type'},
                                      'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                                      'ORDER': 2,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                         'SYMMETRY_TYPE': {'NULLABLE': True,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80}},
                                      'ATTRIBUTE_MAP': {'ENTRY_ID': ('em_single_particle_entity', 'entry_id', None, None),
                                                        'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                        'SYMMETRY_TYPE': ('em_single_particle_entity',
                                                                          'symmetry_type',
                                                                          None,
                                                                          None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'em_single_particle_entity': {'ATTRIBUTES': ('entry_id',),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                      'TABLE_ID': 'EM_SINGLE_PARTICLE_ENTITY',
                                      'TABLE_NAME': 'em_single_particle_entity',
                                      'TABLE_TYPE': 'transactional'},
        'EM_VIRUS_ENTITY': {'ATTRIBUTES': {'DETAILS': 'details',
                                           'EMPTY': 'empty',
                                           'ENTITY_ASSEMBLY_ID': 'entity_assembly_id',
                                           'ENVELOPED': 'enveloped',
                                           'ICTVDB_ID': 'ictvdb_id',
                                           'ID': 'id',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'VIRUS_HOST_CATEGORY': 'virus_host_category',
                                           'VIRUS_HOST_GROWTH_CELL': 'virus_host_growth_cell',
                                           'VIRUS_HOST_SPECIES': 'virus_host_species',
                                           'VIRUS_ISOLATE': 'virus_isolate',
                                           'VIRUS_TYPE': 'virus_type'},
                            'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                           'ORDER': 12,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                               'EMPTY': {'NULLABLE': True,
                                                         'ORDER': 11,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 80},
                                               'ENTITY_ASSEMBLY_ID': {'NULLABLE': False,
                                                                      'ORDER': 9,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                               'ENVELOPED': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                               'ICTVDB_ID': {'NULLABLE': True,
                                                             'ORDER': 8,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                               'ID': {'NULLABLE': False,
                                                      'ORDER': 2,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'VIRUS_HOST_CATEGORY': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                               'VIRUS_HOST_GROWTH_CELL': {'NULLABLE': True,
                                                                          'ORDER': 5,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 80},
                                               'VIRUS_HOST_SPECIES': {'NULLABLE': True,
                                                                      'ORDER': 4,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                               'VIRUS_ISOLATE': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                               'VIRUS_TYPE': {'NULLABLE': True,
                                                              'ORDER': 6,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80}},
                            'ATTRIBUTE_MAP': {'DETAILS': ('em_virus_entity', 'details', None, None),
                                              'EMPTY': ('em_virus_entity', 'empty', None, None),
                                              'ENTITY_ASSEMBLY_ID': ('em_virus_entity', 'entity_assembly_id', None, None),
                                              'ENVELOPED': ('em_virus_entity', 'enveloped', None, None),
                                              'ICTVDB_ID': ('em_virus_entity', 'ictvdb_id', None, None),
                                              'ID': ('em_virus_entity', 'id', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'VIRUS_HOST_CATEGORY': ('em_virus_entity', 'virus_host_category', None, None),
                                              'VIRUS_HOST_GROWTH_CELL': ('em_virus_entity',
                                                                         'virus_host_growth_cell',
                                                                         None,
                                                                         None),
                                              'VIRUS_HOST_SPECIES': ('em_virus_entity', 'virus_host_species', None, None),
                                              'VIRUS_ISOLATE': ('em_virus_entity', 'virus_isolate', None, None),
                                              'VIRUS_TYPE': ('em_virus_entity', 'virus_type', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID', 'ENTITY_ASSEMBLY_ID'),
                                               'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'em_virus_entity': {'ATTRIBUTES': ('id', 'entity_assembly_id'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'EM_VIRUS_ENTITY',
                            'TABLE_NAME': 'em_virus_entity',
                            'TABLE_TYPE': 'transactional'},
        'EM_VITRIFICATION': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                            'CRYOGEN_NAME': 'cryogen_name',
                                            'DETAILS': 'details',
                                            'ENTRY_ID': 'entry_id',
                                            'HUMIDITY': 'humidity',
                                            'ID': 'id',
                                            'INSTRUMENT': 'instrument',
                                            'METHOD': 'method',
                                            'SAMPLE_PREPARATION_ID': 'sample_preparation_id',
                                            'STRUCTURE_ID': 'Structure_ID',
                                            'TEMP': 'temp',
                                            'TIME_RESOLVED_STATE': 'time_resolved_state'},
                             'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': True,
                                                                'ORDER': 11,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                'CRYOGEN_NAME': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                                'DETAILS': {'NULLABLE': True,
                                                            'ORDER': 12,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 511},
                                                'ENTRY_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                                'HUMIDITY': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 80},
                                                'ID': {'NULLABLE': False,
                                                       'ORDER': 3,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                                'INSTRUMENT': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                'METHOD': {'NULLABLE': True,
                                                           'ORDER': 9,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 1023},
                                                'SAMPLE_PREPARATION_ID': {'NULLABLE': True,
                                                                          'ORDER': 4,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                'STRUCTURE_ID': {'NULLABLE': False,
                                                                 'ORDER': 1,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                'TEMP': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                                'TIME_RESOLVED_STATE': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200}},
                             'ATTRIBUTE_MAP': {'CITATION_ID': ('em_vitrification', 'citation_id', None, None),
                                               'CRYOGEN_NAME': ('em_vitrification', 'cryogen_name', None, None),
                                               'DETAILS': ('em_vitrification', 'details', None, None),
                                               'ENTRY_ID': ('em_vitrification', 'entry_id', None, None),
                                               'HUMIDITY': ('em_vitrification', 'humidity', None, None),
                                               'ID': ('em_vitrification', 'id', None, None),
                                               'INSTRUMENT': ('em_vitrification', 'instrument', None, None),
                                               'METHOD': ('em_vitrification', 'method', None, None),
                                               'SAMPLE_PREPARATION_ID': ('em_vitrification',
                                                                         'sample_preparation_id',
                                                                         None,
                                                                         None),
                                               'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                               'TEMP': ('em_vitrification', 'temp', None, None),
                                               'TIME_RESOLVED_STATE': ('em_vitrification',
                                                                       'time_resolved_state',
                                                                       None,
                                                                       None)},
                             'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                         's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                             'MAP_MERGE_INDICES': {'em_vitrification': {'ATTRIBUTES': ('entry_id', 'id'),
                                                                        'TYPE': 'EQUI-JOIN'}},
                             'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                             'TABLE_ID': 'EM_VITRIFICATION',
                             'TABLE_NAME': 'em_vitrification',
                             'TABLE_TYPE': 'transactional'},
        'ENTITY': {'ATTRIBUTES': {'DETAILS': 'details',
                                  'FORMULA_WEIGHT': 'formula_weight',
                                  'ID': 'id',
                                  'PDBX_DESCRIPTION': 'pdbx_description',
                                  'PDBX_EC': 'pdbx_ec',
                                  'PDBX_FORMULA_WEIGHT_EXPTL': 'pdbx_formula_weight_exptl',
                                  'PDBX_FORMULA_WEIGHT_EXPTL_METHOD': 'pdbx_formula_weight_exptl_method',
                                  'PDBX_FRAGMENT': 'pdbx_fragment',
                                  'PDBX_MODIFICATION': 'pdbx_modification',
                                  'PDBX_MUTATION': 'pdbx_mutation',
                                  'PDBX_NUMBER_OF_MOLECULES': 'pdbx_number_of_molecules',
                                  'PDBX_PARENT_ENTITY_ID': 'pdbx_parent_entity_id',
                                  'PDBX_TARGET_ID': 'pdbx_target_id',
                                  'SRC_METHOD': 'src_method',
                                  'STRUCTURE_ID': 'Structure_ID',
                                  'TYPE': 'type'},
                   'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 1023},
                                      'FORMULA_WEIGHT': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                      'ID': {'NULLABLE': False,
                                             'ORDER': 4,
                                             'PRECISION': 0,
                                             'PRIMARY_KEY': True,
                                             'SQL_TYPE': 'VARCHAR',
                                             'WIDTH': 10},
                                      'PDBX_DESCRIPTION': {'NULLABLE': True,
                                                           'ORDER': 7,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 1023},
                                      'PDBX_EC': {'NULLABLE': True,
                                                  'ORDER': 12,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 80},
                                      'PDBX_FORMULA_WEIGHT_EXPTL': {'NULLABLE': True,
                                                                    'ORDER': 14,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                      'PDBX_FORMULA_WEIGHT_EXPTL_METHOD': {'NULLABLE': True,
                                                                           'ORDER': 15,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80},
                                      'PDBX_FRAGMENT': {'NULLABLE': True,
                                                        'ORDER': 11,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 255},
                                      'PDBX_MODIFICATION': {'NULLABLE': True,
                                                            'ORDER': 13,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                      'PDBX_MUTATION': {'NULLABLE': True,
                                                        'ORDER': 10,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 255},
                                      'PDBX_NUMBER_OF_MOLECULES': {'NULLABLE': True,
                                                                   'ORDER': 8,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'PDBX_PARENT_ENTITY_ID': {'NULLABLE': True,
                                                                'ORDER': 9,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                      'PDBX_TARGET_ID': {'NULLABLE': True,
                                                         'ORDER': 16,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                      'SRC_METHOD': {'NULLABLE': True,
                                                     'ORDER': 5,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                      'TYPE': {'NULLABLE': True,
                                               'ORDER': 6,
                                               'PRECISION': 0,
                                               'PRIMARY_KEY': False,
                                               'SQL_TYPE': 'VARCHAR',
                                               'WIDTH': 12}},
                   'ATTRIBUTE_MAP': {'DETAILS': ('entity', 'details', None, None),
                                     'FORMULA_WEIGHT': ('entity', 'formula_weight', None, None),
                                     'ID': ('entity', 'id', None, None),
                                     'PDBX_DESCRIPTION': ('entity', 'pdbx_description', None, None),
                                     'PDBX_EC': ('entity', 'pdbx_ec', None, None),
                                     'PDBX_FORMULA_WEIGHT_EXPTL': ('entity', 'pdbx_formula_weight_exptl', None, None),
                                     'PDBX_FORMULA_WEIGHT_EXPTL_METHOD': ('entity',
                                                                          'pdbx_formula_weight_exptl_method',
                                                                          None,
                                                                          None),
                                     'PDBX_FRAGMENT': ('entity', 'pdbx_fragment', None, None),
                                     'PDBX_MODIFICATION': ('entity', 'pdbx_modification', None, None),
                                     'PDBX_MUTATION': ('entity', 'pdbx_mutation', None, None),
                                     'PDBX_NUMBER_OF_MOLECULES': ('entity', 'pdbx_number_of_molecules', None, None),
                                     'PDBX_PARENT_ENTITY_ID': ('entity', 'pdbx_parent_entity_id', None, None),
                                     'PDBX_TARGET_ID': ('entity', 'pdbx_target_id', None, None),
                                     'SRC_METHOD': ('entity', 'src_method', None, None),
                                     'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                     'TYPE': ('entity', 'type', None, None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                   'MAP_MERGE_INDICES': {'entity': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'ENTITY',
                   'TABLE_NAME': 'entity',
                   'TABLE_TYPE': 'transactional'},
        'ENTITY_KEYWORDS': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                           'PDBX_EC': 'pdbx_ec',
                                           'PDBX_FRAGMENT': 'pdbx_fragment',
                                           'PDBX_MUTATION': 'pdbx_mutation',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'TEXT': 'text'},
                            'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'PDBX_EC': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                               'PDBX_FRAGMENT': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                               'PDBX_MUTATION': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'TEXT': {'NULLABLE': True,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200}},
                            'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_keywords', 'entity_id', None, None),
                                              'PDBX_EC': ('entity_keywords', 'pdbx_ec', None, None),
                                              'PDBX_FRAGMENT': ('entity_keywords', 'pdbx_fragment', None, None),
                                              'PDBX_MUTATION': ('entity_keywords', 'pdbx_mutation', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'TEXT': ('entity_keywords', 'text', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'entity_keywords': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'ENTITY_KEYWORDS',
                            'TABLE_NAME': 'entity_keywords',
                            'TABLE_TYPE': 'transactional'},
        'ENTITY_LINK': {'ATTRIBUTES': {'DETAILS': 'details',
                                       'ENTITY_ID_1': 'entity_id_1',
                                       'ENTITY_ID_2': 'entity_id_2',
                                       'ENTITY_SEQ_NUM_1': 'entity_seq_num_1',
                                       'ENTITY_SEQ_NUM_2': 'entity_seq_num_2',
                                       'LINK_ID': 'link_id',
                                       'STRUCTURE_ID': 'Structure_ID'},
                        'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                       'ORDER': 5,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 200},
                                           'ENTITY_ID_1': {'NULLABLE': True,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                           'ENTITY_ID_2': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                           'ENTITY_SEQ_NUM_1': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                           'ENTITY_SEQ_NUM_2': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                           'LINK_ID': {'NULLABLE': False,
                                                       'ORDER': 2,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10}},
                        'ATTRIBUTE_MAP': {'DETAILS': ('entity_link', 'details', None, None),
                                          'ENTITY_ID_1': ('entity_link', 'entity_id_1', None, None),
                                          'ENTITY_ID_2': ('entity_link', 'entity_id_2', None, None),
                                          'ENTITY_SEQ_NUM_1': ('entity_link', 'entity_seq_num_1', None, None),
                                          'ENTITY_SEQ_NUM_2': ('entity_link', 'entity_seq_num_2', None, None),
                                          'LINK_ID': ('entity_link', 'link_id', None, None),
                                          'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'LINK_ID'), 'TYPE': 'UNIQUE'},
                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                        'MAP_MERGE_INDICES': {'entity_link': {'ATTRIBUTES': ('link_id',), 'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'ENTITY_LINK',
                        'TABLE_NAME': 'entity_link',
                        'TABLE_TYPE': 'transactional'},
        'ENTITY_NAME_COM': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id', 'NAME': 'name', 'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'NAME': {'NULLABLE': True,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 1023},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_name_com', 'entity_id', None, None),
                                              'NAME': ('entity_name_com', 'name', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'entity_name_com': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'ENTITY_NAME_COM',
                            'TABLE_NAME': 'entity_name_com',
                            'TABLE_TYPE': 'transactional'},
        'ENTITY_NAME_SYS': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                           'NAME': 'name',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'SYSTEM': 'system'},
                            'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                             'ORDER': 2,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'NAME': {'NULLABLE': True,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'SYSTEM': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200}},
                            'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_name_sys', 'entity_id', None, None),
                                              'NAME': ('entity_name_sys', 'name', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'SYSTEM': ('entity_name_sys', 'system', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'entity_name_sys': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'ENTITY_NAME_SYS',
                            'TABLE_NAME': 'entity_name_sys',
                            'TABLE_TYPE': 'transactional'},
        'ENTITY_POLY': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                       'NSTD_CHIRALITY': 'nstd_chirality',
                                       'NSTD_LINKAGE': 'nstd_linkage',
                                       'NSTD_MONOMER': 'nstd_monomer',
                                       'NUMBER_OF_MONOMERS': 'number_of_monomers',
                                       'PDBX_SEQ_ONE_LETTER_CODE': 'pdbx_seq_one_letter_code',
                                       'PDBX_SEQ_ONE_LETTER_CODE_CAN': 'pdbx_seq_one_letter_code_can',
                                       'PDBX_STRAND_ID': 'pdbx_strand_id',
                                       'PDBX_TARGET_IDENTIFIER': 'pdbx_target_identifier',
                                       'STRUCTURE_ID': 'Structure_ID',
                                       'TYPE': 'type',
                                       'TYPE_DETAILS': 'type_details'},
                        'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                           'NSTD_CHIRALITY': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                           'NSTD_LINKAGE': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                           'NSTD_MONOMER': {'NULLABLE': True,
                                                            'ORDER': 5,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                           'NUMBER_OF_MONOMERS': {'NULLABLE': True,
                                                                  'ORDER': 6,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                           'PDBX_SEQ_ONE_LETTER_CODE': {'NULLABLE': True,
                                                                        'ORDER': 10,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 32000},
                                           'PDBX_SEQ_ONE_LETTER_CODE_CAN': {'NULLABLE': True,
                                                                            'ORDER': 11,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 16383},
                                           'PDBX_STRAND_ID': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 128},
                                           'PDBX_TARGET_IDENTIFIER': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 128},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                           'TYPE': {'NULLABLE': True,
                                                    'ORDER': 7,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 80},
                                           'TYPE_DETAILS': {'NULLABLE': True,
                                                            'ORDER': 8,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200}},
                        'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_poly', 'entity_id', None, None),
                                          'NSTD_CHIRALITY': ('entity_poly', 'nstd_chirality', None, None),
                                          'NSTD_LINKAGE': ('entity_poly', 'nstd_linkage', None, None),
                                          'NSTD_MONOMER': ('entity_poly', 'nstd_monomer', None, None),
                                          'NUMBER_OF_MONOMERS': ('entity_poly', 'number_of_monomers', None, None),
                                          'PDBX_SEQ_ONE_LETTER_CODE': ('entity_poly',
                                                                       'pdbx_seq_one_letter_code',
                                                                       None,
                                                                       None),
                                          'PDBX_SEQ_ONE_LETTER_CODE_CAN': ('entity_poly',
                                                                           'pdbx_seq_one_letter_code_can',
                                                                           None,
                                                                           None),
                                          'PDBX_STRAND_ID': ('entity_poly', 'pdbx_strand_id', None, None),
                                          'PDBX_TARGET_IDENTIFIER': ('entity_poly', 'pdbx_target_identifier', None, None),
                                          'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                          'TYPE': ('entity_poly', 'type', None, None),
                                          'TYPE_DETAILS': ('entity_poly', 'type_details', None, None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                        'MAP_MERGE_INDICES': {'entity_poly': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'ENTITY_POLY',
                        'TABLE_NAME': 'entity_poly',
                        'TABLE_TYPE': 'transactional'},
        'ENTITY_POLY_SEQ': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                           'HETERO': 'hetero',
                                           'MON_ID': 'mon_id',
                                           'NUM': 'num',
                                           'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                               'HETERO': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                               'MON_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                               'NUM': {'NULLABLE': False,
                                                       'ORDER': 5,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'INT',
                                                       'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_poly_seq', 'entity_id', None, None),
                                              'HETERO': ('entity_poly_seq', 'hetero', None, None),
                                              'MON_ID': ('entity_poly_seq', 'mon_id', None, None),
                                              'NUM': ('entity_poly_seq', 'num', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'MON_ID', 'ENTITY_ID', 'NUM'),
                                               'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'entity_poly_seq': {'ATTRIBUTES': ('mon_id', 'entity_id', 'num'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'ENTITY_POLY_SEQ',
                            'TABLE_NAME': 'entity_poly_seq',
                            'TABLE_TYPE': 'transactional'},
        'ENTITY_SRC_GEN': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                          'EXPRESSION_SYSTEM_ID': 'expression_system_id',
                                          'GENE_SRC_COMMON_NAME': 'gene_src_common_name',
                                          'GENE_SRC_DETAILS': 'gene_src_details',
                                          'GENE_SRC_DEV_STAGE': 'gene_src_dev_stage',
                                          'GENE_SRC_GENUS': 'gene_src_genus',
                                          'GENE_SRC_SPECIES': 'gene_src_species',
                                          'GENE_SRC_STRAIN': 'gene_src_strain',
                                          'GENE_SRC_TISSUE': 'gene_src_tissue',
                                          'GENE_SRC_TISSUE_FRACTION': 'gene_src_tissue_fraction',
                                          'HOST_ORG_COMMON_NAME': 'host_org_common_name',
                                          'HOST_ORG_DETAILS': 'host_org_details',
                                          'HOST_ORG_GENUS': 'host_org_genus',
                                          'HOST_ORG_SPECIES': 'host_org_species',
                                          'HOST_ORG_STRAIN': 'host_org_strain',
                                          'PDBX_DESCRIPTION': 'pdbx_description',
                                          'PDBX_GENE_SRC_ATCC': 'pdbx_gene_src_atcc',
                                          'PDBX_GENE_SRC_CELL': 'pdbx_gene_src_cell',
                                          'PDBX_GENE_SRC_CELLULAR_LOCATION': 'pdbx_gene_src_cellular_location',
                                          'PDBX_GENE_SRC_CELL_LINE': 'pdbx_gene_src_cell_line',
                                          'PDBX_GENE_SRC_FRAGMENT': 'pdbx_gene_src_fragment',
                                          'PDBX_GENE_SRC_GENE': 'pdbx_gene_src_gene',
                                          'PDBX_GENE_SRC_NCBI_TAXONOMY_ID': 'pdbx_gene_src_ncbi_taxonomy_id',
                                          'PDBX_GENE_SRC_ORGAN': 'pdbx_gene_src_organ',
                                          'PDBX_GENE_SRC_ORGANELLE': 'pdbx_gene_src_organelle',
                                          'PDBX_GENE_SRC_PLASMID': 'pdbx_gene_src_plasmid',
                                          'PDBX_GENE_SRC_PLASMID_NAME': 'pdbx_gene_src_plasmid_name',
                                          'PDBX_GENE_SRC_SCIENTIFIC_NAME': 'pdbx_gene_src_scientific_name',
                                          'PDBX_GENE_SRC_VARIANT': 'pdbx_gene_src_variant',
                                          'PDBX_HOST_ORG_ATCC': 'pdbx_host_org_atcc',
                                          'PDBX_HOST_ORG_CELL': 'pdbx_host_org_cell',
                                          'PDBX_HOST_ORG_CELLULAR_LOCATION': 'pdbx_host_org_cellular_location',
                                          'PDBX_HOST_ORG_CELL_LINE': 'pdbx_host_org_cell_line',
                                          'PDBX_HOST_ORG_CULTURE_COLLECTION': 'pdbx_host_org_culture_collection',
                                          'PDBX_HOST_ORG_GENE': 'pdbx_host_org_gene',
                                          'PDBX_HOST_ORG_NCBI_TAXONOMY_ID': 'pdbx_host_org_ncbi_taxonomy_id',
                                          'PDBX_HOST_ORG_ORGAN': 'pdbx_host_org_organ',
                                          'PDBX_HOST_ORG_ORGANELLE': 'pdbx_host_org_organelle',
                                          'PDBX_HOST_ORG_SCIENTIFIC_NAME': 'pdbx_host_org_scientific_name',
                                          'PDBX_HOST_ORG_STRAIN': 'pdbx_host_org_strain',
                                          'PDBX_HOST_ORG_TISSUE': 'pdbx_host_org_tissue',
                                          'PDBX_HOST_ORG_TISSUE_FRACTION': 'pdbx_host_org_tissue_fraction',
                                          'PDBX_HOST_ORG_VARIANT': 'pdbx_host_org_variant',
                                          'PDBX_HOST_ORG_VECTOR': 'pdbx_host_org_vector',
                                          'PDBX_HOST_ORG_VECTOR_TYPE': 'pdbx_host_org_vector_type',
                                          'PLASMID_DETAILS': 'plasmid_details',
                                          'PLASMID_NAME': 'plasmid_name',
                                          'START_CONSTRUCT_ID': 'start_construct_id',
                                          'STRUCTURE_ID': 'Structure_ID'},
                           'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                            'ORDER': 2,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                              'EXPRESSION_SYSTEM_ID': {'NULLABLE': True,
                                                                       'ORDER': 45,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                              'GENE_SRC_COMMON_NAME': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                              'GENE_SRC_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 511},
                                              'GENE_SRC_DEV_STAGE': {'NULLABLE': True,
                                                                     'ORDER': 46,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                              'GENE_SRC_GENUS': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                              'GENE_SRC_SPECIES': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                              'GENE_SRC_STRAIN': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 511},
                                              'GENE_SRC_TISSUE': {'NULLABLE': True,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                              'GENE_SRC_TISSUE_FRACTION': {'NULLABLE': True,
                                                                           'ORDER': 9,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200},
                                              'HOST_ORG_COMMON_NAME': {'NULLABLE': True,
                                                                       'ORDER': 31,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                              'HOST_ORG_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 32,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                              'HOST_ORG_GENUS': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                              'HOST_ORG_SPECIES': {'NULLABLE': True,
                                                                   'ORDER': 11,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                              'HOST_ORG_STRAIN': {'NULLABLE': True,
                                                                  'ORDER': 33,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                              'PDBX_DESCRIPTION': {'NULLABLE': True,
                                                                   'ORDER': 30,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 4095},
                                              'PDBX_GENE_SRC_ATCC': {'NULLABLE': True,
                                                                     'ORDER': 17,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                              'PDBX_GENE_SRC_CELL': {'NULLABLE': True,
                                                                     'ORDER': 22,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                              'PDBX_GENE_SRC_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                                  'ORDER': 23,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 200},
                                              'PDBX_GENE_SRC_CELL_LINE': {'NULLABLE': True,
                                                                          'ORDER': 16,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 200},
                                              'PDBX_GENE_SRC_FRAGMENT': {'NULLABLE': True,
                                                                         'ORDER': 12,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 200},
                                              'PDBX_GENE_SRC_GENE': {'NULLABLE': True,
                                                                     'ORDER': 13,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 511},
                                              'PDBX_GENE_SRC_NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                                 'ORDER': 48,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 80},
                                              'PDBX_GENE_SRC_ORGAN': {'NULLABLE': True,
                                                                      'ORDER': 18,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                              'PDBX_GENE_SRC_ORGANELLE': {'NULLABLE': True,
                                                                          'ORDER': 19,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 200},
                                              'PDBX_GENE_SRC_PLASMID': {'NULLABLE': True,
                                                                        'ORDER': 20,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                              'PDBX_GENE_SRC_PLASMID_NAME': {'NULLABLE': True,
                                                                             'ORDER': 21,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 200},
                                              'PDBX_GENE_SRC_SCIENTIFIC_NAME': {'NULLABLE': True,
                                                                                'ORDER': 14,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 200},
                                              'PDBX_GENE_SRC_VARIANT': {'NULLABLE': True,
                                                                        'ORDER': 15,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                              'PDBX_HOST_ORG_ATCC': {'NULLABLE': True,
                                                                     'ORDER': 38,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                              'PDBX_HOST_ORG_CELL': {'NULLABLE': True,
                                                                     'ORDER': 40,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                              'PDBX_HOST_ORG_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                                  'ORDER': 27,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 200},
                                              'PDBX_HOST_ORG_CELL_LINE': {'NULLABLE': True,
                                                                          'ORDER': 37,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 200},
                                              'PDBX_HOST_ORG_CULTURE_COLLECTION': {'NULLABLE': True,
                                                                                   'ORDER': 39,
                                                                                   'PRECISION': 0,
                                                                                   'PRIMARY_KEY': False,
                                                                                   'SQL_TYPE': 'VARCHAR',
                                                                                   'WIDTH': 200},
                                              'PDBX_HOST_ORG_GENE': {'NULLABLE': True,
                                                                     'ORDER': 24,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 200},
                                              'PDBX_HOST_ORG_NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                                 'ORDER': 49,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 80},
                                              'PDBX_HOST_ORG_ORGAN': {'NULLABLE': True,
                                                                      'ORDER': 25,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 200},
                                              'PDBX_HOST_ORG_ORGANELLE': {'NULLABLE': True,
                                                                          'ORDER': 26,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 200},
                                              'PDBX_HOST_ORG_SCIENTIFIC_NAME': {'NULLABLE': True,
                                                                                'ORDER': 41,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 200},
                                              'PDBX_HOST_ORG_STRAIN': {'NULLABLE': True,
                                                                       'ORDER': 28,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                              'PDBX_HOST_ORG_TISSUE': {'NULLABLE': True,
                                                                       'ORDER': 42,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                              'PDBX_HOST_ORG_TISSUE_FRACTION': {'NULLABLE': True,
                                                                                'ORDER': 29,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'VARCHAR',
                                                                                'WIDTH': 200},
                                              'PDBX_HOST_ORG_VARIANT': {'NULLABLE': True,
                                                                        'ORDER': 36,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                              'PDBX_HOST_ORG_VECTOR': {'NULLABLE': True,
                                                                       'ORDER': 43,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                              'PDBX_HOST_ORG_VECTOR_TYPE': {'NULLABLE': True,
                                                                            'ORDER': 44,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                              'PLASMID_DETAILS': {'NULLABLE': True,
                                                                  'ORDER': 34,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 511},
                                              'PLASMID_NAME': {'NULLABLE': True,
                                                               'ORDER': 35,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                              'START_CONSTRUCT_ID': {'NULLABLE': True,
                                                                     'ORDER': 47,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_src_gen', 'entity_id', None, None),
                                             'EXPRESSION_SYSTEM_ID': ('entity_src_gen', 'expression_system_id', None, None),
                                             'GENE_SRC_COMMON_NAME': ('entity_src_gen', 'gene_src_common_name', None, None),
                                             'GENE_SRC_DETAILS': ('entity_src_gen', 'gene_src_details', None, None),
                                             'GENE_SRC_DEV_STAGE': ('entity_src_gen', 'gene_src_dev_stage', None, None),
                                             'GENE_SRC_GENUS': ('entity_src_gen', 'gene_src_genus', None, None),
                                             'GENE_SRC_SPECIES': ('entity_src_gen', 'gene_src_species', None, None),
                                             'GENE_SRC_STRAIN': ('entity_src_gen', 'gene_src_strain', None, None),
                                             'GENE_SRC_TISSUE': ('entity_src_gen', 'gene_src_tissue', None, None),
                                             'GENE_SRC_TISSUE_FRACTION': ('entity_src_gen',
                                                                          'gene_src_tissue_fraction',
                                                                          None,
                                                                          None),
                                             'HOST_ORG_COMMON_NAME': ('entity_src_gen', 'host_org_common_name', None, None),
                                             'HOST_ORG_DETAILS': ('entity_src_gen', 'host_org_details', None, None),
                                             'HOST_ORG_GENUS': ('entity_src_gen', 'host_org_genus', None, None),
                                             'HOST_ORG_SPECIES': ('entity_src_gen', 'host_org_species', None, None),
                                             'HOST_ORG_STRAIN': ('entity_src_gen', 'host_org_strain', None, None),
                                             'PDBX_DESCRIPTION': ('entity_src_gen', 'pdbx_description', None, None),
                                             'PDBX_GENE_SRC_ATCC': ('entity_src_gen', 'pdbx_gene_src_atcc', None, None),
                                             'PDBX_GENE_SRC_CELL': ('entity_src_gen', 'pdbx_gene_src_cell', None, None),
                                             'PDBX_GENE_SRC_CELLULAR_LOCATION': ('entity_src_gen',
                                                                                 'pdbx_gene_src_cellular_location',
                                                                                 None,
                                                                                 None),
                                             'PDBX_GENE_SRC_CELL_LINE': ('entity_src_gen',
                                                                         'pdbx_gene_src_cell_line',
                                                                         None,
                                                                         None),
                                             'PDBX_GENE_SRC_FRAGMENT': ('entity_src_gen',
                                                                        'pdbx_gene_src_fragment',
                                                                        None,
                                                                        None),
                                             'PDBX_GENE_SRC_GENE': ('entity_src_gen', 'pdbx_gene_src_gene', None, None),
                                             'PDBX_GENE_SRC_NCBI_TAXONOMY_ID': ('entity_src_gen',
                                                                                'pdbx_gene_src_ncbi_taxonomy_id',
                                                                                None,
                                                                                None),
                                             'PDBX_GENE_SRC_ORGAN': ('entity_src_gen', 'pdbx_gene_src_organ', None, None),
                                             'PDBX_GENE_SRC_ORGANELLE': ('entity_src_gen',
                                                                         'pdbx_gene_src_organelle',
                                                                         None,
                                                                         None),
                                             'PDBX_GENE_SRC_PLASMID': ('entity_src_gen',
                                                                       'pdbx_gene_src_plasmid',
                                                                       None,
                                                                       None),
                                             'PDBX_GENE_SRC_PLASMID_NAME': ('entity_src_gen',
                                                                            'pdbx_gene_src_plasmid_name',
                                                                            None,
                                                                            None),
                                             'PDBX_GENE_SRC_SCIENTIFIC_NAME': ('entity_src_gen',
                                                                               'pdbx_gene_src_scientific_name',
                                                                               None,
                                                                               None),
                                             'PDBX_GENE_SRC_VARIANT': ('entity_src_gen',
                                                                       'pdbx_gene_src_variant',
                                                                       None,
                                                                       None),
                                             'PDBX_HOST_ORG_ATCC': ('entity_src_gen', 'pdbx_host_org_atcc', None, None),
                                             'PDBX_HOST_ORG_CELL': ('entity_src_gen', 'pdbx_host_org_cell', None, None),
                                             'PDBX_HOST_ORG_CELLULAR_LOCATION': ('entity_src_gen',
                                                                                 'pdbx_host_org_cellular_location',
                                                                                 None,
                                                                                 None),
                                             'PDBX_HOST_ORG_CELL_LINE': ('entity_src_gen',
                                                                         'pdbx_host_org_cell_line',
                                                                         None,
                                                                         None),
                                             'PDBX_HOST_ORG_CULTURE_COLLECTION': ('entity_src_gen',
                                                                                  'pdbx_host_org_culture_collection',
                                                                                  None,
                                                                                  None),
                                             'PDBX_HOST_ORG_GENE': ('entity_src_gen', 'pdbx_host_org_gene', None, None),
                                             'PDBX_HOST_ORG_NCBI_TAXONOMY_ID': ('entity_src_gen',
                                                                                'pdbx_host_org_ncbi_taxonomy_id',
                                                                                None,
                                                                                None),
                                             'PDBX_HOST_ORG_ORGAN': ('entity_src_gen', 'pdbx_host_org_organ', None, None),
                                             'PDBX_HOST_ORG_ORGANELLE': ('entity_src_gen',
                                                                         'pdbx_host_org_organelle',
                                                                         None,
                                                                         None),
                                             'PDBX_HOST_ORG_SCIENTIFIC_NAME': ('entity_src_gen',
                                                                               'pdbx_host_org_scientific_name',
                                                                               None,
                                                                               None),
                                             'PDBX_HOST_ORG_STRAIN': ('entity_src_gen', 'pdbx_host_org_strain', None, None),
                                             'PDBX_HOST_ORG_TISSUE': ('entity_src_gen', 'pdbx_host_org_tissue', None, None),
                                             'PDBX_HOST_ORG_TISSUE_FRACTION': ('entity_src_gen',
                                                                               'pdbx_host_org_tissue_fraction',
                                                                               None,
                                                                               None),
                                             'PDBX_HOST_ORG_VARIANT': ('entity_src_gen',
                                                                       'pdbx_host_org_variant',
                                                                       None,
                                                                       None),
                                             'PDBX_HOST_ORG_VECTOR': ('entity_src_gen', 'pdbx_host_org_vector', None, None),
                                             'PDBX_HOST_ORG_VECTOR_TYPE': ('entity_src_gen',
                                                                           'pdbx_host_org_vector_type',
                                                                           None,
                                                                           None),
                                             'PLASMID_DETAILS': ('entity_src_gen', 'plasmid_details', None, None),
                                             'PLASMID_NAME': ('entity_src_gen', 'plasmid_name', None, None),
                                             'START_CONSTRUCT_ID': ('entity_src_gen', 'start_construct_id', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'entity_src_gen': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'ENTITY_SRC_GEN',
                           'TABLE_NAME': 'entity_src_gen',
                           'TABLE_TYPE': 'transactional'},
        'ENTITY_SRC_NAT': {'ATTRIBUTES': {'COMMON_NAME': 'common_name',
                                          'DETAILS': 'details',
                                          'ENTITY_ID': 'entity_id',
                                          'GENUS': 'genus',
                                          'PDBX_ATCC': 'pdbx_atcc',
                                          'PDBX_CELL': 'pdbx_cell',
                                          'PDBX_CELLULAR_LOCATION': 'pdbx_cellular_location',
                                          'PDBX_CELL_LINE': 'pdbx_cell_line',
                                          'PDBX_FRAGMENT': 'pdbx_fragment',
                                          'PDBX_NCBI_TAXONOMY_ID': 'pdbx_ncbi_taxonomy_id',
                                          'PDBX_ORGAN': 'pdbx_organ',
                                          'PDBX_ORGANELLE': 'pdbx_organelle',
                                          'PDBX_ORGANISM_SCIENTIFIC': 'pdbx_organism_scientific',
                                          'PDBX_PLASMID_DETAILS': 'pdbx_plasmid_details',
                                          'PDBX_PLASMID_NAME': 'pdbx_plasmid_name',
                                          'PDBX_SECRETION': 'pdbx_secretion',
                                          'PDBX_VARIANT': 'pdbx_variant',
                                          'SPECIES': 'species',
                                          'STRAIN': 'strain',
                                          'STRUCTURE_ID': 'Structure_ID',
                                          'TISSUE': 'tissue',
                                          'TISSUE_FRACTION': 'tissue_fraction'},
                           'ATTRIBUTE_INFO': {'COMMON_NAME': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                              'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 4095},
                                              'ENTITY_ID': {'NULLABLE': False,
                                                            'ORDER': 2,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                              'GENUS': {'NULLABLE': True,
                                                        'ORDER': 5,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                              'PDBX_ATCC': {'NULLABLE': True,
                                                            'ORDER': 15,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                              'PDBX_CELL': {'NULLABLE': True,
                                                            'ORDER': 19,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                              'PDBX_CELLULAR_LOCATION': {'NULLABLE': True,
                                                                         'ORDER': 16,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 200},
                                              'PDBX_CELL_LINE': {'NULLABLE': True,
                                                                 'ORDER': 14,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                              'PDBX_FRAGMENT': {'NULLABLE': True,
                                                                'ORDER': 12,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                              'PDBX_NCBI_TAXONOMY_ID': {'NULLABLE': True,
                                                                        'ORDER': 22,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 80},
                                              'PDBX_ORGAN': {'NULLABLE': True,
                                                             'ORDER': 17,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                              'PDBX_ORGANELLE': {'NULLABLE': True,
                                                                 'ORDER': 18,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                              'PDBX_ORGANISM_SCIENTIFIC': {'NULLABLE': True,
                                                                           'ORDER': 10,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200},
                                              'PDBX_PLASMID_DETAILS': {'NULLABLE': True,
                                                                       'ORDER': 21,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 200},
                                              'PDBX_PLASMID_NAME': {'NULLABLE': True,
                                                                    'ORDER': 20,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 200},
                                              'PDBX_SECRETION': {'NULLABLE': True,
                                                                 'ORDER': 11,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                              'PDBX_VARIANT': {'NULLABLE': True,
                                                               'ORDER': 13,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                              'SPECIES': {'NULLABLE': True,
                                                          'ORDER': 6,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'STRAIN': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 1023},
                                              'STRUCTURE_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'TISSUE': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                              'TISSUE_FRACTION': {'NULLABLE': True,
                                                                  'ORDER': 9,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200}},
                           'ATTRIBUTE_MAP': {'COMMON_NAME': ('entity_src_nat', 'common_name', None, None),
                                             'DETAILS': ('entity_src_nat', 'details', None, None),
                                             'ENTITY_ID': ('entity_src_nat', 'entity_id', None, None),
                                             'GENUS': ('entity_src_nat', 'genus', None, None),
                                             'PDBX_ATCC': ('entity_src_nat', 'pdbx_atcc', None, None),
                                             'PDBX_CELL': ('entity_src_nat', 'pdbx_cell', None, None),
                                             'PDBX_CELLULAR_LOCATION': ('entity_src_nat',
                                                                        'pdbx_cellular_location',
                                                                        None,
                                                                        None),
                                             'PDBX_CELL_LINE': ('entity_src_nat', 'pdbx_cell_line', None, None),
                                             'PDBX_FRAGMENT': ('entity_src_nat', 'pdbx_fragment', None, None),
                                             'PDBX_NCBI_TAXONOMY_ID': ('entity_src_nat',
                                                                       'pdbx_ncbi_taxonomy_id',
                                                                       None,
                                                                       None),
                                             'PDBX_ORGAN': ('entity_src_nat', 'pdbx_organ', None, None),
                                             'PDBX_ORGANELLE': ('entity_src_nat', 'pdbx_organelle', None, None),
                                             'PDBX_ORGANISM_SCIENTIFIC': ('entity_src_nat',
                                                                          'pdbx_organism_scientific',
                                                                          None,
                                                                          None),
                                             'PDBX_PLASMID_DETAILS': ('entity_src_nat', 'pdbx_plasmid_details', None, None),
                                             'PDBX_PLASMID_NAME': ('entity_src_nat', 'pdbx_plasmid_name', None, None),
                                             'PDBX_SECRETION': ('entity_src_nat', 'pdbx_secretion', None, None),
                                             'PDBX_VARIANT': ('entity_src_nat', 'pdbx_variant', None, None),
                                             'SPECIES': ('entity_src_nat', 'species', None, None),
                                             'STRAIN': ('entity_src_nat', 'strain', None, None),
                                             'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                             'TISSUE': ('entity_src_nat', 'tissue', None, None),
                                             'TISSUE_FRACTION': ('entity_src_nat', 'tissue_fraction', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'entity_src_nat': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                           'TABLE_ID': 'ENTITY_SRC_NAT',
                           'TABLE_NAME': 'entity_src_nat',
                           'TABLE_TYPE': 'transactional'},
        'ENTRY': {'ATTRIBUTES': {'ID': 'id', 'PDBX_DOI': 'pdbx_DOI', 'PDBX_PC': 'pdbx_pc', 'STRUCTURE_ID': 'Structure_ID'},
                  'ATTRIBUTE_INFO': {'ID': {'NULLABLE': False,
                                            'ORDER': 2,
                                            'PRECISION': 0,
                                            'PRIMARY_KEY': True,
                                            'SQL_TYPE': 'VARCHAR',
                                            'WIDTH': 10},
                                     'PDBX_DOI': {'NULLABLE': True,
                                                  'ORDER': 3,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 10},
                                     'PDBX_PC': {'NULLABLE': True,
                                                 'ORDER': 4,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 10},
                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                      'ORDER': 1,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10}},
                  'ATTRIBUTE_MAP': {'ID': ('entry', 'id', None, None),
                                    'PDBX_DOI': ('entry', 'pdbx_DOI', None, None),
                                    'PDBX_PC': ('entry', 'pdbx_pc', None, None),
                                    'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                  'MAP_MERGE_INDICES': {'entry': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                  'TABLE_ID': 'ENTRY',
                  'TABLE_NAME': 'entry',
                  'TABLE_TYPE': 'transactional'},
        'ENTRY_LINK': {'ATTRIBUTES': {'DETAILS': 'details',
                                      'ENTRY_ID': 'entry_id',
                                      'ID': 'id',
                                      'STRUCTURE_ID': 'Structure_ID'},
                       'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                      'ORDER': 4,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 200},
                                          'ENTRY_ID': {'NULLABLE': False,
                                                       'ORDER': 2,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 10},
                                          'ID': {'NULLABLE': False,
                                                 'ORDER': 3,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': True,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 10},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10}},
                       'ATTRIBUTE_MAP': {'DETAILS': ('entry_link', 'details', None, None),
                                         'ENTRY_ID': ('entry_link', 'entry_id', None, None),
                                         'ID': ('entry_link', 'id', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'entry_link': {'ATTRIBUTES': ('entry_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'ENTRY_LINK',
                       'TABLE_NAME': 'entry_link',
                       'TABLE_TYPE': 'transactional'},
        'EXPTL': {'ATTRIBUTES': {'ABSORPT_COEFFICIENT_MU': 'absorpt_coefficient_mu',
                                 'ABSORPT_CORRECTION_TYPE': 'absorpt_correction_type',
                                 'ABSORPT_CORRECTION_T_MAX': 'absorpt_correction_T_max',
                                 'ABSORPT_CORRECTION_T_MIN': 'absorpt_correction_T_min',
                                 'ABSORPT_PROCESS_DETAILS': 'absorpt_process_details',
                                 'CRYSTALS_NUMBER': 'crystals_number',
                                 'DETAILS': 'details',
                                 'ENTRY_ID': 'entry_id',
                                 'METHOD': 'method',
                                 'METHOD_DETAILS': 'method_details',
                                 'STRUCTURE_ID': 'Structure_ID'},
                  'ATTRIBUTE_INFO': {'ABSORPT_COEFFICIENT_MU': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                     'ABSORPT_CORRECTION_TYPE': {'NULLABLE': True,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                     'ABSORPT_CORRECTION_T_MAX': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                     'ABSORPT_CORRECTION_T_MIN': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                     'ABSORPT_PROCESS_DETAILS': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                     'CRYSTALS_NUMBER': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                     'DETAILS': {'NULLABLE': True,
                                                 'ORDER': 9,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 1023},
                                     'ENTRY_ID': {'NULLABLE': False,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': True,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 10},
                                     'METHOD': {'NULLABLE': False,
                                                'ORDER': 10,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 80},
                                     'METHOD_DETAILS': {'NULLABLE': True,
                                                        'ORDER': 11,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                      'ORDER': 1,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10}},
                  'ATTRIBUTE_MAP': {'ABSORPT_COEFFICIENT_MU': ('exptl', 'absorpt_coefficient_mu', None, None),
                                    'ABSORPT_CORRECTION_TYPE': ('exptl', 'absorpt_correction_type', None, None),
                                    'ABSORPT_CORRECTION_T_MAX': ('exptl', 'absorpt_correction_T_max', None, None),
                                    'ABSORPT_CORRECTION_T_MIN': ('exptl', 'absorpt_correction_T_min', None, None),
                                    'ABSORPT_PROCESS_DETAILS': ('exptl', 'absorpt_process_details', None, None),
                                    'CRYSTALS_NUMBER': ('exptl', 'crystals_number', None, None),
                                    'DETAILS': ('exptl', 'details', None, None),
                                    'ENTRY_ID': ('exptl', 'entry_id', None, None),
                                    'METHOD': ('exptl', 'method', None, None),
                                    'METHOD_DETAILS': ('exptl', 'method_details', None, None),
                                    'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'METHOD'), 'TYPE': 'UNIQUE'},
                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                  'MAP_MERGE_INDICES': {'exptl': {'ATTRIBUTES': ('entry_id', 'method'), 'TYPE': 'EQUI-JOIN'}},
                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                  'TABLE_ID': 'EXPTL',
                  'TABLE_NAME': 'exptl',
                  'TABLE_TYPE': 'transactional'},
        'EXPTL_CRYSTAL': {'ATTRIBUTES': {'COLOUR': 'colour',
                                         'COLOUR_LUSTRE': 'colour_lustre',
                                         'COLOUR_MODIFIER': 'colour_modifier',
                                         'COLOUR_PRIMARY': 'colour_primary',
                                         'DENSITY_DIFFRN': 'density_diffrn',
                                         'DENSITY_MATTHEWS': 'density_Matthews',
                                         'DENSITY_MEAS': 'density_meas',
                                         'DENSITY_MEAS_ESD': 'density_meas_esd',
                                         'DENSITY_MEAS_GT': 'density_meas_gt',
                                         'DENSITY_MEAS_LT': 'density_meas_lt',
                                         'DENSITY_MEAS_TEMP': 'density_meas_temp',
                                         'DENSITY_MEAS_TEMP_ESD': 'density_meas_temp_esd',
                                         'DENSITY_MEAS_TEMP_GT': 'density_meas_temp_gt',
                                         'DENSITY_MEAS_TEMP_LT': 'density_meas_temp_lt',
                                         'DENSITY_METHOD': 'density_method',
                                         'DENSITY_PERCENT_SOL': 'density_percent_sol',
                                         'DESCRIPTION': 'description',
                                         'F_000': 'F_000',
                                         'ID': 'id',
                                         'PDBX_CRYSTAL_IMAGE_FORMAT': 'pdbx_crystal_image_format',
                                         'PDBX_CRYSTAL_IMAGE_URL': 'pdbx_crystal_image_url',
                                         'PDBX_MOSAICITY': 'pdbx_mosaicity',
                                         'PDBX_MOSAICITY_ESD': 'pdbx_mosaicity_esd',
                                         'PREPARATION': 'preparation',
                                         'SIZE_MAX': 'size_max',
                                         'SIZE_MID': 'size_mid',
                                         'SIZE_MIN': 'size_min',
                                         'SIZE_RAD': 'size_rad',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'COLOUR': {'NULLABLE': True,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 80},
                                             'COLOUR_LUSTRE': {'NULLABLE': True,
                                                               'ORDER': 15,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 80},
                                             'COLOUR_MODIFIER': {'NULLABLE': True,
                                                                 'ORDER': 16,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                             'COLOUR_PRIMARY': {'NULLABLE': True,
                                                                'ORDER': 17,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                             'DENSITY_DIFFRN': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'DENSITY_MATTHEWS': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                             'DENSITY_MEAS': {'NULLABLE': True,
                                                              'ORDER': 18,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                             'DENSITY_MEAS_ESD': {'NULLABLE': True,
                                                                  'ORDER': 19,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                             'DENSITY_MEAS_GT': {'NULLABLE': True,
                                                                 'ORDER': 20,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'DENSITY_MEAS_LT': {'NULLABLE': True,
                                                                 'ORDER': 21,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP': {'NULLABLE': True,
                                                                   'ORDER': 22,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP_ESD': {'NULLABLE': True,
                                                                       'ORDER': 23,
                                                                       'PRECISION': 6,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'FLOAT',
                                                                       'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP_GT': {'NULLABLE': True,
                                                                      'ORDER': 24,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                             'DENSITY_MEAS_TEMP_LT': {'NULLABLE': True,
                                                                      'ORDER': 25,
                                                                      'PRECISION': 6,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'FLOAT',
                                                                      'WIDTH': 10},
                                             'DENSITY_METHOD': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                             'DENSITY_PERCENT_SOL': {'NULLABLE': True,
                                                                     'ORDER': 6,
                                                                     'PRECISION': 6,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'FLOAT',
                                                                     'WIDTH': 10},
                                             'DESCRIPTION': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 4095},
                                             'F_000': {'NULLABLE': True,
                                                       'ORDER': 8,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'INT',
                                                       'WIDTH': 10},
                                             'ID': {'NULLABLE': False,
                                                    'ORDER': 9,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 10},
                                             'PDBX_CRYSTAL_IMAGE_FORMAT': {'NULLABLE': True,
                                                                           'ORDER': 27,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80},
                                             'PDBX_CRYSTAL_IMAGE_URL': {'NULLABLE': True,
                                                                        'ORDER': 26,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 80},
                                             'PDBX_MOSAICITY': {'NULLABLE': True,
                                                                'ORDER': 28,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'PDBX_MOSAICITY_ESD': {'NULLABLE': True,
                                                                    'ORDER': 29,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                             'PREPARATION': {'NULLABLE': True,
                                                             'ORDER': 10,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                             'SIZE_MAX': {'NULLABLE': True,
                                                          'ORDER': 11,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'SIZE_MID': {'NULLABLE': True,
                                                          'ORDER': 12,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'SIZE_MIN': {'NULLABLE': True,
                                                          'ORDER': 13,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'SIZE_RAD': {'NULLABLE': True,
                                                          'ORDER': 14,
                                                          'PRECISION': 6,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'FLOAT',
                                                          'WIDTH': 10},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'COLOUR': ('exptl_crystal', 'colour', None, None),
                                            'COLOUR_LUSTRE': ('exptl_crystal', 'colour_lustre', None, None),
                                            'COLOUR_MODIFIER': ('exptl_crystal', 'colour_modifier', None, None),
                                            'COLOUR_PRIMARY': ('exptl_crystal', 'colour_primary', None, None),
                                            'DENSITY_DIFFRN': ('exptl_crystal', 'density_diffrn', None, None),
                                            'DENSITY_MATTHEWS': ('exptl_crystal', 'density_Matthews', None, None),
                                            'DENSITY_MEAS': ('exptl_crystal', 'density_meas', None, None),
                                            'DENSITY_MEAS_ESD': ('exptl_crystal', 'density_meas_esd', None, None),
                                            'DENSITY_MEAS_GT': ('exptl_crystal', 'density_meas_gt', None, None),
                                            'DENSITY_MEAS_LT': ('exptl_crystal', 'density_meas_lt', None, None),
                                            'DENSITY_MEAS_TEMP': ('exptl_crystal', 'density_meas_temp', None, None),
                                            'DENSITY_MEAS_TEMP_ESD': ('exptl_crystal', 'density_meas_temp_esd', None, None),
                                            'DENSITY_MEAS_TEMP_GT': ('exptl_crystal', 'density_meas_temp_gt', None, None),
                                            'DENSITY_MEAS_TEMP_LT': ('exptl_crystal', 'density_meas_temp_lt', None, None),
                                            'DENSITY_METHOD': ('exptl_crystal', 'density_method', None, None),
                                            'DENSITY_PERCENT_SOL': ('exptl_crystal', 'density_percent_sol', None, None),
                                            'DESCRIPTION': ('exptl_crystal', 'description', None, None),
                                            'F_000': ('exptl_crystal', 'F_000', None, None),
                                            'ID': ('exptl_crystal', 'id', None, None),
                                            'PDBX_CRYSTAL_IMAGE_FORMAT': ('exptl_crystal',
                                                                          'pdbx_crystal_image_format',
                                                                          None,
                                                                          None),
                                            'PDBX_CRYSTAL_IMAGE_URL': ('exptl_crystal',
                                                                       'pdbx_crystal_image_url',
                                                                       None,
                                                                       None),
                                            'PDBX_MOSAICITY': ('exptl_crystal', 'pdbx_mosaicity', None, None),
                                            'PDBX_MOSAICITY_ESD': ('exptl_crystal', 'pdbx_mosaicity_esd', None, None),
                                            'PREPARATION': ('exptl_crystal', 'preparation', None, None),
                                            'SIZE_MAX': ('exptl_crystal', 'size_max', None, None),
                                            'SIZE_MID': ('exptl_crystal', 'size_mid', None, None),
                                            'SIZE_MIN': ('exptl_crystal', 'size_min', None, None),
                                            'SIZE_RAD': ('exptl_crystal', 'size_rad', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'exptl_crystal': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'EXPTL_CRYSTAL',
                          'TABLE_NAME': 'exptl_crystal',
                          'TABLE_TYPE': 'transactional'},
        'EXPTL_CRYSTAL_FACE': {'ATTRIBUTES': {'CRYSTAL_ID': 'crystal_id',
                                              'DIFFR_CHI': 'diffr_chi',
                                              'DIFFR_KAPPA': 'diffr_kappa',
                                              'DIFFR_PHI': 'diffr_phi',
                                              'DIFFR_PSI': 'diffr_psi',
                                              'INDEX_H': 'index_h',
                                              'INDEX_K': 'index_k',
                                              'INDEX_L': 'index_l',
                                              'PERP_DIST': 'perp_dist',
                                              'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'CRYSTAL_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                  'DIFFR_CHI': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                  'DIFFR_KAPPA': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10},
                                                  'DIFFR_PHI': {'NULLABLE': True,
                                                                'ORDER': 5,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                  'DIFFR_PSI': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                  'INDEX_H': {'NULLABLE': False,
                                                              'ORDER': 7,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                                  'INDEX_K': {'NULLABLE': False,
                                                              'ORDER': 8,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                                  'INDEX_L': {'NULLABLE': False,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                                  'PERP_DIST': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10}},
                               'ATTRIBUTE_MAP': {'CRYSTAL_ID': ('exptl_crystal_face', 'crystal_id', None, None),
                                                 'DIFFR_CHI': ('exptl_crystal_face', 'diffr_chi', None, None),
                                                 'DIFFR_KAPPA': ('exptl_crystal_face', 'diffr_kappa', None, None),
                                                 'DIFFR_PHI': ('exptl_crystal_face', 'diffr_phi', None, None),
                                                 'DIFFR_PSI': ('exptl_crystal_face', 'diffr_psi', None, None),
                                                 'INDEX_H': ('exptl_crystal_face', 'index_h', None, None),
                                                 'INDEX_K': ('exptl_crystal_face', 'index_k', None, None),
                                                 'INDEX_L': ('exptl_crystal_face', 'index_l', None, None),
                                                 'PERP_DIST': ('exptl_crystal_face', 'perp_dist', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                 'CRYSTAL_ID',
                                                                 'INDEX_H',
                                                                 'INDEX_K',
                                                                 'INDEX_L'),
                                                  'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'exptl_crystal_face': {'ATTRIBUTES': ('crystal_id',
                                                                                           'index_h',
                                                                                           'index_k',
                                                                                           'index_l'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'EXPTL_CRYSTAL_FACE',
                               'TABLE_NAME': 'exptl_crystal_face',
                               'TABLE_TYPE': 'transactional'},
        'EXPTL_CRYSTAL_GROW': {'ATTRIBUTES': {'APPARATUS': 'apparatus',
                                              'ATMOSPHERE': 'atmosphere',
                                              'CRYSTAL_ID': 'crystal_id',
                                              'DETAILS': 'details',
                                              'METHOD': 'method',
                                              'METHOD_REF': 'method_ref',
                                              'PDBX_DETAILS': 'pdbx_details',
                                              'PDBX_PH_RANGE': 'pdbx_pH_range',
                                              'PH': 'pH',
                                              'PRESSURE': 'pressure',
                                              'PRESSURE_ESD': 'pressure_esd',
                                              'SEEDING': 'seeding',
                                              'SEEDING_REF': 'seeding_ref',
                                              'STRUCTURE_ID': 'Structure_ID',
                                              'TEMP': 'temp',
                                              'TEMP_DETAILS': 'temp_details',
                                              'TEMP_ESD': 'temp_esd',
                                              'TIME': 'time'},
                               'ATTRIBUTE_INFO': {'APPARATUS': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                  'ATMOSPHERE': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                  'CRYSTAL_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                  'DETAILS': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                                  'METHOD': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200},
                                                  'METHOD_REF': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 200},
                                                  'PDBX_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 17,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 4095},
                                                  'PDBX_PH_RANGE': {'NULLABLE': True,
                                                                    'ORDER': 18,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                                  'PH': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                                  'PRESSURE': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                  'PRESSURE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 10,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                                  'SEEDING': {'NULLABLE': True,
                                                              'ORDER': 11,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                                  'SEEDING_REF': {'NULLABLE': True,
                                                                  'ORDER': 12,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                  'TEMP': {'NULLABLE': True,
                                                           'ORDER': 13,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10},
                                                  'TEMP_DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 14,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                  'TEMP_ESD': {'NULLABLE': True,
                                                               'ORDER': 15,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                                  'TIME': {'NULLABLE': True,
                                                           'ORDER': 16,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200}},
                               'ATTRIBUTE_MAP': {'APPARATUS': ('exptl_crystal_grow', 'apparatus', None, None),
                                                 'ATMOSPHERE': ('exptl_crystal_grow', 'atmosphere', None, None),
                                                 'CRYSTAL_ID': ('exptl_crystal_grow', 'crystal_id', None, None),
                                                 'DETAILS': ('exptl_crystal_grow', 'details', None, None),
                                                 'METHOD': ('exptl_crystal_grow', 'method', None, None),
                                                 'METHOD_REF': ('exptl_crystal_grow', 'method_ref', None, None),
                                                 'PDBX_DETAILS': ('exptl_crystal_grow', 'pdbx_details', None, None),
                                                 'PDBX_PH_RANGE': ('exptl_crystal_grow', 'pdbx_pH_range', None, None),
                                                 'PH': ('exptl_crystal_grow', 'pH', None, None),
                                                 'PRESSURE': ('exptl_crystal_grow', 'pressure', None, None),
                                                 'PRESSURE_ESD': ('exptl_crystal_grow', 'pressure_esd', None, None),
                                                 'SEEDING': ('exptl_crystal_grow', 'seeding', None, None),
                                                 'SEEDING_REF': ('exptl_crystal_grow', 'seeding_ref', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                 'TEMP': ('exptl_crystal_grow', 'temp', None, None),
                                                 'TEMP_DETAILS': ('exptl_crystal_grow', 'temp_details', None, None),
                                                 'TEMP_ESD': ('exptl_crystal_grow', 'temp_esd', None, None),
                                                 'TIME': ('exptl_crystal_grow', 'time', None, None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CRYSTAL_ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'exptl_crystal_grow': {'ATTRIBUTES': ('crystal_id',),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'EXPTL_CRYSTAL_GROW',
                               'TABLE_NAME': 'exptl_crystal_grow',
                               'TABLE_TYPE': 'transactional'},
        'EXPTL_CRYSTAL_GROW_COMP': {'ATTRIBUTES': {'CONC': 'conc',
                                                   'CRYSTAL_ID': 'crystal_id',
                                                   'DETAILS': 'details',
                                                   'ID': 'id',
                                                   'NAME': 'name',
                                                   'SOL_ID': 'sol_id',
                                                   'STRUCTURE_ID': 'Structure_ID',
                                                   'VOLUME': 'volume'},
                                    'ATTRIBUTE_INFO': {'CONC': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                       'CRYSTAL_ID': {'NULLABLE': False,
                                                                      'ORDER': 2,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                       'DETAILS': {'NULLABLE': True,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 200},
                                                       'ID': {'NULLABLE': False,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                                       'NAME': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 128},
                                                       'SOL_ID': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80},
                                                       'STRUCTURE_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                       'VOLUME': {'NULLABLE': True,
                                                                  'ORDER': 8,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80}},
                                    'ATTRIBUTE_MAP': {'CONC': ('exptl_crystal_grow_comp', 'conc', None, None),
                                                      'CRYSTAL_ID': ('exptl_crystal_grow_comp', 'crystal_id', None, None),
                                                      'DETAILS': ('exptl_crystal_grow_comp', 'details', None, None),
                                                      'ID': ('exptl_crystal_grow_comp', 'id', None, None),
                                                      'NAME': ('exptl_crystal_grow_comp', 'name', None, None),
                                                      'SOL_ID': ('exptl_crystal_grow_comp', 'sol_id', None, None),
                                                      'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                      'VOLUME': ('exptl_crystal_grow_comp', 'volume', None, None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CRYSTAL_ID', 'ID'),
                                                       'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'exptl_crystal_grow_comp': {'ATTRIBUTES': ('crystal_id', 'id'),
                                                                                      'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                    'TABLE_ID': 'EXPTL_CRYSTAL_GROW_COMP',
                                    'TABLE_NAME': 'exptl_crystal_grow_comp',
                                    'TABLE_TYPE': 'transactional'},
        'GEOM': {'ATTRIBUTES': {'DETAILS': 'details', 'ENTRY_ID': 'entry_id', 'STRUCTURE_ID': 'Structure_ID'},
                 'ATTRIBUTE_INFO': {'DETAILS': {'NULLABLE': True,
                                                'ORDER': 3,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': False,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 200},
                                    'ENTRY_ID': {'NULLABLE': False,
                                                 'ORDER': 2,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': True,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 10},
                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                     'ORDER': 1,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10}},
                 'ATTRIBUTE_MAP': {'DETAILS': ('geom', 'details', None, None),
                                   'ENTRY_ID': ('geom', 'entry_id', None, None),
                                   'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                 'MAP_MERGE_INDICES': {'geom': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                 'TABLE_ID': 'GEOM',
                 'TABLE_NAME': 'geom',
                 'TABLE_TYPE': 'transactional'},
        'GEOM_ANGLE': {'ATTRIBUTES': {'ATOM_SITE_AUTH_ASYM_ID_1': 'atom_site_auth_asym_id_1',
                                      'ATOM_SITE_AUTH_ASYM_ID_2': 'atom_site_auth_asym_id_2',
                                      'ATOM_SITE_AUTH_ASYM_ID_3': 'atom_site_auth_asym_id_3',
                                      'ATOM_SITE_AUTH_ATOM_ID_1': 'atom_site_auth_atom_id_1',
                                      'ATOM_SITE_AUTH_ATOM_ID_2': 'atom_site_auth_atom_id_2',
                                      'ATOM_SITE_AUTH_ATOM_ID_3': 'atom_site_auth_atom_id_3',
                                      'ATOM_SITE_AUTH_COMP_ID_1': 'atom_site_auth_comp_id_1',
                                      'ATOM_SITE_AUTH_COMP_ID_2': 'atom_site_auth_comp_id_2',
                                      'ATOM_SITE_AUTH_COMP_ID_3': 'atom_site_auth_comp_id_3',
                                      'ATOM_SITE_AUTH_SEQ_ID_1': 'atom_site_auth_seq_id_1',
                                      'ATOM_SITE_AUTH_SEQ_ID_2': 'atom_site_auth_seq_id_2',
                                      'ATOM_SITE_AUTH_SEQ_ID_3': 'atom_site_auth_seq_id_3',
                                      'ATOM_SITE_ID_1': 'atom_site_id_1',
                                      'ATOM_SITE_ID_2': 'atom_site_id_2',
                                      'ATOM_SITE_ID_3': 'atom_site_id_3',
                                      'ATOM_SITE_LABEL_ALT_ID_1': 'atom_site_label_alt_id_1',
                                      'ATOM_SITE_LABEL_ALT_ID_2': 'atom_site_label_alt_id_2',
                                      'ATOM_SITE_LABEL_ALT_ID_3': 'atom_site_label_alt_id_3',
                                      'ATOM_SITE_LABEL_ASYM_ID_1': 'atom_site_label_asym_id_1',
                                      'ATOM_SITE_LABEL_ASYM_ID_2': 'atom_site_label_asym_id_2',
                                      'ATOM_SITE_LABEL_ASYM_ID_3': 'atom_site_label_asym_id_3',
                                      'ATOM_SITE_LABEL_ATOM_ID_1': 'atom_site_label_atom_id_1',
                                      'ATOM_SITE_LABEL_ATOM_ID_2': 'atom_site_label_atom_id_2',
                                      'ATOM_SITE_LABEL_ATOM_ID_3': 'atom_site_label_atom_id_3',
                                      'ATOM_SITE_LABEL_COMP_ID_1': 'atom_site_label_comp_id_1',
                                      'ATOM_SITE_LABEL_COMP_ID_2': 'atom_site_label_comp_id_2',
                                      'ATOM_SITE_LABEL_COMP_ID_3': 'atom_site_label_comp_id_3',
                                      'ATOM_SITE_LABEL_SEQ_ID_1': 'atom_site_label_seq_id_1',
                                      'ATOM_SITE_LABEL_SEQ_ID_2': 'atom_site_label_seq_id_2',
                                      'ATOM_SITE_LABEL_SEQ_ID_3': 'atom_site_label_seq_id_3',
                                      'PDBX_ATOM_SITE_PDB_INS_CODE_1': 'pdbx_atom_site_PDB_ins_code_1',
                                      'PDBX_ATOM_SITE_PDB_INS_CODE_2': 'pdbx_atom_site_PDB_ins_code_2',
                                      'PDBX_ATOM_SITE_PDB_INS_CODE_3': 'pdbx_atom_site_PDB_ins_code_3',
                                      'PDBX_PDB_MODEL_NUM': 'pdbx_PDB_model_num',
                                      'PUBL_FLAG': 'publ_flag',
                                      'SITE_SYMMETRY_1': 'site_symmetry_1',
                                      'SITE_SYMMETRY_2': 'site_symmetry_2',
                                      'SITE_SYMMETRY_3': 'site_symmetry_3',
                                      'STRUCTURE_ID': 'Structure_ID',
                                      'VALUE': 'value',
                                      'VALUE_ESD': 'value_esd'},
                       'ATTRIBUTE_INFO': {'ATOM_SITE_AUTH_ASYM_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_AUTH_ASYM_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 3,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_AUTH_ASYM_ID_3': {'NULLABLE': True,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_AUTH_ATOM_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 5,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 6},
                                          'ATOM_SITE_AUTH_ATOM_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 6,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 6},
                                          'ATOM_SITE_AUTH_ATOM_ID_3': {'NULLABLE': True,
                                                                       'ORDER': 7,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 6},
                                          'ATOM_SITE_AUTH_COMP_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 8,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_AUTH_COMP_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 9,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_AUTH_COMP_ID_3': {'NULLABLE': True,
                                                                       'ORDER': 10,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_AUTH_SEQ_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 11,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                          'ATOM_SITE_AUTH_SEQ_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                          'ATOM_SITE_AUTH_SEQ_ID_3': {'NULLABLE': True,
                                                                      'ORDER': 13,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                          'ATOM_SITE_ID_1': {'NULLABLE': False,
                                                             'ORDER': 14,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                          'ATOM_SITE_ID_2': {'NULLABLE': False,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                          'ATOM_SITE_ID_3': {'NULLABLE': False,
                                                             'ORDER': 16,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ALT_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 17,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ALT_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 18,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ALT_ID_3': {'NULLABLE': True,
                                                                       'ORDER': 19,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ASYM_ID_1': {'NULLABLE': True,
                                                                        'ORDER': 29,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ASYM_ID_2': {'NULLABLE': True,
                                                                        'ORDER': 30,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ASYM_ID_3': {'NULLABLE': True,
                                                                        'ORDER': 31,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                          'ATOM_SITE_LABEL_ATOM_ID_1': {'NULLABLE': True,
                                                                        'ORDER': 23,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 6},
                                          'ATOM_SITE_LABEL_ATOM_ID_2': {'NULLABLE': True,
                                                                        'ORDER': 24,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 6},
                                          'ATOM_SITE_LABEL_ATOM_ID_3': {'NULLABLE': True,
                                                                        'ORDER': 25,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 6},
                                          'ATOM_SITE_LABEL_COMP_ID_1': {'NULLABLE': True,
                                                                        'ORDER': 20,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                          'ATOM_SITE_LABEL_COMP_ID_2': {'NULLABLE': True,
                                                                        'ORDER': 21,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                          'ATOM_SITE_LABEL_COMP_ID_3': {'NULLABLE': True,
                                                                        'ORDER': 22,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                          'ATOM_SITE_LABEL_SEQ_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 26,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_LABEL_SEQ_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 27,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                          'ATOM_SITE_LABEL_SEQ_ID_3': {'NULLABLE': True,
                                                                       'ORDER': 28,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                          'PDBX_ATOM_SITE_PDB_INS_CODE_1': {'NULLABLE': True,
                                                                            'ORDER': 38,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                          'PDBX_ATOM_SITE_PDB_INS_CODE_2': {'NULLABLE': True,
                                                                            'ORDER': 39,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                          'PDBX_ATOM_SITE_PDB_INS_CODE_3': {'NULLABLE': True,
                                                                            'ORDER': 40,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                          'PDBX_PDB_MODEL_NUM': {'NULLABLE': True,
                                                                 'ORDER': 41,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'INT',
                                                                 'WIDTH': 10},
                                          'PUBL_FLAG': {'NULLABLE': True,
                                                        'ORDER': 32,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                          'SITE_SYMMETRY_1': {'NULLABLE': False,
                                                              'ORDER': 33,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                          'SITE_SYMMETRY_2': {'NULLABLE': False,
                                                              'ORDER': 34,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                          'SITE_SYMMETRY_3': {'NULLABLE': False,
                                                              'ORDER': 35,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                          'VALUE': {'NULLABLE': True,
                                                    'ORDER': 36,
                                                    'PRECISION': 6,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'FLOAT',
                                                    'WIDTH': 10},
                                          'VALUE_ESD': {'NULLABLE': True,
                                                        'ORDER': 37,
                                                        'PRECISION': 6,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'FLOAT',
                                                        'WIDTH': 10}},
                       'ATTRIBUTE_MAP': {'ATOM_SITE_AUTH_ASYM_ID_1': ('geom_angle', 'atom_site_auth_asym_id_1', None, None),
                                         'ATOM_SITE_AUTH_ASYM_ID_2': ('geom_angle', 'atom_site_auth_asym_id_2', None, None),
                                         'ATOM_SITE_AUTH_ASYM_ID_3': ('geom_angle', 'atom_site_auth_asym_id_3', None, None),
                                         'ATOM_SITE_AUTH_ATOM_ID_1': ('geom_angle', 'atom_site_auth_atom_id_1', None, None),
                                         'ATOM_SITE_AUTH_ATOM_ID_2': ('geom_angle', 'atom_site_auth_atom_id_2', None, None),
                                         'ATOM_SITE_AUTH_ATOM_ID_3': ('geom_angle', 'atom_site_auth_atom_id_3', None, None),
                                         'ATOM_SITE_AUTH_COMP_ID_1': ('geom_angle', 'atom_site_auth_comp_id_1', None, None),
                                         'ATOM_SITE_AUTH_COMP_ID_2': ('geom_angle', 'atom_site_auth_comp_id_2', None, None),
                                         'ATOM_SITE_AUTH_COMP_ID_3': ('geom_angle', 'atom_site_auth_comp_id_3', None, None),
                                         'ATOM_SITE_AUTH_SEQ_ID_1': ('geom_angle', 'atom_site_auth_seq_id_1', None, None),
                                         'ATOM_SITE_AUTH_SEQ_ID_2': ('geom_angle', 'atom_site_auth_seq_id_2', None, None),
                                         'ATOM_SITE_AUTH_SEQ_ID_3': ('geom_angle', 'atom_site_auth_seq_id_3', None, None),
                                         'ATOM_SITE_ID_1': ('geom_angle', 'atom_site_id_1', None, None),
                                         'ATOM_SITE_ID_2': ('geom_angle', 'atom_site_id_2', None, None),
                                         'ATOM_SITE_ID_3': ('geom_angle', 'atom_site_id_3', None, None),
                                         'ATOM_SITE_LABEL_ALT_ID_1': ('geom_angle', 'atom_site_label_alt_id_1', None, None),
                                         'ATOM_SITE_LABEL_ALT_ID_2': ('geom_angle', 'atom_site_label_alt_id_2', None, None),
                                         'ATOM_SITE_LABEL_ALT_ID_3': ('geom_angle', 'atom_site_label_alt_id_3', None, None),
                                         'ATOM_SITE_LABEL_ASYM_ID_1': ('geom_angle',
                                                                       'atom_site_label_asym_id_1',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_ASYM_ID_2': ('geom_angle',
                                                                       'atom_site_label_asym_id_2',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_ASYM_ID_3': ('geom_angle',
                                                                       'atom_site_label_asym_id_3',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_ATOM_ID_1': ('geom_angle',
                                                                       'atom_site_label_atom_id_1',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_ATOM_ID_2': ('geom_angle',
                                                                       'atom_site_label_atom_id_2',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_ATOM_ID_3': ('geom_angle',
                                                                       'atom_site_label_atom_id_3',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_COMP_ID_1': ('geom_angle',
                                                                       'atom_site_label_comp_id_1',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_COMP_ID_2': ('geom_angle',
                                                                       'atom_site_label_comp_id_2',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_COMP_ID_3': ('geom_angle',
                                                                       'atom_site_label_comp_id_3',
                                                                       None,
                                                                       None),
                                         'ATOM_SITE_LABEL_SEQ_ID_1': ('geom_angle', 'atom_site_label_seq_id_1', None, None),
                                         'ATOM_SITE_LABEL_SEQ_ID_2': ('geom_angle', 'atom_site_label_seq_id_2', None, None),
                                         'ATOM_SITE_LABEL_SEQ_ID_3': ('geom_angle', 'atom_site_label_seq_id_3', None, None),
                                         'PDBX_ATOM_SITE_PDB_INS_CODE_1': ('geom_angle',
                                                                           'pdbx_atom_site_PDB_ins_code_1',
                                                                           None,
                                                                           None),
                                         'PDBX_ATOM_SITE_PDB_INS_CODE_2': ('geom_angle',
                                                                           'pdbx_atom_site_PDB_ins_code_2',
                                                                           None,
                                                                           None),
                                         'PDBX_ATOM_SITE_PDB_INS_CODE_3': ('geom_angle',
                                                                           'pdbx_atom_site_PDB_ins_code_3',
                                                                           None,
                                                                           None),
                                         'PDBX_PDB_MODEL_NUM': ('geom_angle', 'pdbx_PDB_model_num', None, None),
                                         'PUBL_FLAG': ('geom_angle', 'publ_flag', None, None),
                                         'SITE_SYMMETRY_1': ('geom_angle', 'site_symmetry_1', None, None),
                                         'SITE_SYMMETRY_2': ('geom_angle', 'site_symmetry_2', None, None),
                                         'SITE_SYMMETRY_3': ('geom_angle', 'site_symmetry_3', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                         'VALUE': ('geom_angle', 'value', None, None),
                                         'VALUE_ESD': ('geom_angle', 'value_esd', None, None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                         'ATOM_SITE_ID_1',
                                                         'ATOM_SITE_ID_2',
                                                         'ATOM_SITE_ID_3',
                                                         'SITE_SYMMETRY_1',
                                                         'SITE_SYMMETRY_2',
                                                         'SITE_SYMMETRY_3'),
                                          'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'geom_angle': {'ATTRIBUTES': ('atom_site_id_1',
                                                                           'atom_site_id_2',
                                                                           'atom_site_id_3',
                                                                           'site_symmetry_1',
                                                                           'site_symmetry_2',
                                                                           'site_symmetry_3'),
                                                            'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'GEOM_ANGLE',
                       'TABLE_NAME': 'geom_angle',
                       'TABLE_TYPE': 'transactional'},
        'GEOM_BOND': {'ATTRIBUTES': {'ATOM_SITE_AUTH_ASYM_ID_1': 'atom_site_auth_asym_id_1',
                                     'ATOM_SITE_AUTH_ASYM_ID_2': 'atom_site_auth_asym_id_2',
                                     'ATOM_SITE_AUTH_ATOM_ID_1': 'atom_site_auth_atom_id_1',
                                     'ATOM_SITE_AUTH_ATOM_ID_2': 'atom_site_auth_atom_id_2',
                                     'ATOM_SITE_AUTH_COMP_ID_1': 'atom_site_auth_comp_id_1',
                                     'ATOM_SITE_AUTH_COMP_ID_2': 'atom_site_auth_comp_id_2',
                                     'ATOM_SITE_AUTH_SEQ_ID_1': 'atom_site_auth_seq_id_1',
                                     'ATOM_SITE_AUTH_SEQ_ID_2': 'atom_site_auth_seq_id_2',
                                     'ATOM_SITE_ID_1': 'atom_site_id_1',
                                     'ATOM_SITE_ID_2': 'atom_site_id_2',
                                     'ATOM_SITE_LABEL_ALT_ID_1': 'atom_site_label_alt_id_1',
                                     'ATOM_SITE_LABEL_ALT_ID_2': 'atom_site_label_alt_id_2',
                                     'ATOM_SITE_LABEL_ASYM_ID_1': 'atom_site_label_asym_id_1',
                                     'ATOM_SITE_LABEL_ASYM_ID_2': 'atom_site_label_asym_id_2',
                                     'ATOM_SITE_LABEL_ATOM_ID_1': 'atom_site_label_atom_id_1',
                                     'ATOM_SITE_LABEL_ATOM_ID_2': 'atom_site_label_atom_id_2',
                                     'ATOM_SITE_LABEL_COMP_ID_1': 'atom_site_label_comp_id_1',
                                     'ATOM_SITE_LABEL_COMP_ID_2': 'atom_site_label_comp_id_2',
                                     'ATOM_SITE_LABEL_SEQ_ID_1': 'atom_site_label_seq_id_1',
                                     'ATOM_SITE_LABEL_SEQ_ID_2': 'atom_site_label_seq_id_2',
                                     'DIST': 'dist',
                                     'DIST_ESD': 'dist_esd',
                                     'PDBX_ATOM_SITE_PDB_INS_CODE_1': 'pdbx_atom_site_PDB_ins_code_1',
                                     'PDBX_ATOM_SITE_PDB_INS_CODE_2': 'pdbx_atom_site_PDB_ins_code_2',
                                     'PDBX_PDB_MODEL_NUM': 'pdbx_PDB_model_num',
                                     'PUBL_FLAG': 'publ_flag',
                                     'SITE_SYMMETRY_1': 'site_symmetry_1',
                                     'SITE_SYMMETRY_2': 'site_symmetry_2',
                                     'STRUCTURE_ID': 'Structure_ID',
                                     'VALENCE': 'valence'},
                      'ATTRIBUTE_INFO': {'ATOM_SITE_AUTH_ASYM_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 2,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_AUTH_ASYM_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 3,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_AUTH_ATOM_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 4,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 6},
                                         'ATOM_SITE_AUTH_ATOM_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 6},
                                         'ATOM_SITE_AUTH_COMP_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_AUTH_COMP_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 7,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_AUTH_SEQ_ID_1': {'NULLABLE': True,
                                                                     'ORDER': 8,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                         'ATOM_SITE_AUTH_SEQ_ID_2': {'NULLABLE': True,
                                                                     'ORDER': 9,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                         'ATOM_SITE_ID_1': {'NULLABLE': False,
                                                            'ORDER': 10,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                         'ATOM_SITE_ID_2': {'NULLABLE': False,
                                                            'ORDER': 11,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                         'ATOM_SITE_LABEL_ALT_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_LABEL_ALT_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 13,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_LABEL_ASYM_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 20,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                         'ATOM_SITE_LABEL_ASYM_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 21,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                         'ATOM_SITE_LABEL_ATOM_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 16,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 6},
                                         'ATOM_SITE_LABEL_ATOM_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 17,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 6},
                                         'ATOM_SITE_LABEL_COMP_ID_1': {'NULLABLE': True,
                                                                       'ORDER': 14,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                         'ATOM_SITE_LABEL_COMP_ID_2': {'NULLABLE': True,
                                                                       'ORDER': 15,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                         'ATOM_SITE_LABEL_SEQ_ID_1': {'NULLABLE': True,
                                                                      'ORDER': 18,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'INT',
                                                                      'WIDTH': 10},
                                         'ATOM_SITE_LABEL_SEQ_ID_2': {'NULLABLE': True,
                                                                      'ORDER': 19,
                                                               