##
# File:    DaInternalSchemaDef.py
# Author:  J. Westbrook
# Date:    9-Aug-2015
# Version: 0.001 Initial version
#
# Updates: 14-Oct-2015  jdw update em_admin category
#          16-Feb-2016  jdw add support for multiple database names for this schema -
##
"""
Database schema defintions for annotation internal database

"""
__docformat__ = "restructuredtext en"
__author__ = "John Westbrook"
__email__ = "jwest@rcsb.rutgers.edu"
__license__ = "Creative Commons Attribution 3.0 Unported"
__version__ = "V0.001"

import sys
from wwpdb.utils.db.SchemaDefBase import SchemaDefBase


class DaInternalSchemaDef(SchemaDefBase):

    """ A data class containing schema definitions for data processing status history.
    """
    _databaseName = "da_internal_combine"
    _schemaDefDict = {
        'AUDIT_AUTHOR': {'ATTRIBUTES': {'IDENTIFIER_ORCID': 'identifier_ORCID',
                                        'NAME': 'name',
                                        'PDBX_ORDINAL': 'pdbx_ordinal',
                                        'STRUCTURE_ID': 'Structure_ID'},
                         'ATTRIBUTE_INFO': {'IDENTIFIER_ORCID': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 20},
                                            'NAME': {'NULLABLE': False,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 128},
                                            'PDBX_ORDINAL': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                            'STRUCTURE_ID': {'NULLABLE': False,
                                                             'ORDER': 1,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 15}},
                         'ATTRIBUTE_MAP': {'IDENTIFIER_ORCID': ('audit_author', 'identifier_ORCID', None, None),
                                           'NAME': ('audit_author', 'name', None, None),
                                           'PDBX_ORDINAL': ('audit_author', 'pdbx_ordinal', None, None),
                                           'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                         'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'NAME', 'PDBX_ORDINAL'), 'TYPE': 'UNIQUE'},
                                     's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                         'MAP_MERGE_INDICES': {'audit_author': {'ATTRIBUTES': ('name', 'pdbx_ordinal'), 'TYPE': 'EQUI-JOIN'}},
                         'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                         'TABLE_ID': 'AUDIT_AUTHOR',
                         'TABLE_NAME': 'audit_author',
                         'TABLE_TYPE': 'transactional'},
        'CHEM_COMP': {'ATTRIBUTES': {'FORMULA': 'formula',
                                     'FORMULA_WEIGHT': 'formula_weight',
                                     'ID': 'id',
                                     'NAME': 'name',
                                     'PDBX_COMPONENT_NO': 'pdbx_component_no',
                                     'PDBX_SYNONYMS': 'pdbx_synonyms',
                                     'STRUCTURE_ID': 'Structure_ID'},
                      'ATTRIBUTE_INFO': {'FORMULA': {'NULLABLE': True,
                                                     'ORDER': 5,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'FORMULA_WEIGHT': {'NULLABLE': True,
                                                            'ORDER': 6,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 2,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 23},
                                         'NAME': {'NULLABLE': True,
                                                  'ORDER': 3,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 1023},
                                         'PDBX_COMPONENT_NO': {'NULLABLE': True,
                                                               'ORDER': 7,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                         'PDBX_SYNONYMS': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 520},
                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 15}},
                      'ATTRIBUTE_MAP': {'FORMULA': ('chem_comp', 'formula', None, None),
                                        'FORMULA_WEIGHT': ('chem_comp', 'formula_weight', None, None),
                                        'ID': ('chem_comp', 'id', None, None),
                                        'NAME': ('chem_comp', 'name', None, None),
                                        'PDBX_COMPONENT_NO': ('chem_comp', 'pdbx_component_no', None, None),
                                        'PDBX_SYNONYMS': ('chem_comp', 'pdbx_synonyms', None, None),
                                        'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'chem_comp': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                      'TABLE_ID': 'CHEM_COMP',
                      'TABLE_NAME': 'chem_comp',
                      'TABLE_TYPE': 'transactional'},
        'CITATION': {'ATTRIBUTES': {'ASTM': 'ASTM',
                                    'ASTM_LIST': 'ASTM_List',
                                    'CODEN_LIST': 'CODEN_List',
                                    'COUNTRY': 'Country',
                                    'EDITOR': 'Editor',
                                    'FIRST_PAGE': 'First_Page',
                                    'ISBN_ISSN': 'ISBN_ISSN',
                                    'ISSN_ISBN_NO': 'ISSN_ISBN_No',
                                    'JRNL_SERIAL_NO': 'Jrnl_Serial_No',
                                    'LAST_PAGE': 'Last_Page',
                                    'PDBX_DATABASE_ID_DOI': 'pdbx_database_id_DOI',
                                    'PDBX_DATABASE_ID_PUBMED': 'pdbx_database_id_PubMed',
                                    'PUBLICATION': 'Publication',
                                    'PUBLISHER': 'Publisher',
                                    'STRUCTURE_ID': 'Structure_ID',
                                    'TITLE': 'Title',
                                    'VOLUME_NO': 'Volume_No',
                                    'YEAR': 'Year'},
                     'ATTRIBUTE_INFO': {'ASTM': {'NULLABLE': True,
                                                 'ORDER': 9,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 5},
                                        'ASTM_LIST': {'NULLABLE': True,
                                                      'ORDER': 10,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 9},
                                        'CODEN_LIST': {'NULLABLE': True,
                                                       'ORDER': 14,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 5},
                                        'COUNTRY': {'NULLABLE': True,
                                                    'ORDER': 11,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 6},
                                        'EDITOR': {'NULLABLE': True,
                                                   'ORDER': 15,
                                                   'PRECISION': 0,
                                                   'PRIMARY_KEY': False,
                                                   'SQL_TYPE': 'VARCHAR',
                                                   'WIDTH': 255},
                                        'FIRST_PAGE': {'NULLABLE': True,
                                                       'ORDER': 5,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 31},
                                        'ISBN_ISSN': {'NULLABLE': True,
                                                      'ORDER': 12,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 5},
                                        'ISSN_ISBN_NO': {'NULLABLE': True,
                                                         'ORDER': 13,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 26},
                                        'JRNL_SERIAL_NO': {'NULLABLE': False,
                                                           'ORDER': 16,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'INT',
                                                           'WIDTH': 10},
                                        'LAST_PAGE': {'NULLABLE': True,
                                                      'ORDER': 7,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 16},
                                        'PDBX_DATABASE_ID_DOI': {'NULLABLE': True,
                                                                 'ORDER': 18,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 128},
                                        'PDBX_DATABASE_ID_PUBMED': {'NULLABLE': True,
                                                                    'ORDER': 17,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 11},
                                        'PUBLICATION': {'NULLABLE': True,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 255},
                                        'PUBLISHER': {'NULLABLE': True,
                                                      'ORDER': 8,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 255},
                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                         'ORDER': 1,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 15},
                                        'TITLE': {'NULLABLE': True,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 511},
                                        'VOLUME_NO': {'NULLABLE': True,
                                                      'ORDER': 4,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 44},
                                        'YEAR': {'NULLABLE': True,
                                                 'ORDER': 6,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'INT',
                                                 'WIDTH': 10}},
                     'ATTRIBUTE_MAP': {'ASTM': (None, None, None, None),
                                       'ASTM_LIST': ('citation', 'journal_id_ASTM', None, None),
                                       'CODEN_LIST': ('citation', 'journal_id_CSD', None, None),
                                       'COUNTRY': ('citation', 'country', None, None),
                                       'EDITOR': (None, None, None, None),
                                       'FIRST_PAGE': ('citation', 'page_first', None, None),
                                       'ISBN_ISSN': (None, None, None, None),
                                       'ISSN_ISBN_NO': ('citation', 'journal_id_ISSN', None, None),
                                       'JRNL_SERIAL_NO': ('citation', 'id', 'tointegerplus()', None),
                                       'LAST_PAGE': ('citation', 'page_last', None, None),
                                       'PDBX_DATABASE_ID_DOI': ('citation', 'pdbx_database_id_DOI', None, None),
                                       'PDBX_DATABASE_ID_PUBMED': ('citation', 'pdbx_database_id_PubMed', None, None),
                                       'PUBLICATION': ('citation', 'journal_abbrev', None, None),
                                       'PUBLISHER': ('citation', 'book_publisher', None, None),
                                       'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                       'TITLE': ('citation', 'title', None, None),
                                       'VOLUME_NO': ('citation', 'journal_volume', None, None),
                                       'YEAR': ('citation', 'year', None, None)},
                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'JRNL_SERIAL_NO'), 'TYPE': 'UNIQUE'},
                                 's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                     'MAP_MERGE_INDICES': {'citation': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                     'TABLE_ID': 'CITATION',
                     'TABLE_NAME': 'citation',
                     'TABLE_TYPE': 'transactional'},
        'CITATION_AUTHOR': {'ATTRIBUTES': {'CITATION_ID': 'citation_id',
                                           'IDENTIFIER_ORCID': 'identifier_ORCID',
                                           'NAME': 'name',
                                           'ORDINAL': 'ordinal',
                                           'STRUCTURE_ID': 'Structure_ID'},
                            'ATTRIBUTE_INFO': {'CITATION_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 16},
                                               'IDENTIFIER_ORCID': {'NULLABLE': True,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 20},
                                               'NAME': {'NULLABLE': False,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 80},
                                               'ORDINAL': {'NULLABLE': False,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'INT',
                                                           'WIDTH': 10},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 15}},
                            'ATTRIBUTE_MAP': {'CITATION_ID': ('citation_author', 'citation_id', None, None),
                                              'IDENTIFIER_ORCID': ('citation_author', 'identifier_ORCID', None, None),
                                              'NAME': ('citation_author', 'name', None, None),
                                              'ORDINAL': ('citation_author', 'ordinal', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'CITATION_ID', 'ORDINAL'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'citation_author': {'ATTRIBUTES': ('citation_id', 'ordinal'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'CITATION_AUTHOR',
                            'TABLE_NAME': 'citation_author',
                            'TABLE_TYPE': 'transactional'},
        'DATABASE_2': {'ATTRIBUTES': {'DATABASE_CODE': 'database_code',
                                      'DATABASE_ID': 'database_id',
                                      'STRUCTURE_ID': 'Structure_ID'},
                       'ATTRIBUTE_INFO': {'DATABASE_CODE': {'NULLABLE': False,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 80},
                                          'DATABASE_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                          'STRUCTURE_ID': {'NULLABLE': False,
                                                           'ORDER': 1,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 15}},
                       'ATTRIBUTE_MAP': {'DATABASE_CODE': ('database_2', 'database_code', None, None),
                                         'DATABASE_ID': ('database_2', 'database_id', None, None),
                                         'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                       'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DATABASE_ID', 'DATABASE_CODE'), 'TYPE': 'UNIQUE'},
                                   's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                       'MAP_MERGE_INDICES': {'database_2': {'ATTRIBUTES': ('database_id', 'database_code'),
                                                            'TYPE': 'EQUI-JOIN'}},
                       'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                       'TABLE_ID': 'DATABASE_2',
                       'TABLE_NAME': 'database_2',
                       'TABLE_TYPE': 'transactional'},
        'DIFFRN_SOURCE': {'ATTRIBUTES': {'CURRENT': 'current',
                                         'DETAILS': 'details',
                                         'DIFFRN_ID': 'diffrn_id',
                                         'PDBX_SYNCHROTRON_BEAMLINE': 'pdbx_synchrotron_beamline',
                                         'PDBX_SYNCHROTRON_SITE': 'pdbx_synchrotron_site',
                                         'PDBX_WAVELENGTH': 'pdbx_wavelength',
                                         'PDBX_WAVELENGTH_LIST': 'pdbx_wavelength_list',
                                         'POWER': 'power',
                                         'SIZE': 'size',
                                         'SOURCE': 'source',
                                         'STRUCTURE_ID': 'Structure_ID',
                                         'TAKE_OFF_ANGLE': 'take_off_angle',
                                         'TARGET': 'target',
                                         'TYPE': 'type',
                                         'VOLTAGE': 'voltage'},
                          'ATTRIBUTE_INFO': {'CURRENT': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                             'DETAILS': {'NULLABLE': True,
                                                         'ORDER': 4,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 200},
                                             'DIFFRN_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                             'PDBX_SYNCHROTRON_BEAMLINE': {'NULLABLE': True,
                                                                           'ORDER': 14,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80},
                                             'PDBX_SYNCHROTRON_SITE': {'NULLABLE': True,
                                                                       'ORDER': 15,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                             'PDBX_WAVELENGTH': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                             'PDBX_WAVELENGTH_LIST': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                             'POWER': {'NULLABLE': True,
                                                       'ORDER': 5,
                                                       'PRECISION': 6,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'FLOAT',
                                                       'WIDTH': 10},
                                             'SIZE': {'NULLABLE': True,
                                                      'ORDER': 6,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 200},
                                             'SOURCE': {'NULLABLE': True,
                                                        'ORDER': 7,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 15},
                                             'TAKE_OFF_ANGLE': {'NULLABLE': True,
                                                                'ORDER': 11,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                             'TARGET': {'NULLABLE': True,
                                                        'ORDER': 8,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                             'TYPE': {'NULLABLE': True,
                                                      'ORDER': 9,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 200},
                                             'VOLTAGE': {'NULLABLE': True,
                                                         'ORDER': 10,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'CURRENT': ('diffrn_source', 'current', None, None),
                                            'DETAILS': ('diffrn_source', 'details', None, None),
                                            'DIFFRN_ID': ('diffrn_source', 'diffrn_id', None, None),
                                            'PDBX_SYNCHROTRON_BEAMLINE': ('diffrn_source',
                                                                          'pdbx_synchrotron_beamline',
                                                                          None,
                                                                          None),
                                            'PDBX_SYNCHROTRON_SITE': ('diffrn_source', 'pdbx_synchrotron_site', None, None),
                                            'PDBX_WAVELENGTH': ('diffrn_source', 'pdbx_wavelength', None, None),
                                            'PDBX_WAVELENGTH_LIST': ('diffrn_source', 'pdbx_wavelength_list', None, None),
                                            'POWER': ('diffrn_source', 'power', None, None),
                                            'SIZE': ('diffrn_source', 'size', None, None),
                                            'SOURCE': ('diffrn_source', 'source', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                            'TAKE_OFF_ANGLE': ('diffrn_source', 'take-off_angle', None, None),
                                            'TARGET': ('diffrn_source', 'target', None, None),
                                            'TYPE': ('diffrn_source', 'type', None, None),
                                            'VOLTAGE': ('diffrn_source', 'voltage', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DIFFRN_ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'diffrn_source': {'ATTRIBUTES': ('diffrn_id',), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'DIFFRN_SOURCE',
                          'TABLE_NAME': 'diffrn_source',
                          'TABLE_TYPE': 'transactional'},
        'EM_ADMIN': {'ATTRIBUTES': {'AUTHOR_LIST': 'author_list',
                                    'CURRENT_STATUS': 'current_status',
                                    'DEPOSITION_DATE': 'deposition_date',
                                    'DEPOSITION_SITE': 'deposition_site',
                                    'DETAILS': 'details',
                                    'ENTRY_ID': 'entry_id',
                                    'HEADER_RELEASE_DATE': 'header_release_date',
                                    'LAST_UPDATE': 'last_update',
                                    'MAP_HOLD_DATE': 'map_hold_date',
                                    'MAP_RELEASE_DATE': 'map_release_date',
                                    'OBSOLETED_DATE': 'obsoleted_date',
                                    'REPLACE_EXISTING_ENTRY_FLAG': 'replace_existing_entry_flag',
                                    'STRUCTURE_ID': 'Structure_ID',
                                    'TITLE': 'title'},
                     'ATTRIBUTE_INFO': {'AUTHOR_LIST': {'NULLABLE': True,
                                                        'ORDER': 13,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 700},
                                        'CURRENT_STATUS': {'NULLABLE': True,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 24},
                                        'DEPOSITION_DATE': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'DATE',
                                                            'WIDTH': 19},
                                        'DEPOSITION_SITE': {'NULLABLE': True,
                                                            'ORDER': 5,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 24},
                                        'DETAILS': {'NULLABLE': True,
                                                    'ORDER': 11,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 200},
                                        'ENTRY_ID': {'NULLABLE': False,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 15},
                                        'HEADER_RELEASE_DATE': {'NULLABLE': True,
                                                                'ORDER': 12,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 19},
                                        'LAST_UPDATE': {'NULLABLE': True,
                                                        'ORDER': 6,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'DATE',
                                                        'WIDTH': 19},
                                        'MAP_HOLD_DATE': {'NULLABLE': True,
                                                          'ORDER': 14,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'DATE',
                                                          'WIDTH': 19},
                                        'MAP_RELEASE_DATE': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'DATE',
                                                             'WIDTH': 19},
                                        'OBSOLETED_DATE': {'NULLABLE': True,
                                                           'ORDER': 8,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'DATE',
                                                           'WIDTH': 19},
                                        'REPLACE_EXISTING_ENTRY_FLAG': {'NULLABLE': True,
                                                                        'ORDER': 9,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                         'ORDER': 1,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 15},
                                        'TITLE': {'NULLABLE': True,
                                                  'ORDER': 10,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 600}},
                     'ATTRIBUTE_MAP': {'AUTHOR_LIST': ('em_author_list', 'author', 'collapse(comma)', None),
                                       'CURRENT_STATUS': ('em_admin', 'current_status', None, None),
                                       'DEPOSITION_DATE': ('em_admin', 'deposition_date', None, None),
                                       'DEPOSITION_SITE': ('em_admin', 'deposition_site', None, None),
                                       'DETAILS': ('em_admin', 'details', None, None),
                                       'ENTRY_ID': ('em_admin', 'entry_id', None, None),
                                       'HEADER_RELEASE_DATE': ('em_admin', 'header_release_date', None, None),
                                       'LAST_UPDATE': ('em_admin', 'last_update', None, None),
                                       'MAP_HOLD_DATE': ('em_admin', 'map_hold_date', None, None),
                                       'MAP_RELEASE_DATE': ('em_admin', 'map_release_date', None, None),
                                       'OBSOLETED_DATE': ('em_admin', 'obsoleted_date', None, None),
                                       'REPLACE_EXISTING_ENTRY_FLAG': ('em_admin', 'replace_existing_entry_flag', None, None),
                                       'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                       'TITLE': ('em_admin', 'title', None, None)},
                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'},
                                 's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                     'TABLE_ID': 'EM_ADMIN',
                     'TABLE_NAME': 'em_admin',
                     'TABLE_TYPE': 'transactional'},
        'ENTITY': {'ATTRIBUTES': {'FORMULA_WEIGHT': 'formula_weight',
                                  'ID': 'id',
                                  'PDBX_DESCRIPTION': 'pdbx_description',
                                  'PDBX_NUMBER_OF_MOLECULES': 'pdbx_number_of_molecules',
                                  'SRC_METHOD': 'src_method',
                                  'STRUCTURE_ID': 'Structure_ID',
                                  'TYPE': 'type'},
                   'ATTRIBUTE_INFO': {'FORMULA_WEIGHT': {'NULLABLE': True,
                                                         'ORDER': 7,
                                                         'PRECISION': 6,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'FLOAT',
                                                         'WIDTH': 10},
                                      'ID': {'NULLABLE': False,
                                             'ORDER': 2,
                                             'PRECISION': 0,
                                             'PRIMARY_KEY': True,
                                             'SQL_TYPE': 'VARCHAR',
                                             'WIDTH': 10},
                                      'PDBX_DESCRIPTION': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 1023},
                                      'PDBX_NUMBER_OF_MOLECULES': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                      'SRC_METHOD': {'NULLABLE': True,
                                                     'ORDER': 4,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 15},
                                      'TYPE': {'NULLABLE': True,
                                               'ORDER': 3,
                                               'PRECISION': 0,
                                               'PRIMARY_KEY': False,
                                               'SQL_TYPE': 'VARCHAR',
                                               'WIDTH': 12}},
                   'ATTRIBUTE_MAP': {'FORMULA_WEIGHT': ('entity', 'formula_weight', None, None),
                                     'ID': ('entity', 'id', None, None),
                                     'PDBX_DESCRIPTION': ('entity', 'pdbx_description', None, None),
                                     'PDBX_NUMBER_OF_MOLECULES': ('entity', 'pdbx_number_of_molecules', None, None),
                                     'SRC_METHOD': ('entity', 'src_method', None, None),
                                     'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                     'TYPE': ('entity', 'type', None, None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ID'), 'TYPE': 'UNIQUE'},
                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                   'MAP_MERGE_INDICES': {'entity': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'ENTITY',
                   'TABLE_NAME': 'entity',
                   'TABLE_TYPE': 'transactional'},
        'ENTITY_POLY': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                       'NSTD_LINKAGE': 'nstd_linkage',
                                       'NSTD_MONOMER': 'nstd_monomer',
                                       'NUMBER_OF_MONOMERS': 'number_of_monomers',
                                       'PDBX_DESCRIPTION': 'pdbx_description',
                                       'PDBX_SEQ_ONE_LETTER_CODE': 'pdbx_seq_one_letter_code',
                                       'PDBX_SEQ_ONE_LETTER_CODE_CAN': 'pdbx_seq_one_letter_code_can',
                                       'PDBX_STRAND_ID': 'pdbx_strand_id',
                                       'PDBX_TARGET_IDENTIFIER': 'pdbx_target_identifier',
                                       'STRUCTURE_ID': 'Structure_ID',
                                       'TYPE': 'type'},
                        'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                           'NSTD_LINKAGE': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'INT',
                                                            'WIDTH': 1},
                                           'NSTD_MONOMER': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'INT',
                                                            'WIDTH': 1},
                                           'NUMBER_OF_MONOMERS': {'NULLABLE': True,
                                                                  'ORDER': 10,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                           'PDBX_DESCRIPTION': {'NULLABLE': True,
                                                                'ORDER': 8,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 1023},
                                           'PDBX_SEQ_ONE_LETTER_CODE': {'NULLABLE': True,
                                                                        'ORDER': 6,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 33000},
                                           'PDBX_SEQ_ONE_LETTER_CODE_CAN': {'NULLABLE': True,
                                                                            'ORDER': 7,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 33000},
                                           'PDBX_STRAND_ID': {'NULLABLE': True,
                                                              'ORDER': 9,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 5000},
                                           'PDBX_TARGET_IDENTIFIER': {'NULLABLE': True,
                                                                      'ORDER': 11,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 150},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 15},
                                           'TYPE': {'NULLABLE': True,
                                                    'ORDER': 5,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': False,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 200}},
                        'ATTRIBUTE_MAP': {'ENTITY_ID': ('entity_poly', 'entity_id', None, None),
                                          'NSTD_LINKAGE': ('entity_poly', 'nstd_linkage', 'tobool()', None),
                                          'NSTD_MONOMER': ('entity_poly', 'nstd_monomer', 'tobool()', None),
                                          'NUMBER_OF_MONOMERS': ('entity_poly_seq', 'mon_id', 'count()', None),
                                          'PDBX_DESCRIPTION': ('entity', 'pdbx_description', None, None),
                                          'PDBX_SEQ_ONE_LETTER_CODE': ('entity_poly', 'pdbx_seq_one_letter_code', None, None),
                                          'PDBX_SEQ_ONE_LETTER_CODE_CAN': ('entity_poly',
                                                                           'pdbx_seq_one_letter_code_can',
                                                                           None,
                                                                           None),
                                          'PDBX_STRAND_ID': ('entity_poly', 'pdbx_strand_id', None, None),
                                          'PDBX_TARGET_IDENTIFIER': ('entity_poly', 'pdbx_target_identifier', None, None),
                                          'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                          'TYPE': ('entity_poly', 'type', 'toupper()', None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                        'MAP_MERGE_INDICES': {'entity_poly': {'ATTRIBUTES': ('entity_id',), 'TYPE': 'EQUI-JOIN'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'ENTITY_POLY',
                        'TABLE_NAME': 'entity_poly',
                        'TABLE_TYPE': 'transactional'},
        'EXPTL': {'ATTRIBUTES': {'CRYSTALS_NUMBER': 'crystals_number',
                                 'DETAILS': 'details',
                                 'ENTRY_ID': 'entry_id',
                                 'METHOD': 'method',
                                 'METHOD_DETAILS': 'method_details',
                                 'STRUCTURE_ID': 'Structure_ID'},
                  'ATTRIBUTE_INFO': {'CRYSTALS_NUMBER': {'NULLABLE': True,
                                                         'ORDER': 3,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                     'DETAILS': {'NULLABLE': True,
                                                 'ORDER': 4,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 1100},
                                     'ENTRY_ID': {'NULLABLE': True,
                                                  'ORDER': 2,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 15},
                                     'METHOD': {'NULLABLE': False,
                                                'ORDER': 5,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 80},
                                     'METHOD_DETAILS': {'NULLABLE': True,
                                                        'ORDER': 6,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 200},
                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                      'ORDER': 1,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 15}},
                  'ATTRIBUTE_MAP': {'CRYSTALS_NUMBER': ('exptl', 'crystals_number', None, None),
                                    'DETAILS': ('exptl', 'details', None, None),
                                    'ENTRY_ID': ('database_2', 'database_code', None, None),
                                    'METHOD': ('exptl', 'method', None, None),
                                    'METHOD_DETAILS': ('exptl', 'method_details', None, None),
                                    'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'METHOD'), 'TYPE': 'UNIQUE'},
                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                  'MAP_MERGE_INDICES': {'exptl': {'ATTRIBUTES': ('method',), 'TYPE': 'EQUI-JOIN'}},
                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                  'TABLE_ID': 'EXPTL',
                  'TABLE_NAME': 'exptl',
                  'TABLE_TYPE': 'transactional'},
        'NDB_STRUCT_CONF_NA': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                              'FEATURE': 'feature',
                                              'FEATURE_COUNT': 'feature_count',
                                              'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 15},
                                                  'FEATURE': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                                  'FEATURE_COUNT': {'NULLABLE': True,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 15}},
                               'ATTRIBUTE_MAP': {'ENTRY_ID': ('ndb_struct_conf_na', 'entry_id', None, None),
                                                 'FEATURE': ('ndb_struct_conf_na', 'feature', None, None),
                                                 'FEATURE_COUNT': ('ndb_struct_conf_na', 'feature_count', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID', 'FEATURE'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'ndb_struct_conf_na': {'ATTRIBUTES': ('entry_id', 'feature'),
                                                                            'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'NDB_STRUCT_CONF_NA',
                               'TABLE_NAME': 'ndb_struct_conf_na',
                               'TABLE_TYPE': 'transactional'},
        'PDBX_AUDIT_REVISION_CATEGORY': {'ATTRIBUTES': {'CATEGORY': 'category',
                                                        'DATA_CONTENT_TYPE': 'data_content_type',
                                                        'ORDINAL': 'ordinal',
                                                        'REVISION_ORDINAL': 'revision_ordinal',
                                                        'STRUCTURE_ID': 'Structure_ID'},
                                         'ATTRIBUTE_INFO': {'CATEGORY': {'NULLABLE': True,
                                                                         'ORDER': 5,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 50},
                                                            'DATA_CONTENT_TYPE': {'NULLABLE': False,
                                                                                  'ORDER': 4,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': True,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 30},
                                                            'ORDINAL': {'NULLABLE': False,
                                                                        'ORDER': 2,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': 10},
                                                            'REVISION_ORDINAL': {'NULLABLE': False,
                                                                                 'ORDER': 3,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': True,
                                                                                 'SQL_TYPE': 'INT',
                                                                                 'WIDTH': 10},
                                                            'STRUCTURE_ID': {'NULLABLE': False,
                                                                             'ORDER': 1,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 15}},
                                         'ATTRIBUTE_MAP': {'CATEGORY': ('pdbx_audit_revision_category',
                                                                        'category',
                                                                        None,
                                                                        None),
                                                           'DATA_CONTENT_TYPE': ('pdbx_audit_revision_category',
                                                                                 'data_content_type',
                                                                                 None,
                                                                                 None),
                                                           'ORDINAL': ('pdbx_audit_revision_category', 'ordinal', None, None),
                                                           'REVISION_ORDINAL': ('pdbx_audit_revision_category',
                                                                                'revision_ordinal',
                                                                                None,
                                                                                None),
                                                           'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                         'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                           'ORDINAL',
                                                                           'REVISION_ORDINAL',
                                                                           'DATA_CONTENT_TYPE'),
                                                            'TYPE': 'UNIQUE'},
                                                     's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                         'MAP_MERGE_INDICES': {'pdbx_audit_revision_category': {'ATTRIBUTES': ('ordinal',
                                                                                                               'revision_ordinal',
                                                                                                               'data_content_type'),
                                                                                                'TYPE': 'EQUI-JOIN'}},
                                         'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                         'TABLE_ID': 'PDBX_AUDIT_REVISION_CATEGORY',
                                         'TABLE_NAME': 'pdbx_audit_revision_category',
                                         'TABLE_TYPE': 'transactional'},
        'PDBX_AUDIT_REVISION_DETAILS': {'ATTRIBUTES': {'DATA_CONTENT_TYPE': 'data_content_type',
                                                       'DESCRIPTION': 'description',
                                                       'ORDINAL': 'ordinal',
                                                       'PROVIDER': 'provider',
                                                       'REVISION_ORDINAL': 'revision_ordinal',
                                                       'STRUCTURE_ID': 'Structure_ID',
                                                       'TYPE': 'type'},
                                        'ATTRIBUTE_INFO': {'DATA_CONTENT_TYPE': {'NULLABLE': False,
                                                                                 'ORDER': 4,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': True,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 30},
                                                           'DESCRIPTION': {'NULLABLE': True,
                                                                           'ORDER': 7,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 200},
                                                           'ORDINAL': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                                           'PROVIDER': {'NULLABLE': True,
                                                                        'ORDER': 5,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 30},
                                                           'REVISION_ORDINAL': {'NULLABLE': False,
                                                                                'ORDER': 3,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': True,
                                                                                'SQL_TYPE': 'INT',
                                                                                'WIDTH': 10},
                                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 15},
                                                           'TYPE': {'NULLABLE': True,
                                                                    'ORDER': 6,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 50}},
                                        'ATTRIBUTE_MAP': {'DATA_CONTENT_TYPE': ('pdbx_audit_revision_details',
                                                                                'data_content_type',
                                                                                None,
                                                                                None),
                                                          'DESCRIPTION': ('pdbx_audit_revision_details',
                                                                          'description',
                                                                          None,
                                                                          None),
                                                          'ORDINAL': ('pdbx_audit_revision_details', 'ordinal', None, None),
                                                          'PROVIDER': ('pdbx_audit_revision_details', 'provider', None, None),
                                                          'REVISION_ORDINAL': ('pdbx_audit_revision_details',
                                                                               'revision_ordinal',
                                                                               None,
                                                                               None),
                                                          'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                          'TYPE': ('pdbx_audit_revision_details', 'type', None, None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                          'ORDINAL',
                                                                          'REVISION_ORDINAL',
                                                                          'DATA_CONTENT_TYPE'),
                                                           'TYPE': 'UNIQUE'},
                                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                        'MAP_MERGE_INDICES': {'pdbx_audit_revision_details': {'ATTRIBUTES': ('ordinal',
                                                                                                             'revision_ordinal',
                                                                                                             'data_content_type'),
                                                                                              'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                        'TABLE_ID': 'PDBX_AUDIT_REVISION_DETAILS',
                                        'TABLE_NAME': 'pdbx_audit_revision_details',
                                        'TABLE_TYPE': 'transactional'},
        'PDBX_AUDIT_REVISION_GROUP': {'ATTRIBUTES': {'CONTENT_GROUP': 'content_group',
                                                     'DATA_CONTENT_TYPE': 'data_content_type',
                                                     'ORDINAL': 'ordinal',
                                                     'REVISION_ORDINAL': 'revision_ordinal',
                                                     'STRUCTURE_ID': 'Structure_ID'},
                                      'ATTRIBUTE_INFO': {'CONTENT_GROUP': {'NULLABLE': True,
                                                                           'ORDER': 5,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 80},
                                                         'DATA_CONTENT_TYPE': {'NULLABLE': False,
                                                                               'ORDER': 4,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': True,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 30},
                                                         'ORDINAL': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'REVISION_ORDINAL': {'NULLABLE': False,
                                                                              'ORDER': 3,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'INT',
                                                                              'WIDTH': 10},
                                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 15}},
                                      'ATTRIBUTE_MAP': {'CONTENT_GROUP': ('pdbx_audit_revision_group', 'group', None, None),
                                                        'DATA_CONTENT_TYPE': ('pdbx_audit_revision_group',
                                                                              'data_content_type',
                                                                              None,
                                                                              None),
                                                        'ORDINAL': ('pdbx_audit_revision_group', 'ordinal', None, None),
                                                        'REVISION_ORDINAL': ('pdbx_audit_revision_group',
                                                                             'revision_ordinal',
                                                                             None,
                                                                             None),
                                                        'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                        'ORDINAL',
                                                                        'REVISION_ORDINAL',
                                                                        'DATA_CONTENT_TYPE'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_audit_revision_group': {'ATTRIBUTES': ('ordinal',
                                                                                                         'revision_ordinal',
                                                                                                         'data_content_type'),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                      'TABLE_ID': 'PDBX_AUDIT_REVISION_GROUP',
                                      'TABLE_NAME': 'pdbx_audit_revision_group',
                                      'TABLE_TYPE': 'transactional'},
        'PDBX_AUDIT_REVISION_HISTORY': {'ATTRIBUTES': {'DATA_CONTENT_TYPE': 'data_content_type',
                                                       'INTERNAL_DEPOSITION_ID': 'internal_deposition_id',
                                                       'INTERNAL_VERSION': 'internal_version',
                                                       'MAJOR_REVISION': 'major_revision',
                                                       'MINOR_REVISION': 'minor_revision',
                                                       'ORDINAL': 'ordinal',
                                                       'REVISION_DATE': 'revision_date',
                                                       'STRUCTURE_ID': 'Structure_ID'},
                                        'ATTRIBUTE_INFO': {'DATA_CONTENT_TYPE': {'NULLABLE': False,
                                                                                 'ORDER': 3,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': True,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 30},
                                                           'INTERNAL_DEPOSITION_ID': {'NULLABLE': True,
                                                                                      'ORDER': 8,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': False,
                                                                                      'SQL_TYPE': 'VARCHAR',
                                                                                      'WIDTH': 20},
                                                           'INTERNAL_VERSION': {'NULLABLE': True,
                                                                                'ORDER': 7,
                                                                                'PRECISION': 0,
                                                                                'PRIMARY_KEY': False,
                                                                                'SQL_TYPE': 'INT',
                                                                                'WIDTH': 10},
                                                           'MAJOR_REVISION': {'NULLABLE': True,
                                                                              'ORDER': 4,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'INT',
                                                                              'WIDTH': 10},
                                                           'MINOR_REVISION': {'NULLABLE': True,
                                                                              'ORDER': 5,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'INT',
                                                                              'WIDTH': 10},
                                                           'ORDINAL': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                                           'REVISION_DATE': {'NULLABLE': True,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': False,
                                                                             'SQL_TYPE': 'DATE',
                                                                             'WIDTH': 15},
                                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 15}},
                                        'ATTRIBUTE_MAP': {'DATA_CONTENT_TYPE': ('pdbx_audit_revision_history',
                                                                                'data_content_type',
                                                                                None,
                                                                                None),
                                                          'INTERNAL_DEPOSITION_ID': ('pdbx_audit_revision_history',
                                                                                     'internal_deposition_id',
                                                                                     None,
                                                                                     None),
                                                          'INTERNAL_VERSION': ('pdbx_audit_revision_history',
                                                                               'internal_version',
                                                                               None,
                                                                               None),
                                                          'MAJOR_REVISION': ('pdbx_audit_revision_history',
                                                                             'major_revision',
                                                                             None,
                                                                             None),
                                                          'MINOR_REVISION': ('pdbx_audit_revision_history',
                                                                             'minor_revision',
                                                                             None,
                                                                             None),
                                                          'ORDINAL': ('pdbx_audit_revision_history', 'ordinal', None, None),
                                                          'REVISION_DATE': ('pdbx_audit_revision_history',
                                                                            'revision_date',
                                                                            None,
                                                                            None),
                                                          'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ORDINAL', 'DATA_CONTENT_TYPE'),
                                                           'TYPE': 'UNIQUE'},
                                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                        'MAP_MERGE_INDICES': {'pdbx_audit_revision_history': {'ATTRIBUTES': ('ordinal',
                                                                                                             'data_content_type'),
                                                                                              'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                        'TABLE_ID': 'PDBX_AUDIT_REVISION_HISTORY',
                                        'TABLE_NAME': 'pdbx_audit_revision_history',
                                        'TABLE_TYPE': 'transactional'},
        'PDBX_AUDIT_REVISION_ITEM': {'ATTRIBUTES': {'DATA_CONTENT_TYPE': 'data_content_type',
                                                    'ITEM': 'item',
                                                    'ORDINAL': 'ordinal',
                                                    'REVISION_ORDINAL': 'revision_ordinal',
                                                    'STRUCTURE_ID': 'Structure_ID'},
                                     'ATTRIBUTE_INFO': {'DATA_CONTENT_TYPE': {'NULLABLE': False,
                                                                              'ORDER': 4,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': True,
                                                                              'SQL_TYPE': 'VARCHAR',
                                                                              'WIDTH': 30},
                                                        'ITEM': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 30},
                                                        'ORDINAL': {'NULLABLE': False,
                                                                    'ORDER': 2,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                                        'REVISION_ORDINAL': {'NULLABLE': False,
                                                                             'ORDER': 3,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'INT',
                                                                             'WIDTH': 10},
                                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 15}},
                                     'ATTRIBUTE_MAP': {'DATA_CONTENT_TYPE': ('pdbx_audit_revision_item',
                                                                             'data_content_type',
                                                                             None,
                                                                             None),
                                                       'ITEM': ('pdbx_audit_revision_item', 'item', None, None),
                                                       'ORDINAL': ('pdbx_audit_revision_item', 'ordinal', None, None),
                                                       'REVISION_ORDINAL': ('pdbx_audit_revision_item',
                                                                            'revision_ordinal',
                                                                            None,
                                                                            None),
                                                       'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',
                                                                       'ORDINAL',
                                                                       'REVISION_ORDINAL',
                                                                       'DATA_CONTENT_TYPE'),
                                                        'TYPE': 'UNIQUE'},
                                                 's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                     'MAP_MERGE_INDICES': {'pdbx_audit_revision_item': {'ATTRIBUTES': ('ordinal',
                                                                                                       'revision_ordinal',
                                                                                                       'data_content_type'),
                                                                                        'TYPE': 'EQUI-JOIN'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                     'TABLE_ID': 'PDBX_AUDIT_REVISION_ITEM',
                                     'TABLE_NAME': 'pdbx_audit_revision_item',
                                     'TABLE_TYPE': 'transactional'},
        'PDBX_CONTACT_AUTHOR': {'ATTRIBUTES': {'ADDRESS_1': 'address_1',
                                               'ADDRESS_2': 'address_2',
                                               'ADDRESS_3': 'address_3',
                                               'CITY': 'city',
                                               'CONTINENT': 'continent',
                                               'COUNTRY': 'country',
                                               'EMAIL': 'email',
                                               'FAX': 'fax',
                                               'IDENTIFIER_ORCID': 'identifier_ORCID',
                                               'NAME_FIRST': 'name_first',
                                               'NAME_LAST': 'name_last',
                                               'NAME_MI': 'name_mi',
                                               'NAME_SALUTATION': 'name_salutation',
                                               'ORGANIZATION_TYPE': 'organization_type',
                                               'PHONE': 'phone',
                                               'POSTAL_CODE': 'postal_code',
                                               'ROLE': 'role',
                                               'STATE_PROVINCE': 'state_province',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'ADDRESS_1': {'NULLABLE': True,
                                                                 'ORDER': 8,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 520},
                                                   'ADDRESS_2': {'NULLABLE': True,
                                                                 'ORDER': 9,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 255},
                                                   'ADDRESS_3': {'NULLABLE': True,
                                                                 'ORDER': 10,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 255},
                                                   'CITY': {'NULLABLE': True,
                                                            'ORDER': 11,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 60},
                                                   'CONTINENT': {'NULLABLE': True,
                                                                 'ORDER': 18,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 20},
                                                   'COUNTRY': {'NULLABLE': False,
                                                               'ORDER': 14,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 50},
                                                   'EMAIL': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 255},
                                                   'FAX': {'NULLABLE': True,
                                                           'ORDER': 16,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 60},
                                                   'IDENTIFIER_ORCID': {'NULLABLE': True,
                                                                        'ORDER': 19,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 20},
                                                   'NAME_FIRST': {'NULLABLE': True,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 60},
                                                   'NAME_LAST': {'NULLABLE': False,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 65},
                                                   'NAME_MI': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 50},
                                                   'NAME_SALUTATION': {'NULLABLE': True,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 15},
                                                   'ORGANIZATION_TYPE': {'NULLABLE': True,
                                                                         'ORDER': 17,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 40},
                                                   'PHONE': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 60},
                                                   'POSTAL_CODE': {'NULLABLE': True,
                                                                   'ORDER': 13,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 128},
                                                   'ROLE': {'NULLABLE': False,
                                                            'ORDER': 6,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 50},
                                                   'STATE_PROVINCE': {'NULLABLE': True,
                                                                      'ORDER': 12,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 70},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 15}},
                                'ATTRIBUTE_MAP': {'ADDRESS_1': ('pdbx_contact_author', 'address_1', None, None),
                                                  'ADDRESS_2': ('pdbx_contact_author', 'address_2', None, None),
                                                  'ADDRESS_3': ('pdbx_contact_author', 'address_3', None, None),
                                                  'CITY': ('pdbx_contact_author', 'city', None, None),
                                                  'CONTINENT': ('pdbx_contact_author', 'continent', None, None),
                                                  'COUNTRY': ('pdbx_contact_author', 'country', None, None),
                                                  'EMAIL': ('pdbx_contact_author', 'email', None, None),
                                                  'FAX': ('pdbx_contact_author', 'fax', None, None),
                                                  'IDENTIFIER_ORCID': ('pdbx_contact_author', 'identifier_ORCID', None, None),
                                                  'NAME_FIRST': ('pdbx_contact_author', 'name_first', None, None),
                                                  'NAME_LAST': ('pdbx_contact_author', 'name_last', None, None),
                                                  'NAME_MI': ('pdbx_contact_author', 'name_mi', None, None),
                                                  'NAME_SALUTATION': ('pdbx_contact_author', 'name_salutation', None, None),
                                                  'ORGANIZATION_TYPE': ('pdbx_contact_author',
                                                                        'organization_type',
                                                                        None,
                                                                        None),
                                                  'PHONE': ('pdbx_contact_author', 'phone', None, None),
                                                  'POSTAL_CODE': ('pdbx_contact_author', 'postal_code', None, None),
                                                  'ROLE': ('pdbx_contact_author', 'role', None, None),
                                                  'STATE_PROVINCE': ('pdbx_contact_author', 'state_province', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'PDBX_CONTACT_AUTHOR',
                                'TABLE_NAME': 'pdbx_contact_author',
                                'TABLE_TYPE': 'transactional'},
        'PDBX_DATABASE_PDB_OBS_SPR': {'ATTRIBUTES': {'DATE': 'date',
                                                     'DETAILS': 'details',
                                                     'ID': 'id',
                                                     'PDB_ID': 'pdb_id',
                                                     'REPLACE_PDB_ID': 'replace_pdb_id',
                                                     'STRUCTURE_ID': 'Structure_ID'},
                                      'ATTRIBUTE_INFO': {'DATE': {'NULLABLE': True,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 19},
                                                         'DETAILS': {'NULLABLE': True,
                                                                     'ORDER': 6,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 550},
                                                         'ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                         'PDB_ID': {'NULLABLE': False,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 30},
                                                         'REPLACE_PDB_ID': {'NULLABLE': False,
                                                                            'ORDER': 5,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80},
                                                         'STRUCTURE_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 15}},
                                      'ATTRIBUTE_MAP': {'DATE': ('pdbx_database_PDB_obs_spr', 'date', None, None),
                                                        'DETAILS': ('pdbx_database_PDB_obs_spr', 'details', None, None),
                                                        'ID': ('pdbx_database_PDB_obs_spr', 'id', None, None),
                                                        'PDB_ID': ('pdbx_database_PDB_obs_spr', 'pdb_id', None, None),
                                                        'REPLACE_PDB_ID': ('pdbx_database_PDB_obs_spr',
                                                                           'replace_pdb_id',
                                                                           None,
                                                                           None),
                                                        'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PDB_ID', 'REPLACE_PDB_ID'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_database_PDB_obs_spr': {'ATTRIBUTES': ('pdb_id',
                                                                                                         'replace_pdb_id'),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                      'TABLE_ID': 'PDBX_DATABASE_PDB_OBS_SPR',
                                      'TABLE_NAME': 'pdbx_database_PDB_obs_spr',
                                      'TABLE_TYPE': 'transactional'},
        'PDBX_DATABASE_RELATED': {'ATTRIBUTES': {'CONTENT_TYPE': 'content_type',
                                                 'DB_ID': 'db_id',
                                                 'DB_NAME': 'db_name',
                                                 'DETAILS': 'details',
                                                 'STRUCTURE_ID': 'Structure_ID'},
                                  'ATTRIBUTE_INFO': {'CONTENT_TYPE': {'NULLABLE': False,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                                     'DB_ID': {'NULLABLE': False,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 80},
                                                     'DB_NAME': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 12},
                                                     'DETAILS': {'NULLABLE': True,
                                                                 'ORDER': 3,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 5000},
                                                     'STRUCTURE_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 15}},
                                  'ATTRIBUTE_MAP': {'CONTENT_TYPE': ('pdbx_database_related', 'content_type', None, None),
                                                    'DB_ID': ('pdbx_database_related', 'db_id', None, None),
                                                    'DB_NAME': ('pdbx_database_related', 'db_name', None, None),
                                                    'DETAILS': ('pdbx_database_related', 'details', None, None),
                                                    'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                  'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'DB_NAME', 'DB_ID', 'CONTENT_TYPE'),
                                                     'TYPE': 'UNIQUE'},
                                              's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                  'MAP_MERGE_INDICES': {'pdbx_database_related': {'ATTRIBUTES': ('db_name',
                                                                                                 'db_id',
                                                                                                 'content_type'),
                                                                                  'TYPE': 'EQUI-JOIN'}},
                                  'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                  'TABLE_ID': 'PDBX_DATABASE_RELATED',
                                  'TABLE_NAME': 'pdbx_database_related',
                                  'TABLE_TYPE': 'transactional'},
        'PDBX_DEPOSIT_GROUP': {'ATTRIBUTES': {'GROUP_DESCRIPTION': 'group_description',
                                              'GROUP_ID': 'group_id',
                                              'GROUP_TITLE': 'group_title',
                                              'STRUCTURE_ID': 'Structure_ID'},
                               'ATTRIBUTE_INFO': {'GROUP_DESCRIPTION': {'NULLABLE': True,
                                                                        'ORDER': 4,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 200},
                                                  'GROUP_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 12},
                                                  'GROUP_TITLE': {'NULLABLE': True,
                                                                  'ORDER': 3,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                  'STRUCTURE_ID': {'NULLABLE': False,
                                                                   'ORDER': 1,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 15}},
                               'ATTRIBUTE_MAP': {'GROUP_DESCRIPTION': ('pdbx_deposit_group', 'group_description', None, None),
                                                 'GROUP_ID': ('pdbx_deposit_group', 'group_id', None, None),
                                                 'GROUP_TITLE': ('pdbx_deposit_group', 'group_title', None, None),
                                                 'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                               'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'GROUP_ID'), 'TYPE': 'UNIQUE'},
                                           's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                               'MAP_MERGE_INDICES': {'pdbx_deposit_group': {'ATTRIBUTES': ('group_id',), 'TYPE': 'EQUI-JOIN'}},
                               'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                               'TABLE_ID': 'PDBX_DEPOSIT_GROUP',
                               'TABLE_NAME': 'pdbx_deposit_group',
                               'TABLE_TYPE': 'transactional'},
        'PDBX_DEPUI_ENTRY_DETAILS': {'ATTRIBUTES': {'COUNTRY': 'country',
                                                    'EXPERIMENTAL_METHODS': 'experimental_methods',
                                                    'RELATED_DATABASE_CODE': 'related_database_code',
                                                    'RELATED_DATABASE_NAME': 'related_database_name',
                                                    'REPLACE_PDB_ID': 'replace_pdb_id',
                                                    'REQUESTED_ACCESSION_TYPES': 'requested_accession_types',
                                                    'STRUCTURAL_GENOMICS_FLAG': 'structural_genomics_flag',
                                                    'STRUCTURE_ID': 'Structure_ID',
                                                    'VALIDATED_CONTACT_EMAIL': 'validated_contact_email',
                                                    'WWPDB_SITE_ID': 'wwpdb_site_id'},
                                     'ATTRIBUTE_INFO': {'COUNTRY': {'NULLABLE': False,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 50},
                                                        'EXPERIMENTAL_METHODS': {'NULLABLE': False,
                                                                                 'ORDER': 2,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 80},
                                                        'RELATED_DATABASE_CODE': {'NULLABLE': True,
                                                                                  'ORDER': 8,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 20},
                                                        'RELATED_DATABASE_NAME': {'NULLABLE': True,
                                                                                  'ORDER': 7,
                                                                                  'PRECISION': 0,
                                                                                  'PRIMARY_KEY': False,
                                                                                  'SQL_TYPE': 'VARCHAR',
                                                                                  'WIDTH': 10},
                                                        'REPLACE_PDB_ID': {'NULLABLE': True,
                                                                           'ORDER': 6,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 40},
                                                        'REQUESTED_ACCESSION_TYPES': {'NULLABLE': False,
                                                                                      'ORDER': 3,
                                                                                      'PRECISION': 0,
                                                                                      'PRIMARY_KEY': False,
                                                                                      'SQL_TYPE': 'VARCHAR',
                                                                                      'WIDTH': 20},
                                                        'STRUCTURAL_GENOMICS_FLAG': {'NULLABLE': True,
                                                                                     'ORDER': 9,
                                                                                     'PRECISION': 0,
                                                                                     'PRIMARY_KEY': False,
                                                                                     'SQL_TYPE': 'VARCHAR',
                                                                                     'WIDTH': 2},
                                                        'STRUCTURE_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 15},
                                                        'VALIDATED_CONTACT_EMAIL': {'NULLABLE': False,
                                                                                    'ORDER': 4,
                                                                                    'PRECISION': 0,
                                                                                    'PRIMARY_KEY': False,
                                                                                    'SQL_TYPE': 'VARCHAR',
                                                                                    'WIDTH': 100},
                                                        'WWPDB_SITE_ID': {'NULLABLE': True,
                                                                          'ORDER': 10,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 40}},
                                     'ATTRIBUTE_MAP': {'COUNTRY': ('pdbx_depui_entry_details', 'country', None, None),
                                                       'EXPERIMENTAL_METHODS': ('pdbx_depui_entry_details',
                                                                                'experimental_methods',
                                                                                None,
                                                                                None),
                                                       'RELATED_DATABASE_CODE': ('pdbx_depui_entry_details',
                                                                                 'related_database_code',
                                                                                 None,
                                                                                 None),
                                                       'RELATED_DATABASE_NAME': ('pdbx_depui_entry_details',
                                                                                 'related_database_name',
                                                                                 None,
                                                                                 None),
                                                       'REPLACE_PDB_ID': ('pdbx_depui_entry_details',
                                                                          'replace_pdb_id',
                                                                          None,
                                                                          None),
                                                       'REQUESTED_ACCESSION_TYPES': ('pdbx_depui_entry_details',
                                                                                     'requested_accession_types',
                                                                                     None,
                                                                                     None),
                                                       'STRUCTURAL_GENOMICS_FLAG': ('pdbx_depui_entry_details',
                                                                                    'structural_genomics_flag',
                                                                                    None,
                                                                                    None),
                                                       'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                       'VALIDATED_CONTACT_EMAIL': ('pdbx_depui_entry_details',
                                                                                   'validated_contact_email',
                                                                                   None,
                                                                                   None),
                                                       'WWPDB_SITE_ID': ('pdbx_depui_entry_details',
                                                                         'wwpdb_site_id',
                                                                         None,
                                                                         None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'},
                                                 's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                     'TABLE_ID': 'PDBX_DEPUI_ENTRY_DETAILS',
                                     'TABLE_NAME': 'pdbx_depui_entry_details',
                                     'TABLE_TYPE': 'transactional'},
        'PDBX_ENTITY_NONPOLY': {'ATTRIBUTES': {'COMP_ID': 'comp_id',
                                               'ENTITY_ID': 'entity_id',
                                               'NAME': 'name',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'COMP_ID': {'NULLABLE': True,
                                                               'ORDER': 3,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'ENTITY_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                   'NAME': {'NULLABLE': True,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 1023},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 15}},
                                'ATTRIBUTE_MAP': {'COMP_ID': ('pdbx_entity_nonpoly', 'comp_id', None, None),
                                                  'ENTITY_ID': ('pdbx_entity_nonpoly', 'entity_id', None, None),
                                                  'NAME': ('pdbx_entity_nonpoly', 'name', None, None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'pdbx_entity_nonpoly': {'ATTRIBUTES': ('entity_id',),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'PDBX_ENTITY_NONPOLY',
                                'TABLE_NAME': 'pdbx_entity_nonpoly',
                                'TABLE_TYPE': 'transactional'},
        'PDBX_MOLECULE': {'ATTRIBUTES': {'ASYM_ID': 'asym_id',
                                         'INSTANCE_ID': 'instance_id',
                                         'PRD_ID': 'prd_id',
                                         'STRUCTURE_ID': 'Structure_ID'},
                          'ATTRIBUTE_INFO': {'ASYM_ID': {'NULLABLE': False,
                                                         'ORDER': 4,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                             'INSTANCE_ID': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                             'PRD_ID': {'NULLABLE': False,
                                                        'ORDER': 2,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': True,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 10},
                                             'STRUCTURE_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 15}},
                          'ATTRIBUTE_MAP': {'ASYM_ID': ('pdbx_molecule', 'asym_id', None, None),
                                            'INSTANCE_ID': ('pdbx_molecule', 'instance_id', None, None),
                                            'PRD_ID': ('pdbx_molecule', 'prd_id', None, None),
                                            'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PRD_ID', 'INSTANCE_ID', 'ASYM_ID'),
                                             'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'pdbx_molecule': {'ATTRIBUTES': ('prd_id', 'instance_id', 'asym_id'),
                                                                  'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                          'TABLE_ID': 'PDBX_MOLECULE',
                          'TABLE_NAME': 'pdbx_molecule',
                          'TABLE_TYPE': 'transactional'},
        'PDBX_MOLECULE_FEATURES': {'ATTRIBUTES': {'CLASS': 'class',
                                                  'DETAILS': 'details',
                                                  'NAME': 'name',
                                                  'PRD_ID': 'prd_id',
                                                  'STRUCTURE_ID': 'Structure_ID',
                                                  'TYPE': 'type'},
                                   'ATTRIBUTE_INFO': {'CLASS': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200},
                                                      'DETAILS': {'NULLABLE': True,
                                                                  'ORDER': 6,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                      'NAME': {'NULLABLE': True,
                                                               'ORDER': 5,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 200},
                                                      'PRD_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 15},
                                                      'TYPE': {'NULLABLE': True,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 80}},
                                   'ATTRIBUTE_MAP': {'CLASS': ('pdbx_molecule_features', 'class', None, None),
                                                     'DETAILS': ('pdbx_molecule_features', 'details', None, None),
                                                     'NAME': ('pdbx_molecule_features', 'name', None, None),
                                                     'PRD_ID': ('pdbx_molecule_features', 'prd_id', None, None),
                                                     'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                     'TYPE': ('pdbx_molecule_features', 'type', None, None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'PRD_ID'), 'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'pdbx_molecule_features': {'ATTRIBUTES': ('prd_id',),
                                                                                    'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                   'TABLE_ID': 'PDBX_MOLECULE_FEATURES',
                                   'TABLE_NAME': 'pdbx_molecule_features',
                                   'TABLE_TYPE': 'transactional'},
        'PDBX_PRERELEASE_SEQ': {'ATTRIBUTES': {'ENTITY_ID': 'entity_id',
                                               'SEQ_ONE_LETTER_CODE': 'seq_one_letter_code',
                                               'STRUCTURE_ID': 'Structure_ID'},
                                'ATTRIBUTE_INFO': {'ENTITY_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                                   'SEQ_ONE_LETTER_CODE': {'NULLABLE': True,
                                                                           'ORDER': 3,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 16400},
                                                   'STRUCTURE_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 15}},
                                'ATTRIBUTE_MAP': {'ENTITY_ID': ('pdbx_prerelease_seq', 'entity_id', None, None),
                                                  'SEQ_ONE_LETTER_CODE': ('pdbx_prerelease_seq',
                                                                          'seq_one_letter_code',
                                                                          None,
                                                                          None),
                                                  'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTITY_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'pdbx_prerelease_seq': {'ATTRIBUTES': ('entity_id',),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                'TABLE_ID': 'PDBX_PRERELEASE_SEQ',
                                'TABLE_NAME': 'pdbx_prerelease_seq',
                                'TABLE_TYPE': 'transactional'},
        'PDB_STATUS_INFORMATION': {'ATTRIBUTES': {'REVISION_DATE': 'Revision_Date',
                                                  'REVISION_NUMBER': 'Revision_Number',
                                                  'REVISION_RECORDS': 'Revision_Records',
                                                  'REVISION_TYPE': 'Revision_Type',
                                                  'STRUCTURE_ID': 'Structure_ID'},
                                   'ATTRIBUTE_INFO': {'REVISION_DATE': {'NULLABLE': True,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'DATE',
                                                                        'WIDTH': 19},
                                                      'REVISION_NUMBER': {'NULLABLE': False,
                                                                          'ORDER': 2,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'INT',
                                                                          'WIDTH': 10},
                                                      'REVISION_RECORDS': {'NULLABLE': True,
                                                                           'ORDER': 5,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'VARCHAR',
                                                                           'WIDTH': 255},
                                                      'REVISION_TYPE': {'NULLABLE': True,
                                                                        'ORDER': 4,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'INT',
                                                                        'WIDTH': 10},
                                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 15}},
                                   'ATTRIBUTE_MAP': {'REVISION_DATE': ('database_PDB_rev', 'date', None, None),
                                                     'REVISION_NUMBER': ('database_PDB_rev', 'num', None, None),
                                                     'REVISION_RECORDS': ('database_PDB_rev_record',
                                                                          'type',
                                                                          'collapse(comma)',
                                                                          None),
                                                     'REVISION_TYPE': ('database_PDB_rev', 'mod_type', None, None),
                                                     'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'REVISION_NUMBER'), 'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'database_PDB_rev': {'ATTRIBUTES': ('num',), 'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                   'TABLE_ID': 'PDB_STATUS_INFORMATION',
                                   'TABLE_NAME': 'PDB_status_information',
                                   'TABLE_TYPE': 'transactional'},
        'PROCESSING_STATUS': {'ATTRIBUTES': {'END_DATE': 'End_Date',
                                             'PROCESS_DESCRIPTION': 'Process_Description',
                                             'SERIAL_NO': 'Serial_No',
                                             'START_DATE': 'Start_Date',
                                             'STRUCTURE_ID': 'Structure_ID'},
                              'ATTRIBUTE_INFO': {'END_DATE': {'NULLABLE': True,
                                                              'ORDER': 4,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'DATE',
                                                              'WIDTH': 19},
                                                 'PROCESS_DESCRIPTION': {'NULLABLE': True,
                                                                         'ORDER': 5,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 32000},
                                                 'SERIAL_NO': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                                 'START_DATE': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 19},
                                                 'STRUCTURE_ID': {'NULLABLE': False,
                                                                  'ORDER': 1,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 15}},
                              'ATTRIBUTE_MAP': {'END_DATE': ('pdbx_database_proc', 'date_end_cycle', None, None),
                                                'PROCESS_DESCRIPTION': ('pdbx_database_proc', 'details', None, None),
                                                'SERIAL_NO': ('pdbx_database_proc', 'cycle_id', None, None),
                                                'START_DATE': ('pdbx_database_proc', 'date_begin_cycle', None, None),
                                                'STRUCTURE_ID': (None, None, 'datablockid()', None)},
                              'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'SERIAL_NO'), 'TYPE': 'UNIQUE'},
                                          's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                              'MAP_MERGE_INDICES': {'pdbx_database_proc': {'ATTRIBUTES': ('cycle_id',), 'TYPE': 'EQUI-JOIN'}},
                              'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                              'TABLE_ID': 'PROCESSING_STATUS',
                              'TABLE_NAME': 'processing_status',
                              'TABLE_TYPE': 'transactional'},
        'RCSB_STATUS': {'ATTRIBUTES': {'AUTHOR_APPROVAL_TYPE': 'author_approval_type',
                                       'AUTHOR_LIST': 'author_list',
                                       'AUTHOR_RELEASE_SEQUENCE': 'author_release_sequence',
                                       'AUTHOR_RELEASE_STATUS_CODE': 'author_release_status_code',
                                       'DATE_AUTHOR_APPROVAL': 'date_author_approval',
                                       'DATE_AUTHOR_RELEASE_REQUEST': 'date_author_release_request',
                                       'DATE_BEGIN_DEPOSITION': 'date_begin_deposition',
                                       'DATE_BEGIN_PROCESSING': 'date_begin_processing',
                                       'DATE_BEGIN_RELEASE_PREPARATION': 'date_begin_release_preparation',
                                       'DATE_CHEMICAL_SHIFTS': 'date_chemical_shifts',
                                       'DATE_COORDINATES': 'date_coordinates',
                                       'DATE_DEPOSITION_FORM': 'date_deposition_form',
                                       'DATE_END_PROCESSING': 'date_end_processing',
                                       'DATE_HOLD_CHEMICAL_SHIFTS': 'date_hold_chemical_shifts',
                                       'DATE_HOLD_COORDINATES': 'date_hold_coordinates',
                                       'DATE_HOLD_NMR_CONSTRAINTS': 'date_hold_nmr_constraints',
                                       'DATE_HOLD_NMR_DATA': 'date_hold_nmr_data',
                                       'DATE_HOLD_STRUCT_FACT': 'date_hold_struct_fact',
                                       'DATE_LAST_UPDATE': 'date_last_update',
                                       'DATE_MANUSCRIPT': 'date_manuscript',
                                       'DATE_NMR_CONSTRAINTS': 'date_nmr_constraints',
                                       'DATE_NMR_DATA': 'date_nmr_data',
                                       'DATE_OF_CS_RELEASE': 'date_of_cs_release',
                                       'DATE_OF_MR_RELEASE': 'date_of_mr_release',
                                       'DATE_OF_NMR_DATA_RELEASE': 'date_of_nmr_data_release',
                                       'DATE_OF_RCSB_RELEASE': 'date_of_RCSB_release',
                                       'DATE_OF_SF_RELEASE': 'date_of_sf_release',
                                       'DATE_STRUCT_FACT': 'date_struct_fact',
                                       'DEPOSIT_SITE': 'deposit_site',
                                       'DEP_RELEASE_CODE_NMR_DATA': 'dep_release_code_nmr_data',
                                       'EBI_ID': 'ebi_id',
                                       'EXP_METHOD': 'exp_method',
                                       'HEADER': 'header',
                                       'INITIAL_DEPOSITION_DATE': 'initial_deposition_date',
                                       'KEYWORDS': 'keywords',
                                       'METHODS_DEVELOPMENT_CATEGORY': 'methods_development_category',
                                       'NDB_ID': 'ndb_id',
                                       'PDB_FORMAT_COMPATIBLE': 'pdb_format_compatible',
                                       'PDB_ID': 'pdb_id',
                                       'POST_REL_RECVD_COORD': 'post_rel_recvd_coord',
                                       'POST_REL_RECVD_COORD_DATE': 'post_rel_recvd_coord_date',
                                       'POST_REL_STATUS': 'post_rel_status',
                                       'PROCESS_SITE': 'process_site',
                                       'RCSB_ANNOTATOR': 'rcsb_annotator',
                                       'RECVD_AUTHOR_APPROVAL': 'recvd_author_approval',
                                       'RECVD_CHEMICAL_SHIFTS': 'recvd_chemical_shifts',
                                       'RECVD_COORDINATES': 'recvd_coordinates',
                                       'RECVD_NMR_CONSTRAINTS': 'recvd_nmr_constraints',
                                       'RECVD_NMR_DATA': 'recvd_nmr_data',
                                       'RECVD_STRUCT_FACT': 'recvd_struct_fact',
                                       'REPLACED_ENTRY_ID': 'replaced_entry_id',
                                       'REVISION_DESCRIPTION': 'revision_description',
                                       'SG_ENTRY': 'SG_entry',
                                       'STATUS_CODE': 'status_code',
                                       'STATUS_CODE_CS': 'status_code_cs',
                                       'STATUS_CODE_MR': 'status_code_mr',
                                       'STATUS_CODE_NMR_DATA': 'status_code_nmr_data',
                                       'STATUS_CODE_SF': 'status_code_sf',
                                       'STRUCTURE_ID': 'Structure_ID',
                                       'SUPPRESSED_TITLE_Y_N': 'suppressed_title_Y_N',
                                       'TITLE': 'title',
                                       'TITLEUC': 'titleUC'},
                        'ATTRIBUTE_INFO': {'AUTHOR_APPROVAL_TYPE': {'NULLABLE': True,
                                                                    'ORDER': 11,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                           'AUTHOR_LIST': {'NULLABLE': True,
                                                           'ORDER': 23,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 1000},
                                           'AUTHOR_RELEASE_SEQUENCE': {'NULLABLE': True,
                                                                       'ORDER': 27,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 20},
                                           'AUTHOR_RELEASE_STATUS_CODE': {'NULLABLE': True,
                                                                          'ORDER': 5,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': False,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                           'DATE_AUTHOR_APPROVAL': {'NULLABLE': True,
                                                                    'ORDER': 9,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 19},
                                           'DATE_AUTHOR_RELEASE_REQUEST': {'NULLABLE': True,
                                                                           'ORDER': 44,
                                                                           'PRECISION': 0,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'DATE',
                                                                           'WIDTH': 19},
                                           'DATE_BEGIN_DEPOSITION': {'NULLABLE': True,
                                                                     'ORDER': 43,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'DATE',
                                                                     'WIDTH': 19},
                                           'DATE_BEGIN_PROCESSING': {'NULLABLE': True,
                                                                     'ORDER': 46,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'DATE',
                                                                     'WIDTH': 19},
                                           'DATE_BEGIN_RELEASE_PREPARATION': {'NULLABLE': True,
                                                                              'ORDER': 45,
                                                                              'PRECISION': 0,
                                                                              'PRIMARY_KEY': False,
                                                                              'SQL_TYPE': 'DATE',
                                                                              'WIDTH': 19},
                                           'DATE_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                    'ORDER': 40,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 19},
                                           'DATE_COORDINATES': {'NULLABLE': True,
                                                                'ORDER': 17,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 19},
                                           'DATE_DEPOSITION_FORM': {'NULLABLE': True,
                                                                    'ORDER': 16,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 19},
                                           'DATE_END_PROCESSING': {'NULLABLE': True,
                                                                   'ORDER': 47,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'DATE',
                                                                   'WIDTH': 19},
                                           'DATE_HOLD_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                         'ORDER': 41,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'DATE',
                                                                         'WIDTH': 19},
                                           'DATE_HOLD_COORDINATES': {'NULLABLE': True,
                                                                     'ORDER': 12,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'DATE',
                                                                     'WIDTH': 19},
                                           'DATE_HOLD_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                         'ORDER': 14,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'DATE',
                                                                         'WIDTH': 19},
                                           'DATE_HOLD_NMR_DATA': {'NULLABLE': True,
                                                                  'ORDER': 60,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 19},
                                           'DATE_HOLD_STRUCT_FACT': {'NULLABLE': True,
                                                                     'ORDER': 13,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'DATE',
                                                                     'WIDTH': 19},
                                           'DATE_LAST_UPDATE': {'NULLABLE': True,
                                                                'ORDER': 26,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATETIME',
                                                                'WIDTH': 19},
                                           'DATE_MANUSCRIPT': {'NULLABLE': True,
                                                               'ORDER': 19,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'DATE',
                                                               'WIDTH': 19},
                                           'DATE_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                    'ORDER': 20,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 19},
                                           'DATE_NMR_DATA': {'NULLABLE': True,
                                                             'ORDER': 59,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'DATE',
                                                             'WIDTH': 19},
                                           'DATE_OF_CS_RELEASE': {'NULLABLE': True,
                                                                  'ORDER': 42,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 19},
                                           'DATE_OF_MR_RELEASE': {'NULLABLE': True,
                                                                  'ORDER': 32,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 19},
                                           'DATE_OF_NMR_DATA_RELEASE': {'NULLABLE': True,
                                                                        'ORDER': 62,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'DATE',
                                                                        'WIDTH': 19},
                                           'DATE_OF_RCSB_RELEASE': {'NULLABLE': True,
                                                                    'ORDER': 15,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'DATE',
                                                                    'WIDTH': 19},
                                           'DATE_OF_SF_RELEASE': {'NULLABLE': True,
                                                                  'ORDER': 31,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'DATE',
                                                                  'WIDTH': 19},
                                           'DATE_STRUCT_FACT': {'NULLABLE': True,
                                                                'ORDER': 18,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATE',
                                                                'WIDTH': 19},
                                           'DEPOSIT_SITE': {'NULLABLE': True,
                                                            'ORDER': 6,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                           'DEP_RELEASE_CODE_NMR_DATA': {'NULLABLE': True,
                                                                         'ORDER': 61,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 24},
                                           'EBI_ID': {'NULLABLE': True,
                                                      'ORDER': 36,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                           'EXP_METHOD': {'NULLABLE': True,
                                                          'ORDER': 33,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 80},
                                           'HEADER': {'NULLABLE': True,
                                                      'ORDER': 34,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 80},
                                           'INITIAL_DEPOSITION_DATE': {'NULLABLE': True,
                                                                       'ORDER': 8,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'DATE',
                                                                       'WIDTH': 19},
                                           'KEYWORDS': {'NULLABLE': True,
                                                        'ORDER': 35,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 1100},
                                           'METHODS_DEVELOPMENT_CATEGORY': {'NULLABLE': True,
                                                                            'ORDER': 52,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 20},
                                           'NDB_ID': {'NULLABLE': True,
                                                      'ORDER': 37,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                           'PDB_FORMAT_COMPATIBLE': {'NULLABLE': True,
                                                                     'ORDER': 53,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 2},
                                           'PDB_ID': {'NULLABLE': True,
                                                      'ORDER': 2,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': False,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 9},
                                           'POST_REL_RECVD_COORD': {'NULLABLE': True,
                                                                    'ORDER': 55,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 1},
                                           'POST_REL_RECVD_COORD_DATE': {'NULLABLE': True,
                                                                         'ORDER': 56,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'DATE',
                                                                         'WIDTH': 19},
                                           'POST_REL_STATUS': {'NULLABLE': True,
                                                               'ORDER': 54,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                           'PROCESS_SITE': {'NULLABLE': True,
                                                            'ORDER': 7,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 10},
                                           'RCSB_ANNOTATOR': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                           'RECVD_AUTHOR_APPROVAL': {'NULLABLE': True,
                                                                     'ORDER': 10,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 1},
                                           'RECVD_CHEMICAL_SHIFTS': {'NULLABLE': True,
                                                                     'ORDER': 51,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 1},
                                           'RECVD_COORDINATES': {'NULLABLE': True,
                                                                 'ORDER': 48,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 1},
                                           'RECVD_NMR_CONSTRAINTS': {'NULLABLE': True,
                                                                     'ORDER': 50,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 1},
                                           'RECVD_NMR_DATA': {'NULLABLE': True,
                                                              'ORDER': 58,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 1},
                                           'RECVD_STRUCT_FACT': {'NULLABLE': True,
                                                                 'ORDER': 49,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 1},
                                           'REPLACED_ENTRY_ID': {'NULLABLE': True,
                                                                 'ORDER': 21,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                           'REVISION_DESCRIPTION': {'NULLABLE': True,
                                                                    'ORDER': 22,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 255},
                                           'SG_ENTRY': {'NULLABLE': True,
                                                        'ORDER': 30,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 50},
                                           'STATUS_CODE': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                           'STATUS_CODE_CS': {'NULLABLE': True,
                                                              'ORDER': 39,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                           'STATUS_CODE_MR': {'NULLABLE': True,
                                                              'ORDER': 29,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                           'STATUS_CODE_NMR_DATA': {'NULLABLE': True,
                                                                    'ORDER': 57,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                           'STATUS_CODE_SF': {'NULLABLE': True,
                                                              'ORDER': 28,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                           'STRUCTURE_ID': {'NULLABLE': False,
                                                            'ORDER': 1,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 15},
                                           'SUPPRESSED_TITLE_Y_N': {'NULLABLE': True,
                                                                    'ORDER': 38,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 2},
                                           'TITLE': {'NULLABLE': True,
                                                     'ORDER': 24,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 500},
                                           'TITLEUC': {'NULLABLE': True,
                                                       'ORDER': 25,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 500}},
                        'ATTRIBUTE_MAP': {'AUTHOR_APPROVAL_TYPE': ('pdbx_database_status', 'author_approval_type', None, None),
                                          'AUTHOR_LIST': ('audit_author', 'name', 'collapse(comma)', None),
                                          'AUTHOR_RELEASE_SEQUENCE': ('pdbx_database_status',
                                                                      'dep_release_code_sequence',
                                                                      None,
                                                                      None),
                                          'AUTHOR_RELEASE_STATUS_CODE': ('pdbx_database_status',
                                                                         'author_release_status_code',
                                                                         None,
                                                                         None),
                                          'DATE_AUTHOR_APPROVAL': ('pdbx_database_status',
                                                                   'date_author_approval',
                                                                   'datecnv(sybase)',
                                                                   None),
                                          'DATE_AUTHOR_RELEASE_REQUEST': ('pdbx_database_status',
                                                                          'date_author_release_request',
                                                                          None,
                                                                          None),
                                          'DATE_BEGIN_DEPOSITION': ('pdbx_database_status',
                                                                    'date_begin_deposition',
                                                                    None,
                                                                    None),
                                          'DATE_BEGIN_PROCESSING': ('pdbx_database_status',
                                                                    'date_begin_processing',
                                                                    None,
                                                                    None),
                                          'DATE_BEGIN_RELEASE_PREPARATION': ('pdbx_database_status',
                                                                             'date_begin_release_preparation',
                                                                             None,
                                                                             None),
                                          'DATE_CHEMICAL_SHIFTS': ('pdbx_database_status', 'date_chemical_shifts', None, None),
                                          'DATE_COORDINATES': ('pdbx_database_status',
                                                               'date_coordinates',
                                                               'datecnv(sybase)',
                                                               None),
                                          'DATE_DEPOSITION_FORM': ('pdbx_database_status',
                                                                   'date_deposition_form',
                                                                   'datecnv(sybase)',
                                                                   None),
                                          'DATE_END_PROCESSING': ('pdbx_database_status', 'date_end_processing', None, None),
                                          'DATE_HOLD_CHEMICAL_SHIFTS': ('pdbx_database_status',
                                                                        'date_hold_chemical_shifts',
                                                                        None,
                                                                        None),
                                          'DATE_HOLD_COORDINATES': ('pdbx_database_status',
                                                                    'date_hold_coordinates',
                                                                    'datecnv(sybase)',
                                                                    None),
                                          'DATE_HOLD_NMR_CONSTRAINTS': ('pdbx_database_status',
                                                                        'date_hold_nmr_constraints',
                                                                        'datecnv(sybase)',
                                                                        None),
                                          'DATE_HOLD_NMR_DATA': ('pdbx_database_status',
                                                                 'date_hold_nmr_data',
                                                                 'datecnv(sybase)',
                                                                 None),
                                          'DATE_HOLD_STRUCT_FACT': ('pdbx_database_status',
                                                                    'date_hold_struct_fact',
                                                                    'datecnv(sybase)',
                                                                    None),
                                          'DATE_LAST_UPDATE': (None, None, 'today()', None),
                                          'DATE_MANUSCRIPT': ('pdbx_database_status',
                                                              'date_manuscript',
                                                              'datecnv(sybase)',
                                                              None),
                                          'DATE_NMR_CONSTRAINTS': ('pdbx_database_status',
                                                                   'date_nmr_constraints',
                                                                   'datecnv(sybase)',
                                                                   None),
                                          'DATE_NMR_DATA': ('pdbx_database_status', 'date_nmr_data', 'datecnv(sybase)', None),
                                          'DATE_OF_CS_RELEASE': ('pdbx_database_status', 'date_of_cs_release', None, None),
                                          'DATE_OF_MR_RELEASE': ('pdbx_database_status', 'date_of_mr_release', None, None),
                                          'DATE_OF_NMR_DATA_RELEASE': ('pdbx_database_status',
                                                                       'date_of_nmr_data_release',
                                                                       'datecnv(sybase)',
                                                                       None),
                                          'DATE_OF_RCSB_RELEASE': ('pdbx_database_status',
                                                                   'date_of_NDB_release',
                                                                   'datecnv(sybase)',
                                                                   None),
                                          'DATE_OF_SF_RELEASE': ('pdbx_database_status', 'date_of_sf_release', None, None),
                                          'DATE_STRUCT_FACT': ('pdbx_database_status',
                                                               'date_struct_fact',
                                                               'datecnv(sybase)',
                                                               None),
                                          'DEPOSIT_SITE': ('pdbx_database_status', 'deposit_site', None, None),
                                          'DEP_RELEASE_CODE_NMR_DATA': ('pdbx_database_status',
                                                                        'dep_release_code_nmr_data',
                                                                        None,
                                                                        None),
                                          'EBI_ID': (None, None, None, None),
                                          'EXP_METHOD': ('exptl', 'method', 'collapse(comma)', None),
                                          'HEADER': ('struct_keywords', 'pdbx_keywords', None, None),
                                          'INITIAL_DEPOSITION_DATE': ('pdbx_database_status',
                                                                      'recvd_initial_deposition_date',
                                                                      'datecnv(sybase)',
                                                                      None),
                                          'KEYWORDS': ('struct_keywords', 'text', None, None),
                                          'METHODS_DEVELOPMENT_CATEGORY': ('pdbx_database_status',
                                                                           'methods_development_category',
                                                                           None,
                                                                           None),
                                          'NDB_ID': ('database_2', 'database_code', None, None),
                                          'PDB_FORMAT_COMPATIBLE': ('pdbx_database_status',
                                                                    'pdb_format_compatible',
                                                                    None,
                                                                    None),
                                          'PDB_ID': ('database_2', 'database_code', None, None),
                                          'POST_REL_RECVD_COORD': ('pdbx_database_status', 'post_rel_recvd_coord', None, None),
                                          'POST_REL_RECVD_COORD_DATE': ('pdbx_database_status',
                                                                        'post_rel_recvd_coord_date',
                                                                        'datecnv(sybase)',
                                                                        None),
                                          'POST_REL_STATUS': ('pdbx_database_status', 'post_rel_status', None, None),
                                          'PROCESS_SITE': ('pdbx_database_status', 'process_site', None, None),
                                          'RCSB_ANNOTATOR': ('pdbx_database_status', 'pdbx_annotator', None, None),
                                          'RECVD_AUTHOR_APPROVAL': ('pdbx_database_status',
                                                                    'recvd_author_approval',
                                                                    None,
                                                                    None),
                                          'RECVD_CHEMICAL_SHIFTS': ('pdbx_database_status',
                                                                    'recvd_chemical_shifts',
                                                                    None,
                                                                    None),
                                          'RECVD_COORDINATES': ('pdbx_database_status', 'recvd_coordinates', None, None),
                                          'RECVD_NMR_CONSTRAINTS': ('pdbx_database_status',
                                                                    'recvd_nmr_constraints',
                                                                    None,
                                                                    None),
                                          'RECVD_NMR_DATA': ('pdbx_database_status', 'recvd_nmr_data', None, None),
                                          'RECVD_STRUCT_FACT': ('pdbx_database_status', 'recvd_struct_fact', None, None),
                                          'REPLACED_ENTRY_ID': ('pdbx_database_status', 'replaced_entry_id', None, None),
                                          'REVISION_DESCRIPTION': ('pdbx_database_status', 'revision_description', None, None),
                                          'SG_ENTRY': ('pdbx_database_status', 'SG_entry', None, None),
                                          'STATUS_CODE': ('pdbx_database_status', 'status_code', None, None),
                                          'STATUS_CODE_CS': ('pdbx_database_status', 'status_code_cs', None, None),
                                          'STATUS_CODE_MR': ('pdbx_database_status', 'status_code_mr', None, None),
                                          'STATUS_CODE_NMR_DATA': ('pdbx_database_status', 'status_code_nmr_data', None, None),
                                          'STATUS_CODE_SF': ('pdbx_database_status', 'status_code_sf', None, None),
                                          'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                          'SUPPRESSED_TITLE_Y_N': ('pdbx_database_status', 'title_suppression', None, None),
                                          'TITLE': ('struct', 'title', None, None),
                                          'TITLEUC': ('struct', 'title', 'toupper()', None)},
                        'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'},
                                    's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                        'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                        'TABLE_ID': 'RCSB_STATUS',
                        'TABLE_NAME': 'rcsb_status',
                        'TABLE_TYPE': 'transactional'},
        'STRUCT': {'ATTRIBUTES': {'PDBX_CASP_FLAG': 'pdbx_CASP_flag',
                                  'PDBX_DESCRIPTOR': 'pdbx_descriptor',
                                  'PDBX_DETAILS': 'pdbx_details',
                                  'PDBX_MODEL_DETAILS': 'pdbx_model_details',
                                  'PDBX_TITLE_TEXT': 'pdbx_title_text',
                                  'PDB_ID': 'pdb_id',
                                  'STRUCTURE_ID': 'Structure_ID',
                                  'TITLE': 'title'},
                   'ATTRIBUTE_INFO': {'PDBX_CASP_FLAG': {'NULLABLE': True,
                                                         'ORDER': 8,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 2},
                                      'PDBX_DESCRIPTOR': {'NULLABLE': True,
                                                          'ORDER': 5,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 1100},
                                      'PDBX_DETAILS': {'NULLABLE': True,
                                                       'ORDER': 6,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 4095},
                                      'PDBX_MODEL_DETAILS': {'NULLABLE': True,
                                                             'ORDER': 7,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 16383},
                                      'PDBX_TITLE_TEXT': {'NULLABLE': True,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 255},
                                      'PDB_ID': {'NULLABLE': True,
                                                 'ORDER': 2,
                                                 'PRECISION': 0,
                                                 'PRIMARY_KEY': False,
                                                 'SQL_TYPE': 'VARCHAR',
                                                 'WIDTH': 9},
                                      'STRUCTURE_ID': {'NULLABLE': False,
                                                       'ORDER': 1,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': True,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 15},
                                      'TITLE': {'NULLABLE': True,
                                                'ORDER': 3,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': False,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 600}},
                   'ATTRIBUTE_MAP': {'PDBX_CASP_FLAG': ('struct', 'pdbx_CASP_flag', None, None),
                                     'PDBX_DESCRIPTOR': ('struct', 'pdbx_descriptor', None, None),
                                     'PDBX_DETAILS': ('struct', 'pdbx_details', None, None),
                                     'PDBX_MODEL_DETAILS': ('struct', 'pdbx_model_details', None, None),
                                     'PDBX_TITLE_TEXT': ('struct', 'pdbx_title_text', None, None),
                                     'PDB_ID': ('database_2', 'database_code', None, None),
                                     'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                     'TITLE': ('struct', 'title', None, None)},
                   'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'UNIQUE'},
                               's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                   'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                   'TABLE_ID': 'STRUCT',
                   'TABLE_NAME': 'struct',
                   'TABLE_TYPE': 'transactional'},
        'STRUCT_KEYWORDS': {'ATTRIBUTES': {'ENTRY_ID': 'entry_id',
                                           'PDBX_KEYWORDS': 'pdbx_keywords',
                                           'STRUCTURE_ID': 'Structure_ID',
                                           'TEXT': 'text'},
                            'ATTRIBUTE_INFO': {'ENTRY_ID': {'NULLABLE': False,
                                                            'ORDER': 2,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 15},
                                               'PDBX_KEYWORDS': {'NULLABLE': True,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                               'STRUCTURE_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 15},
                                               'TEXT': {'NULLABLE': True,
                                                        'ORDER': 3,
                                                        'PRECISION': 0,
                                                        'PRIMARY_KEY': False,
                                                        'SQL_TYPE': 'VARCHAR',
                                                        'WIDTH': 1023}},
                            'ATTRIBUTE_MAP': {'ENTRY_ID': ('struct_keywords', 'entry_id', None, None),
                                              'PDBX_KEYWORDS': ('struct_keywords', 'pdbx_keywords', None, None),
                                              'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                              'TEXT': ('struct_keywords', 'text', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'ENTRY_ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'struct_keywords': {'ATTRIBUTES': ('entry_id',), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                            'TABLE_ID': 'STRUCT_KEYWORDS',
                            'TABLE_NAME': 'struct_keywords',
                            'TABLE_TYPE': 'transactional'},
        'STRUCT_SITE_KEYWORDS': {'ATTRIBUTES': {'SITE_ID': 'site_id', 'STRUCTURE_ID': 'Structure_ID', 'TEXT': 'text'},
                                 'ATTRIBUTE_INFO': {'SITE_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80},
                                                    'STRUCTURE_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 15},
                                                    'TEXT': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 200}},
                                 'ATTRIBUTE_MAP': {'SITE_ID': ('struct_site_keywords', 'site_id', None, None),
                                                   'STRUCTURE_ID': (None, None, 'datablockid()', None),
                                                   'TEXT': ('struct_site_keywords', 'text', None, None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('STRUCTURE_ID', 'SITE_ID', 'TEXT'), 'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('STRUCTURE_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'struct_site_keywords': {'ATTRIBUTES': ('site_id', 'text'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'STRUCTURE_ID',
                                 'TABLE_ID': 'STRUCT_SITE_KEYWORDS',
                                 'TABLE_NAME': 'struct_site_keywords',
                                 'TABLE_TYPE': 'transactional'}}

    def __init__(self, verbose=True, log=sys.stderr, databaseName=None):
        if databaseName is None:
            super(
                DaInternalSchemaDef,
                self).__init__(
                databaseName=DaInternalSchemaDef._databaseName,
                schemaDefDict=DaInternalSchemaDef._schemaDefDict,
                verbose=verbose,
                log=log)
        else:
            super(
                DaInternalSchemaDef,
                self).__init__(
                databaseName=databaseName,
                schemaDefDict=DaInternalSchemaDef._schemaDefDict,
                verbose=verbose,
                log=log)
        self.__verbose = verbose
        self.__lfh = log


if __name__ == "__main__":
    msd = DaInternalSchemaDef(databaseName='da_internal_combined')
    tableIdList = msd.getTableIdList()

    for tableId in tableIdList:
        aIdL = msd.getAttributeIdList(tableId)
        tObj = msd.getTable(tableId)
        attributeIdList = tObj.getAttributeIdList()
        attributeNameList = tObj.getAttributeNameList()
        sys.stdout.write("Ordered attribute Id   list %s\n" % (str(attributeIdList)))
        sys.stdout.write("Ordered attribute name list %s\n" % (str(attributeNameList)))
    #
