"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Telemetry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const amp = require("./amp");
const defaultProps = {
    createPrometheusWorkspace: false,
};
class Telemetry extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.options = { ...defaultProps, ...props };
        const telemetry_namespace = new aws_cdk_lib_1.aws_eks.KubernetesManifest(this, 'TelemetryNameSpace', {
            cluster: this.options.cluster,
            overwrite: true,
            manifest: [
                {
                    apiVersion: 'v1',
                    kind: 'Namespace',
                    metadata: { name: this.options.namespace },
                },
            ],
        });
        const telemetry_certificate = new aws_cdk_lib_1.aws_eks.KubernetesManifest(this, 'TelemetryCert', {
            cluster: this.options.cluster,
            overwrite: true,
            manifest: [
                {
                    apiVersion: 'cert-manager.io/v1',
                    kind: 'Certificate',
                    metadata: {
                        name: this.options.cacertname,
                        namespace: this.options.namespace,
                    },
                    spec: {
                        commonName: this.options.hostedZoneName,
                        dnsNames: this.options.dnsNames,
                        duration: '2160h0m0s',
                        issuerRef: {
                            group: 'awspca.cert-manager.io',
                            kind: 'AWSPCAClusterIssuer',
                            name: this.options.clusterIssuerName,
                        },
                        renewBefore: '360h0m0s',
                        secretName: this.options.cacertname,
                        usages: [
                            'server auth',
                            'client auth',
                        ],
                        privateKey: {
                            algorithm: 'RSA',
                            size: 2048,
                        },
                    },
                },
            ],
        });
        telemetry_certificate.node.addDependency(telemetry_namespace);
        const deploy_adot_operator_helm = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'AdotHelm', {
            cluster: this.options.cluster,
            repository: 'https://open-telemetry.github.io/opentelemetry-helm-charts',
            chart: 'opentelemetry-operator',
            release: 'opentelemetry-operator',
            namespace: this.options.namespace,
            wait: true,
            createNamespace: false,
            values: {
                admissionWebhooks: {
                    certManager: {
                        issuerRef: {
                            kind: 'ClusterIssuer',
                            name: this.options.clusterIssuerName,
                        },
                    },
                },
            },
        });
        deploy_adot_operator_helm.node.addDependency(telemetry_certificate, telemetry_namespace);
        const amp_in_telemetry = new amp.Amp(this, 'AmpAmg', {
            cluster: this.options.cluster,
            namespace: this.options.namespace,
            createPrometheusWorkspace: this.options.createPrometheusWorkspace,
            prometheusEndpoint: this.options.prometheusEndpoint,
        });
        amp_in_telemetry.node.addDependency(deploy_adot_operator_helm, telemetry_namespace);
        // new CfnOutput(this, 'ESDomainEndpointOutput', { value: kong_elk_stack.domainEndpoint });
    }
}
exports.Telemetry = Telemetry;
_a = JSII_RTTI_SYMBOL_1;
Telemetry[_a] = { fqn: "kong-core.Telemetry", version: "2.0.13" };
//# sourceMappingURL=data:application/json;base64,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