"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SecretsManager extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const deploy_secrets_manager_csi = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'ExternalSecrets', {
            cluster: props.cluster,
            repository: 'https://kubernetes-sigs.github.io/secrets-store-csi-driver/charts',
            chart: 'secrets-store-csi-driver',
            release: 'secrets-store-csi-driver',
            namespace: 'kube-system',
            wait: true,
            values: {
                syncSecret: {
                    enabled: true,
                },
                enableSecretRotation: true,
                rotationPollInterval: '3600s',
            },
        });
        // deploy_secrets_manager_csi.node.addDependency(kong_namespace);
        const secrets_store_csi_driver_provider_aws = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'AwsSecretsExtension', {
            cluster: props.cluster,
            repository: 'https://aws.github.io/eks-charts',
            chart: 'csi-secrets-store-provider-aws',
            release: 'csi-secrets-store-provider-aws',
            namespace: 'kube-system',
            wait: true,
            values: {
                'secrets-store-csi-driver': {
                    install: false,
                },
            },
        });
        secrets_store_csi_driver_provider_aws.node.addDependency(deploy_secrets_manager_csi);
    }
}
exports.SecretsManager = SecretsManager;
_a = JSII_RTTI_SYMBOL_1;
SecretsManager[_a] = { fqn: "kong-core.SecretsManager", version: "2.0.13" };
//# sourceMappingURL=data:application/json;base64,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