#!/bin/bash
if [[ -z ${rootCAArn} ]]; then
  echo "ERROR: Environment Variable rootCAArn is not set and empty"
  exit 1
fi
if [[ -z ${certArn} ]]; then
  echo "ERROR: Environment Variable certArn is not set and empty"
  exit 1
fi
rootCAArn=$rootCAArn
certArn=$certArn
region=$AWS_DEFAULT_REGION
echo $rootCertArn
echo "cleaning up certs"
rm -rf /certs/*
#mkdir -p certs
echo "generating passphrase certs"
randomString=`cat /dev/urandom | tr -dc 'a-z0-9' | fold -w 7 | head -n 1 `
echo -n $randomString > /certs/passphrase.txt
if [[ ! -e /certs/passphrase.txt ]]; then
  echo "ERROR: File /certs/passphrase.txt does not exist."
  exit 1
fi
echo "download the CA certificate"
aws acm-pca get-certificate-authority-certificate  --certificate-authority-arn $rootCAArn --output text --region $region > /certs/ca.crt
if [[ ! -e /certs/ca.crt ]]; then
  echo "ERROR: File /certs/ca.crt does not exist. Download CA certificate failed."
  exit 1
fi
aws acm export-certificate \
     --certificate-arn $certArn \
     --passphrase fileb:///certs/passphrase.txt \
     --region $region \
     > /certs/export.txt
if [[ -s /certs/export.txt ]]; then
  echo "Download the Cluster certificate"
  cat /certs/export.txt | jq -r '"\(.Certificate)"' > /certs/cluster.crt
  cat /certs/export.txt | jq -r '"\(.PrivateKey)"'  > /certs/cluster.key
  rm /certs/export.txt
else
  echo "ERROR: File /certs/export.txt does not exist. Download Cluster Certificate Failed."
  exit 1
fi
echo "Decode the private keys"
openssl rsa -in /certs/cluster.key -out /certs/cluster.key -passin file:/certs/passphrase.txt
rm /certs/passphrase.txt
if [ "$?" -ne 0 ]
   then
      echo "script failed"
      exit 1
   else
      echo "Scripted executed successfully"
fi
