"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NlbStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const constructs_1 = require("constructs");
class NlbStack extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.kongNlb = new elbv2.NetworkLoadBalancer(this, 'NLBInstance', {
            vpc: props.vpc,
            internetFacing: props.internetFacing,
            loadBalancerName: props.name,
            crossZoneEnabled: true,
        });
    }
}
exports.NlbStack = NlbStack;
_a = JSII_RTTI_SYMBOL_1;
NlbStack[_a] = { fqn: "kong-core.NlbStack", version: "2.0.13" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL25sYi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLGdFQUFnRTtBQUNoRSwyQ0FBdUM7QUFPdkMsTUFBYSxRQUFTLFNBQVEsc0JBQVM7SUFJckMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFlO1FBQ3ZELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFO1lBQ2hFLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRztZQUNkLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsSUFBSTtZQUM1QixnQkFBZ0IsRUFBRSxJQUFJO1NBQ3ZCLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBYkgsNEJBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlYzIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBlbGJ2MiBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmd2Mic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBObGJQcm9wcyB7XG4gIHJlYWRvbmx5IHZwYyA6IGVjMi5JVnBjO1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGludGVybmV0RmFjaW5nOiBib29sZWFuO1xufVxuZXhwb3J0IGNsYXNzIE5sYlN0YWNrIGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICBwdWJsaWMga29uZ05sYiA6IGVsYnYyLk5ldHdvcmtMb2FkQmFsYW5jZXI7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE5sYlByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMua29uZ05sYiA9IG5ldyBlbGJ2Mi5OZXR3b3JrTG9hZEJhbGFuY2VyKHRoaXMsICdOTEJJbnN0YW5jZScsIHtcbiAgICAgIHZwYzogcHJvcHMudnBjLFxuICAgICAgaW50ZXJuZXRGYWNpbmc6IHByb3BzLmludGVybmV0RmFjaW5nLFxuICAgICAgbG9hZEJhbGFuY2VyTmFtZTogcHJvcHMubmFtZSxcbiAgICAgIGNyb3NzWm9uZUVuYWJsZWQ6IHRydWUsXG4gICAgfSk7XG4gIH1cbn0iXX0=