"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCertManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_eks_1 = require("aws-cdk-lib/aws-eks");
const constructs_1 = require("constructs");
const enums = require("./enums/");
class AwsCertManager extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Customize this and further restrict access to aws pca issuer to scoped cert only
        const cert_manager_namespace = new aws_eks_1.KubernetesManifest(this, 'CertManagerNamespace', {
            cluster: props.cluster,
            overwrite: true,
            manifest: [
                {
                    apiVersion: 'v1',
                    kind: 'Namespace',
                    metadata: { name: enums.Namespace.CERT_MANAGER },
                },
            ],
        });
        const deploy_cert_manager = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'CertManagerHelm', {
            cluster: props.cluster,
            repository: 'https://charts.jetstack.io',
            chart: 'cert-manager',
            createNamespace: false,
            namespace: enums.Namespace.CERT_MANAGER,
            release: 'cert-manager',
            wait: true,
            values: {
                installCRDs: true,
                webhook: {
                    timeoutSeconds: 30,
                },
            },
        });
        deploy_cert_manager.node.addDependency(cert_manager_namespace);
        const aws_pca_issuer_namespace = new aws_eks_1.KubernetesManifest(this, 'AwsPcaIssuerNamespace', {
            cluster: props.cluster,
            overwrite: true,
            manifest: [
                {
                    apiVersion: 'v1',
                    kind: 'Namespace',
                    metadata: { name: enums.Namespace.AWS_PCA_ISSUER },
                },
            ],
        });
        const aws_pca_issuer_service_account = new aws_cdk_lib_1.aws_eks.ServiceAccount(this, 'AwsPcaIssuerSa', {
            cluster: props.cluster,
            name: 'aws-pca-issuer-service-account',
            namespace: enums.Namespace.AWS_PCA_ISSUER,
        });
        aws_pca_issuer_service_account.node.addDependency(aws_pca_issuer_namespace);
        aws_pca_issuer_service_account.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: [props.privateCaArn],
            actions: [
                'acm-pca:Get*',
                'acm-pca:Issue*',
                'acm-pca:Describe*',
            ],
        }));
        const deploy_pca_issuer = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'AwsPcaIssuerHelm', {
            cluster: props.cluster,
            repository: 'https://cert-manager.github.io/aws-privateca-issuer',
            chart: 'aws-pca-issuer',
            namespace: aws_pca_issuer_service_account.serviceAccountNamespace,
            release: 'aws-pca-issuer',
            wait: true,
            createNamespace: false,
            values: {
                serviceAccount: {
                    create: false,
                    name: aws_pca_issuer_service_account.serviceAccountName,
                },
            },
        });
        deploy_pca_issuer.node.addDependency(aws_pca_issuer_service_account, aws_pca_issuer_namespace, deploy_cert_manager);
        const helm_waiter = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'DummyWaiter', {
            cluster: props.cluster,
            repository: 'https://anshrma.github.io/helm-charts',
            chart: 'helm-waiter',
            release: 'helm-waiter',
            wait: true,
        });
        helm_waiter.node.addDependency(deploy_pca_issuer);
        const aws_pca_cluster_issuer = new aws_cdk_lib_1.aws_eks.KubernetesManifest(this, 'ClusterIssuerManifest', {
            cluster: props.cluster,
            overwrite: true,
            manifest: [
                {
                    apiVersion: 'awspca.cert-manager.io/v1beta1',
                    kind: 'AWSPCAClusterIssuer',
                    metadata: { name: props.clusterIssuerName },
                    spec: {
                        arn: props.privateCaArn,
                        region: aws_cdk_lib_1.Stack.of(this).region,
                    },
                },
            ],
        });
        aws_pca_cluster_issuer.node.addDependency(helm_waiter, deploy_pca_issuer);
    }
}
exports.AwsCertManager = AwsCertManager;
_a = JSII_RTTI_SYMBOL_1;
AwsCertManager[_a] = { fqn: "kong-core.AwsCertManager", version: "2.0.13" };
//# sourceMappingURL=data:application/json;base64,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