"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Amp = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
// import { KubernetesManifest } from 'aws-cdk-lib/aws-eks';
const constructs_1 = require("constructs");
class Amp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Customize this and further restrict access to aws pca issuer to scoped cert only
        // const amp_namespace = new KubernetesManifest(this, 'AmpNamespace', {
        //   cluster: props.cluster,
        //   overwrite: true,
        //   manifest: [
        //     {
        //       apiVersion: 'v1',
        //       kind: 'Namespace',
        //       metadata: { name: enums.Namespace.AMP },
        //     },
        //   ],
        // });
        const amp_service_account = new aws_cdk_lib_1.aws_eks.ServiceAccount(this, 'AmpSa', {
            cluster: props.cluster,
            name: 'amp-service-account',
            namespace: props.namespace,
        });
        // amp_service_account.node.addDependency(amp_namespace);
        amp_service_account.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'aps:RemoteWrite',
                'aps:QueryMetrics',
                'aps:GetSeries',
                'aps:GetLabels',
                'aps:GetMetricMetadata',
            ],
        }));
        if (props.prometheusEndpoint) {
            this.prometheus_endpoint = props.prometheusEndpoint;
        }
        ;
        if (props.createPrometheusWorkspace) {
            this.aps_workspace = new aws_cdk_lib_1.aws_aps.CfnWorkspace(this, 'ApsWorkspace');
            this.prometheus_endpoint = `${this.aps_workspace.attrPrometheusEndpoint}` + 'api/v1/remote_write';
        }
        ;
        // As ADOT AMP is in preview + Does not supports SA, using community prometheus for now
        const deploy_prometheus_collector = new aws_cdk_lib_1.aws_eks.HelmChart(this, 'PromCollectorHelm', {
            cluster: props.cluster,
            repository: 'https://prometheus-community.github.io/helm-charts',
            chart: 'prometheus',
            namespace: props.namespace,
            release: 'prometheus-community',
            wait: true,
            createNamespace: false,
            values: {
                server: {
                    //   statefulSet: {
                    //     enabled: false,
                    //   },
                    //   retention: '1h',
                    remoteWrite: [
                        {
                            url: this.prometheus_endpoint,
                            sigv4: {
                                region: aws_cdk_lib_1.Stack.of(this).region,
                            },
                            queue_config: {
                                max_samples_per_send: 1000,
                                max_shards: 200,
                                capacity: 2500,
                            },
                        },
                    ],
                },
                serviceAccounts: {
                    server: {
                        name: amp_service_account.serviceAccountName,
                        create: false,
                        annotations: {
                            'eks.amazonaws.com/role-arn': amp_service_account.role.roleArn,
                        },
                        alertmanager: {
                            create: false,
                        },
                        pushgateway: {
                            create: false,
                        },
                    },
                },
                alertmanager: {
                    enabled: false,
                },
                pushgateway: {
                    enabled: false,
                },
            },
        });
        deploy_prometheus_collector.node.addDependency(amp_service_account);
    }
}
exports.Amp = Amp;
//# sourceMappingURL=data:application/json;base64,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