# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### AcmPca <a name="AcmPca" id="kong-core.AcmPca"></a>

#### Initializers <a name="Initializers" id="kong-core.AcmPca.Initializer"></a>

```typescript
import { AcmPca } from 'kong-core'

new AcmPca(scope: Construct, id: string, props: AcmPcaProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AcmPca.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.AcmPca.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AcmPca.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.AcmPcaProps">AcmPcaProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.AcmPca.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.AcmPca.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.AcmPca.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.AcmPcaProps">AcmPcaProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.AcmPca.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.AcmPca.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.AcmPca.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.AcmPca.isConstruct"></a>

```typescript
import { AcmPca } from 'kong-core'

AcmPca.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.AcmPca.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AcmPca.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-core.AcmPca.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AcmPca.property.route53Zone">route53Zone</a></code> | <code>aws-cdk-lib.aws_route53.PrivateHostedZone</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.AcmPca.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-core.AcmPca.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `route53Zone`<sup>Required</sup> <a name="route53Zone" id="kong-core.AcmPca.property.route53Zone"></a>

```typescript
public readonly route53Zone: PrivateHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.PrivateHostedZone

---


### AutoScalar <a name="AutoScalar" id="kong-core.AutoScalar"></a>

#### Initializers <a name="Initializers" id="kong-core.AutoScalar.Initializer"></a>

```typescript
import { AutoScalar } from 'kong-core'

new AutoScalar(scope: Construct, id: string, props: AutoScalarProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AutoScalar.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.AutoScalar.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AutoScalar.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.AutoScalarProps">AutoScalarProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.AutoScalar.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.AutoScalar.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.AutoScalar.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.AutoScalarProps">AutoScalarProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.AutoScalar.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.AutoScalar.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.AutoScalar.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.AutoScalar.isConstruct"></a>

```typescript
import { AutoScalar } from 'kong-core'

AutoScalar.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.AutoScalar.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AutoScalar.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.AutoScalar.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### AwsCertManager <a name="AwsCertManager" id="kong-core.AwsCertManager"></a>

#### Initializers <a name="Initializers" id="kong-core.AwsCertManager.Initializer"></a>

```typescript
import { AwsCertManager } from 'kong-core'

new AwsCertManager(scope: Construct, id: string, props: AwsCertManagerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AwsCertManager.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.AwsCertManager.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AwsCertManager.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.AwsCertManagerProps">AwsCertManagerProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.AwsCertManager.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.AwsCertManager.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.AwsCertManager.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.AwsCertManagerProps">AwsCertManagerProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.AwsCertManager.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.AwsCertManager.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.AwsCertManager.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.AwsCertManager.isConstruct"></a>

```typescript
import { AwsCertManager } from 'kong-core'

AwsCertManager.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.AwsCertManager.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AwsCertManager.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.AwsCertManager.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### Certificates <a name="Certificates" id="kong-core.Certificates"></a>

#### Initializers <a name="Initializers" id="kong-core.Certificates.Initializer"></a>

```typescript
import { Certificates } from 'kong-core'

new Certificates(scope: Construct, id: string, props: KongCertificatesProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.Certificates.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.Certificates.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.Certificates.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.KongCertificatesProps">KongCertificatesProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.Certificates.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.Certificates.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.Certificates.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.KongCertificatesProps">KongCertificatesProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Certificates.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.Certificates.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Certificates.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.Certificates.isConstruct"></a>

```typescript
import { Certificates } from 'kong-core'

Certificates.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.Certificates.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.Certificates.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-core.Certificates.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.CfnCertificate</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.Certificates.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `certificate`<sup>Required</sup> <a name="certificate" id="kong-core.Certificates.property.certificate"></a>

```typescript
public readonly certificate: CfnCertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.CfnCertificate

---


### CustomImage <a name="CustomImage" id="kong-core.CustomImage"></a>

#### Initializers <a name="Initializers" id="kong-core.CustomImage.Initializer"></a>

```typescript
import { CustomImage } from 'kong-core'

new CustomImage(scope: Construct, id: string, props: KongCustomImageProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.CustomImage.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.CustomImage.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.CustomImage.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.KongCustomImageProps">KongCustomImageProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.CustomImage.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.CustomImage.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.CustomImage.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.KongCustomImageProps">KongCustomImageProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.CustomImage.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.CustomImage.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.CustomImage.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.CustomImage.isConstruct"></a>

```typescript
import { CustomImage } from 'kong-core'

CustomImage.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.CustomImage.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.CustomImage.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-core.CustomImage.property.kongCustomImage">kongCustomImage</a></code> | <code>aws-cdk-lib.aws_ecs.ContainerImage</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.CustomImage.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `kongCustomImage`<sup>Required</sup> <a name="kongCustomImage" id="kong-core.CustomImage.property.kongCustomImage"></a>

```typescript
public readonly kongCustomImage: ContainerImage;
```

- *Type:* aws-cdk-lib.aws_ecs.ContainerImage

---


### EksNodeHandler <a name="EksNodeHandler" id="kong-core.EksNodeHandler"></a>

#### Initializers <a name="Initializers" id="kong-core.EksNodeHandler.Initializer"></a>

```typescript
import { EksNodeHandler } from 'kong-core'

new EksNodeHandler(scope: Construct, id: string, props: NodeHandlerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.EksNodeHandler.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.EksNodeHandler.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.EksNodeHandler.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.NodeHandlerProps">NodeHandlerProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.EksNodeHandler.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.EksNodeHandler.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.EksNodeHandler.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.NodeHandlerProps">NodeHandlerProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.EksNodeHandler.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.EksNodeHandler.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.EksNodeHandler.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.EksNodeHandler.isConstruct"></a>

```typescript
import { EksNodeHandler } from 'kong-core'

EksNodeHandler.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.EksNodeHandler.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.EksNodeHandler.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-core.EksNodeHandler.property.notificationQueue">notificationQueue</a></code> | <code>aws-cdk-lib.aws_sqs.Queue</code> | *No description.* |
| <code><a href="#kong-core.EksNodeHandler.property.serviceAccount">serviceAccount</a></code> | <code>aws-cdk-lib.aws_eks.ServiceAccount</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.EksNodeHandler.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `notificationQueue`<sup>Required</sup> <a name="notificationQueue" id="kong-core.EksNodeHandler.property.notificationQueue"></a>

```typescript
public readonly notificationQueue: Queue;
```

- *Type:* aws-cdk-lib.aws_sqs.Queue

---

##### `serviceAccount`<sup>Required</sup> <a name="serviceAccount" id="kong-core.EksNodeHandler.property.serviceAccount"></a>

```typescript
public readonly serviceAccount: ServiceAccount;
```

- *Type:* aws-cdk-lib.aws_eks.ServiceAccount

---


### ElastiCacheStack <a name="ElastiCacheStack" id="kong-core.ElastiCacheStack"></a>

#### Initializers <a name="Initializers" id="kong-core.ElastiCacheStack.Initializer"></a>

```typescript
import { ElastiCacheStack } from 'kong-core'

new ElastiCacheStack(scope: Construct, id: string, props: ElastiCacheStackProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.ElastiCacheStack.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.ElastiCacheStack.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.ElastiCacheStack.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.ElastiCacheStackProps">ElastiCacheStackProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.ElastiCacheStack.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.ElastiCacheStack.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.ElastiCacheStack.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.ElastiCacheStackProps">ElastiCacheStackProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.ElastiCacheStack.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.ElastiCacheStack.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.ElastiCacheStack.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.ElastiCacheStack.isConstruct"></a>

```typescript
import { ElastiCacheStack } from 'kong-core'

ElastiCacheStack.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.ElastiCacheStack.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.ElastiCacheStack.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.ElastiCacheStack.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### ExternalDns <a name="ExternalDns" id="kong-core.ExternalDns"></a>

#### Initializers <a name="Initializers" id="kong-core.ExternalDns.Initializer"></a>

```typescript
import { ExternalDns } from 'kong-core'

new ExternalDns(scope: Construct, id: string, props: ExternalDnsProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.ExternalDns.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.ExternalDns.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.ExternalDns.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.ExternalDnsProps">ExternalDnsProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.ExternalDns.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.ExternalDns.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.ExternalDns.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.ExternalDnsProps">ExternalDnsProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.ExternalDns.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.ExternalDns.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.ExternalDns.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.ExternalDns.isConstruct"></a>

```typescript
import { ExternalDns } from 'kong-core'

ExternalDns.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.ExternalDns.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.ExternalDns.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.ExternalDns.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### MetricsServer <a name="MetricsServer" id="kong-core.MetricsServer"></a>

#### Initializers <a name="Initializers" id="kong-core.MetricsServer.Initializer"></a>

```typescript
import { MetricsServer } from 'kong-core'

new MetricsServer(scope: Construct, id: string, props: MetricsServerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.MetricsServer.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.MetricsServer.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.MetricsServer.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.MetricsServerProps">MetricsServerProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.MetricsServer.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.MetricsServer.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.MetricsServer.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.MetricsServerProps">MetricsServerProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.MetricsServer.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.MetricsServer.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.MetricsServer.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.MetricsServer.isConstruct"></a>

```typescript
import { MetricsServer } from 'kong-core'

MetricsServer.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.MetricsServer.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.MetricsServer.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.MetricsServer.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### NlbStack <a name="NlbStack" id="kong-core.NlbStack"></a>

#### Initializers <a name="Initializers" id="kong-core.NlbStack.Initializer"></a>

```typescript
import { NlbStack } from 'kong-core'

new NlbStack(scope: Construct, id: string, props: NlbProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.NlbStack.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.NlbStack.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.NlbStack.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.NlbProps">NlbProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.NlbStack.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.NlbStack.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.NlbStack.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.NlbProps">NlbProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.NlbStack.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.NlbStack.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.NlbStack.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.NlbStack.isConstruct"></a>

```typescript
import { NlbStack } from 'kong-core'

NlbStack.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.NlbStack.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.NlbStack.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-core.NlbStack.property.kongNlb">kongNlb</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.NlbStack.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `kongNlb`<sup>Required</sup> <a name="kongNlb" id="kong-core.NlbStack.property.kongNlb"></a>

```typescript
public readonly kongNlb: NetworkLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer

---


### RdsStack <a name="RdsStack" id="kong-core.RdsStack"></a>

#### Initializers <a name="Initializers" id="kong-core.RdsStack.Initializer"></a>

```typescript
import { RdsStack } from 'kong-core'

new RdsStack(scope: Construct, id: string, props: RdsProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.RdsStack.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.RdsStack.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.RdsStack.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.RdsProps">RdsProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.RdsStack.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.RdsStack.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.RdsStack.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.RdsProps">RdsProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.RdsStack.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.RdsStack.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.RdsStack.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.RdsStack.isConstruct"></a>

```typescript
import { RdsStack } from 'kong-core'

RdsStack.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.RdsStack.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.RdsStack.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#kong-core.RdsStack.property.kongPostgresSql">kongPostgresSql</a></code> | <code>aws-cdk-lib.aws_rds.DatabaseInstance</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.RdsStack.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `kongPostgresSql`<sup>Required</sup> <a name="kongPostgresSql" id="kong-core.RdsStack.property.kongPostgresSql"></a>

```typescript
public readonly kongPostgresSql: DatabaseInstance;
```

- *Type:* aws-cdk-lib.aws_rds.DatabaseInstance

---


### SecretsManager <a name="SecretsManager" id="kong-core.SecretsManager"></a>

#### Initializers <a name="Initializers" id="kong-core.SecretsManager.Initializer"></a>

```typescript
import { SecretsManager } from 'kong-core'

new SecretsManager(scope: Construct, id: string, props: SecretsManagerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.SecretsManager.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.SecretsManager.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.SecretsManager.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.SecretsManagerProps">SecretsManagerProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.SecretsManager.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.SecretsManager.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.SecretsManager.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.SecretsManagerProps">SecretsManagerProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.SecretsManager.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.SecretsManager.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.SecretsManager.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.SecretsManager.isConstruct"></a>

```typescript
import { SecretsManager } from 'kong-core'

SecretsManager.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.SecretsManager.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.SecretsManager.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.SecretsManager.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### Telemetry <a name="Telemetry" id="kong-core.Telemetry"></a>

#### Initializers <a name="Initializers" id="kong-core.Telemetry.Initializer"></a>

```typescript
import { Telemetry } from 'kong-core'

new Telemetry(scope: Construct, id: string, props: TelemetryProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.Telemetry.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#kong-core.Telemetry.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.Telemetry.Initializer.parameter.props">props</a></code> | <code><a href="#kong-core.TelemetryProps">TelemetryProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="kong-core.Telemetry.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="kong-core.Telemetry.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="kong-core.Telemetry.Initializer.parameter.props"></a>

- *Type:* <a href="#kong-core.TelemetryProps">TelemetryProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Telemetry.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="kong-core.Telemetry.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Telemetry.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="kong-core.Telemetry.isConstruct"></a>

```typescript
import { Telemetry } from 'kong-core'

Telemetry.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="kong-core.Telemetry.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.Telemetry.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="kong-core.Telemetry.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


## Structs <a name="Structs" id="Structs"></a>

### AcmPcaProps <a name="AcmPcaProps" id="kong-core.AcmPcaProps"></a>

#### Initializer <a name="Initializer" id="kong-core.AcmPcaProps.Initializer"></a>

```typescript
import { AcmPcaProps } from 'kong-core'

const acmPcaProps: AcmPcaProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AcmPcaProps.property.hostedZoneName">hostedZoneName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AcmPcaProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | *No description.* |

---

##### `hostedZoneName`<sup>Required</sup> <a name="hostedZoneName" id="kong-core.AcmPcaProps.property.hostedZoneName"></a>

```typescript
public readonly hostedZoneName: string;
```

- *Type:* string

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="kong-core.AcmPcaProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

---

### AutoScalarProps <a name="AutoScalarProps" id="kong-core.AutoScalarProps"></a>

#### Initializer <a name="Initializer" id="kong-core.AutoScalarProps.Initializer"></a>

```typescript
import { AutoScalarProps } from 'kong-core'

const autoScalarProps: AutoScalarProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AutoScalarProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |
| <code><a href="#kong-core.AutoScalarProps.property.namespace">namespace</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AutoScalarProps.property.nodegroup">nodegroup</a></code> | <code>aws-cdk-lib.aws_eks.Nodegroup</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.AutoScalarProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

##### `namespace`<sup>Required</sup> <a name="namespace" id="kong-core.AutoScalarProps.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* string

---

##### `nodegroup`<sup>Required</sup> <a name="nodegroup" id="kong-core.AutoScalarProps.property.nodegroup"></a>

```typescript
public readonly nodegroup: Nodegroup;
```

- *Type:* aws-cdk-lib.aws_eks.Nodegroup

---

### AwsCertManagerProps <a name="AwsCertManagerProps" id="kong-core.AwsCertManagerProps"></a>

#### Initializer <a name="Initializer" id="kong-core.AwsCertManagerProps.Initializer"></a>

```typescript
import { AwsCertManagerProps } from 'kong-core'

const awsCertManagerProps: AwsCertManagerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.AwsCertManagerProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |
| <code><a href="#kong-core.AwsCertManagerProps.property.clusterIssuerName">clusterIssuerName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.AwsCertManagerProps.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.AwsCertManagerProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

##### `clusterIssuerName`<sup>Required</sup> <a name="clusterIssuerName" id="kong-core.AwsCertManagerProps.property.clusterIssuerName"></a>

```typescript
public readonly clusterIssuerName: string;
```

- *Type:* string

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-core.AwsCertManagerProps.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

### ElastiCacheStackProps <a name="ElastiCacheStackProps" id="kong-core.ElastiCacheStackProps"></a>

#### Initializer <a name="Initializer" id="kong-core.ElastiCacheStackProps.Initializer"></a>

```typescript
import { ElastiCacheStackProps } from 'kong-core'

const elastiCacheStackProps: ElastiCacheStackProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.ElastiCacheStackProps.property.numberofnodegroups">numberofnodegroups</a></code> | <code>number</code> | *No description.* |
| <code><a href="#kong-core.ElastiCacheStackProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | *No description.* |

---

##### `numberofnodegroups`<sup>Required</sup> <a name="numberofnodegroups" id="kong-core.ElastiCacheStackProps.property.numberofnodegroups"></a>

```typescript
public readonly numberofnodegroups: number;
```

- *Type:* number

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="kong-core.ElastiCacheStackProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

---

### ExternalDnsProps <a name="ExternalDnsProps" id="kong-core.ExternalDnsProps"></a>

#### Initializer <a name="Initializer" id="kong-core.ExternalDnsProps.Initializer"></a>

```typescript
import { ExternalDnsProps } from 'kong-core'

const externalDnsProps: ExternalDnsProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.ExternalDnsProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.ExternalDnsProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

### KongCertificatesProps <a name="KongCertificatesProps" id="kong-core.KongCertificatesProps"></a>

#### Initializer <a name="Initializer" id="kong-core.KongCertificatesProps.Initializer"></a>

```typescript
import { KongCertificatesProps } from 'kong-core'

const kongCertificatesProps: KongCertificatesProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.KongCertificatesProps.property.dnsNames">dnsNames</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#kong-core.KongCertificatesProps.property.privateCaArn">privateCaArn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.KongCertificatesProps.property.topLevelDomain">topLevelDomain</a></code> | <code>string</code> | *No description.* |

---

##### `dnsNames`<sup>Required</sup> <a name="dnsNames" id="kong-core.KongCertificatesProps.property.dnsNames"></a>

```typescript
public readonly dnsNames: string[];
```

- *Type:* string[]

---

##### `privateCaArn`<sup>Required</sup> <a name="privateCaArn" id="kong-core.KongCertificatesProps.property.privateCaArn"></a>

```typescript
public readonly privateCaArn: string;
```

- *Type:* string

---

##### `topLevelDomain`<sup>Required</sup> <a name="topLevelDomain" id="kong-core.KongCertificatesProps.property.topLevelDomain"></a>

```typescript
public readonly topLevelDomain: string;
```

- *Type:* string

---

### KongCustomImageProps <a name="KongCustomImageProps" id="kong-core.KongCustomImageProps"></a>

#### Initializer <a name="Initializer" id="kong-core.KongCustomImageProps.Initializer"></a>

```typescript
import { KongCustomImageProps } from 'kong-core'

const kongCustomImageProps: KongCustomImageProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.KongCustomImageProps.property.imageName">imageName</a></code> | <code>string</code> | *No description.* |

---

##### `imageName`<sup>Required</sup> <a name="imageName" id="kong-core.KongCustomImageProps.property.imageName"></a>

```typescript
public readonly imageName: string;
```

- *Type:* string

---

### MetricsServerProps <a name="MetricsServerProps" id="kong-core.MetricsServerProps"></a>

#### Initializer <a name="Initializer" id="kong-core.MetricsServerProps.Initializer"></a>

```typescript
import { MetricsServerProps } from 'kong-core'

const metricsServerProps: MetricsServerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.MetricsServerProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.MetricsServerProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

### NlbProps <a name="NlbProps" id="kong-core.NlbProps"></a>

#### Initializer <a name="Initializer" id="kong-core.NlbProps.Initializer"></a>

```typescript
import { NlbProps } from 'kong-core'

const nlbProps: NlbProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.NlbProps.property.internetFacing">internetFacing</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-core.NlbProps.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.NlbProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | *No description.* |

---

##### `internetFacing`<sup>Required</sup> <a name="internetFacing" id="kong-core.NlbProps.property.internetFacing"></a>

```typescript
public readonly internetFacing: boolean;
```

- *Type:* boolean

---

##### `name`<sup>Required</sup> <a name="name" id="kong-core.NlbProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="kong-core.NlbProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

---

### NodeHandlerProps <a name="NodeHandlerProps" id="kong-core.NodeHandlerProps"></a>

#### Initializer <a name="Initializer" id="kong-core.NodeHandlerProps.Initializer"></a>

```typescript
import { NodeHandlerProps } from 'kong-core'

const nodeHandlerProps: NodeHandlerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.NodeHandlerProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |
| <code><a href="#kong-core.NodeHandlerProps.property.nodegroup">nodegroup</a></code> | <code>aws-cdk-lib.aws_autoscaling.AutoScalingGroup</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.NodeHandlerProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

##### `nodegroup`<sup>Required</sup> <a name="nodegroup" id="kong-core.NodeHandlerProps.property.nodegroup"></a>

```typescript
public readonly nodegroup: AutoScalingGroup;
```

- *Type:* aws-cdk-lib.aws_autoscaling.AutoScalingGroup

---

### RdsProps <a name="RdsProps" id="kong-core.RdsProps"></a>

#### Initializer <a name="Initializer" id="kong-core.RdsProps.Initializer"></a>

```typescript
import { RdsProps } from 'kong-core'

const rdsProps: RdsProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.RdsProps.property.databasename">databasename</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.RdsProps.property.postgresversion">postgresversion</a></code> | <code>aws-cdk-lib.aws_rds.PostgresEngineVersion</code> | *No description.* |
| <code><a href="#kong-core.RdsProps.property.username">username</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.RdsProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | *No description.* |

---

##### `databasename`<sup>Required</sup> <a name="databasename" id="kong-core.RdsProps.property.databasename"></a>

```typescript
public readonly databasename: string;
```

- *Type:* string

---

##### `postgresversion`<sup>Required</sup> <a name="postgresversion" id="kong-core.RdsProps.property.postgresversion"></a>

```typescript
public readonly postgresversion: PostgresEngineVersion;
```

- *Type:* aws-cdk-lib.aws_rds.PostgresEngineVersion

---

##### `username`<sup>Required</sup> <a name="username" id="kong-core.RdsProps.property.username"></a>

```typescript
public readonly username: string;
```

- *Type:* string

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="kong-core.RdsProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

---

### SecretsManagerProps <a name="SecretsManagerProps" id="kong-core.SecretsManagerProps"></a>

#### Initializer <a name="Initializer" id="kong-core.SecretsManagerProps.Initializer"></a>

```typescript
import { SecretsManagerProps } from 'kong-core'

const secretsManagerProps: SecretsManagerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.SecretsManagerProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.SecretsManagerProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

### TelemetryProps <a name="TelemetryProps" id="kong-core.TelemetryProps"></a>

#### Initializer <a name="Initializer" id="kong-core.TelemetryProps.Initializer"></a>

```typescript
import { TelemetryProps } from 'kong-core'

const telemetryProps: TelemetryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#kong-core.TelemetryProps.property.cacertname">cacertname</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_eks.Cluster</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.clusterIssuerName">clusterIssuerName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.createPrometheusWorkspace">createPrometheusWorkspace</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.dnsNames">dnsNames</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.hostedZoneName">hostedZoneName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.namespace">namespace</a></code> | <code>string</code> | *No description.* |
| <code><a href="#kong-core.TelemetryProps.property.prometheusEndpoint">prometheusEndpoint</a></code> | <code>string</code> | *No description.* |

---

##### `cacertname`<sup>Required</sup> <a name="cacertname" id="kong-core.TelemetryProps.property.cacertname"></a>

```typescript
public readonly cacertname: string;
```

- *Type:* string

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="kong-core.TelemetryProps.property.cluster"></a>

```typescript
public readonly cluster: Cluster;
```

- *Type:* aws-cdk-lib.aws_eks.Cluster

---

##### `clusterIssuerName`<sup>Required</sup> <a name="clusterIssuerName" id="kong-core.TelemetryProps.property.clusterIssuerName"></a>

```typescript
public readonly clusterIssuerName: string;
```

- *Type:* string

---

##### `createPrometheusWorkspace`<sup>Required</sup> <a name="createPrometheusWorkspace" id="kong-core.TelemetryProps.property.createPrometheusWorkspace"></a>

```typescript
public readonly createPrometheusWorkspace: boolean;
```

- *Type:* boolean

---

##### `dnsNames`<sup>Required</sup> <a name="dnsNames" id="kong-core.TelemetryProps.property.dnsNames"></a>

```typescript
public readonly dnsNames: string[];
```

- *Type:* string[]

---

##### `hostedZoneName`<sup>Required</sup> <a name="hostedZoneName" id="kong-core.TelemetryProps.property.hostedZoneName"></a>

```typescript
public readonly hostedZoneName: string;
```

- *Type:* string

---

##### `namespace`<sup>Required</sup> <a name="namespace" id="kong-core.TelemetryProps.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* string

---

##### `prometheusEndpoint`<sup>Optional</sup> <a name="prometheusEndpoint" id="kong-core.TelemetryProps.property.prometheusEndpoint"></a>

```typescript
public readonly prometheusEndpoint: string;
```

- *Type:* string

---



## Enums <a name="Enums" id="Enums"></a>

### Namespace <a name="Namespace" id="kong-core.Namespace"></a>

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Namespace.KONG_CONTROL_PLANE">KONG_CONTROL_PLANE</a></code> | *No description.* |
| <code><a href="#kong-core.Namespace.TELEMETRY">TELEMETRY</a></code> | *No description.* |
| <code><a href="#kong-core.Namespace.KONG_DATA_PLANE">KONG_DATA_PLANE</a></code> | *No description.* |
| <code><a href="#kong-core.Namespace.AWS_PCA_ISSUER">AWS_PCA_ISSUER</a></code> | *No description.* |
| <code><a href="#kong-core.Namespace.CERT_MANAGER">CERT_MANAGER</a></code> | *No description.* |

---

##### `KONG_CONTROL_PLANE` <a name="KONG_CONTROL_PLANE" id="kong-core.Namespace.KONG_CONTROL_PLANE"></a>

---


##### `TELEMETRY` <a name="TELEMETRY" id="kong-core.Namespace.TELEMETRY"></a>

---


##### `KONG_DATA_PLANE` <a name="KONG_DATA_PLANE" id="kong-core.Namespace.KONG_DATA_PLANE"></a>

---


##### `AWS_PCA_ISSUER` <a name="AWS_PCA_ISSUER" id="kong-core.Namespace.AWS_PCA_ISSUER"></a>

---


##### `CERT_MANAGER` <a name="CERT_MANAGER" id="kong-core.Namespace.CERT_MANAGER"></a>

---


### Nlb <a name="Nlb" id="kong-core.Nlb"></a>

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Nlb.KONG_CP_ADMIN_LB_SUFFIX">KONG_CP_ADMIN_LB_SUFFIX</a></code> | *No description.* |
| <code><a href="#kong-core.Nlb.KONG_CP_MANAGER_LB_SUFFIX">KONG_CP_MANAGER_LB_SUFFIX</a></code> | *No description.* |
| <code><a href="#kong-core.Nlb.KONG_CP_DEVPORTAL_LB_SUFFIX">KONG_CP_DEVPORTAL_LB_SUFFIX</a></code> | *No description.* |
| <code><a href="#kong-core.Nlb.KONG_DP_LB_SUFFIX">KONG_DP_LB_SUFFIX</a></code> | *No description.* |

---

##### `KONG_CP_ADMIN_LB_SUFFIX` <a name="KONG_CP_ADMIN_LB_SUFFIX" id="kong-core.Nlb.KONG_CP_ADMIN_LB_SUFFIX"></a>

---


##### `KONG_CP_MANAGER_LB_SUFFIX` <a name="KONG_CP_MANAGER_LB_SUFFIX" id="kong-core.Nlb.KONG_CP_MANAGER_LB_SUFFIX"></a>

---


##### `KONG_CP_DEVPORTAL_LB_SUFFIX` <a name="KONG_CP_DEVPORTAL_LB_SUFFIX" id="kong-core.Nlb.KONG_CP_DEVPORTAL_LB_SUFFIX"></a>

---


##### `KONG_DP_LB_SUFFIX` <a name="KONG_DP_LB_SUFFIX" id="kong-core.Nlb.KONG_DP_LB_SUFFIX"></a>

---


### Tls <a name="Tls" id="kong-core.Tls"></a>

#### Members <a name="Members" id="Members"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#kong-core.Tls.ADOT_CERTNAME">ADOT_CERTNAME</a></code> | *No description.* |
| <code><a href="#kong-core.Tls.KONG_CP_CERTNAME">KONG_CP_CERTNAME</a></code> | *No description.* |
| <code><a href="#kong-core.Tls.KONG_CP_CLUSTER_ISSUER_NAME">KONG_CP_CLUSTER_ISSUER_NAME</a></code> | *No description.* |
| <code><a href="#kong-core.Tls.KONG_DP_CERTNAME">KONG_DP_CERTNAME</a></code> | *No description.* |
| <code><a href="#kong-core.Tls.KONG_DP_CLUSTER_ISSUER_NAME">KONG_DP_CLUSTER_ISSUER_NAME</a></code> | *No description.* |

---

##### `ADOT_CERTNAME` <a name="ADOT_CERTNAME" id="kong-core.Tls.ADOT_CERTNAME"></a>

---


##### `KONG_CP_CERTNAME` <a name="KONG_CP_CERTNAME" id="kong-core.Tls.KONG_CP_CERTNAME"></a>

---


##### `KONG_CP_CLUSTER_ISSUER_NAME` <a name="KONG_CP_CLUSTER_ISSUER_NAME" id="kong-core.Tls.KONG_CP_CLUSTER_ISSUER_NAME"></a>

---


##### `KONG_DP_CERTNAME` <a name="KONG_DP_CERTNAME" id="kong-core.Tls.KONG_DP_CERTNAME"></a>

---


##### `KONG_DP_CLUSTER_ISSUER_NAME` <a name="KONG_DP_CLUSTER_ISSUER_NAME" id="kong-core.Tls.KONG_DP_CLUSTER_ISSUER_NAME"></a>

---

