/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum DetectorType implements Enumeration
{
    CCD("CCD"),
    INTENSIFIEDCCD("IntensifiedCCD"),
    ANALOGVIDEO("AnalogVideo"),
    PMT("PMT"),
    PHOTODIODE("Photodiode"),
    SPECTROSCOPY("Spectroscopy"),
    LIFETIMEIMAGING("LifetimeImaging"),
    CORRELATIONSPECTROSCOPY("CorrelationSpectroscopy"),
    FTIR("FTIR"),
    EMCCD("EMCCD"),
    APD("APD"),
    CMOS("CMOS"),
    EBCCD("EBCCD"),
    OTHER("Other");

    private final String value;

    private DetectorType(String value) {
        this.value = value;
    }

    public static DetectorType fromString(String value) throws EnumerationException {
        if ("CCD".equals(value)) {
            return CCD;
        }
        if ("IntensifiedCCD".equals(value)) {
            return INTENSIFIEDCCD;
        }
        if ("AnalogVideo".equals(value)) {
            return ANALOGVIDEO;
        }
        if ("PMT".equals(value)) {
            return PMT;
        }
        if ("Photodiode".equals(value)) {
            return PHOTODIODE;
        }
        if ("Spectroscopy".equals(value)) {
            return SPECTROSCOPY;
        }
        if ("LifetimeImaging".equals(value)) {
            return LIFETIMEIMAGING;
        }
        if ("CorrelationSpectroscopy".equals(value)) {
            return CORRELATIONSPECTROSCOPY;
        }
        if ("FTIR".equals(value)) {
            return FTIR;
        }
        if ("EMCCD".equals(value)) {
            return EMCCD;
        }
        if ("APD".equals(value)) {
            return APD;
        }
        if ("CMOS".equals(value)) {
            return CMOS;
        }
        if ("EBCCD".equals(value)) {
            return EBCCD;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, DetectorType.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

