/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.OperationPtg;
import loci.poi.util.BitField;
import loci.poi.util.BitFieldFactory;
import loci.poi.util.LittleEndian;

public class AttrPtg
extends OperationPtg {
    public static final byte sid = 25;
    private static final int SIZE = 4;
    private byte field_1_options;
    private short field_2_data;
    private BitField semiVolatile = BitFieldFactory.getInstance(1);
    private BitField optiIf = BitFieldFactory.getInstance(2);
    private BitField optiChoose = BitFieldFactory.getInstance(4);
    private BitField optGoto = BitFieldFactory.getInstance(8);
    private BitField sum = BitFieldFactory.getInstance(16);
    private BitField baxcel = BitFieldFactory.getInstance(32);
    private BitField space = BitFieldFactory.getInstance(64);

    public AttrPtg() {
    }

    public AttrPtg(RecordInputStream in) {
        this.field_1_options = in.readByte();
        this.field_2_data = in.readShort();
    }

    public void setOptions(byte options) {
        this.field_1_options = options;
    }

    public byte getOptions() {
        return this.field_1_options;
    }

    public boolean isSemiVolatile() {
        return this.semiVolatile.isSet(this.getOptions());
    }

    public boolean isOptimizedIf() {
        return this.optiIf.isSet(this.getOptions());
    }

    public boolean isOptimizedChoose() {
        return this.optiChoose.isSet(this.getOptions());
    }

    public boolean isGoto() {
        return this.optGoto.isSet(this.getOptions());
    }

    public boolean isSum() {
        return this.sum.isSet(this.getOptions());
    }

    public void setSum(boolean bsum) {
        this.field_1_options = this.sum.setByteBoolean(this.field_1_options, bsum);
    }

    public void setOptimizedIf(boolean bif) {
        this.field_1_options = this.optiIf.setByteBoolean(this.field_1_options, bif);
    }

    public void setGoto(boolean isGoto) {
        this.field_1_options = this.optGoto.setByteBoolean(this.field_1_options, isGoto);
    }

    public boolean isBaxcel() {
        return this.baxcel.isSet(this.getOptions());
    }

    public boolean isSpace() {
        return this.space.isSet(this.getOptions());
    }

    public void setData(short data) {
        this.field_2_data = data;
    }

    public short getData() {
        return this.field_2_data;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AttrPtg\n");
        buffer.append("options=").append(this.field_1_options).append("\n");
        buffer.append("data   =").append(this.field_2_data).append("\n");
        buffer.append("semi   =").append(this.isSemiVolatile()).append("\n");
        buffer.append("optimif=").append(this.isOptimizedIf()).append("\n");
        buffer.append("optchos=").append(this.isOptimizedChoose()).append("\n");
        buffer.append("isGoto =").append(this.isGoto()).append("\n");
        buffer.append("isSum  =").append(this.isSum()).append("\n");
        buffer.append("isBaxce=").append(this.isBaxcel()).append("\n");
        buffer.append("isSpace=").append(this.isSpace()).append("\n");
        return buffer.toString();
    }

    @Override
    public void writeBytes(byte[] array, int offset) {
        array[offset] = 25;
        array[offset + 1] = this.field_1_options;
        LittleEndian.putShort(array, offset + 2, this.field_2_data);
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String toFormulaString(String[] operands) {
        if (this.space.isSet(this.field_1_options)) {
            return operands[0];
        }
        if (this.optiIf.isSet(this.field_1_options)) {
            return this.toFormulaString((Workbook)null) + "(" + operands[0] + ")";
        }
        if (this.optGoto.isSet(this.field_1_options)) {
            return this.toFormulaString((Workbook)null) + operands[0];
        }
        return this.toFormulaString((Workbook)null) + "(" + operands[0] + ")";
    }

    @Override
    public int getNumberOfOperands() {
        return 1;
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public String toFormulaString(Workbook book) {
        if (this.semiVolatile.isSet(this.field_1_options)) {
            return "ATTR(semiVolatile)";
        }
        if (this.optiIf.isSet(this.field_1_options)) {
            return "IF";
        }
        if (this.optiChoose.isSet(this.field_1_options)) {
            return "CHOOSE";
        }
        if (this.optGoto.isSet(this.field_1_options)) {
            return "";
        }
        if (this.sum.isSet(this.field_1_options)) {
            return "SUM";
        }
        if (this.baxcel.isSet(this.field_1_options)) {
            return "ATTR(baxcel)";
        }
        if (this.space.isSet(this.field_1_options)) {
            return "";
        }
        return "UNKNOWN ATTRIBUTE";
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public Object clone() {
        AttrPtg ptg = new AttrPtg();
        ptg.field_1_options = this.field_1_options;
        ptg.field_2_data = this.field_2_data;
        return ptg;
    }
}

