# -*- coding: utf-8 -*-
#
# Common (non-language-specific) configuration for Read The Docs & Sphinx
#
# Based on a Read the Docs Template documentation build configuration file,
# created by sphinx-quickstart on Tue Aug 26 14:19:49 2014.
#
# This file is imported from a language-specific conf.py (ie en/conf.py or
# zh_CN/conf.py)
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

from __future__ import print_function, unicode_literals

import os
import os.path

# -- General configuration ------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx_copybutton',
              'sphinx_rtd_theme',
              'sphinx.ext.autodoc',
              'sphinx.ext.doctest',
              'sphinx.ext.intersphinx',
              'sphinx.ext.todo',
              'sphinx.ext.coverage',
              'sphinx.ext.mathjax',
              'sphinx.ext.ifconfig',
              'sphinx.ext.viewcode',
              'breathe',
              'ts_docs.at_extensions.link_roles',
              'sphinx.ext.viewcode',
              'sphinx.ext.napoleon',
              ]

# sphinx.ext.todo extension parameters
# If the below parameter is True, the extension
# produces output, else it produces nothing.
todo_include_todos = False

# Enabling this fixes cropping of blockdiag edge labels
seqdiag_antialias = True

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
source_suffix = ['.rst', '.md']

source_parsers = {'.md': 'recommonmark.parser.CommonMarkParser',
                  }

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# exclude_patterns = ['**/inc/**', '_static/', '_build/**']

# conditional_include_dict = {}

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

html_theme = 'sphinx_idf_theme'

# context used by sphinx_idf_theme
# html_context = {
#     'display_github': True,  # Add 'Edit on Github' link instead of 'View page source'
#     'github_version': get_github_rev(),
# }

config_dir = os.path.abspath(os.path.dirname(__file__))

# Add any paths that contain templates here, relative to this directory.
templates_path = ['../_templates']

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.

breathe_default_project = "at"

html_logo = "../_static/timesintelli.jpg"

# If true, show URL addresses after external links.
# man_show_urls = False

# -- Options for LaTeX output ---------------------------------------------
latex_template_dir = os.path.join(config_dir, 'latex_templates')
preamble = 'r'
with open(os.path.join(latex_template_dir, 'preamble.tex')) as f:
     preamble = f.read()

titlepage = ''
with open(os.path.join(latex_template_dir, 'titlepage.tex')) as f:
     titlepage = f.read()

latex_engine = 'xelatex'
latex_logo = "../_static/timesintelli_logo.jpg"

latex_additional_files = [os.path.join(latex_template_dir,"timesintelli.sty")]
latex_elements = {
    'fncychap': '\\usepackage[Sonny]{fncychap}',

    'preamble': preamble,

    'maketitle': titlepage,
}
chips={
    'at1k': ['Please waiting'],
    'at820': ['Please waiting'],
    'at5050': ['Please waiting'],
}
versions=['Please waiting']
html_context = {
    'chips' : chips,
    'versions' : versions,
    # must  change,  last weekly
    'languages' : "en",
}

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/': None}

def setup(app):

    # config values that are pushed in by build_docs,py
    if 'chip' not in app.config:
        app.add_config_value('chip', None, 'env')






