"""
    Copyright 2022 Calcasa B.V.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Calcasa Public API v1

    The version of the OpenAPI document: 1.1.6
    Contact: info@calcasa.nl
    Generated by: https://openapi-generator.tech
"""

import re  # noqa: F401
import sys  # noqa: F401

from calcasa.api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from calcasa.api.exceptions import ApiAttributeError


def lazy_import():
    from calcasa.api.model.adres import Adres
    from calcasa.api.model.cbs_indeling import CbsIndeling
    from calcasa.api.model.factuur import Factuur
    from calcasa.api.model.foto import Foto
    from calcasa.api.model.modeldata import Modeldata
    from calcasa.api.model.objectdata import Objectdata
    from calcasa.api.model.rapport import Rapport
    from calcasa.api.model.referentieobject import Referentieobject
    from calcasa.api.model.taxatiedata import Taxatiedata
    from calcasa.api.model.vorige_verkoop import VorigeVerkoop
    from calcasa.api.model.waardering_input_parameters import WaarderingInputParameters
    from calcasa.api.model.waardering_status import WaarderingStatus
    globals()['Adres'] = Adres
    globals()['CbsIndeling'] = CbsIndeling
    globals()['Factuur'] = Factuur
    globals()['Foto'] = Foto
    globals()['Modeldata'] = Modeldata
    globals()['Objectdata'] = Objectdata
    globals()['Rapport'] = Rapport
    globals()['Referentieobject'] = Referentieobject
    globals()['Taxatiedata'] = Taxatiedata
    globals()['VorigeVerkoop'] = VorigeVerkoop
    globals()['WaarderingInputParameters'] = WaarderingInputParameters
    globals()['WaarderingStatus'] = WaarderingStatus


class Waardering(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'aangemaakt': (datetime,),  # noqa: E501
            'status': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'originele_input': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'adres': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'model': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'taxatie': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'object': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'cbs_indeling': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'fotos': ([Foto], none_type,),  # noqa: E501
            'referenties': ([Referentieobject], none_type,),  # noqa: E501
            'vorige_verkopen': ([VorigeVerkoop], none_type,),  # noqa: E501
            'rapport': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'factuur': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'aangemaakt': 'aangemaakt',  # noqa: E501
        'status': 'status',  # noqa: E501
        'originele_input': 'origineleInput',  # noqa: E501
        'adres': 'adres',  # noqa: E501
        'model': 'model',  # noqa: E501
        'taxatie': 'taxatie',  # noqa: E501
        'object': 'object',  # noqa: E501
        'cbs_indeling': 'cbsIndeling',  # noqa: E501
        'fotos': 'fotos',  # noqa: E501
        'referenties': 'referenties',  # noqa: E501
        'vorige_verkopen': 'vorigeVerkopen',  # noqa: E501
        'rapport': 'rapport',  # noqa: E501
        'factuur': 'factuur',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Waardering - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Id van de waardering of tracking Id.. [optional]  # noqa: E501
            aangemaakt (datetime): Het tijdsstempel van wanneer de waardering aangemaakt is.. [optional]  # noqa: E501
            status (bool, date, datetime, dict, float, int, list, str, none_type): De huidige status van de waardering. | Waarde | Omschrijving | | --- | --- | | `onbekend` | Status onbekend. | | `initialiseren` | Deze waardering is geinitialiseerd maar moet nog bevestigd worden. | | `open` | Deze waardering is bevestigd maar moet nog uitgevoerd worden. | | `voltooid` | Deze waardering is voltooid. | | `opgewaardeerd` | Deze waardering is geupgrade naar een ander waardering type. | | `ongeldig` | Deze waardering is niet geldig, bijvoorbeeld omdat hij niet door de business rules is gekomen. | | `verlopen` | Deze waardering is verlopen omdat hij niet op tijd bevestigd is. | | `error` | Er is iets mis gegaan voor deze waardering. | | `inBehandeling` | Deze waardering is in behandeling door het systeem. |   . [optional]  # noqa: E501
            originele_input (bool, date, datetime, dict, float, int, list, str, none_type): De invoer die gebruikt is voor het aanmaken van deze waardering.. [optional]  # noqa: E501
            adres (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            model (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            taxatie (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            object (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            cbs_indeling (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            fotos ([Foto], none_type): [optional]  # noqa: E501
            referenties ([Referentieobject], none_type): [optional]  # noqa: E501
            vorige_verkopen ([VorigeVerkoop], none_type): [optional]  # noqa: E501
            rapport (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            factuur (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Waardering - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Id van de waardering of tracking Id.. [optional]  # noqa: E501
            aangemaakt (datetime): Het tijdsstempel van wanneer de waardering aangemaakt is.. [optional]  # noqa: E501
            status (bool, date, datetime, dict, float, int, list, str, none_type): De huidige status van de waardering. | Waarde | Omschrijving | | --- | --- | | `onbekend` | Status onbekend. | | `initialiseren` | Deze waardering is geinitialiseerd maar moet nog bevestigd worden. | | `open` | Deze waardering is bevestigd maar moet nog uitgevoerd worden. | | `voltooid` | Deze waardering is voltooid. | | `opgewaardeerd` | Deze waardering is geupgrade naar een ander waardering type. | | `ongeldig` | Deze waardering is niet geldig, bijvoorbeeld omdat hij niet door de business rules is gekomen. | | `verlopen` | Deze waardering is verlopen omdat hij niet op tijd bevestigd is. | | `error` | Er is iets mis gegaan voor deze waardering. | | `inBehandeling` | Deze waardering is in behandeling door het systeem. |   . [optional]  # noqa: E501
            originele_input (bool, date, datetime, dict, float, int, list, str, none_type): De invoer die gebruikt is voor het aanmaken van deze waardering.. [optional]  # noqa: E501
            adres (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            model (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            taxatie (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            object (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            cbs_indeling (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            fotos ([Foto], none_type): [optional]  # noqa: E501
            referenties ([Referentieobject], none_type): [optional]  # noqa: E501
            vorige_verkopen ([VorigeVerkoop], none_type): [optional]  # noqa: E501
            rapport (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            factuur (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
