from .utils import hsl
from .utils import rgb


def get_item(color: str, name: str):
    r, g, b = rgb(color)
    h, s, l = hsl(color)  # noqa: E741

    return f'#{color}', name, r, g, b, h, s, l


names = [
    get_item('000000', 'Black'),
    get_item('000080', 'Navy Blue'),
    get_item('0000C8', 'Dark Blue'),
    get_item('0000FF', 'Blue'),
    get_item('000741', 'Stratos'),
    get_item('001B1C', 'Swamp'),
    get_item('002387', 'Resolution Blue'),
    get_item('002900', 'Deep Fir'),
    get_item('002E20', 'Burnham'),
    get_item('002FA7', 'International Klein Blue'),
    get_item('003153', 'Prussian Blue'),
    get_item('003366', 'Midnight Blue'),
    get_item('003399', 'Smalt'),
    get_item('003532', 'Deep Teal'),
    get_item('003E40', 'Cyprus'),
    get_item('004620', 'Kaitoke Green'),
    get_item('0047AB', 'Cobalt'),
    get_item('004816', 'Crusoe'),
    get_item('004950', 'Sherpa Blue'),
    get_item('0056A7', 'Endeavour'),
    get_item('00581A', 'Camarone'),
    get_item('0066CC', 'Science Blue'),
    get_item('0066FF', 'Blue Ribbon'),
    get_item('00755E', 'Tropical Rain Forest'),
    get_item('0076A3', 'Allports'),
    get_item('007BA7', 'Deep Cerulean'),
    get_item('007EC7', 'Lochmara'),
    get_item('007FFF', 'Azure Radiance'),
    get_item('008080', 'Teal'),
    get_item('0095B6', 'Bondi Blue'),
    get_item('009DC4', 'Pacific Blue'),
    get_item('00A693', 'Persian Green'),
    get_item('00A86B', 'Jade'),
    get_item('00CC99', 'Caribbean Green'),
    get_item('00CCCC', 'Robin\'s Egg Blue'),
    get_item('00FF00', 'Green'),
    get_item('00FF7F', 'Spring Green'),
    get_item('00FFFF', 'Cyan / Aqua'),
    get_item('010D1A', 'Blue Charcoal'),
    get_item('011635', 'Midnight'),
    get_item('011D13', 'Holly'),
    get_item('012731', 'Daintree'),
    get_item('01361C', 'Cardin Green'),
    get_item('01371A', 'County Green'),
    get_item('013E62', 'Astronaut Blue'),
    get_item('013F6A', 'Regal Blue'),
    get_item('014B43', 'Aqua Deep'),
    get_item('015E85', 'Orient'),
    get_item('016162', 'Blue Stone'),
    get_item('016D39', 'Fun Green'),
    get_item('01796F', 'Pine Green'),
    get_item('017987', 'Blue Lagoon'),
    get_item('01826B', 'Deep Sea'),
    get_item('01A368', 'Green Haze'),
    get_item('022D15', 'English Holly'),
    get_item('02402C', 'Sherwood Green'),
    get_item('02478E', 'Congress Blue'),
    get_item('024E46', 'Evening Sea'),
    get_item('026395', 'Bahama Blue'),
    get_item('02866F', 'Observatory'),
    get_item('02A4D3', 'Cerulean'),
    get_item('03163C', 'Tangaroa'),
    get_item('032B52', 'Green Vogue'),
    get_item('036A6E', 'Mosque'),
    get_item('041004', 'Midnight Moss'),
    get_item('041322', 'Black Pearl'),
    get_item('042E4C', 'Blue Whale'),
    get_item('044022', 'Zuccini'),
    get_item('044259', 'Teal Blue'),
    get_item('051040', 'Deep Cove'),
    get_item('051657', 'Gulf Blue'),
    get_item('055989', 'Venice Blue'),
    get_item('056F57', 'Watercourse'),
    get_item('062A78', 'Catalina Blue'),
    get_item('063537', 'Tiber'),
    get_item('069B81', 'Gossamer'),
    get_item('06A189', 'Niagara'),
    get_item('073A50', 'Tarawera'),
    get_item('080110', 'Jaguar'),
    get_item('081910', 'Black Bean'),
    get_item('082567', 'Deep Sapphire'),
    get_item('088370', 'Elf Green'),
    get_item('08E8DE', 'Bright Turquoise'),
    get_item('092256', 'Downriver'),
    get_item('09230F', 'Palm Green'),
    get_item('09255D', 'Madison'),
    get_item('093624', 'Bottle Green'),
    get_item('095859', 'Deep Sea Green'),
    get_item('097F4B', 'Salem'),
    get_item('0A001C', 'Black Russian'),
    get_item('0A480D', 'Dark Fern'),
    get_item('0A6906', 'Japanese Laurel'),
    get_item('0A6F75', 'Atoll'),
    get_item('0B0B0B', 'Cod Gray'),
    get_item('0B0F08', 'Marshland'),
    get_item('0B1107', 'Gordons Green'),
    get_item('0B1304', 'Black Forest'),
    get_item('0B6207', 'San Felix'),
    get_item('0BDA51', 'Malachite'),
    get_item('0C0B1D', 'Ebony'),
    get_item('0C0D0F', 'Woodsmoke'),
    get_item('0C1911', 'Racing Green'),
    get_item('0C7A79', 'Surfie Green'),
    get_item('0C8990', 'Blue Chill'),
    get_item('0D0332', 'Black Rock'),
    get_item('0D1117', 'Bunker'),
    get_item('0D1C19', 'Aztec'),
    get_item('0D2E1C', 'Bush'),
    get_item('0E0E18', 'Cinder'),
    get_item('0E2A30', 'Firefly'),
    get_item('0F2D9E', 'Torea Bay'),
    get_item('10121D', 'Vulcan'),
    get_item('101405', 'Green Waterloo'),
    get_item('105852', 'Eden'),
    get_item('110C6C', 'Arapawa'),
    get_item('120A8F', 'Ultramarine'),
    get_item('123447', 'Elephant'),
    get_item('126B40', 'Jewel'),
    get_item('130000', 'Diesel'),
    get_item('130A06', 'Asphalt'),
    get_item('13264D', 'Blue Zodiac'),
    get_item('134F19', 'Parsley'),
    get_item('140600', 'Nero'),
    get_item('1450AA', 'Tory Blue'),
    get_item('151F4C', 'Bunting'),
    get_item('1560BD', 'Denim'),
    get_item('15736B', 'Genoa'),
    get_item('161928', 'Mirage'),
    get_item('161D10', 'Hunter Green'),
    get_item('162A40', 'Big Stone'),
    get_item('163222', 'Celtic'),
    get_item('16322C', 'Timber Green'),
    get_item('163531', 'Gable Green'),
    get_item('171F04', 'Pine Tree'),
    get_item('175579', 'Chathams Blue'),
    get_item('182D09', 'Deep Forest Green'),
    get_item('18587A', 'Blumine'),
    get_item('19330E', 'Palm Leaf'),
    get_item('193751', 'Nile Blue'),
    get_item('1959A8', 'Fun Blue'),
    get_item('1A1A68', 'Lucky Point'),
    get_item('1AB385', 'Mountain Meadow'),
    get_item('1B0245', 'Tolopea'),
    get_item('1B1035', 'Haiti'),
    get_item('1B127B', 'Deep Koamaru'),
    get_item('1B1404', 'Acadia'),
    get_item('1B2F11', 'Seaweed'),
    get_item('1B3162', 'Biscay'),
    get_item('1B659D', 'Matisse'),
    get_item('1C1208', 'Crowshead'),
    get_item('1C1E13', 'Rangoon Green'),
    get_item('1C39BB', 'Persian Blue'),
    get_item('1C402E', 'Everglade'),
    get_item('1C7C7D', 'Elm'),
    get_item('1D6142', 'Green Pea'),
    get_item('1E0F04', 'Creole'),
    get_item('1E1609', 'Karaka'),
    get_item('1E1708', 'El Paso'),
    get_item('1E385B', 'Cello'),
    get_item('1E433C', 'Te Papa Green'),
    get_item('1E90FF', 'Dodger Blue'),
    get_item('1E9AB0', 'Eastern Blue'),
    get_item('1F120F', 'Night Rider'),
    get_item('1FC2C2', 'Java'),
    get_item('20208D', 'Jacksons Purple'),
    get_item('202E54', 'Cloud Burst'),
    get_item('204852', 'Blue Dianne'),
    get_item('211A0E', 'Eternity'),
    get_item('220878', 'Deep Blue'),
    get_item('228B22', 'Forest Green'),
    get_item('233418', 'Mallard'),
    get_item('240A40', 'Violet'),
    get_item('240C02', 'Kilamanjaro'),
    get_item('242A1D', 'Log Cabin'),
    get_item('242E16', 'Black Olive'),
    get_item('24500F', 'Green House'),
    get_item('251607', 'Graphite'),
    get_item('251706', 'Cannon Black'),
    get_item('251F4F', 'Port Gore'),
    get_item('25272C', 'Shark'),
    get_item('25311C', 'Green Kelp'),
    get_item('2596D1', 'Curious Blue'),
    get_item('260368', 'Paua'),
    get_item('26056A', 'Paris M'),
    get_item('261105', 'Wood Bark'),
    get_item('261414', 'Gondola'),
    get_item('262335', 'Steel Gray'),
    get_item('26283B', 'Ebony Clay'),
    get_item('273A81', 'Bay of Many'),
    get_item('27504B', 'Plantation'),
    get_item('278A5B', 'Eucalyptus'),
    get_item('281E15', 'Oil'),
    get_item('283A77', 'Astronaut'),
    get_item('286ACD', 'Mariner'),
    get_item('290C5E', 'Violent Violet'),
    get_item('292130', 'Bastille'),
    get_item('292319', 'Zeus'),
    get_item('292937', 'Charade'),
    get_item('297B9A', 'Jelly Bean'),
    get_item('29AB87', 'Jungle Green'),
    get_item('2A0359', 'Cherry Pie'),
    get_item('2A140E', 'Coffee Bean'),
    get_item('2A2630', 'Baltic Sea'),
    get_item('2A380B', 'Turtle Green'),
    get_item('2A52BE', 'Cerulean Blue'),
    get_item('2B0202', 'Sepia Black'),
    get_item('2B194F', 'Valhalla'),
    get_item('2B3228', 'Heavy Metal'),
    get_item('2C0E8C', 'Blue Gem'),
    get_item('2C1632', 'Revolver'),
    get_item('2C2133', 'Bleached Cedar'),
    get_item('2C8C84', 'Lochinvar'),
    get_item('2D2510', 'Mikado'),
    get_item('2D383A', 'Outer Space'),
    get_item('2D569B', 'St Tropaz'),
    get_item('2E0329', 'Jacaranda'),
    get_item('2E1905', 'Jacko Bean'),
    get_item('2E3222', 'Rangitoto'),
    get_item('2E3F62', 'Rhino'),
    get_item('2E8B57', 'Sea Green'),
    get_item('2EBFD4', 'Scooter'),
    get_item('2F270E', 'Onion'),
    get_item('2F3CB3', 'Governor Bay'),
    get_item('2F519E', 'Sapphire'),
    get_item('2F5A57', 'Spectra'),
    get_item('2F6168', 'Casal'),
    get_item('300529', 'Melanzane'),
    get_item('301F1E', 'Cocoa Brown'),
    get_item('302A0F', 'Woodrush'),
    get_item('304B6A', 'San Juan'),
    get_item('30D5C8', 'Turquoise'),
    get_item('311C17', 'Eclipse'),
    get_item('314459', 'Pickled Bluewood'),
    get_item('315BA1', 'Azure'),
    get_item('31728D', 'Calypso'),
    get_item('317D82', 'Paradiso'),
    get_item('32127A', 'Persian Indigo'),
    get_item('32293A', 'Blackcurrant'),
    get_item('323232', 'Mine Shaft'),
    get_item('325D52', 'Stromboli'),
    get_item('327C14', 'Bilbao'),
    get_item('327DA0', 'Astral'),
    get_item('33036B', 'Christalle'),
    get_item('33292F', 'Thunder'),
    get_item('33CC99', 'Shamrock'),
    get_item('341515', 'Tamarind'),
    get_item('350036', 'Mardi Gras'),
    get_item('350E42', 'Valentino'),
    get_item('350E57', 'Jagger'),
    get_item('353542', 'Tuna'),
    get_item('354E8C', 'Chambray'),
    get_item('363050', 'Martinique'),
    get_item('363534', 'Tuatara'),
    get_item('363C0D', 'Waiouru'),
    get_item('36747D', 'Ming'),
    get_item('368716', 'La Palma'),
    get_item('370202', 'Chocolate'),
    get_item('371D09', 'Clinker'),
    get_item('37290E', 'Brown Tumbleweed'),
    get_item('373021', 'Birch'),
    get_item('377475', 'Oracle'),
    get_item('380474', 'Blue Diamond'),
    get_item('381A51', 'Grape'),
    get_item('383533', 'Dune'),
    get_item('384555', 'Oxford Blue'),
    get_item('384910', 'Clover'),
    get_item('394851', 'Limed Spruce'),
    get_item('396413', 'Dell'),
    get_item('3A0020', 'Toledo'),
    get_item('3A2010', 'Sambuca'),
    get_item('3A2A6A', 'Jacarta'),
    get_item('3A686C', 'William'),
    get_item('3A6A47', 'Killarney'),
    get_item('3AB09E', 'Keppel'),
    get_item('3B000B', 'Temptress'),
    get_item('3B0910', 'Aubergine'),
    get_item('3B1F1F', 'Jon'),
    get_item('3B2820', 'Treehouse'),
    get_item('3B7A57', 'Amazon'),
    get_item('3B91B4', 'Boston Blue'),
    get_item('3C0878', 'Windsor'),
    get_item('3C1206', 'Rebel'),
    get_item('3C1F76', 'Meteorite'),
    get_item('3C2005', 'Dark Ebony'),
    get_item('3C3910', 'Camouflage'),
    get_item('3C4151', 'Bright Gray'),
    get_item('3C4443', 'Cape Cod'),
    get_item('3C493A', 'Lunar Green'),
    get_item('3D0C02', 'Bean  '),
    get_item('3D2B1F', 'Bistre'),
    get_item('3D7D52', 'Goblin'),
    get_item('3E0480', 'Kingfisher Daisy'),
    get_item('3E1C14', 'Cedar'),
    get_item('3E2B23', 'English Walnut'),
    get_item('3E2C1C', 'Black Marlin'),
    get_item('3E3A44', 'Ship Gray'),
    get_item('3EABBF', 'Pelorous'),
    get_item('3F2109', 'Bronze'),
    get_item('3F2500', 'Cola'),
    get_item('3F3002', 'Madras'),
    get_item('3F307F', 'Minsk'),
    get_item('3F4C3A', 'Cabbage Pont'),
    get_item('3F583B', 'Tom Thumb'),
    get_item('3F5D53', 'Mineral Green'),
    get_item('3FC1AA', 'Puerto Rico'),
    get_item('3FFF00', 'Harlequin'),
    get_item('401801', 'Brown Pod'),
    get_item('40291D', 'Cork'),
    get_item('403B38', 'Masala'),
    get_item('403D19', 'Thatch Green'),
    get_item('405169', 'Fiord'),
    get_item('40826D', 'Viridian'),
    get_item('40A860', 'Chateau Green'),
    get_item('410056', 'Ripe Plum'),
    get_item('411F10', 'Paco'),
    get_item('412010', 'Deep Oak'),
    get_item('413C37', 'Merlin'),
    get_item('414257', 'Gun Powder'),
    get_item('414C7D', 'East Bay'),
    get_item('4169E1', 'Royal Blue'),
    get_item('41AA78', 'Ocean Green'),
    get_item('420303', 'Burnt Maroon'),
    get_item('423921', 'Lisbon Brown'),
    get_item('427977', 'Faded Jade'),
    get_item('431560', 'Scarlet Gum'),
    get_item('433120', 'Iroko'),
    get_item('433E37', 'Armadillo'),
    get_item('434C59', 'River Bed'),
    get_item('436A0D', 'Green Leaf'),
    get_item('44012D', 'Barossa'),
    get_item('441D00', 'Morocco Brown'),
    get_item('444954', 'Mako'),
    get_item('454936', 'Kelp'),
    get_item('456CAC', 'San Marino'),
    get_item('45B1E8', 'Picton Blue'),
    get_item('460B41', 'Loulou'),
    get_item('462425', 'Crater Brown'),
    get_item('465945', 'Gray Asparagus'),
    get_item('4682B4', 'Steel Blue'),
    get_item('480404', 'Rustic Red'),
    get_item('480607', 'Bulgarian Rose'),
    get_item('480656', 'Clairvoyant'),
    get_item('481C1C', 'Cocoa Bean'),
    get_item('483131', 'Woody Brown'),
    get_item('483C32', 'Taupe'),
    get_item('49170C', 'Van Cleef'),
    get_item('492615', 'Brown Derby'),
    get_item('49371B', 'Metallic Bronze'),
    get_item('495400', 'Verdun Green'),
    get_item('496679', 'Blue Bayoux'),
    get_item('497183', 'Bismark'),
    get_item('4A2A04', 'Bracken'),
    get_item('4A3004', 'Deep Bronze'),
    get_item('4A3C30', 'Mondo'),
    get_item('4A4244', 'Tundora'),
    get_item('4A444B', 'Gravel'),
    get_item('4A4E5A', 'Trout'),
    get_item('4B0082', 'Pigment Indigo'),
    get_item('4B5D52', 'Nandor'),
    get_item('4C3024', 'Saddle'),
    get_item('4C4F56', 'Abbey'),
    get_item('4D0135', 'Blackberry'),
    get_item('4D0A18', 'Cab Sav'),
    get_item('4D1E01', 'Indian Tan'),
    get_item('4D282D', 'Cowboy'),
    get_item('4D282E', 'Livid Brown'),
    get_item('4D3833', 'Rock'),
    get_item('4D3D14', 'Punga'),
    get_item('4D400F', 'Bronzetone'),
    get_item('4D5328', 'Woodland'),
    get_item('4E0606', 'Mahogany'),
    get_item('4E2A5A', 'Bossanova'),
    get_item('4E3B41', 'Matterhorn'),
    get_item('4E420C', 'Bronze Olive'),
    get_item('4E4562', 'Mulled Wine'),
    get_item('4E6649', 'Axolotl'),
    get_item('4E7F9E', 'Wedgewood'),
    get_item('4EABD1', 'Shakespeare'),
    get_item('4F1C70', 'Honey Flower'),
    get_item('4F2398', 'Daisy Bush'),
    get_item('4F69C6', 'Indigo'),
    get_item('4F7942', 'Fern Green'),
    get_item('4F9D5D', 'Fruit Salad'),
    get_item('4FA83D', 'Apple'),
    get_item('504351', 'Mortar'),
    get_item('507096', 'Kashmir Blue'),
    get_item('507672', 'Cutty Sark'),
    get_item('50C878', 'Emerald'),
    get_item('514649', 'Emperor'),
    get_item('516E3D', 'Chalet Green'),
    get_item('517C66', 'Como'),
    get_item('51808F', 'Smalt Blue'),
    get_item('52001F', 'Castro'),
    get_item('520C17', 'Maroon Oak'),
    get_item('523C94', 'Gigas'),
    get_item('533455', 'Voodoo'),
    get_item('534491', 'Victoria'),
    get_item('53824B', 'Hippie Green'),
    get_item('541012', 'Heath'),
    get_item('544333', 'Judge Gray'),
    get_item('54534D', 'Fuscous Gray'),
    get_item('549019', 'Vida Loca'),
    get_item('55280C', 'Cioccolato'),
    get_item('555B10', 'Saratoga'),
    get_item('556D56', 'Finlandia'),
    get_item('5590D9', 'Havelock Blue'),
    get_item('56B4BE', 'Fountain Blue'),
    get_item('578363', 'Spring Leaves'),
    get_item('583401', 'Saddle Brown'),
    get_item('585562', 'Scarpa Flow'),
    get_item('587156', 'Cactus'),
    get_item('589AAF', 'Hippie Blue'),
    get_item('591D35', 'Wine Berry'),
    get_item('592804', 'Brown Bramble'),
    get_item('593737', 'Congo Brown'),
    get_item('594433', 'Millbrook'),
    get_item('5A6E9C', 'Waikawa Gray'),
    get_item('5A87A0', 'Horizon'),
    get_item('5B3013', 'Jambalaya'),
    get_item('5C0120', 'Bordeaux'),
    get_item('5C0536', 'Mulberry Wood'),
    get_item('5C2E01', 'Carnaby Tan'),
    get_item('5C5D75', 'Comet'),
    get_item('5D1E0F', 'Redwood'),
    get_item('5D4C51', 'Don Juan'),
    get_item('5D5C58', 'Chicago'),
    get_item('5D5E37', 'Verdigris'),
    get_item('5D7747', 'Dingley'),
    get_item('5DA19F', 'Breaker Bay'),
    get_item('5E483E', 'Kabul'),
    get_item('5E5D3B', 'Hemlock'),
    get_item('5F3D26', 'Irish Coffee'),
    get_item('5F5F6E', 'Mid Gray'),
    get_item('5F6672', 'Shuttle Gray'),
    get_item('5FA777', 'Aqua Forest'),
    get_item('5FB3AC', 'Tradewind'),
    get_item('604913', 'Horses Neck'),
    get_item('605B73', 'Smoky'),
    get_item('606E68', 'Corduroy'),
    get_item('6093D1', 'Danube'),
    get_item('612718', 'Espresso'),
    get_item('614051', 'Eggplant'),
    get_item('615D30', 'Costa Del Sol'),
    get_item('61845F', 'Glade Green'),
    get_item('622F30', 'Buccaneer'),
    get_item('623F2D', 'Quincy'),
    get_item('624E9A', 'Butterfly Bush'),
    get_item('625119', 'West Coast'),
    get_item('626649', 'Finch'),
    get_item('639A8F', 'Patina'),
    get_item('63B76C', 'Fern'),
    get_item('6456B7', 'Blue Violet'),
    get_item('646077', 'Dolphin'),
    get_item('646463', 'Storm Dust'),
    get_item('646A54', 'Siam'),
    get_item('646E75', 'Nevada'),
    get_item('6495ED', 'Cornflower Blue'),
    get_item('64CCDB', 'Viking'),
    get_item('65000B', 'Rosewood'),
    get_item('651A14', 'Cherrywood'),
    get_item('652DC1', 'Purple Heart'),
    get_item('657220', 'Fern Frond'),
    get_item('65745D', 'Willow Grove'),
    get_item('65869F', 'Hoki'),
    get_item('660045', 'Pompadour'),
    get_item('660099', 'Purple'),
    get_item('66023C', 'Tyrian Purple'),
    get_item('661010', 'Dark Tan'),
    get_item('66B58F', 'Silver Tree'),
    get_item('66FF00', 'Bright Green'),
    get_item('66FF66', 'Screamin\' Green'),
    get_item('67032D', 'Black Rose'),
    get_item('675FA6', 'Scampi'),
    get_item('676662', 'Ironside Gray'),
    get_item('678975', 'Viridian Green'),
    get_item('67A712', 'Christi'),
    get_item('683600', 'Nutmeg Wood Finish'),
    get_item('685558', 'Zambezi'),
    get_item('685E6E', 'Salt Box'),
    get_item('692545', 'Tawny Port'),
    get_item('692D54', 'Finn'),
    get_item('695F62', 'Scorpion'),
    get_item('697E9A', 'Lynch'),
    get_item('6A442E', 'Spice'),
    get_item('6A5D1B', 'Himalaya'),
    get_item('6A6051', 'Soya Bean'),
    get_item('6B2A14', 'Hairy Heath'),
    get_item('6B3FA0', 'Royal Purple'),
    get_item('6B4E31', 'Shingle Fawn'),
    get_item('6B5755', 'Dorado'),
    get_item('6B8BA2', 'Bermuda Gray'),
    get_item('6B8E23', 'Olive Drab'),
    get_item('6C3082', 'Eminence'),
    get_item('6CDAE7', 'Turquoise Blue'),
    get_item('6D0101', 'Lonestar'),
    get_item('6D5E54', 'Pine Cone'),
    get_item('6D6C6C', 'Dove Gray'),
    get_item('6D9292', 'Juniper'),
    get_item('6D92A1', 'Gothic'),
    get_item('6E0902', 'Red Oxide'),
    get_item('6E1D14', 'Moccaccino'),
    get_item('6E4826', 'Pickled Bean'),
    get_item('6E4B26', 'Dallas'),
    get_item('6E6D57', 'Kokoda'),
    get_item('6E7783', 'Pale Sky'),
    get_item('6F440C', 'Cafe Royale'),
    get_item('6F6A61', 'Flint'),
    get_item('6F8E63', 'Highland'),
    get_item('6F9D02', 'Limeade'),
    get_item('6FD0C5', 'Downy'),
    get_item('701C1C', 'Persian Plum'),
    get_item('704214', 'Sepia'),
    get_item('704A07', 'Antique Bronze'),
    get_item('704F50', 'Ferra'),
    get_item('706555', 'Coffee'),
    get_item('708090', 'Slate Gray'),
    get_item('711A00', 'Cedar Wood Finish'),
    get_item('71291D', 'Metallic Copper'),
    get_item('714693', 'Affair'),
    get_item('714AB2', 'Studio'),
    get_item('715D47', 'Tobacco Brown'),
    get_item('716338', 'Yellow Metal'),
    get_item('716B56', 'Peat'),
    get_item('716E10', 'Olivetone'),
    get_item('717486', 'Storm Gray'),
    get_item('718080', 'Sirocco'),
    get_item('71D9E2', 'Aquamarine Blue'),
    get_item('72010F', 'Venetian Red'),
    get_item('724A2F', 'Old Copper'),
    get_item('726D4E', 'Go Ben'),
    get_item('727B89', 'Raven'),
    get_item('731E8F', 'Seance'),
    get_item('734A12', 'Raw Umber'),
    get_item('736C9F', 'Kimberly'),
    get_item('736D58', 'Crocodile'),
    get_item('737829', 'Crete'),
    get_item('738678', 'Xanadu'),
    get_item('74640D', 'Spicy Mustard'),
    get_item('747D63', 'Limed Ash'),
    get_item('747D83', 'Rolling Stone'),
    get_item('748881', 'Blue Smoke'),
    get_item('749378', 'Laurel'),
    get_item('74C365', 'Mantis'),
    get_item('755A57', 'Russett'),
    get_item('7563A8', 'Deluge'),
    get_item('76395D', 'Cosmic'),
    get_item('7666C6', 'Blue Marguerite'),
    get_item('76BD17', 'Lima'),
    get_item('76D7EA', 'Sky Blue'),
    get_item('770F05', 'Dark Burgundy'),
    get_item('771F1F', 'Crown of Thorns'),
    get_item('773F1A', 'Walnut'),
    get_item('776F61', 'Pablo'),
    get_item('778120', 'Pacifika'),
    get_item('779E86', 'Oxley'),
    get_item('77DD77', 'Pastel Green'),
    get_item('780109', 'Japanese Maple'),
    get_item('782D19', 'Mocha'),
    get_item('782F16', 'Peanut'),
    get_item('78866B', 'Camouflage Green'),
    get_item('788A25', 'Wasabi'),
    get_item('788BBA', 'Ship Cove'),
    get_item('78A39C', 'Sea Nymph'),
    get_item('795D4C', 'Roman Coffee'),
    get_item('796878', 'Old Lavender'),
    get_item('796989', 'Rum'),
    get_item('796A78', 'Fedora'),
    get_item('796D62', 'Sandstone'),
    get_item('79DEEC', 'Spray'),
    get_item('7A013A', 'Siren'),
    get_item('7A58C1', 'Fuchsia Blue'),
    get_item('7A7A7A', 'Boulder'),
    get_item('7A89B8', 'Wild Blue Yonder'),
    get_item('7AC488', 'De York'),
    get_item('7B3801', 'Red Beech'),
    get_item('7B3F00', 'Cinnamon'),
    get_item('7B6608', 'Yukon Gold'),
    get_item('7B7874', 'Tapa'),
    get_item('7B7C94', 'Waterloo '),
    get_item('7B8265', 'Flax Smoke'),
    get_item('7B9F80', 'Amulet'),
    get_item('7BA05B', 'Asparagus'),
    get_item('7C1C05', 'Kenyan Copper'),
    get_item('7C7631', 'Pesto'),
    get_item('7C778A', 'Topaz'),
    get_item('7C7B7A', 'Concord'),
    get_item('7C7B82', 'Jumbo'),
    get_item('7C881A', 'Trendy Green'),
    get_item('7CA1A6', 'Gumbo'),
    get_item('7CB0A1', 'Acapulco'),
    get_item('7CB7BB', 'Neptune'),
    get_item('7D2C14', 'Pueblo'),
    get_item('7DA98D', 'Bay Leaf'),
    get_item('7DC8F7', 'Malibu'),
    get_item('7DD8C6', 'Bermuda'),
    get_item('7E3A15', 'Copper Canyon'),
    get_item('7F1734', 'Claret'),
    get_item('7F3A02', 'Peru Tan'),
    get_item('7F626D', 'Falcon'),
    get_item('7F7589', 'Mobster'),
    get_item('7F76D3', 'Moody Blue'),
    get_item('7FFF00', 'Chartreuse'),
    get_item('7FFFD4', 'Aquamarine'),
    get_item('800000', 'Maroon'),
    get_item('800B47', 'Rose Bud Cherry'),
    get_item('801818', 'Falu Red'),
    get_item('80341F', 'Red Robin'),
    get_item('803790', 'Vivid Violet'),
    get_item('80461B', 'Russet'),
    get_item('807E79', 'Friar Gray'),
    get_item('808000', 'Olive'),
    get_item('808080', 'Gray'),
    get_item('80B3AE', 'Gulf Stream'),
    get_item('80B3C4', 'Glacier'),
    get_item('80CCEA', 'Seagull'),
    get_item('81422C', 'Nutmeg'),
    get_item('816E71', 'Spicy Pink'),
    get_item('817377', 'Empress'),
    get_item('819885', 'Spanish Green'),
    get_item('826F65', 'Sand Dune'),
    get_item('828685', 'Gunsmoke'),
    get_item('828F72', 'Battleship Gray'),
    get_item('831923', 'Merlot'),
    get_item('837050', 'Shadow'),
    get_item('83AA5D', 'Chelsea Cucumber'),
    get_item('83D0C6', 'Monte Carlo'),
    get_item('843179', 'Plum'),
    get_item('84A0A0', 'Granny Smith'),
    get_item('8581D9', 'Chetwode Blue'),
    get_item('858470', 'Bandicoot'),
    get_item('859FAF', 'Bali Hai'),
    get_item('85C4CC', 'Half Baked'),
    get_item('860111', 'Red Devil'),
    get_item('863C3C', 'Lotus'),
    get_item('86483C', 'Ironstone'),
    get_item('864D1E', 'Bull Shot'),
    get_item('86560A', 'Rusty Nail'),
    get_item('868974', 'Bitter'),
    get_item('86949F', 'Regent Gray'),
    get_item('871550', 'Disco'),
    get_item('87756E', 'Americano'),
    get_item('877C7B', 'Hurricane'),
    get_item('878D91', 'Oslo Gray'),
    get_item('87AB39', 'Sushi'),
    get_item('885342', 'Spicy Mix'),
    get_item('886221', 'Kumera'),
    get_item('888387', 'Suva Gray'),
    get_item('888D65', 'Avocado'),
    get_item('893456', 'Camelot'),
    get_item('893843', 'Solid Pink'),
    get_item('894367', 'Cannon Pink'),
    get_item('897D6D', 'Makara'),
    get_item('8A3324', 'Burnt Umber'),
    get_item('8A73D6', 'True V'),
    get_item('8A8360', 'Clay Creek'),
    get_item('8A8389', 'Monsoon'),
    get_item('8A8F8A', 'Stack'),
    get_item('8AB9F1', 'Jordy Blue'),
    get_item('8B00FF', 'Electric Violet'),
    get_item('8B0723', 'Monarch'),
    get_item('8B6B0B', 'Corn Harvest'),
    get_item('8B8470', 'Olive Haze'),
    get_item('8B847E', 'Schooner'),
    get_item('8B8680', 'Natural Gray'),
    get_item('8B9C90', 'Mantle'),
    get_item('8B9FEE', 'Portage'),
    get_item('8BA690', 'Envy'),
    get_item('8BA9A5', 'Cascade'),
    get_item('8BE6D8', 'Riptide'),
    get_item('8C055E', 'Cardinal Pink'),
    get_item('8C472F', 'Mule Fawn'),
    get_item('8C5738', 'Potters Clay'),
    get_item('8C6495', 'Trendy Pink'),
    get_item('8D0226', 'Paprika'),
    get_item('8D3D38', 'Sanguine Brown'),
    get_item('8D3F3F', 'Tosca'),
    get_item('8D7662', 'Cement'),
    get_item('8D8974', 'Granite Green'),
    get_item('8D90A1', 'Manatee'),
    get_item('8DA8CC', 'Polo Blue'),
    get_item('8E0000', 'Red Berry'),
    get_item('8E4D1E', 'Rope'),
    get_item('8E6F70', 'Opium'),
    get_item('8E775E', 'Domino'),
    get_item('8E8190', 'Mamba'),
    get_item('8EABC1', 'Nepal'),
    get_item('8F021C', 'Pohutukawa'),
    get_item('8F3E33', 'El Salva'),
    get_item('8F4B0E', 'Korma'),
    get_item('8F8176', 'Squirrel'),
    get_item('8FD6B4', 'Vista Blue'),
    get_item('900020', 'Burgundy'),
    get_item('901E1E', 'Old Brick'),
    get_item('907874', 'Hemp'),
    get_item('907B71', 'Almond Frost'),
    get_item('908D39', 'Sycamore'),
    get_item('92000A', 'Sangria'),
    get_item('924321', 'Cumin'),
    get_item('926F5B', 'Beaver'),
    get_item('928573', 'Stonewall'),
    get_item('928590', 'Venus'),
    get_item('9370DB', 'Medium Purple'),
    get_item('93CCEA', 'Cornflower'),
    get_item('93DFB8', 'Algae Green'),
    get_item('944747', 'Copper Rust'),
    get_item('948771', 'Arrowtown'),
    get_item('950015', 'Scarlett'),
    get_item('956387', 'Strikemaster'),
    get_item('959396', 'Mountain Mist'),
    get_item('960018', 'Carmine'),
    get_item('964B00', 'Brown'),
    get_item('967059', 'Leather'),
    get_item('9678B6', 'Purple Mountain\'s Majesty'),
    get_item('967BB6', 'Lavender Purple'),
    get_item('96A8A1', 'Pewter'),
    get_item('96BBAB', 'Summer Green'),
    get_item('97605D', 'Au Chico'),
    get_item('9771B5', 'Wisteria'),
    get_item('97CD2D', 'Atlantis'),
    get_item('983D61', 'Vin Rouge'),
    get_item('9874D3', 'Lilac Bush'),
    get_item('98777B', 'Bazaar'),
    get_item('98811B', 'Hacienda'),
    get_item('988D77', 'Pale Oyster'),
    get_item('98FF98', 'Mint Green'),
    get_item('990066', 'Fresh Eggplant'),
    get_item('991199', 'Violet Eggplant'),
    get_item('991613', 'Tamarillo'),
    get_item('991B07', 'Totem Pole'),
    get_item('996666', 'Copper Rose'),
    get_item('9966CC', 'Amethyst'),
    get_item('997A8D', 'Mountbatten Pink'),
    get_item('9999CC', 'Blue Bell'),
    get_item('9A3820', 'Prairie Sand'),
    get_item('9A6E61', 'Toast'),
    get_item('9A9577', 'Gurkha'),
    get_item('9AB973', 'Olivine'),
    get_item('9AC2B8', 'Shadow Green'),
    get_item('9B4703', 'Oregon'),
    get_item('9B9E8F', 'Lemon Grass'),
    get_item('9C3336', 'Stiletto'),
    get_item('9D5616', 'Hawaiian Tan'),
    get_item('9DACB7', 'Gull Gray'),
    get_item('9DC209', 'Pistachio'),
    get_item('9DE093', 'Granny Smith Apple'),
    get_item('9DE5FF', 'Anakiwa'),
    get_item('9E5302', 'Chelsea Gem'),
    get_item('9E5B40', 'Sepia Skin'),
    get_item('9EA587', 'Sage'),
    get_item('9EA91F', 'Citron'),
    get_item('9EB1CD', 'Rock Blue'),
    get_item('9EDEE0', 'Morning Glory'),
    get_item('9F381D', 'Cognac'),
    get_item('9F821C', 'Reef Gold'),
    get_item('9F9F9C', 'Star Dust'),
    get_item('9FA0B1', 'Santas Gray'),
    get_item('9FD7D3', 'Sinbad'),
    get_item('9FDD8C', 'Feijoa'),
    get_item('A02712', 'Tabasco'),
    get_item('A1750D', 'Buttered Rum'),
    get_item('A1ADB5', 'Hit Gray'),
    get_item('A1C50A', 'Citrus'),
    get_item('A1DAD7', 'Aqua Island'),
    get_item('A1E9DE', 'Water Leaf'),
    get_item('A2006D', 'Flirt'),
    get_item('A23B6C', 'Rouge'),
    get_item('A26645', 'Cape Palliser'),
    get_item('A2AAB3', 'Gray Chateau'),
    get_item('A2AEAB', 'Edward'),
    get_item('A3807B', 'Pharlap'),
    get_item('A397B4', 'Amethyst Smoke'),
    get_item('A3E3ED', 'Blizzard Blue'),
    get_item('A4A49D', 'Delta'),
    get_item('A4A6D3', 'Wistful'),
    get_item('A4AF6E', 'Green Smoke'),
    get_item('A50B5E', 'Jazzberry Jam'),
    get_item('A59B91', 'Zorba'),
    get_item('A5CB0C', 'Bahia'),
    get_item('A62F20', 'Roof Terracotta'),
    get_item('A65529', 'Paarl'),
    get_item('A68B5B', 'Barley Corn'),
    get_item('A69279', 'Donkey Brown'),
    get_item('A6A29A', 'Dawn'),
    get_item('A72525', 'Mexican Red'),
    get_item('A7882C', 'Luxor Gold'),
    get_item('A85307', 'Rich Gold'),
    get_item('A86515', 'Reno Sand'),
    get_item('A86B6B', 'Coral Tree'),
    get_item('A8989B', 'Dusty Gray'),
    get_item('A899E6', 'Dull Lavender'),
    get_item('A8A589', 'Tallow'),
    get_item('A8AE9C', 'Bud'),
    get_item('A8AF8E', 'Locust'),
    get_item('A8BD9F', 'Norway'),
    get_item('A8E3BD', 'Chinook'),
    get_item('A9A491', 'Gray Olive'),
    get_item('A9ACB6', 'Aluminium'),
    get_item('A9B2C3', 'Cadet Blue'),
    get_item('A9B497', 'Schist'),
    get_item('A9BDBF', 'Tower Gray'),
    get_item('A9BEF2', 'Perano'),
    get_item('A9C6C2', 'Opal'),
    get_item('AA375A', 'Night Shadz'),
    get_item('AA4203', 'Fire'),
    get_item('AA8B5B', 'Muesli'),
    get_item('AA8D6F', 'Sandal'),
    get_item('AAA5A9', 'Shady Lady'),
    get_item('AAA9CD', 'Logan'),
    get_item('AAABB7', 'Spun Pearl'),
    get_item('AAD6E6', 'Regent St Blue'),
    get_item('AAF0D1', 'Magic Mint'),
    get_item('AB0563', 'Lipstick'),
    get_item('AB3472', 'Royal Heath'),
    get_item('AB917A', 'Sandrift'),
    get_item('ABA0D9', 'Cold Purple'),
    get_item('ABA196', 'Bronco'),
    get_item('AC8A56', 'Limed Oak'),
    get_item('AC91CE', 'East Side'),
    get_item('AC9E22', 'Lemon Ginger'),
    get_item('ACA494', 'Napa'),
    get_item('ACA586', 'Hillary'),
    get_item('ACA59F', 'Cloudy'),
    get_item('ACACAC', 'Silver Chalice'),
    get_item('ACB78E', 'Swamp Green'),
    get_item('ACCBB1', 'Spring Rain'),
    get_item('ACDD4D', 'Conifer'),
    get_item('ACE1AF', 'Celadon'),
    get_item('AD781B', 'Mandalay'),
    get_item('ADBED1', 'Casper'),
    get_item('ADDFAD', 'Moss Green'),
    get_item('ADE6C4', 'Padua'),
    get_item('ADFF2F', 'Green Yellow'),
    get_item('AE4560', 'Hippie Pink'),
    get_item('AE6020', 'Desert'),
    get_item('AE809E', 'Bouquet'),
    get_item('AF4035', 'Medium Carmine'),
    get_item('AF4D43', 'Apple Blossom'),
    get_item('AF593E', 'Brown Rust'),
    get_item('AF8751', 'Driftwood'),
    get_item('AF8F2C', 'Alpine'),
    get_item('AF9F1C', 'Lucky'),
    get_item('AFA09E', 'Martini'),
    get_item('AFB1B8', 'Bombay'),
    get_item('AFBDD9', 'Pigeon Post'),
    get_item('B04C6A', 'Cadillac'),
    get_item('B05D54', 'Matrix'),
    get_item('B05E81', 'Tapestry'),
    get_item('B06608', 'Mai Tai'),
    get_item('B09A95', 'Del Rio'),
    get_item('B0E0E6', 'Powder Blue'),
    get_item('B0E313', 'Inch Worm'),
    get_item('B10000', 'Bright Red'),
    get_item('B14A0B', 'Vesuvius'),
    get_item('B1610B', 'Pumpkin Skin'),
    get_item('B16D52', 'Santa Fe'),
    get_item('B19461', 'Teak'),
    get_item('B1E2C1', 'Fringy Flower'),
    get_item('B1F4E7', 'Ice Cold'),
    get_item('B20931', 'Shiraz'),
    get_item('B2A1EA', 'Biloba Flower'),
    get_item('B32D29', 'Tall Poppy'),
    get_item('B35213', 'Fiery Orange'),
    get_item('B38007', 'Hot Toddy'),
    get_item('B3AF95', 'Taupe Gray'),
    get_item('B3C110', 'La Rioja'),
    get_item('B43332', 'Well Read'),
    get_item('B44668', 'Blush'),
    get_item('B4CFD3', 'Jungle Mist'),
    get_item('B57281', 'Turkish Rose'),
    get_item('B57EDC', 'Lavender'),
    get_item('B5A27F', 'Mongoose'),
    get_item('B5B35C', 'Olive Green'),
    get_item('B5D2CE', 'Jet Stream'),
    get_item('B5ECDF', 'Cruise'),
    get_item('B6316C', 'Hibiscus'),
    get_item('B69D98', 'Thatch'),
    get_item('B6B095', 'Heathered Gray'),
    get_item('B6BAA4', 'Eagle'),
    get_item('B6D1EA', 'Spindle'),
    get_item('B6D3BF', 'Gum Leaf'),
    get_item('B7410E', 'Rust'),
    get_item('B78E5C', 'Muddy Waters'),
    get_item('B7A214', 'Sahara'),
    get_item('B7A458', 'Husk'),
    get_item('B7B1B1', 'Nobel'),
    get_item('B7C3D0', 'Heather'),
    get_item('B7F0BE', 'Madang'),
    get_item('B81104', 'Milano Red'),
    get_item('B87333', 'Copper'),
    get_item('B8B56A', 'Gimblet'),
    get_item('B8C1B1', 'Green Spring'),
    get_item('B8C25D', 'Celery'),
    get_item('B8E0F9', 'Sail'),
    get_item('B94E48', 'Chestnut'),
    get_item('B95140', 'Crail'),
    get_item('B98D28', 'Marigold'),
    get_item('B9C46A', 'Wild Willow'),
    get_item('B9C8AC', 'Rainee'),
    get_item('BA0101', 'Guardsman Red'),
    get_item('BA450C', 'Rock Spray'),
    get_item('BA6F1E', 'Bourbon'),
    get_item('BA7F03', 'Pirate Gold'),
    get_item('BAB1A2', 'Nomad'),
    get_item('BAC7C9', 'Submarine'),
    get_item('BAEEF9', 'Charlotte'),
    get_item('BB3385', 'Medium Red Violet'),
    get_item('BB8983', 'Brandy Rose'),
    get_item('BBD009', 'Rio Grande'),
    get_item('BBD7C1', 'Surf'),
    get_item('BCC9C2', 'Powder Ash'),
    get_item('BD5E2E', 'Tuscany'),
    get_item('BD978E', 'Quicksand'),
    get_item('BDB1A8', 'Silk'),
    get_item('BDB2A1', 'Malta'),
    get_item('BDB3C7', 'Chatelle'),
    get_item('BDBBD7', 'Lavender Gray'),
    get_item('BDBDC6', 'French Gray'),
    get_item('BDC8B3', 'Clay Ash'),
    get_item('BDC9CE', 'Loblolly'),
    get_item('BDEDFD', 'French Pass'),
    get_item('BEA6C3', 'London Hue'),
    get_item('BEB5B7', 'Pink Swan'),
    get_item('BEDE0D', 'Fuego'),
    get_item('BF5500', 'Rose of Sharon'),
    get_item('BFB8B0', 'Tide'),
    get_item('BFBED8', 'Blue Haze'),
    get_item('BFC1C2', 'Silver Sand'),
    get_item('BFC921', 'Key Lime Pie'),
    get_item('BFDBE2', 'Ziggurat'),
    get_item('BFFF00', 'Lime'),
    get_item('C02B18', 'Thunderbird'),
    get_item('C04737', 'Mojo'),
    get_item('C08081', 'Old Rose'),
    get_item('C0C0C0', 'Silver'),
    get_item('C0D3B9', 'Pale Leaf'),
    get_item('C0D8B6', 'Pixie Green'),
    get_item('C1440E', 'Tia Maria'),
    get_item('C154C1', 'Fuchsia Pink'),
    get_item('C1A004', 'Buddha Gold'),
    get_item('C1B7A4', 'Bison Hide'),
    get_item('C1BAB0', 'Tea'),
    get_item('C1BECD', 'Gray Suit'),
    get_item('C1D7B0', 'Sprout'),
    get_item('C1F07C', 'Sulu'),
    get_item('C26B03', 'Indochine'),
    get_item('C2955D', 'Twine'),
    get_item('C2BDB6', 'Cotton Seed'),
    get_item('C2CAC4', 'Pumice'),
    get_item('C2E8E5', 'Jagged Ice'),
    get_item('C32148', 'Maroon Flush'),
    get_item('C3B091', 'Indian Khaki'),
    get_item('C3BFC1', 'Pale Slate'),
    get_item('C3C3BD', 'Gray Nickel'),
    get_item('C3CDE6', 'Periwinkle Gray'),
    get_item('C3D1D1', 'Tiara'),
    get_item('C3DDF9', 'Tropical Blue'),
    get_item('C41E3A', 'Cardinal'),
    get_item('C45655', 'Fuzzy Wuzzy Brown'),
    get_item('C45719', 'Orange Roughy'),
    get_item('C4C4BC', 'Mist Gray'),
    get_item('C4D0B0', 'Coriander'),
    get_item('C4F4EB', 'Mint Tulip'),
    get_item('C54B8C', 'Mulberry'),
    get_item('C59922', 'Nugget'),
    get_item('C5994B', 'Tussock'),
    get_item('C5DBCA', 'Sea Mist'),
    get_item('C5E17A', 'Yellow Green'),
    get_item('C62D42', 'Brick Red'),
    get_item('C6726B', 'Contessa'),
    get_item('C69191', 'Oriental Pink'),
    get_item('C6A84B', 'Roti'),
    get_item('C6C3B5', 'Ash'),
    get_item('C6C8BD', 'Kangaroo'),
    get_item('C6E610', 'Las Palmas'),
    get_item('C7031E', 'Monza'),
    get_item('C71585', 'Red Violet'),
    get_item('C7BCA2', 'Coral Reef'),
    get_item('C7C1FF', 'Melrose'),
    get_item('C7C4BF', 'Cloud'),
    get_item('C7C9D5', 'Ghost'),
    get_item('C7CD90', 'Pine Glade'),
    get_item('C7DDE5', 'Botticelli'),
    get_item('C88A65', 'Antique Brass'),
    get_item('C8A2C8', 'Lilac'),
    get_item('C8A528', 'Hokey Pokey'),
    get_item('C8AABF', 'Lily'),
    get_item('C8B568', 'Laser'),
    get_item('C8E3D7', 'Edgewater'),
    get_item('C96323', 'Piper'),
    get_item('C99415', 'Pizza'),
    get_item('C9A0DC', 'Light Wisteria'),
    get_item('C9B29B', 'Rodeo Dust'),
    get_item('C9B35B', 'Sundance'),
    get_item('C9B93B', 'Earls Green'),
    get_item('C9C0BB', 'Silver Rust'),
    get_item('C9D9D2', 'Conch'),
    get_item('C9FFA2', 'Reef'),
    get_item('C9FFE5', 'Aero Blue'),
    get_item('CA3435', 'Flush Mahogany'),
    get_item('CABB48', 'Turmeric'),
    get_item('CADCD4', 'Paris White'),
    get_item('CAE00D', 'Bitter Lemon'),
    get_item('CAE6DA', 'Skeptic'),
    get_item('CB8FA9', 'Viola'),
    get_item('CBCAB6', 'Foggy Gray'),
    get_item('CBD3B0', 'Green Mist'),
    get_item('CBDBD6', 'Nebula'),
    get_item('CC3333', 'Persian Red'),
    get_item('CC5500', 'Burnt Orange'),
    get_item('CC7722', 'Ochre'),
    get_item('CC8899', 'Puce'),
    get_item('CCCAA8', 'Thistle Green'),
    get_item('CCCCFF', 'Periwinkle'),
    get_item('CCFF00', 'Electric Lime'),
    get_item('CD5700', 'Tenn'),
    get_item('CD5C5C', 'Chestnut Rose'),
    get_item('CD8429', 'Brandy Punch'),
    get_item('CDF4FF', 'Onahau'),
    get_item('CEB98F', 'Sorrell Brown'),
    get_item('CEBABA', 'Cold Turkey'),
    get_item('CEC291', 'Yuma'),
    get_item('CEC7A7', 'Chino'),
    get_item('CFA39D', 'Eunry'),
    get_item('CFB53B', 'Old Gold'),
    get_item('CFDCCF', 'Tasman'),
    get_item('CFE5D2', 'Surf Crest'),
    get_item('CFF9F3', 'Humming Bird'),
    get_item('CFFAF4', 'Scandal'),
    get_item('D05F04', 'Red Stage'),
    get_item('D06DA1', 'Hopbush'),
    get_item('D07D12', 'Meteor'),
    get_item('D0BEF8', 'Perfume'),
    get_item('D0C0E5', 'Prelude'),
    get_item('D0F0C0', 'Tea Green'),
    get_item('D18F1B', 'Geebung'),
    get_item('D1BEA8', 'Vanilla'),
    get_item('D1C6B4', 'Soft Amber'),
    get_item('D1D2CA', 'Celeste'),
    get_item('D1D2DD', 'Mischka'),
    get_item('D1E231', 'Pear'),
    get_item('D2691E', 'Hot Cinnamon'),
    get_item('D27D46', 'Raw Sienna'),
    get_item('D29EAA', 'Careys Pink'),
    get_item('D2B48C', 'Tan'),
    get_item('D2DA97', 'Deco'),
    get_item('D2F6DE', 'Blue Romance'),
    get_item('D2F8B0', 'Gossip'),
    get_item('D3CBBA', 'Sisal'),
    get_item('D3CDC5', 'Swirl'),
    get_item('D47494', 'Charm'),
    get_item('D4B6AF', 'Clam Shell'),
    get_item('D4BF8D', 'Straw'),
    get_item('D4C4A8', 'Akaroa'),
    get_item('D4CD16', 'Bird Flower'),
    get_item('D4D7D9', 'Iron'),
    get_item('D4DFE2', 'Geyser'),
    get_item('D4E2FC', 'Hawkes Blue'),
    get_item('D54600', 'Grenadier'),
    get_item('D591A4', 'Can Can'),
    get_item('D59A6F', 'Whiskey'),
    get_item('D5D195', 'Winter Hazel'),
    get_item('D5F6E3', 'Granny Apple'),
    get_item('D69188', 'My Pink'),
    get_item('D6C562', 'Tacha'),
    get_item('D6CEF6', 'Moon Raker'),
    get_item('D6D6D1', 'Quill Gray'),
    get_item('D6FFDB', 'Snowy Mint'),
    get_item('D7837F', 'New York Pink'),
    get_item('D7C498', 'Pavlova'),
    get_item('D7D0FF', 'Fog'),
    get_item('D84437', 'Valencia'),
    get_item('D87C63', 'Japonica'),
    get_item('D8BFD8', 'Thistle'),
    get_item('D8C2D5', 'Maverick'),
    get_item('D8FCFA', 'Foam'),
    get_item('D94972', 'Cabaret'),
    get_item('D99376', 'Burning Sand'),
    get_item('D9B99B', 'Cameo'),
    get_item('D9D6CF', 'Timberwolf'),
    get_item('D9DCC1', 'Tana'),
    get_item('D9E4F5', 'Link Water'),
    get_item('D9F7FF', 'Mabel'),
    get_item('DA3287', 'Cerise'),
    get_item('DA5B38', 'Flame Pea'),
    get_item('DA6304', 'Bamboo'),
    get_item('DA6A41', 'Red Damask'),
    get_item('DA70D6', 'Orchid'),
    get_item('DA8A67', 'Copperfield'),
    get_item('DAA520', 'Golden Grass'),
    get_item('DAECD6', 'Zanah'),
    get_item('DAF4F0', 'Iceberg'),
    get_item('DAFAFF', 'Oyster Bay'),
    get_item('DB5079', 'Cranberry'),
    get_item('DB9690', 'Petite Orchid'),
    get_item('DB995E', 'Di Serria'),
    get_item('DBDBDB', 'Alto'),
    get_item('DBFFF8', 'Frosted Mint'),
    get_item('DC143C', 'Crimson'),
    get_item('DC4333', 'Punch'),
    get_item('DCB20C', 'Galliano'),
    get_item('DCB4BC', 'Blossom'),
    get_item('DCD747', 'Wattle'),
    get_item('DCD9D2', 'Westar'),
    get_item('DCDDCC', 'Moon Mist'),
    get_item('DCEDB4', 'Caper'),
    get_item('DCF0EA', 'Swans Down'),
    get_item('DDD6D5', 'Swiss Coffee'),
    get_item('DDF9F1', 'White Ice'),
    get_item('DE3163', 'Cerise Red'),
    get_item('DE6360', 'Roman'),
    get_item('DEA681', 'Tumbleweed'),
    get_item('DEBA13', 'Gold Tips'),
    get_item('DEC196', 'Brandy'),
    get_item('DECBC6', 'Wafer'),
    get_item('DED4A4', 'Sapling'),
    get_item('DED717', 'Barberry'),
    get_item('DEE5C0', 'Beryl Green'),
    get_item('DEF5FF', 'Pattens Blue'),
    get_item('DF73FF', 'Heliotrope'),
    get_item('DFBE6F', 'Apache'),
    get_item('DFCD6F', 'Chenin'),
    get_item('DFCFDB', 'Lola'),
    get_item('DFECDA', 'Willow Brook'),
    get_item('DFFF00', 'Chartreuse Yellow'),
    get_item('E0B0FF', 'Mauve'),
    get_item('E0B646', 'Anzac'),
    get_item('E0B974', 'Harvest Gold'),
    get_item('E0C095', 'Calico'),
    get_item('E0FFFF', 'Baby Blue'),
    get_item('E16865', 'Sunglo'),
    get_item('E1BC64', 'Equator'),
    get_item('E1C0C8', 'Pink Flare'),
    get_item('E1E6D6', 'Periglacial Blue'),
    get_item('E1EAD4', 'Kidnapper'),
    get_item('E1F6E8', 'Tara'),
    get_item('E25465', 'Mandy'),
    get_item('E2725B', 'Terracotta'),
    get_item('E28913', 'Golden Bell'),
    get_item('E292C0', 'Shocking'),
    get_item('E29418', 'Dixie'),
    get_item('E29CD2', 'Light Orchid'),
    get_item('E2D8ED', 'Snuff'),
    get_item('E2EBED', 'Mystic'),
    get_item('E2F3EC', 'Apple Green'),
    get_item('E30B5C', 'Razzmatazz'),
    get_item('E32636', 'Alizarin Crimson'),
    get_item('E34234', 'Cinnabar'),
    get_item('E3BEBE', 'Cavern Pink'),
    get_item('E3F5E1', 'Peppermint'),
    get_item('E3F988', 'Mindaro'),
    get_item('E47698', 'Deep Blush'),
    get_item('E49B0F', 'Gamboge'),
    get_item('E4C2D5', 'Melanie'),
    get_item('E4CFDE', 'Twilight'),
    get_item('E4D1C0', 'Bone'),
    get_item('E4D422', 'Sunflower'),
    get_item('E4D5B7', 'Grain Brown'),
    get_item('E4D69B', 'Zombie'),
    get_item('E4F6E7', 'Frostee'),
    get_item('E4FFD1', 'Snow Flurry'),
    get_item('E52B50', 'Amaranth'),
    get_item('E5841B', 'Zest'),
    get_item('E5CCC9', 'Dust Storm'),
    get_item('E5D7BD', 'Stark White'),
    get_item('E5D8AF', 'Hampton'),
    get_item('E5E0E1', 'Bon Jour'),
    get_item('E5E5E5', 'Mercury'),
    get_item('E5F9F6', 'Polar'),
    get_item('E64E03', 'Trinidad'),
    get_item('E6BE8A', 'Gold Sand'),
    get_item('E6BEA5', 'Cashmere'),
    get_item('E6D7B9', 'Double Spanish White'),
    get_item('E6E4D4', 'Satin Linen'),
    get_item('E6F2EA', 'Harp'),
    get_item('E6F8F3', 'Off Green'),
    get_item('E6FFE9', 'Hint of Green'),
    get_item('E6FFFF', 'Tranquil'),
    get_item('E77200', 'Mango Tango'),
    get_item('E7730A', 'Christine'),
    get_item('E79F8C', 'Tonys Pink'),
    get_item('E79FC4', 'Kobi'),
    get_item('E7BCB4', 'Rose Fog'),
    get_item('E7BF05', 'Corn'),
    get_item('E7CD8C', 'Putty'),
    get_item('E7ECE6', 'Gray Nurse'),
    get_item('E7F8FF', 'Lily White'),
    get_item('E7FEFF', 'Bubbles'),
    get_item('E89928', 'Fire Bush'),
    get_item('E8B9B3', 'Shilo'),
    get_item('E8E0D5', 'Pearl Bush'),
    get_item('E8EBE0', 'Green White'),
    get_item('E8F1D4', 'Chrome White'),
    get_item('E8F2EB', 'Gin'),
    get_item('E8F5F2', 'Aqua Squeeze'),
    get_item('E96E00', 'Clementine'),
    get_item('E97451', 'Burnt Sienna'),
    get_item('E97C07', 'Tahiti Gold'),
    get_item('E9CECD', 'Oyster Pink'),
    get_item('E9D75A', 'Confetti'),
    get_item('E9E3E3', 'Ebb'),
    get_item('E9F8ED', 'Ottoman'),
    get_item('E9FFFD', 'Clear Day'),
    get_item('EA88A8', 'Carissma'),
    get_item('EAAE69', 'Porsche'),
    get_item('EAB33B', 'Tulip Tree'),
    get_item('EAC674', 'Rob Roy'),
    get_item('EADAB8', 'Raffia'),
    get_item('EAE8D4', 'White Rock'),
    get_item('EAF6EE', 'Panache'),
    get_item('EAF6FF', 'Solitude'),
    get_item('EAF9F5', 'Aqua Spring'),
    get_item('EAFFFE', 'Dew'),
    get_item('EB9373', 'Apricot'),
    get_item('EBC2AF', 'Zinnwaldite'),
    get_item('ECA927', 'Fuel Yellow'),
    get_item('ECC54E', 'Ronchi'),
    get_item('ECC7EE', 'French Lilac'),
    get_item('ECCDB9', 'Just Right'),
    get_item('ECE090', 'Wild Rice'),
    get_item('ECEBBD', 'Fall Green'),
    get_item('ECEBCE', 'Aths Special'),
    get_item('ECF245', 'Starship'),
    get_item('ED0A3F', 'Red Ribbon'),
    get_item('ED7A1C', 'Tango'),
    get_item('ED9121', 'Carrot Orange'),
    get_item('ED989E', 'Sea Pink'),
    get_item('EDB381', 'Tacao'),
    get_item('EDC9AF', 'Desert Sand'),
    get_item('EDCDAB', 'Pancho'),
    get_item('EDDCB1', 'Chamois'),
    get_item('EDEA99', 'Primrose'),
    get_item('EDF5DD', 'Frost'),
    get_item('EDF5F5', 'Aqua Haze'),
    get_item('EDF6FF', 'Zumthor'),
    get_item('EDF9F1', 'Narvik'),
    get_item('EDFC84', 'Honeysuckle'),
    get_item('EE82EE', 'Lavender Magenta'),
    get_item('EEC1BE', 'Beauty Bush'),
    get_item('EED794', 'Chalky'),
    get_item('EED9C4', 'Almond'),
    get_item('EEDC82', 'Flax'),
    get_item('EEDEDA', 'Bizarre'),
    get_item('EEE3AD', 'Double Colonial White'),
    get_item('EEEEE8', 'Cararra'),
    get_item('EEEF78', 'Manz'),
    get_item('EEF0C8', 'Tahuna Sands'),
    get_item('EEF0F3', 'Athens Gray'),
    get_item('EEF3C3', 'Tusk'),
    get_item('EEF4DE', 'Loafer'),
    get_item('EEF6F7', 'Catskill White'),
    get_item('EEFDFF', 'Twilight Blue'),
    get_item('EEFF9A', 'Jonquil'),
    get_item('EEFFE2', 'Rice Flower'),
    get_item('EF863F', 'Jaffa'),
    get_item('EFEFEF', 'Gallery'),
    get_item('EFF2F3', 'Porcelain'),
    get_item('F091A9', 'Mauvelous'),
    get_item('F0D52D', 'Golden Dream'),
    get_item('F0DB7D', 'Golden Sand'),
    get_item('F0DC82', 'Buff'),
    get_item('F0E2EC', 'Prim'),
    get_item('F0E68C', 'Khaki'),
    get_item('F0EEFD', 'Selago'),
    get_item('F0EEFF', 'Titan White'),
    get_item('F0F8FF', 'Alice Blue'),
    get_item('F0FCEA', 'Feta'),
    get_item('F18200', 'Gold Drop'),
    get_item('F19BAB', 'Wewak'),
    get_item('F1E788', 'Sahara Sand'),
    get_item('F1E9D2', 'Parchment'),
    get_item('F1E9FF', 'Blue Chalk'),
    get_item('F1EEC1', 'Mint Julep'),
    get_item('F1F1F1', 'Seashell'),
    get_item('F1F7F2', 'Saltpan'),
    get_item('F1FFAD', 'Tidal'),
    get_item('F1FFC8', 'Chiffon'),
    get_item('F2552A', 'Flamingo'),
    get_item('F28500', 'Tangerine'),
    get_item('F2C3B2', 'Mandys Pink'),
    get_item('F2F2F2', 'Concrete'),
    get_item('F2FAFA', 'Black Squeeze'),
    get_item('F34723', 'Pomegranate'),
    get_item('F3AD16', 'Buttercup'),
    get_item('F3D69D', 'New Orleans'),
    get_item('F3D9DF', 'Vanilla Ice'),
    get_item('F3E7BB', 'Sidecar'),
    get_item('F3E9E5', 'Dawn Pink'),
    get_item('F3EDCF', 'Wheatfield'),
    get_item('F3FB62', 'Canary'),
    get_item('F3FBD4', 'Orinoco'),
    get_item('F3FFD8', 'Carla'),
    get_item('F400A1', 'Hollywood Cerise'),
    get_item('F4A460', 'Sandy brown'),
    get_item('F4C430', 'Saffron'),
    get_item('F4D81C', 'Ripe Lemon'),
    get_item('F4EBD3', 'Janna'),
    get_item('F4F2EE', 'Pampas'),
    get_item('F4F4F4', 'Wild Sand'),
    get_item('F4F8FF', 'Zircon'),
    get_item('F57584', 'Froly'),
    get_item('F5C85C', 'Cream Can'),
    get_item('F5C999', 'Manhattan'),
    get_item('F5D5A0', 'Maize'),
    get_item('F5DEB3', 'Wheat'),
    get_item('F5E7A2', 'Sandwisp'),
    get_item('F5E7E2', 'Pot Pourri'),
    get_item('F5E9D3', 'Albescent White'),
    get_item('F5EDEF', 'Soft Peach'),
    get_item('F5F3E5', 'Ecru White'),
    get_item('F5F5DC', 'Beige'),
    get_item('F5FB3D', 'Golden Fizz'),
    get_item('F5FFBE', 'Australian Mint'),
    get_item('F64A8A', 'French Rose'),
    get_item('F653A6', 'Brilliant Rose'),
    get_item('F6A4C9', 'Illusion'),
    get_item('F6F0E6', 'Merino'),
    get_item('F6F7F7', 'Black Haze'),
    get_item('F6FFDC', 'Spring Sun'),
    get_item('F7468A', 'Violet Red'),
    get_item('F77703', 'Chilean Fire'),
    get_item('F77FBE', 'Persian Pink'),
    get_item('F7B668', 'Rajah'),
    get_item('F7C8DA', 'Azalea'),
    get_item('F7DBE6', 'We Peep'),
    get_item('F7F2E1', 'Quarter Spanish White'),
    get_item('F7F5FA', 'Whisper'),
    get_item('F7FAF7', 'Snow Drift'),
    get_item('F8B853', 'Casablanca'),
    get_item('F8C3DF', 'Chantilly'),
    get_item('F8D9E9', 'Cherub'),
    get_item('F8DB9D', 'Marzipan'),
    get_item('F8DD5C', 'Energy Yellow'),
    get_item('F8E4BF', 'Givry'),
    get_item('F8F0E8', 'White Linen'),
    get_item('F8F4FF', 'Magnolia'),
    get_item('F8F6F1', 'Spring Wood'),
    get_item('F8F7DC', 'Coconut Cream'),
    get_item('F8F7FC', 'White Lilac'),
    get_item('F8F8F7', 'Desert Storm'),
    get_item('F8F99C', 'Texas'),
    get_item('F8FACD', 'Corn Field'),
    get_item('F8FDD3', 'Mimosa'),
    get_item('F95A61', 'Carnation'),
    get_item('F9BF58', 'Saffron Mango'),
    get_item('F9E0ED', 'Carousel Pink'),
    get_item('F9E4BC', 'Dairy Cream'),
    get_item('F9E663', 'Portica'),
    get_item('F9EAF3', 'Amour'),
    get_item('F9F8E4', 'Rum Swizzle'),
    get_item('F9FF8B', 'Dolly'),
    get_item('F9FFF6', 'Sugar Cane'),
    get_item('FA7814', 'Ecstasy'),
    get_item('FA9D5A', 'Tan Hide'),
    get_item('FAD3A2', 'Corvette'),
    get_item('FADFAD', 'Peach Yellow'),
    get_item('FAE600', 'Turbo'),
    get_item('FAEAB9', 'Astra'),
    get_item('FAECCC', 'Champagne'),
    get_item('FAF0E6', 'Linen'),
    get_item('FAF3F0', 'Fantasy'),
    get_item('FAF7D6', 'Citrine White'),
    get_item('FAFAFA', 'Alabaster'),
    get_item('FAFDE4', 'Hint of Yellow'),
    get_item('FAFFA4', 'Milan'),
    get_item('FB607F', 'Brink Pink'),
    get_item('FB8989', 'Geraldine'),
    get_item('FBA0E3', 'Lavender Rose'),
    get_item('FBA129', 'Sea Buckthorn'),
    get_item('FBAC13', 'Sun'),
    get_item('FBAED2', 'Lavender Pink'),
    get_item('FBB2A3', 'Rose Bud'),
    get_item('FBBEDA', 'Cupid'),
    get_item('FBCCE7', 'Classic Rose'),
    get_item('FBCEB1', 'Apricot Peach'),
    get_item('FBE7B2', 'Banana Mania'),
    get_item('FBE870', 'Marigold Yellow'),
    get_item('FBE96C', 'Festival'),
    get_item('FBEA8C', 'Sweet Corn'),
    get_item('FBEC5D', 'Candy Corn'),
    get_item('FBF9F9', 'Hint of Red'),
    get_item('FBFFBA', 'Shalimar'),
    get_item('FC0FC0', 'Shocking Pink'),
    get_item('FC80A5', 'Tickle Me Pink'),
    get_item('FC9C1D', 'Tree Poppy'),
    get_item('FCC01E', 'Lightning Yellow'),
    get_item('FCD667', 'Goldenrod'),
    get_item('FCD917', 'Candlelight'),
    get_item('FCDA98', 'Cherokee'),
    get_item('FCF4D0', 'Double Pearl Lusta'),
    get_item('FCF4DC', 'Pearl Lusta'),
    get_item('FCF8F7', 'Vista White'),
    get_item('FCFBF3', 'Bianca'),
    get_item('FCFEDA', 'Moon Glow'),
    get_item('FCFFE7', 'China Ivory'),
    get_item('FCFFF9', 'Ceramic'),
    get_item('FD0E35', 'Torch Red'),
    get_item('FD5B78', 'Wild Watermelon'),
    get_item('FD7B33', 'Crusta'),
    get_item('FD7C07', 'Sorbus'),
    get_item('FD9FA2', 'Sweet Pink'),
    get_item('FDD5B1', 'Light Apricot'),
    get_item('FDD7E4', 'Pig Pink'),
    get_item('FDE1DC', 'Cinderella'),
    get_item('FDE295', 'Golden Glow'),
    get_item('FDE910', 'Lemon'),
    get_item('FDF5E6', 'Old Lace'),
    get_item('FDF6D3', 'Half Colonial White'),
    get_item('FDF7AD', 'Drover'),
    get_item('FDFEB8', 'Pale Prim'),
    get_item('FDFFD5', 'Cumulus'),
    get_item('FE28A2', 'Persian Rose'),
    get_item('FE4C40', 'Sunset Orange'),
    get_item('FE6F5E', 'Bittersweet'),
    get_item('FE9D04', 'California'),
    get_item('FEA904', 'Yellow Sea'),
    get_item('FEBAAD', 'Melon'),
    get_item('FED33C', 'Bright Sun'),
    get_item('FED85D', 'Dandelion'),
    get_item('FEDB8D', 'Salomie'),
    get_item('FEE5AC', 'Cape Honey'),
    get_item('FEEBF3', 'Remy'),
    get_item('FEEFCE', 'Oasis'),
    get_item('FEF0EC', 'Bridesmaid'),
    get_item('FEF2C7', 'Beeswax'),
    get_item('FEF3D8', 'Bleach White'),
    get_item('FEF4CC', 'Pipi'),
    get_item('FEF4DB', 'Half Spanish White'),
    get_item('FEF4F8', 'Wisp Pink'),
    get_item('FEF5F1', 'Provincial Pink'),
    get_item('FEF7DE', 'Half Dutch White'),
    get_item('FEF8E2', 'Solitaire'),
    get_item('FEF8FF', 'White Pointer'),
    get_item('FEF9E3', 'Off Yellow'),
    get_item('FEFCED', 'Orange White'),
    get_item('FF0000', 'Red'),
    get_item('FF007F', 'Rose'),
    get_item('FF00CC', 'Purple Pizzazz'),
    get_item('FF00FF', 'Magenta / Fuchsia'),
    get_item('FF2400', 'Scarlet'),
    get_item('FF3399', 'Wild Strawberry'),
    get_item('FF33CC', 'Razzle Dazzle Rose'),
    get_item('FF355E', 'Radical Red'),
    get_item('FF3F34', 'Red Orange'),
    get_item('FF4040', 'Coral Red'),
    get_item('FF4D00', 'Vermilion'),
    get_item('FF4F00', 'International Orange'),
    get_item('FF6037', 'Outrageous Orange'),
    get_item('FF6600', 'Blaze Orange'),
    get_item('FF66FF', 'Pink Flamingo'),
    get_item('FF681F', 'Orange'),
    get_item('FF69B4', 'Hot Pink'),
    get_item('FF6B53', 'Persimmon'),
    get_item('FF6FFF', 'Blush Pink'),
    get_item('FF7034', 'Burning Orange'),
    get_item('FF7518', 'Pumpkin'),
    get_item('FF7D07', 'Flamenco'),
    get_item('FF7F00', 'Flush Orange'),
    get_item('FF7F50', 'Coral'),
    get_item('FF8C69', 'Salmon'),
    get_item('FF9000', 'Pizazz'),
    get_item('FF910F', 'West Side'),
    get_item('FF91A4', 'Pink Salmon'),
    get_item('FF9933', 'Neon Carrot'),
    get_item('FF9966', 'Atomic Tangerine'),
    get_item('FF9980', 'Vivid Tangerine'),
    get_item('FF9E2C', 'Sunshade'),
    get_item('FFA000', 'Orange Peel'),
    get_item('FFA194', 'Mona Lisa'),
    get_item('FFA500', 'Web Orange'),
    get_item('FFA6C9', 'Carnation Pink'),
    get_item('FFAB81', 'Hit Pink'),
    get_item('FFAE42', 'Yellow Orange'),
    get_item('FFB0AC', 'Cornflower Lilac'),
    get_item('FFB1B3', 'Sundown'),
    get_item('FFB31F', 'My Sin'),
    get_item('FFB555', 'Texas Rose'),
    get_item('FFB7D5', 'Cotton Candy'),
    get_item('FFB97B', 'Macaroni and Cheese'),
    get_item('FFBA00', 'Selective Yellow'),
    get_item('FFBD5F', 'Koromiko'),
    get_item('FFBF00', 'Amber'),
    get_item('FFC0A8', 'Wax Flower'),
    get_item('FFC0CB', 'Pink'),
    get_item('FFC3C0', 'Your Pink'),
    get_item('FFC901', 'Supernova'),
    get_item('FFCBA4', 'Flesh'),
    get_item('FFCC33', 'Sunglow'),
    get_item('FFCC5C', 'Golden Tainoi'),
    get_item('FFCC99', 'Peach Orange'),
    get_item('FFCD8C', 'Chardonnay'),
    get_item('FFD1DC', 'Pastel Pink'),
    get_item('FFD2B7', 'Romantic'),
    get_item('FFD38C', 'Grandis'),
    get_item('FFD700', 'Gold'),
    get_item('FFD800', 'School bus Yellow'),
    get_item('FFD8D9', 'Cosmos'),
    get_item('FFDB58', 'Mustard'),
    get_item('FFDCD6', 'Peach Schnapps'),
    get_item('FFDDAF', 'Caramel'),
    get_item('FFDDCD', 'Tuft Bush'),
    get_item('FFDDCF', 'Watusi'),
    get_item('FFDDF4', 'Pink Lace'),
    get_item('FFDEAD', 'Navajo White'),
    get_item('FFDEB3', 'Frangipani'),
    get_item('FFE1DF', 'Pippin'),
    get_item('FFE1F2', 'Pale Rose'),
    get_item('FFE2C5', 'Negroni'),
    get_item('FFE5A0', 'Cream Brulee'),
    get_item('FFE5B4', 'Peach'),
    get_item('FFE6C7', 'Tequila'),
    get_item('FFE772', 'Kournikova'),
    get_item('FFEAC8', 'Sandy Beach'),
    get_item('FFEAD4', 'Karry'),
    get_item('FFEC13', 'Broom'),
    get_item('FFEDBC', 'Colonial White'),
    get_item('FFEED8', 'Derby'),
    get_item('FFEFA1', 'Vis Vis'),
    get_item('FFEFC1', 'Egg White'),
    get_item('FFEFD5', 'Papaya Whip'),
    get_item('FFEFEC', 'Fair Pink'),
    get_item('FFF0DB', 'Peach Cream'),
    get_item('FFF0F5', 'Lavender blush'),
    get_item('FFF14F', 'Gorse'),
    get_item('FFF1B5', 'Buttermilk'),
    get_item('FFF1D8', 'Pink Lady'),
    get_item('FFF1EE', 'Forget Me Not'),
    get_item('FFF1F9', 'Tutu'),
    get_item('FFF39D', 'Picasso'),
    get_item('FFF3F1', 'Chardon'),
    get_item('FFF46E', 'Paris Daisy'),
    get_item('FFF4CE', 'Barley White'),
    get_item('FFF4DD', 'Egg Sour'),
    get_item('FFF4E0', 'Sazerac'),
    get_item('FFF4E8', 'Serenade'),
    get_item('FFF4F3', 'Chablis'),
    get_item('FFF5EE', 'Seashell Peach'),
    get_item('FFF5F3', 'Sauvignon'),
    get_item('FFF6D4', 'Milk Punch'),
    get_item('FFF6DF', 'Varden'),
    get_item('FFF6F5', 'Rose White'),
    get_item('FFF8D1', 'Baja White'),
    get_item('FFF9E2', 'Gin Fizz'),
    get_item('FFF9E6', 'Early Dawn'),
    get_item('FFFACD', 'Lemon Chiffon'),
    get_item('FFFAF4', 'Bridal Heath'),
    get_item('FFFBDC', 'Scotch Mist'),
    get_item('FFFBF9', 'Soapstone'),
    get_item('FFFC99', 'Witch Haze'),
    get_item('FFFCEA', 'Buttery White'),
    get_item('FFFCEE', 'Island Spice'),
    get_item('FFFDD0', 'Cream'),
    get_item('FFFDE6', 'Chilean Heath'),
    get_item('FFFDE8', 'Travertine'),
    get_item('FFFDF3', 'Orchid White'),
    get_item('FFFDF4', 'Quarter Pearl Lusta'),
    get_item('FFFEE1', 'Half and Half'),
    get_item('FFFEEC', 'Apricot White'),
    get_item('FFFEF0', 'Rice Cake'),
    get_item('FFFEF6', 'Black White'),
    get_item('FFFEFD', 'Romance'),
    get_item('FFFF00', 'Yellow'),
    get_item('FFFF66', 'Laser Lemon'),
    get_item('FFFF99', 'Pale Canary'),
    get_item('FFFFB4', 'Portafino'),
    get_item('FFFFF0', 'Ivory'),
    get_item('FFFFFF', 'White'),
]
