#!/usr/bin/env python
# coding: utf-8

# Copyright (c) Saga Inc.
# Distributed under the terms of the GPL License.
import pytest
import os

from mitosheet.saved_analyses import _get_all_analysis_filenames, _delete_analyses


@pytest.fixture(scope="session", autouse=True)
def cleanup_files():
    """
    This fixture is responsible for cleaning up all saved analyses that result from
    test runs. 

    It does so by reading in all analyses at the start of the testing session, 
    and then removing any new analyses at the end. 

    NOTE: if you use the app while the tests are running, it might delete
    your analyses - but this is really rare!
    """
    # This test runs before 
    old_analysis_filenames = _get_all_analysis_filenames()

    yield # All tests run here

    # This code runs after all the tests
    curr_analysis_filenames = _get_all_analysis_filenames()
    # Find all the new analysis file names (generated by tests)
    new_analysis_filenames = curr_analysis_filenames.difference(old_analysis_filenames)
    # Delete them
    _delete_analyses(new_analysis_filenames)