# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['aim_build']

package_data = \
{'': ['*']}

install_requires = \
['cerberus>=1.3,<2.0',
 'ninja-syntax>=1.7,<2.0',
 'tabulate>=0.8.7,<0.9.0',
 'toml>=0.10.0,<0.11.0']

entry_points = \
{'console_scripts': ['aim = aim.main:entry']}

setup_kwargs = {
    'name': 'aim-build',
    'version': '0.1.9',
    'description': 'A simple, but easy to use, build tool for C++.',
    'long_description': '<p align="center">\n<img src="https://github.com/diwalkerdev/Assets/blob/master/Aim/aim.png" width="300" height="300">\n</p>\n\n# Aim\n\nAim is a command line tool for building C++ projects.\n\nAim attempts to make building C++ projects, for different targets, as simple as possible.\nA build target is some combination of operating system, compiler and build type (and possibly other things). For example `linux-clang++-release`.\n\nSupport for a build target is added by writing a target file in TOML format. \nEach build target has its own `target.toml` file and must be written out in full for each target that you need to support.\nWhile the duplication may be a bit annoying, build errors are far easier to debug.\n\nAim doesn\'t try to be too clever although it does add a few compiler flags to make building and using libraries simpler.\n\n## Limitations\n* Currently only supports Linux.\n* Some Windows support via LLVM but hasn\'t been tested for a while.\n\n## Why another build tool?\nOther build tools are far too difficult to use. Aim allows you to partition a project into a executables, static libraries\nand shared libraries for any number of different build targets (Debug, Release, Sanitized). All builds occur in their own\ndirectory and dependency tracking is managed by Ninja.\n\nAll you have to do is write the `target.toml` file. It is very easy. No weird new syntax that you\'ll probably\nuse nowhere else.\n\n## Getting Started\nAim is a python project. It uses [poetry](https://python-poetry.org/) for the dependency manager.\n\nCurrently there is no installer and so installation must be done using `poetry` (see Installing below).\n\n### Prerequisites\n* Python 3.7 or above.\n* [poetry](https://python-poetry.org/)\n\n### Installing\n\n<img src="https://github.com/diwalkerdev/Assets/blob/master/Aim/aim-installation.gif?raw=true" width="600px">\n\nClone the project.\n\nThen install the dependencies (this also creates a virtual environment):\n\n```\npoetry install\n```\n\nUnfortunately, unlike `setuptools` there is no means to do a \'dev install\' using poetry. So simplest thing to, in order to use Aim, is to create an alias. The alias adds Aim to `PYTHONPATH` to resolve import/module paths and then uses Python in the virtualenv created by poetry to run Aim.\n\nFor `bash`:\n```\nalias aim="PYTHONPATH=$PWD/src $(poetry env info -p)/bin/python $PWD/src/aim/main.py"\n```\n\nFor `fish` shell:\n```\nalias aim="PYTHONPATH=$PWD/src "(poetry env info -p)"/bin/python $PWD/src/aim/main.py"\n```\n\nCheck the alias works correctly:\n\n```\naim --help\n```\n\nYou should see something similar to:\n```\nusage: aim [-h] [-v] {init,build} ...\n\nAim C++ build tool. For more help run aim <command> --help\n\npositional arguments:\n  {init,build}   Commands\n    init         Initialise the current directory\n    build        The build name\n\noptional arguments:\n  -h, --help     show this help message and exit\n  -v, --version  show program\'s version number and exit\n\n```\n\n### Using\n\n<img src="https://github.com/diwalkerdev/Assets/blob/master/Aim/aim-init-demo.gif?raw=true" width="600px">\n\nCreate a folder for your project and `cd` into it. For example: `AimDemoProject`.\n\nNow initialise the directory:\n\n```\nmkdir AimDemoProject\ncd AimDemoProject\naim init\n```\n\nThe following output will be displayed:\n\n```\nCreating directories...\n\t/home/username/AimDemoProject/headers\n\t/home/username/AimDemoProject/src\n\t/home/username/AimDemoProject/lib\n\t/home/username/AimDemoProject/builds\nCreating common build targets...\n\t/home/username/AimTest/builds/windows-clang_cl-debug/target.toml\n\t/home/username/AimTest/builds/windows-clang_cl-release/target.toml\n\t/home/username/AimTest/builds/linux-clang++-debug/target.toml\n\t/home/username/AimTest/builds/linux-clang++-release/target.toml\n```\n\nAim has created some folders for your project and some build targets for you. Don\'t feel like you have to keep to the project structure, you can modify the target files to point to any directory.\n\nAim has create some common build targets: `Windows` and `Linux` operating systems, using `clang_cl` compiler for Windows and `clang++` for Linux, and `debug` and `release` builds created for each. Simply add/delete target directories as required.\n\nLet\'s take a look at the `linux-clang++-debug/target.toml` file:\n\n```toml\nprojectRoot = "../.."                   # the relative path from the target build directory to the project src directory.\ncxx = "clang++"                         # the cxx compiler to use.\ncc = "clang"                            # the cc compiler to use.\nar = "llvm-ar"                          # the archiver to use.\ncompilerFrontend="gcc"                  # informs aim_build of which additional flags to include at various stages of the build.\n\nflags = [                               # compiler flags pass to all build targets.\n    "-std=c++17",\n    "-g"\n]\n\ndefines = []                            # defines passed to all build targets.\n\n[[builds]]                              # a list of builds.\n    name = "lib_calculator"             # the unique name for this build.\n    buildRule = "staticlib"             # the type of build, in this case create a static library.\n    outputName = "libCalculator.a"      # the library output name,\n    srcDirs = ["../../lib"]             # the src directories  to build the static library from.\n    includePaths = ["../../include"]   # additional include paths to use during the build.\n\n#[[builds]]\n#    name = "lib_calculator_so"         # the unique name for this build.\n#    buildRule = "dynamiclib"           # the type of build, in this case create a shared library.\n#    outputName = "libCalculator.so"    # the library output name,\n#    srcDirs = ["../../lib"]            # the src directories to build the shared library from.\n#    includePaths = ["../../include"]  # additional include paths to use during the build.\n\n[[builds]]\n    name = "exe"                        # the unique name for this build.\n    buildRule = "exe"                   # the type of build, in this case an executable.\n    requires = ["lib_calculator"]       # build dependencies. Aim figures out the linker flags for you.\n    outputName = "the_calculator.exe"   # the exe output name,\n    srcDirs = ["../../src"]             # the src directories to build the shared library from.\n    includePaths = ["../../include"]   # additional include paths to use during the build.\n    #libraryPaths = []                   # additional library paths, used for including third party libraries.\n    #libraries = []                      # additional libraries, used for including third party libraries.\n```\nFor the complete set of options, please refer to `src/aim/schema.py`.\n\nAll paths a relative to the target build directory hence why things like the `srcDirs` need to be prefixed with `../../`. \nThis will change in the near future.\n\n`init` adds a very simple `main.cpp` and calculator library library to the project. By default the library\nis built as a static library. You can replace the `lib_calculator` build with with the `lib_calculator_so` build if you\nwant the library to be created as a dynamic library. When using dynamic libraries Aim will update `rpath` to include\nany dynamic libraries that an executable uses.\n\nBuild and run the project:\n\n```\naim build --target exe --path builds/linux-clang++-debug/\n./builds/linux-clang++-debug/exe/the_calculator.exe\n```\n\n## Other remarks\nThe target file can be extended with other builds. For example to add unit tests. Begin by partitioning any code that\nneeds to be tested into a library. Then create another build for the test. Since unit tests are really an executable,\nset `buildRule="exe"` and add the library to the `requires` list. Remember to update the build for the primary\nexecutable as well if you have one.\n\nThe unit tests can now be built and run like any other executable.\n\n## Future improvements / known limitations\n * The `cc` field isn\'t actually used at the moment. All build steps are performed by the cxx compiler.\n',
    'author': 'David Walker',
    'author_email': 'diwalkerdev@twitter.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/diwalkerdev/Aim',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
