# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six


class ReplicationsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """ReplicationsService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def delete_replication_by_id(self, replication_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_replication_by_id(replication_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_replication_by_id_with_http_info(replication_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_replication_by_id_with_http_info(replication_id, **kwargs)  # noqa: E501
            return data

    def delete_replication_by_id_with_http_info(self, replication_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_replication_by_id_with_http_info(replication_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['replication_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_replication_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'replication_id' is set
        if ('replication_id' not in local_var_params or
                local_var_params['replication_id'] is None):
            raise ValueError("Missing the required parameter `replication_id` when calling `delete_replication_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'replication_id' in local_var_params:
            path_params['replicationID'] = local_var_params['replication_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/replications/{replicationID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_replication_by_id(self, replication_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_replication_by_id(replication_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Replication
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_replication_by_id_with_http_info(replication_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_replication_by_id_with_http_info(replication_id, **kwargs)  # noqa: E501
            return data

    def get_replication_by_id_with_http_info(self, replication_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_replication_by_id_with_http_info(replication_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Replication
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['replication_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_replication_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'replication_id' is set
        if ('replication_id' not in local_var_params or
                local_var_params['replication_id'] is None):
            raise ValueError("Missing the required parameter `replication_id` when calling `get_replication_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'replication_id' in local_var_params:
            path_params['replicationID'] = local_var_params['replication_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/replications/{replicationID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Replication',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_replications(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all replications.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_replications(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str name:
        :param str remote_id:
        :param str local_bucket_id:
        :return: Replications
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_replications_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_replications_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_replications_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all replications.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_replications_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str name:
        :param str remote_id:
        :param str local_bucket_id:
        :return: Replications
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span', 'name', 'remote_id', 'local_bucket_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_replications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_replications`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'remote_id' in local_var_params:
            query_params.append(('remoteID', local_var_params['remote_id']))  # noqa: E501
        if 'local_bucket_id' in local_var_params:
            query_params.append(('localBucketID', local_var_params['local_bucket_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/replications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Replications',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_replication_by_id(self, replication_id, replication_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_replication_by_id(replication_id, replication_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param ReplicationUpdateRequest replication_update_request: (required)
        :param str zap_trace_span: OpenTracing span context
        :param bool validate: If true, validate the updated information, but don't save it.
        :return: Replication
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_replication_by_id_with_http_info(replication_id, replication_update_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_replication_by_id_with_http_info(replication_id, replication_update_request, **kwargs)  # noqa: E501
            return data

    def patch_replication_by_id_with_http_info(self, replication_id, replication_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_replication_by_id_with_http_info(replication_id, replication_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param ReplicationUpdateRequest replication_update_request: (required)
        :param str zap_trace_span: OpenTracing span context
        :param bool validate: If true, validate the updated information, but don't save it.
        :return: Replication
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['replication_id', 'replication_update_request', 'zap_trace_span', 'validate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_replication_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'replication_id' is set
        if ('replication_id' not in local_var_params or
                local_var_params['replication_id'] is None):
            raise ValueError("Missing the required parameter `replication_id` when calling `patch_replication_by_id`")  # noqa: E501
        # verify the required parameter 'replication_update_request' is set
        if ('replication_update_request' not in local_var_params or
                local_var_params['replication_update_request'] is None):
            raise ValueError("Missing the required parameter `replication_update_request` when calling `patch_replication_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'replication_id' in local_var_params:
            path_params['replicationID'] = local_var_params['replication_id']  # noqa: E501

        query_params = []
        if 'validate' in local_var_params:
            query_params.append(('validate', local_var_params['validate']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'replication_update_request' in local_var_params:
            body_params = local_var_params['replication_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/replications/{replicationID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Replication',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_replication(self, replication_creation_request, **kwargs):  # noqa: E501,D401,D403
        """Register a new replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_replication(replication_creation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplicationCreationRequest replication_creation_request: (required)
        :param str zap_trace_span: OpenTracing span context
        :param bool validate: If true, validate the replication, but don't save it.
        :return: Replication
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_replication_with_http_info(replication_creation_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_replication_with_http_info(replication_creation_request, **kwargs)  # noqa: E501
            return data

    def post_replication_with_http_info(self, replication_creation_request, **kwargs):  # noqa: E501,D401,D403
        """Register a new replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_replication_with_http_info(replication_creation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReplicationCreationRequest replication_creation_request: (required)
        :param str zap_trace_span: OpenTracing span context
        :param bool validate: If true, validate the replication, but don't save it.
        :return: Replication
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['replication_creation_request', 'zap_trace_span', 'validate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_replication" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'replication_creation_request' is set
        if ('replication_creation_request' not in local_var_params or
                local_var_params['replication_creation_request'] is None):
            raise ValueError("Missing the required parameter `replication_creation_request` when calling `post_replication`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'validate' in local_var_params:
            query_params.append(('validate', local_var_params['validate']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'replication_creation_request' in local_var_params:
            body_params = local_var_params['replication_creation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/replications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Replication',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_validate_replication_by_id(self, replication_id, **kwargs):  # noqa: E501,D401,D403
        """Validate a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_validate_replication_by_id(replication_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_validate_replication_by_id_with_http_info(replication_id, **kwargs)  # noqa: E501
        else:
            (data) = self.post_validate_replication_by_id_with_http_info(replication_id, **kwargs)  # noqa: E501
            return data

    def post_validate_replication_by_id_with_http_info(self, replication_id, **kwargs):  # noqa: E501,D401,D403
        """Validate a replication.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_validate_replication_by_id_with_http_info(replication_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str replication_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['replication_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_validate_replication_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'replication_id' is set
        if ('replication_id' not in local_var_params or
                local_var_params['replication_id'] is None):
            raise ValueError("Missing the required parameter `replication_id` when calling `post_validate_replication_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'replication_id' in local_var_params:
            path_params['replicationID'] = local_var_params['replication_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/replications/{replicationID}/validate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
