# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six


class RemoteConnectionsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """RemoteConnectionsService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def delete_remote_connection_by_id(self, remote_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_remote_connection_by_id(remote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str remote_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_remote_connection_by_id_with_http_info(remote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_remote_connection_by_id_with_http_info(remote_id, **kwargs)  # noqa: E501
            return data

    def delete_remote_connection_by_id_with_http_info(self, remote_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_remote_connection_by_id_with_http_info(remote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str remote_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['remote_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_remote_connection_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'remote_id' is set
        if ('remote_id' not in local_var_params or
                local_var_params['remote_id'] is None):
            raise ValueError("Missing the required parameter `remote_id` when calling `delete_remote_connection_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'remote_id' in local_var_params:
            path_params['remoteID'] = local_var_params['remote_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/remotes/{remoteID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_remote_connection_by_id(self, remote_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_remote_connection_by_id(remote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str remote_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RemoteConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_remote_connection_by_id_with_http_info(remote_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_remote_connection_by_id_with_http_info(remote_id, **kwargs)  # noqa: E501
            return data

    def get_remote_connection_by_id_with_http_info(self, remote_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_remote_connection_by_id_with_http_info(remote_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str remote_id: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RemoteConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['remote_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_remote_connection_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'remote_id' is set
        if ('remote_id' not in local_var_params or
                local_var_params['remote_id'] is None):
            raise ValueError("Missing the required parameter `remote_id` when calling `get_remote_connection_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'remote_id' in local_var_params:
            path_params['remoteID'] = local_var_params['remote_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/remotes/{remoteID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemoteConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_remote_connections(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all remote connections.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_remote_connections(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str name:
        :param str remote_url:
        :return: RemoteConnections
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_remote_connections_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_remote_connections_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_remote_connections_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all remote connections.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_remote_connections_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: The organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str name:
        :param str remote_url:
        :return: RemoteConnections
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span', 'name', 'remote_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_remote_connections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_remote_connections`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'remote_url' in local_var_params:
            query_params.append(('remoteURL', local_var_params['remote_url']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/remotes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemoteConnections',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_remote_connection_by_id(self, remote_id, remote_connection_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_remote_connection_by_id(remote_id, remote_connection_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str remote_id: (required)
        :param RemoteConnectionUpdateRequest remote_connection_update_request: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RemoteConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_remote_connection_by_id_with_http_info(remote_id, remote_connection_update_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_remote_connection_by_id_with_http_info(remote_id, remote_connection_update_request, **kwargs)  # noqa: E501
            return data

    def patch_remote_connection_by_id_with_http_info(self, remote_id, remote_connection_update_request, **kwargs):  # noqa: E501,D401,D403
        """Update a remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_remote_connection_by_id_with_http_info(remote_id, remote_connection_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str remote_id: (required)
        :param RemoteConnectionUpdateRequest remote_connection_update_request: (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RemoteConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['remote_id', 'remote_connection_update_request', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_remote_connection_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'remote_id' is set
        if ('remote_id' not in local_var_params or
                local_var_params['remote_id'] is None):
            raise ValueError("Missing the required parameter `remote_id` when calling `patch_remote_connection_by_id`")  # noqa: E501
        # verify the required parameter 'remote_connection_update_request' is set
        if ('remote_connection_update_request' not in local_var_params or
                local_var_params['remote_connection_update_request'] is None):
            raise ValueError("Missing the required parameter `remote_connection_update_request` when calling `patch_remote_connection_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'remote_id' in local_var_params:
            path_params['remoteID'] = local_var_params['remote_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'remote_connection_update_request' in local_var_params:
            body_params = local_var_params['remote_connection_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/remotes/{remoteID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemoteConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_remote_connection(self, remote_connection_creation_request, **kwargs):  # noqa: E501,D401,D403
        """Register a new remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_remote_connection(remote_connection_creation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoteConnectionCreationRequest remote_connection_creation_request: (required)
        :return: RemoteConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_remote_connection_with_http_info(remote_connection_creation_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_remote_connection_with_http_info(remote_connection_creation_request, **kwargs)  # noqa: E501
            return data

    def post_remote_connection_with_http_info(self, remote_connection_creation_request, **kwargs):  # noqa: E501,D401,D403
        """Register a new remote connection.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_remote_connection_with_http_info(remote_connection_creation_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RemoteConnectionCreationRequest remote_connection_creation_request: (required)
        :return: RemoteConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['remote_connection_creation_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_remote_connection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'remote_connection_creation_request' is set
        if ('remote_connection_creation_request' not in local_var_params or
                local_var_params['remote_connection_creation_request'] is None):
            raise ValueError("Missing the required parameter `remote_connection_creation_request` when calling `post_remote_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'remote_connection_creation_request' in local_var_params:
            body_params = local_var_params['remote_connection_creation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/remotes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemoteConnection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
