# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ScraperTargetRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'type': 'str',
        'url': 'str',
        'org_id': 'str',
        'bucket_id': 'str',
        'allow_insecure': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'url': 'url',
        'org_id': 'orgID',
        'bucket_id': 'bucketID',
        'allow_insecure': 'allowInsecure'
    }

    def __init__(self, name=None, type=None, url=None, org_id=None, bucket_id=None, allow_insecure=False):  # noqa: E501,D401,D403
        """ScraperTargetRequest - a model defined in OpenAPI."""  # noqa: E501
        self._name = None
        self._type = None
        self._url = None
        self._org_id = None
        self._bucket_id = None
        self._allow_insecure = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if url is not None:
            self.url = url
        if org_id is not None:
            self.org_id = org_id
        if bucket_id is not None:
            self.bucket_id = bucket_id
        if allow_insecure is not None:
            self.allow_insecure = allow_insecure

    @property
    def name(self):
        """Get the name of this ScraperTargetRequest.

        The name of the scraper target.

        :return: The name of this ScraperTargetRequest.
        :rtype: str
        """  # noqa: E501
        return self._name

    @name.setter
    def name(self, name):
        """Set the name of this ScraperTargetRequest.

        The name of the scraper target.

        :param name: The name of this ScraperTargetRequest.
        :type: str
        """  # noqa: E501
        self._name = name

    @property
    def type(self):
        """Get the type of this ScraperTargetRequest.

        The type of the metrics to be parsed.

        :return: The type of this ScraperTargetRequest.
        :rtype: str
        """  # noqa: E501
        return self._type

    @type.setter
    def type(self, type):
        """Set the type of this ScraperTargetRequest.

        The type of the metrics to be parsed.

        :param type: The type of this ScraperTargetRequest.
        :type: str
        """  # noqa: E501
        self._type = type

    @property
    def url(self):
        """Get the url of this ScraperTargetRequest.

        The URL of the metrics endpoint.

        :return: The url of this ScraperTargetRequest.
        :rtype: str
        """  # noqa: E501
        return self._url

    @url.setter
    def url(self, url):
        """Set the url of this ScraperTargetRequest.

        The URL of the metrics endpoint.

        :param url: The url of this ScraperTargetRequest.
        :type: str
        """  # noqa: E501
        self._url = url

    @property
    def org_id(self):
        """Get the org_id of this ScraperTargetRequest.

        The organization ID.

        :return: The org_id of this ScraperTargetRequest.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this ScraperTargetRequest.

        The organization ID.

        :param org_id: The org_id of this ScraperTargetRequest.
        :type: str
        """  # noqa: E501
        self._org_id = org_id

    @property
    def bucket_id(self):
        """Get the bucket_id of this ScraperTargetRequest.

        The ID of the bucket to write to.

        :return: The bucket_id of this ScraperTargetRequest.
        :rtype: str
        """  # noqa: E501
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """Set the bucket_id of this ScraperTargetRequest.

        The ID of the bucket to write to.

        :param bucket_id: The bucket_id of this ScraperTargetRequest.
        :type: str
        """  # noqa: E501
        self._bucket_id = bucket_id

    @property
    def allow_insecure(self):
        """Get the allow_insecure of this ScraperTargetRequest.

        Skip TLS verification on endpoint.

        :return: The allow_insecure of this ScraperTargetRequest.
        :rtype: bool
        """  # noqa: E501
        return self._allow_insecure

    @allow_insecure.setter
    def allow_insecure(self, allow_insecure):
        """Set the allow_insecure of this ScraperTargetRequest.

        Skip TLS verification on endpoint.

        :param allow_insecure: The allow_insecure of this ScraperTargetRequest.
        :type: bool
        """  # noqa: E501
        self._allow_insecure = allow_insecure

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, ScraperTargetRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
