# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class File(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'name': 'str',
        'package': 'PackageClause',
        'imports': 'list[ImportDeclaration]',
        'body': 'list[Statement]'
    }

    attribute_map = {
        'type': 'type',
        'name': 'name',
        'package': 'package',
        'imports': 'imports',
        'body': 'body'
    }

    def __init__(self, type=None, name=None, package=None, imports=None, body=None):  # noqa: E501,D401,D403
        """File - a model defined in OpenAPI."""  # noqa: E501
        self._type = None
        self._name = None
        self._package = None
        self._imports = None
        self._body = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if name is not None:
            self.name = name
        if package is not None:
            self.package = package
        if imports is not None:
            self.imports = imports
        if body is not None:
            self.body = body

    @property
    def type(self):
        """Get the type of this File.

        Type of AST node

        :return: The type of this File.
        :rtype: str
        """  # noqa: E501
        return self._type

    @type.setter
    def type(self, type):
        """Set the type of this File.

        Type of AST node

        :param type: The type of this File.
        :type: str
        """  # noqa: E501
        self._type = type

    @property
    def name(self):
        """Get the name of this File.

        The name of the file.

        :return: The name of this File.
        :rtype: str
        """  # noqa: E501
        return self._name

    @name.setter
    def name(self, name):
        """Set the name of this File.

        The name of the file.

        :param name: The name of this File.
        :type: str
        """  # noqa: E501
        self._name = name

    @property
    def package(self):
        """Get the package of this File.

        :return: The package of this File.
        :rtype: PackageClause
        """  # noqa: E501
        return self._package

    @package.setter
    def package(self, package):
        """Set the package of this File.

        :param package: The package of this File.
        :type: PackageClause
        """  # noqa: E501
        self._package = package

    @property
    def imports(self):
        """Get the imports of this File.

        A list of package imports

        :return: The imports of this File.
        :rtype: list[ImportDeclaration]
        """  # noqa: E501
        return self._imports

    @imports.setter
    def imports(self, imports):
        """Set the imports of this File.

        A list of package imports

        :param imports: The imports of this File.
        :type: list[ImportDeclaration]
        """  # noqa: E501
        self._imports = imports

    @property
    def body(self):
        """Get the body of this File.

        List of Flux statements

        :return: The body of this File.
        :rtype: list[Statement]
        """  # noqa: E501
        return self._body

    @body.setter
    def body(self, body):
        """Set the body of this File.

        List of Flux statements

        :param body: The body of this File.
        :type: list[Statement]
        """  # noqa: E501
        self._body = body

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, File):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
