# dtx-models

**dtx-models** provides shared model schemas, configuration structures, and YAML-based assets used across the [DTX AI Red Teaming Framework](https://docs.detoxio.ai).

This package helps standardize model definitions and integrates seamlessly with components in the `dtx` ecosystem.

## Features

- Pydantic-based schema definitions
- YAML-driven model and plugin configuration
- Clean separation of model assets from core logic

## Installation

```bash
pip install dtx-models
````

Or, if developing locally:

```bash
poetry install
```

## Requirements

* Python >= 3.11
* [Pydantic](https://docs.pydantic.dev/) v2
* [PyYAML](https://pyyaml.org/)

## Documentation

Full documentation available at [docs.detoxio.ai](https://docs.detoxio.ai)

---

© Detoxio.ai – All rights reserved.

