"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pinger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class Pinger extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.url = props.url;
        const onEvent = new aws_lambda_nodejs_1.NodejsFunction(this, 'ProviderFunc', {
            entry: (_b = props.entry) !== null && _b !== void 0 ? _b : path.join(__dirname, './lambda/index.js'),
            handler: 'onEvent',
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.PARAMETER': jsonStringifiedBundlingDefinition((_c = props.parameter) !== null && _c !== void 0 ? _c : {}),
                },
            },
        });
        const myProvider = new cr.Provider(this, 'Provider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const pingerResource = new core_1.CustomResource(this, 'PingerResource', {
            serviceToken: myProvider.serviceToken,
            resourceType: 'Custom::Pinger',
            properties: {
                url: props.url,
            },
        });
        this.resource = pingerResource;
        this.httpStatus = pingerResource.getAtt('status').toString();
        this.htmlTitle = pingerResource.getAtt('title').toString();
        this.body = pingerResource.getAtt('body').toString();
    }
}
exports.Pinger = Pinger;
_a = JSII_RTTI_SYMBOL_1;
Pinger[_a] = { fqn: "cdk-http-pinger.Pinger", version: "0.1.88" };
function jsonStringifiedBundlingDefinition(value) {
    return JSON.stringify(value)
        .replace(/"/g, '\\"')
        .replace(/,/g, '\\,');
}
//# sourceMappingURL=data:application/json;base64,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