use base "installedtest";
use strict;
use testapi;
use utils;

# This is the {{title}} test created by the AutoCoconut Tool.

sub run {
my $self = shift;

# Here starts the autogenerated part.

# IMPORTANT NOTICE:
# 1. You should manually check that the assertion needles for post action assertions, such as key presses, etc.
# point to correct locations. Be default they only check the upper left corner which may lead to false
# positives. You can also delete them, if you do not require such assertions.
# 2. If you were creating tests for terminal commands, you might want to switch some of the 
# `type_very_safely` routines for something like `assert_script_run` or `script_run` to get some more terminal
# functionality.

{% for event in report %}
{% if event.type == "mouse" and event.action == "click" %}
{% if event.combined  %}
# Press and hold a {{event.combined}} while clicking the mouse.
hold_key("{{event.combined}}");
{% endif %}
# Click with the *{{event.button}}* button (needle click area might need some correction)
assert_and_click("{{event.screens[0]}}", button => "{{event.button}}", timeout => 30);
{% elif event.type == "mouse" and event.action == "doubleclick" %}
{% if event.combined  %}
# Press and hold a {{event.combined}} while clicking the mouse.
hold_key("{{event.combined}}");
{% endif %}

# Doubleclick with the *{{event.button}}* button (needle click area might need some correction) 
assert_and_click("{{event.screens[0]}}", button => "{{event.button}}", timeout => 30, dclick => 1);
{% elif event.type == "mouse" and event.action == "scroll" %}
# The mouse has been scrolled, but mouse scroll is not supported in OpenQA. The following solution
# is a workaround using arrows instead of mouse wheel. Note, that focus needs to be in the window
# you want to scroll. You are also free to implement this by some other means.
{% if event.combined  %}
# Press and hold a {{event.combined}} while pressing the arrow.
hold_key("{{event.combined}}");
{% endif %}

# Press one of the arrow key repeatedly to move to {{event.direction}}  
{% if event.direction == "north"  %}
my @range = (1..{{event.vertical}});
for my $iter (@range) {
        send_key("up");
}

{% elif event.direction == "south"  %}
my @range = (1..{{event.vertical}});
for my $iter (@range) {
        send_key("down");
}

{% elif event.direction == "west"  %}
my @range = (1..{{event.horizontal}});
for my $iter (@range) {
send_key("left");
}

{% elif event.direction == "east"  %}
my @range = (1..{{event.vertical}});
for my $iter (@range) {
send_key("right");
}
{% endif %}
# And check that the result has been achieved. (You probably need to modify the needle assertion area.)
assert_screen("{{event.screens[0]}}", timeout => 30);
{% elif event.type == "mouse" and event.action == "drag" %}
{% if event.combined  %}
# Press and hold a {{event.combined}} while pressing the arrow.
hold_key("{{event.combined}}");
{% endif %}
# Move the mouse to {{event.coordinates[0]}}, {{event.coordinates[1]}}, click and hold the *{{event.button}}* button for {{event.duration}} second, while moving the mouse to the coordinates *{{event.end_coordinates[0], event.end_coordinates[1]}}*. 
mouse_drag("{{event.screens[0]}}", button => "{{event.button}}" , xend => {{event.end_coordinates[0]}}, yend => {{event.end_coordinates[1]}}, timeout => 30);
# Check the result of the action. (You probably need to modify the needle assertion area.)
assert_screen("{{event.screens[0]}}", timeout => 30);
{% elif event.type == "key combination" and event.subtype == "modifier" and event.action == "press" %}
{% if event.combined %}
# Press and hold a {{event.combined}} modifier.
hold_key("{{event.combined}}");
{% endif %}
# Press *{{event.key}}*. 
send_key("{{event.key}}");
{% elif event.type == "key" and event.subtype == "special" and event.action == "press" %}
{% if event.combined  %}
# Press and hold a {{event.combined}} modifier.
hold_key("{{event.combined}}");
{% endif %}
# Press *{{event.key}}*.
send_key("{{event.key}}");
# Check the needle for the result of the action
assert_screen("{{event.screens[0]}}", timeout => 30);
{% elif event.type == "typing" %}
# Type *{{event.text}}*.
type_very_safely("{{event.text}}");
{% elif event.type == "key" and event.subtype == "modifier" and event.action == "release"%}
# Release modifier. Note that if there were more modifiers pressed, only the last one is marked for release.
# Fix this according to your needs.
release_key("{{event.key}}");
# Check the needle to see the result of the action.
assert_screen("{{event.screens[0]}}", timeout => 30);
{% elif event.type == "key" and event.subtype == "stop" and event.action == "press" %}
# This is the end of the recording. See the screenshot that shows the situation at the end of the recording. 
assert_screen("{{event.screens[0]}}", timeout => 30);
{% endif %}
{% endfor %}

# Here ends the autogenerated part.

}

sub test_flags {
        return {always_rollback => 1};
}

1;

