# micromagneticmodel

[Marijan Beg](https://github.com/marijanbeg)<sup>1,2</sup>, [Martin Lang](https://github.com/lang-m)<sup>2</sup>, [Samuel Holt](https://github.com/samjrholt)<sup>2,3</sup>, and [Hans Fangohr](https://github.com/fangohr)<sup>2,4,5</sup>

<sup>1</sup> *Department of Earth Science and Engineering, Imperial College London, London SW7 2AZ, UK*  
<sup>2</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, UK*  
<sup>3</sup> *Department of Physics, University of Warwick, Coventry CV4 7AL, UK*  
<sup>4</sup> *Max Planck Institute for the Structure and Dynamics of Matter, Luruper Chaussee 149, 22761 Hamburg, Germany*  
<sup>5</sup> *Center for Free-Electron Laser Science, Luruper Chaussee 149, 22761 Hamburg, Germany*  


| Description | Badge |
| --- | --- |
| Tests | [![Build status](https://github.com/ubermag/micromagneticmodel/workflows/workflow/badge.svg)](https://github.com/ubermag/micromagneticmodel/actions?query=workflow%3Aworkflow) |
|       | [![conda](https://github.com/ubermag/micromagneticmodel/workflows/conda/badge.svg)](https://github.com/ubermag/micromagneticmodel/actions?query=workflow%3Aconda) |
| Linting | [![pre-commit.ci status](https://results.pre-commit.ci/badge/github/ubermag/micromagneticmodel/master.svg)](https://results.pre-commit.ci/latest/github/ubermag/micromagneticmodel/master)
| Releases | [![PyPI version](https://badge.fury.io/py/micromagneticmodel.svg)](https://badge.fury.io/py/micromagneticmodel) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/micromagneticmodel/badges/version.svg)](https://anaconda.org/conda-forge/micromagneticmodel) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/micromagneticmodel/branch/master/graph/badge.svg?token=hcK4fofmrL)](https://codecov.io/gh/ubermag/micromagneticmodel) |
| Documentation | [![Documentation](https://img.shields.io/badge/Docs-ubermag.github.io-blue)](https://ubermag.github.io/documentation/micromagneticmodel.html) |
| YouTube | [![YouTube](https://img.shields.io/badge/YouTube-ubermag-blue)](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/micromagneticmodel/stable?urlpath=lab/tree/docs/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/micromagneticmodel/badges/platforms.svg)](https://anaconda.org/conda-forge/micromagneticmodel) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/micromagneticmodel/badges/downloads.svg)](https://anaconda.org/conda-forge/micromagneticmodel) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/67028400.svg)](https://zenodo.org/badge/latestdoi/67028400) |

## About

`micromagneticmodel` is a Python package, integrated with Jupyter, providing:

- Domain-specific language for computational magnetism.


It is available on Windows, MacOS, and Linux. It requires Python 3.8+.

## Documentation

APIs and tutorials are available in the documentation. To access the documentation, use the badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the [documentation](https://ubermag.github.io/installation.html).

## Binder

This package can be used in the cloud via Binder. To access Binder, use the badge in the table above.

## YouTube

YouTube video tutorials are available on the [Ubermag channel](https://www.youtube.com/channel/UC7MSqVQSMFV42R1jAYmKGLg).

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## Contributions

All contributions are welcome, however small they are. If you would like to contribute, please fork the repository and create a pull request. If you are not sure how to contribute, please contact us by raising an issue in [ubermag/help](https://github.com/ubermag/help) repository, and we are going to help you get started and assist you on the way.

**Contributors**:

- [Thomas Kluyver](https://github.com/takluyver)
- [Ryan A. Pepper](https://github.com/rpep)
- [Sergii Mamedov](https://github.com/sergii-mamedov)
- [Natalie Downing](https://github.com/gamdow)

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

1. M. Beg, M. Lang, and H. Fangohr. Ubermag: Towards more effective micromagnetic workflows. [*IEEE Transactions on Magnetics* **58**, 7300205](https://doi.org/10.1109/TMAG.2021.3078896) (2022).

2. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025](http://aip.scitation.org/doi/10.1063/1.4977225) (2017).

3. Marijan Beg, Martin Lang, Samuel Holt, and Hans Fangohr. micromagneticmodel: Python-based domain-specific language for computational magnetism DOI: [10.5281/zenodo.3539479](http://doi.org/10.5281/zenodo.3539479) (2022).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme Grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1)
