# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06_spacy.ipynb (unless otherwise specified).

__all__ = ['l2norm', 'normal', 'distance', 'make_map', 'make_span', 'make_div', 'doc2div', 'compare_sentences',
           'highlight']

# Cell
from .html import DOM,JS
import numpy as np
import json

# Cell
def l2norm(x):return np.sqrt(np.power(x,2).sum(-1))
def normal(x):return (x/l2norm(x)[:,None])
def distance(a,b):return 1- normal(a)@(normal(b).T)

# Cell

highlight = """
$(document).ready(function(){
    const red=(dom)=>{
        $(dom)
            .css("background-color","#FFCCEE")
            .css("box-shadow","0px 0px 10px #FFCCEE")
    }
    const white=(dom)=>{
        $(dom).css("background-color","#FFFFFF")
            .css("box-shadow","0px 0px 0px #FFFFFF")
    }
    $(".nlp_tok")
            .css("margin","1px 2px")
            .css("padding","1px 1px")
            .css("border-radius","5px");
        var edge = JSON.parse(window.edge_data)
        var edge2 = JSON.parse(window.edge_data2)
        var all_b = []
        for(var a in edge)
        {
            $(`#map_word_src_${a}`).data("match",edge[a].idx)
            $(`#map_word_src_${a}`).css("font-weight",900)
           $(`#map_word_src_${a}`)
                   .hover(function(){
                       red(this)
                       var b_match = $(this).data("match")
                       for(var i in b_match){
                           var b = b_match[i]
                           red(document.querySelector(`#map_word_tgt_${b}`))
                       }
                   })
            $(`#map_word_src_${a}`)
                    .mouseleave(function(){
                        white(this)
                        var b_match = $(this).data("match")
                        for(var i in b_match){
                           var b = b_match[i]
                           white(document.querySelector(`#map_word_tgt_${b}`))
                       }
                    })
        }
        for(var a in edge2)
        {
            $(`#map_word_tgt_${a}`).data("match",edge2[a].idx)
            $(`#map_word_tgt_${a}`).css("font-weight",900)
           $(`#map_word_tgt_${a}`)
                   .hover(function(){
                       red(this)
                       var b_match = $(this).data("match")
                       for(var i in b_match){
                           var b = b_match[i]
                           red(document.querySelector(`#map_word_src_${b}`))
                       }
                   })
            $(`#map_word_tgt_${a}`)
                    .mouseleave(function(){
                        white(this)
                        var b_match = $(this).data("match")
                        for(var i in b_match){
                           var b = b_match[i]
                           white(document.querySelector(`#map_word_src_${b}`))
                       }
                    })
        }

})
"""
def make_map(distance_map,th = .1):
    """
    create a hot spot map between similar token
    return dict, token index with matching token index in the target sentence
    """
    a2b_dict = dict()
    tgt_range = np.arange(distance_map.shape[-1])
    for i in range(len(distance_map)):
        slice_ = (distance_map[i,:]<th)
        if slice_.sum()>0:
            a2b_dict[str(i)]= dict(dist = list(distance_map[i,:][slice_].astype(float)),
                              idx = list(tgt_range[slice_].astype(str)))
    return a2b_dict

def make_span(tok,tok_id,classes):
    """
    create span for token
    tok,spacy token
    tok_id, span's html id

    return forgebox.html.DOM
    """
    return DOM(tok.text,"span",{"class":" ".join(classes),"id":tok_id})

def make_div(doc,id_list,classes_list):
    """
    create div tag for a sentence
    doc:spacy doc
    id_list, a list of html id
    classes_list, a list of classes assigning to the token span

    return forgebox.html.DOM
    """
    div = DOM("","div",{"class":"text-block"})
    for tok,tok_id,classes in zip(doc,id_list,classes_list):
        div.append(make_span(tok,tok_id,classes))
    return div

def doc2div(doc,distance_map,th=.1,is_src= True):
    totallen = len(doc)
    src_tgt = "src" if is_src else "tgt"
    id_list = list(f"map_word_{src_tgt}_{i}" for i in range(len(doc)))
    if is_src:
        edge_map = make_map(distance_map,th=th)
        DOM(f"window.edge_data = '{json.dumps(edge_map)}'","script")()
    else:
        edge_map2 = make_map(distance_map.T,th=th)
        DOM(f"window.edge_data2 = '{json.dumps(edge_map2)}'","script")()

    return make_div(doc,id_list,zip([src_tgt,]*totallen,["nlp_tok"]*totallen))



def compare_sentences(A,B,nlp,th=.1):
    """
    Compare between sentences
    A: str, a sentence
    B: str, another sentence
    nlp: loaded spacy: eg. from spacy import load;nlp = load("some_model_name"),
    see spacy documentation https://spacy.io/usage/spacy-101/

    th:float, threshold for consine distance, smaller it is, fewer matching tokens will be found,
    but assume that means higher quality
    """
    doc_a = nlp(A)
    doc_b = nlp(B)
    distance_map = distance(doc_a.tensor,doc_b.tensor)
    DOM("Sentence A","h3",{"class":"text-primary"})()
    doc2div(doc_a,distance_map,th=th,is_src=True)()
    DOM("Sentence B","h3",{"class":"text-primary"})()
    doc2div(doc_b,distance_map,th=th,is_src=False)()
    JS(highlight)