# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/31_df_filter.ipynb (unless otherwise specified).

__all__ = ['detect_number_column', 'DataFilter']

# Cell
import pandas as pd
import numpy as np

# Cell
from ipywidgets import VBox, Button,\
    FloatSlider, IntSlider,Dropdown, Label,Checkbox,\
    interact

import plotly.express as px

def detect_number_column(df):
    """
    Detect number columns in dataframe
    """
    cols = df.columns
    dtypes = [df[col].dtype.name for col in cols]
    return pd.DataFrame({"cols":cols, "dtypes":dtypes})

class DataFilter:
    """
    Single column number filter
    """
    def __init__(self, df: pd.DataFrame):
        """
        df: input dataframe

        data_filter = DataFilter(df)

        # start filtering
        data_filter()
        """
        self.df = df

    def show_distribution(self, col_name):
        fig = px.histogram(self.df, x=col_name, height=300, width=800)
        return fig

    def create_filter(self, field: str) -> None:
        big_boxes = []

        dtype = self.df[field].dtype.name
        if 'float' in dtype:
            slider = FloatSlider
        elif 'int' in dtype:
            slider = IntSlider
        else:
            print(f"filter of {dtype} not supported")

        btn = Button(description="Run Filter")
        btn.on_click(self.execute_filter)

        print(f"NaN count: {(self.df[field].isna()).sum()}")

        widget = VBox([
                    Label(f"Range for {field}"),
                    Dropdown(options=["Larger Than or equal to", "Smaller Than or equal to"]),
                    slider(
                        min = self.df[field].min(),
                        max = self.df[field].max(),
                        step = (self.df[field].max()-self.df[field].min())/100),
                    Checkbox(description="Remove NaN", value=True),
                    btn
                ])
        self.widget = widget
        widget.original_name = field

        display(widget)

    def execute_filter(
        self, _) -> None:
        """
        This function will be used as a callback
        for ipywidgets.Button.on_click
        """
        original_name = self.widget.original_name
        label_,condi_,value_,remove_na_, btn_ = self.widget.children
        label, condi, value, remove_na = label_.value ,condi_.value ,value_.value, remove_na_.value
        condi = ">=" if condi=='Larger Than or equal to' else "<="
        expression = f"({original_name} {condi} {value})"

        if remove_na:
            self.remove_na(original_name)

        print(f"Filter with query expression: {expression}")
        before = len(self.df)
        self.df = self.df.query(expression).reset_index(drop=True)
        after = len(self.df)
        print(f"[Before]: {before}, [After]: {after}")

    def remove_na(self, field):
        """
        Remove nan value in a dataframe
        """
        before = len(self.df)
        self.df = self.df[~self.df[field].isna()]
        after = len(self.df)
        print(f"Remove NA on {field} [Before]: {before}, [After]: {after}")

    def __call__(self):
        """
        Execute an interact to filter things column by column
        """
        @interact
        def select_field(field = list(self.df.columns)):
            # visualize histogram
            self.show_distribution(field).show()

            # create a filter execution interactive
            self.create_filter(field)