/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.BaseSpecialColorEditor;
import fr.orsay.lri.varna.components.BaseTableModel;
import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VueBases
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int KIND_MODE = 1;
    public static final int ALL_MODE = 2;
    public static final int COUPLE_MODE = 3;
    private int _mode;
    private VARNAPanel _vp;
    private ArrayList<BaseList> data = new ArrayList();
    private Hashtable<String, BaseList> revdata = new Hashtable();
    private JTable table;
    private BaseTableModel specialTableModel;

    public VueBases(VARNAPanel vARNAPanel, int n) {
        super(new GridLayout(1, 0));
        this._vp = vARNAPanel;
        switch (n) {
            case 1: {
                this._mode = 1;
                this.kindMode();
                break;
            }
            case 2: {
                this._mode = 2;
                this.allMode();
                break;
            }
            case 3: {
                this._mode = 3;
                this.coupleMode();
                break;
            }
        }
    }

    private BaseList locateOrAddList(String string) {
        if (!this.revdata.containsKey(string)) {
            BaseList baseList = new BaseList(string);
            this.revdata.put(string, baseList);
            this.data.add(baseList);
        }
        return this.revdata.get(string);
    }

    private void coupleMode() {
        for (int i = 0; i < this._vp.getRNA().get_listeBases().size(); ++i) {
            int n = this._vp.getRNA().get_listeBases().get(i).getElementStructure();
            if (n <= i) continue;
            String string = this._vp.getRNA().get_listeBases().get(i).getContent();
            String string2 = this._vp.getRNA().get_listeBases().get(n).getContent();
            String string3 = string + "-" + string2;
            BaseList baseList = this.locateOrAddList(string3);
            baseList.addBase(this._vp.getRNA().get_listeBases().get(i));
            baseList.addBase(this._vp.getRNA().get_listeBases().get(n));
        }
        this.createView();
    }

    private void allMode() {
        for (int i = 0; i < this._vp.getRNA().get_listeBases().size(); ++i) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(i);
            BaseList baseList = this.locateOrAddList("" + i);
            baseList.addBase(modeleBase);
        }
        this.createView();
    }

    private void kindMode() {
        for (int i = 0; i < this._vp.getRNA().get_listeBases().size(); ++i) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(i);
            String string = modeleBase.getContent();
            BaseList baseList = this.locateOrAddList(string);
            baseList.addBase(modeleBase);
        }
        this.createView();
    }

    private void createView() {
        this.specialTableModel = new BaseTableModel(this.data);
        this.table = new JTable(this.specialTableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultEditor(Color.class, new BaseSpecialColorEditor(this));
        this.specialTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                VueBases.this._vp.repaint();
            }
        });
        this.add(jScrollPane);
        this.UIvueBases();
    }

    public void UIvueBases() {
        VueBases vueBases = this;
        vueBases.setOpaque(true);
        JOptionPane.showMessageDialog(this._vp, vueBases, "Base Colors Edition", -1);
    }

    public int getMode() {
        return this._mode;
    }

    public BaseList getDataAt(int n) {
        return this.data.get(n);
    }

    public ArrayList<BaseList> getData() {
        return this.data;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public BaseTableModel getSpecialTableModel() {
        return this.specialTableModel;
    }

    public void setSpecialTableModel(BaseTableModel baseTableModel) {
        this.specialTableModel = baseTableModel;
    }
}

