from setuptools import setup
from builtins import open

# read the contents of your README file
from os import path
this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, 'readme.md'), encoding='utf-8') as f:
    long_description = f.read()

setup(name="weaviate-classification",
      version="0.1.10",
      description="A weaviate python data classification module.",
      long_description=long_description,
      long_description_content_type='text/markdown',
      author="SeMI Technologies",
      author_email="hello@semi.technology",
      packages=["weaviate_classification"],
      python_requires='>=3.6',
      install_requires=[
        "weaviate-client>=2.2.1",
        "PyYAML==5.3.1",
        "openpyxl==3.0.5"]),
