## wiki-con - A console app that displays random facts using the Wikipedia API

[![Tests](https://github.com/kevinbowen777/wiki-con/workflows/Tests/badge.svg)](https://github.com/kevinbowen777/wiki-con/actions?workflow=Tests)
[![PyPI](https://img.shields.io/pypi/v/wiki-con.svg)](https://pypi.org/project/wiki-con/)
[![Read the Docs](https://readthedocs.org/projects/wiki-con/badge/)](https://wiki-con.readthedocs.io/)

`wiki-con` is a simple CLI-based application that displays random facts using the Wikipedia API. The main focus of this repository is the implementation of various testing components and practices for the release and packaging of a Python project.


### Installation
 - `git clone https://github.com/kevinbowen777/wiki-con.git`
 - `cd wiki-con`
 - `poetry run wiki_con`

---
### Packages:
 - TestPyPi: https://test.pypi.org/project/wiki-con/
 - PyPi: https://pypi.org/project/wiki-con/

---
## Features
 - Testing
     - pytest
     - coverage
     - nox
     - pytest-mock
 - Linting
     - Black
     - Flake8
       - flake8-annotations
       - flake8-bandit
       - flake8-black
       - flake8-bugbear
       - flake8-docstrings
       - flake8-import-order
       - darglint
     - Safety
     - pre-commit
 - Typing

---
[![License](https://img.shields.io/badge/license-MIT-green)](https://github.com/kevinbowen777/wiki-con/blob/master/LICENSE)
---
### Reporting Bugs

   Visit the [Issues page](https://github.com/kevinbowen777/wiki-con/issues) to view currently open bug reports or open a new issue.
