# Generated by Django 3.2.5 on 2021-10-04 10:05

from django.db import migrations, models


class Migration(migrations.Migration):
    def add_slug(apps, _):
        from django.utils.text import slugify

        for term in apps.get_model("core.Term").objects.all():
            term.slug = slugify(term.term)
            n = 1
            while apps.get_model("core.Term").objects.filter(slug=term.slug).exists():
                term.slug = slugify(term.term) + str(n)
                n += 1

            term.save()

    dependencies = [
        ("core", "0017_remove_person_categories"),
    ]

    operations = [
        migrations.AddField(
            model_name="term",
            name="slug",
            field=models.CharField(
                default="", max_length=255, verbose_name="Slug", blank=True
            ),
            preserve_default=False,
        ),
        migrations.RunPython(add_slug, migrations.RunPython.noop),
    ]
