# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['utils_ak',
 'utils_ak.architecture',
 'utils_ak.architecture.finite_state_machine',
 'utils_ak.architecture.func',
 'utils_ak.architecture.integrity_guard',
 'utils_ak.architecture.operation',
 'utils_ak.architecture.sink',
 'utils_ak.async_tools',
 'utils_ak.aws',
 'utils_ak.block_tree',
 'utils_ak.block_tree.pushers',
 'utils_ak.builtin',
 'utils_ak.callback_timer',
 'utils_ak.clock',
 'utils_ak.color',
 'utils_ak.config',
 'utils_ak.dag',
 'utils_ak.deployment',
 'utils_ak.deployment.controller',
 'utils_ak.deployment.controller.controllers',
 'utils_ak.deployment.example',
 'utils_ak.dict',
 'utils_ak.exceptions',
 'utils_ak.fluid_flow',
 'utils_ak.fluid_flow.actors',
 'utils_ak.fluid_flow.tests',
 'utils_ak.functions',
 'utils_ak.git',
 'utils_ak.golang',
 'utils_ak.granular_storage',
 'utils_ak.granular_storage.df',
 'utils_ak.granular_storage.df.file',
 'utils_ak.granular_storage.df.gran_df',
 'utils_ak.granular_storage.storage',
 'utils_ak.granular_storage.table',
 'utils_ak.granular_storage.table.timeseries',
 'utils_ak.iteration',
 'utils_ak.json',
 'utils_ak.jupyter',
 'utils_ak.kafka',
 'utils_ak.log',
 'utils_ak.loguru',
 'utils_ak.message_queue',
 'utils_ak.message_queue.brokers',
 'utils_ak.message_queue.brokers.examples',
 'utils_ak.message_queue.clients',
 'utils_ak.messenger',
 'utils_ak.messenger.slack',
 'utils_ak.mongo_job_queue',
 'utils_ak.mongo_job_queue.worker',
 'utils_ak.mongo_job_queue.worker.test',
 'utils_ak.mongoengine',
 'utils_ak.naming',
 'utils_ak.networking',
 'utils_ak.networking.proxy',
 'utils_ak.nn',
 'utils_ak.numeric',
 'utils_ak.openpyxl',
 'utils_ak.os',
 'utils_ak.pandas',
 'utils_ak.pandas_writer',
 'utils_ak.plot',
 'utils_ak.portion',
 'utils_ak.properties',
 'utils_ak.properties.archive',
 'utils_ak.proxy',
 'utils_ak.re',
 'utils_ak.reflexion',
 'utils_ak.script_manager',
 'utils_ak.scripts',
 'utils_ak.serialization',
 'utils_ak.simple_event_manager',
 'utils_ak.simple_microservice',
 'utils_ak.simple_microservice.examples',
 'utils_ak.simple_vector',
 'utils_ak.split_file',
 'utils_ak.ssh',
 'utils_ak.state',
 'utils_ak.state.provider',
 'utils_ak.str',
 'utils_ak.streaming',
 'utils_ak.streaming.windowing',
 'utils_ak.system',
 'utils_ak.time',
 'utils_ak.tqdm',
 'utils_ak.zmq',
 'utils_ak.zmq.benchmark']

package_data = \
{'': ['*'],
 'utils_ak.deployment': ['controller/controllers/data/123/*'],
 'utils_ak.log': ['logs/*'],
 'utils_ak.mongo_job_queue': ['data/docker-compose/601fb3b2fae079694e9bffc6/*',
                              'data/docker-compose/601fb5e86d7bcff9e4bb2e8e/*',
                              'data/docker-compose/601fb62c3b2e4db2e22bcb5d/*',
                              'data/docker-compose/601fb75839b1782336a7526a/*',
                              'data/docker-compose/601fb83c47748754f032ed2f/*',
                              'data/docker-compose/601fb8b4ecb47ccfedca6ff8/*',
                              'data/docker-compose/601fb90f5a68d5fb8bcb1917/*',
                              'data/docker-compose/601fb945e561bd6721cf1c4f/*',
                              'data/docker-compose/601fba9228c92e888a8e0688/*',
                              'data/docker-compose/601ffb46bb447437ca90d7bf/*',
                              'data/docker-compose/6020028c0098c1f51119cc55/*',
                              'data/docker-compose/602129cf1cd00b24cb27b31c/*',
                              'data/kubernetes/601fbb5002f5d3c83008580d/*',
                              'data/kubernetes/6020033d6a02e816b4b114a7/*',
                              'data/kubernetes/60212a51a66ecefe66120c0a/*',
                              'data/kubernetes/60212c15c601175c48bf8a53/*',
                              'data/kubernetes/60212d461d8bad556bd388ae/*',
                              'data/kubernetes/60212deec77a775d132a6f48/*',
                              'data/kubernetes/60212e2b078151797a094266/*',
                              'data/kubernetes/60212e6aa5b45b4bd9e16de1/*',
                              'data/kubernetes/602137b92ff441fe7bdf2bcc/*',
                              'data/kubernetes/602137ba2ff441fe7bdf2bcd/*',
                              'data/kubernetes/602137d82ff441fe7bdf2bce/*',
                              'data/kubernetes/6021393630b8552bbe7ba5b8/*',
                              'data/kubernetes/6021394530b8552bbe7ba5b9/*',
                              'data/kubernetes/602139f8ef7d97c515cdff53/*',
                              'data/kubernetes/6021648d23146081340fa8a8/*',
                              'data/kubernetes/602164c923146081340fa8a9/*',
                              'worker/test/data/docker-compose/deployment_id/*']}

install_requires = \
['Delorean>=1.0.0,<2.0.0',
 'GitPython>=3.1.9,<4.0.0',
 'PyYAML>=5.4.1,<6.0.0',
 'anyconfig>=0.9.11,<0.10.0',
 'boto3>=1.15.18,<2.0.0',
 'empyrical>=0.5.5,<0.6.0',
 'filelock>=3.0.12,<4.0.0',
 'fire>=0.4.0,<0.5.0',
 'h5py>=2.10.0,<3.0.0',
 'joblib>=0.17.0,<0.18.0',
 'loguru>=0.5.3,<0.6.0',
 'mongoengine>=0.22.1,<0.23.0',
 'msgpack>=1.0.2,<2.0.0',
 'numpy>=1.19.2,<2.0.0',
 'opencv-python>=4.4.0,<5.0.0',
 'openpyxl>=3.0.6,<4.0.0',
 'pandas>=1.1.3,<2.0.0',
 'paramiko>=2.7.2,<3.0.0',
 'pathlib>=1.0.1,<2.0.0',
 'pickleDB>=0.9.2,<0.10.0',
 'portion>=2.1.4,<3.0.0',
 'pymongo>=3.11.0,<4.0.0',
 'pyperclip>=1.8.1,<2.0.0',
 'pyzmail36>=1.0.4,<2.0.0',
 'pyzmq>=19.0.2,<20.0.0',
 'requests-futures>=1.0.0,<2.0.0',
 'retrypy>=0.0.33,<0.0.34',
 'scp>=0.13.2,<0.14.0',
 'seaborn>=0.11.0,<0.12.0',
 'slacker>=0.14.0,<0.15.0',
 'sortedcollections>=2.1.0,<3.0.0',
 'stackprinter>=0.2.5,<0.3.0',
 'telegram>=0.0.1,<0.0.2',
 'tenacity>=6.2.0,<7.0.0',
 'tqdm>=4.50.2,<5.0.0']

setup_kwargs = {
    'name': 'utils-ak',
    'version': '0.1.4',
    'description': 'Lots of small utils',
    'long_description': None,
    'author': 'akadaner',
    'author_email': 'arseniikadaner@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
