# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['stalcraft']

package_data = \
{'': ['*'], 'stalcraft': ['data/global/*', 'data/ru/*']}

install_requires = \
['pytz>=2021.1,<2022.0', 'requests>=2.25.1,<3.0.0']

setup_kwargs = {
    'name': 'stalcraft-api',
    'version': '0.2.5',
    'description': 'stalcraft api unofficial python library',
    'long_description': '<h1 align="center">stalcraft-api unofficial python library</h1>\n\n<p align="center">\n    <a href="https://pypi.org/project/stalcraft-api" alt="PyPi Package Version">\n        <img src="https://img.shields.io/pypi/v/stalcraft-api.svg?style=flat-square"/></a>\n    <a href="https://pypi.org/project/stalcraft-api" alt="Supported python versions">\n        <img src="https://img.shields.io/pypi/pyversions/stalcraft-api.svg?style=flat-square"/></a>\n    <a href="https://opensource.org/licenses/MIT" alt="MIT License">\n        <img src="https://img.shields.io/pypi/l/aiogram.svg?style=flat-squar"/></a>\n</p>\n\n\n<br>\n\n<p align="center">\n    <b>Official API documentation:</b> https://eapi.stalcraft.net\n</p>\n<p align="center">\n    <b>Before you can use the API, you must register your application and receive approval<b>\n</p>\n<p align="center">\n    <b>For testing Demo API is available<b>\n</p>\n<p align="center">\n    <a href="https://eapi.stalcraft.net/registration.html">more about applications</a>\n</p>\n\n\n<br>\n\n# 🔧 Install\n\n### Pip\n\n```console\npip install stalcraft-api --upgrade\n```\n\n<details>\n<summary>Manual</summary>\n\n```console\ngit clone git@github.com:onejeuu/stalcraft-api.git\n```\n\n```console\ncd stalcraft-api\n```\n\n```console\npip install -r requirements.txt\n```\n</details>\n\n\n<br>\n\n# ⚡ Quick Start\n\n```python\nfrom stalcraft import AppClient\n\nTOKEN = "YOUR_TOKEN"\n\nclient = AppClient(token=TOKEN)\n```\n\n\n<br>\n\n# 📎 Usage Examples\n\n<details>\n<summary>App Client</summary>\n\n```python\nfrom stalcraft import AppClient, Region, Sort, Order\n\nCLIENT_ID = "YOUR_CLIENT_ID"\nCLIENT_SECRET = "YOUR_CLIENT_SECRET"\n\nTOKEN = "YOUR_TOKEN"\n\n# Method 1:\nclient = AppClient(token=TOKEN)\n\n# Method 2:\nclient = AppClient(client_id=CLIENT_ID, client_secret=CLIENT_SECRET)\n\nprint()\nprint("List of regions")\nprint(client.regions())\n\nprint()\nprint("List of clans with limit 2")\nprint(client.clans(limit=2))\n\nprint()\nprint("Information about emission on NA server")\nprint(client.emission(Region.NA))\n\nprint()\nprint("List of lots for item with id \'1r756\'")\nprint("With offset 5, limit 2, sort by buyout price and order by descending")\nprint(client.auction("1r756").lots(offset=5, limit=2, sort=Sort.BUYOUT_PRICE, order=Order.DESC))\n\nprint()\nprint("List of price history for item with id \'1r756\'")\nprint(client.auction("1r756").price_history())\n\nprint()\nprint("Information about clan with id \'562968e7-4282-4ac6-900f-f7f1581495e8\'")\nprint(client.clan("562968e7-4282-4ac6-900f-f7f1581495e8").info())\n```\n\n</details>\n\n\n<br>\n\n<details>\n<summary>User Client</summary>\n\n```python\nfrom stalcraft import UserClient, BaseUrl, Region\n\nTOKEN = "YOUR_TOKEN"\n\nclient = UserClient(token=TOKEN, base_url=BaseUrl.DEMO)\n\n# + all methods from AppClient\n\nprint("List of characters created by the user on EU server by which used access token was provided")\nprint(client.characters(Region.EU))\n\nprint()\nprint("List of friends character names who are friend with \'Test-1\'")\nprint(client.friends("Test-1"))\n\n\n# Members in clan with id \'562968e7-4282-4ac6-900f-f7f1581495e8\'\n# (Can be used only when using user access token and that user has at least one character in that clan)\n# client.clan("562968e7-4282-4ac6-900f-f7f1581495e8").members()\n\n#\n# Information about player\'s profile. Includes alliance, profile description, last login time, stats, etc.\n# (Not working in DEMO API)\n# client.character_profile("ZIV")\n```\n\n</details>\n\n\n<br>\n\n<details>\n<summary>Find Item ID by name</summary>\n\n```python\nfrom stalcraft import AppClient, LocalItem, WebItem, ItemFolder\n\nTOKEN = "YOUR_TOKEN"\n\nclient = AppClient(token=TOKEN)\n\nprint()\nprint("Search by local file")\nprint(client.auction(LocalItem("Snowflake")).lots())\n\nprint()\nprint("(Not reliable)")\nprint("Search by listing.json in stalcraft-database github repository")\nprint(client.auction(WebItem("Snowflake", folder=ItemFolder.GLOBAL)).lots())\n```\n\n</details>\n\n\n<br>\n\n<details>\n<summary>Exceptions</summary>\n\n```python\nfrom stalcraft import UserClient, LocalItem\n\nfrom stalcraft.exceptions import (\n    InvalidToken, StalcraftApiException, ItemException\n)\n\nTOKEN = "YOUR_TOKEN"\n\nclient = UserClient(token=TOKEN)\n\ndef handle_exception(func, exception):\n    try:\n        func()\n    except exception as e:\n        print("Error:", e)\n\nprint()\nprint("If token is invalid")\nhandle_exception(lambda: UserClient("test1234567890"), InvalidToken)\n\nprint()\nprint("If an item with that name does not exist")\nhandle_exception(lambda: LocalItem("test"), ItemException)\n\nprint()\nprint("If one of parameters is invalid")\nhandle_exception(lambda: client.auction("test").price_history(), StalcraftApiException)\n```\n\n</details>\n\n\n<br>\n\n# 🔑 About Tokens\n\n### Get User and App Token\n\n```python\nCLIENT_ID = "YOUR_CLIENT_ID"\nCLIENT_SECRET = "YOUR_CLIENT_SECRET"\n\nauth = Authorization(client_id=CLIENT_ID, client_secret=CLIENT_SECRET)\n\nprint()\nprint("Get App Token")\nprint(auth.get_app_token())\n\nprint()\nprint("Get User Code")\nprint(auth.get_user_code())\n\nauth.input_code()\n\n# or\n# auth.code = "USER_CODE"\n\nprint()\nprint("Get User Token")\nprint(auth.get_user_token())\n```\n\n### Refresh User Token\n\n```python\nCLIENT_ID = "YOUR_CLIENT_ID"\nCLIENT_SECRET = "YOUR_CLIENT_SECRET"\n\nauth = Authorization(client_id=CLIENT_ID, client_secret=CLIENT_SECRET)\n\nREFRESH_TOKEN = "USER_REFRESH_TOKEN"\n\nprint()\nprint("Refresh User Token")\nprint(auth.update_token(REFRESH_TOKEN))\n```\n\n\n<br>\n\n# 📋 Output Formats\n\n```python\nfrom stalcraft import AppClient\n\n# Optional\nfrom rich import print\n\nTOKEN = "YOUR_TOKEN"\n\nclient = AppClient(token=TOKEN)\n\nprint()\nprint("Object:")\nprint(client.emission())\n\n# or client = AppClient(TOKEN, json=True)\nclient.json = True\n\nprint()\nprint("Json:")\nprint(client.emission())\n```\n\n### Output:\n\n```python\nObject:\nEmission(\n    current_start=None,\n    previous_start=datetime.datetime(2023, 1, 30, 5, 16, 52, tzinfo=datetime.timezone.utc),\n    previous_end=datetime.datetime(2023, 1, 30, 5, 21, 52, tzinfo=datetime.timezone.utc)\n)\n\nJson:\n{\n    \'previousStart\': \'2023-01-30T05:16:52Z\',\n    \'previousEnd\': \'2023-01-30T05:21:52Z\'\n}\n```\n',
    'author': 'onejeuu',
    'author_email': 'bloodtrail@beber1k.ru',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
