// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays all the actions that are available for general update
 * events, like undo and redo
 */
const ToolbarEditDropdown = (props) => {
    return (React.createElement(React.Fragment, null, props.uiState.currOpenToolbarDropdown === 'Edit' &&
        React.createElement(Dropdown, { closeDropdown: () => props.setUIState((prevUIState) => {
                if (prevUIState.currOpenToolbarDropdown === 'Edit') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'medium' },
            makeToolbarDropdownItem(props.actions[ActionEnum.Undo]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Redo]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Clear]))));
};
export default ToolbarEditDropdown;
//# sourceMappingURL=ToolbarEditDropdown.js.map