// Copyright (c) Mito
import React, { Fragment, useState } from 'react';
import { DISCORD_INVITE_LINK } from '../../data/documentationLinks';
import { overwriteAnalysisToReplayToMitosheetCall } from '../../jupyter/jupyterUtils';
import DefaultModal from '../DefaultModal';
import TextButton from '../elements/TextButton';
import { ModalEnum } from './modals';
/*
    This modal displays to the user when:
    1. the analysis that they are replaying does not exist on their computer
    2. the analysis errors during replay for some other reason
*/
const ErrorReplayedAnalysisModal = (props) => {
    var _a, _b;
    const [viewTraceback, setViewTraceback] = useState(false);
    return (React.createElement(DefaultModal, { header: props.header, modalType: ModalEnum.Error, wide: true, viewComponent: React.createElement(Fragment, null,
            React.createElement("div", { className: 'text-align-left text-body-1', onClick: () => setViewTraceback((viewTraceback) => !viewTraceback) },
                props.message,
                " ",
                ' ',
                ((_a = props.error) === null || _a === void 0 ? void 0 : _a.traceback) &&
                    React.createElement("span", { className: 'text-body-1-link' }, "Click to view full traceback.")),
            ((_b = props.error) === null || _b === void 0 ? void 0 : _b.traceback) && viewTraceback &&
                React.createElement("div", { className: 'flex flex-column text-align-left text-overflow-hidden text-overflow-scroll mt-5px', style: { height: '200px', border: '1px solid var(--mito-purple)', borderRadius: '2px', padding: '5px' } },
                    React.createElement("pre", null, props.error.traceback))), buttons: React.createElement(React.Fragment, null,
            React.createElement(TextButton, { variant: 'light', width: 'medium', href: DISCORD_INVITE_LINK, target: '_blank' }, "Get Support"),
            React.createElement(TextButton, { variant: 'dark', width: 'medium', onClick: () => {
                    overwriteAnalysisToReplayToMitosheetCall(props.oldAnalysisName, props.newAnalysisName, props.mitoAPI);
                    props.setUIState((prevUIState) => {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
                    });
                } }, "Start New Analysis")) }));
};
export default ErrorReplayedAnalysisModal;
//# sourceMappingURL=ReplayAnalysisModals.js.map