import { getDisplayColumnHeader, isPrimitiveColumnHeader, rowIndexToColumnHeaderLevel } from "../../utils/columnHeaders";
import { TaskpaneType } from "../taskpanes/taskpanes";
export const submitRenameColumnHeader = (columnHeader, finalColumnHeader, columnID, sheetIndex, editorState, setUIState, mitoAPI) => {
    // Only submit the formula if it actually has changed
    const newColumnHeader = (editorState === null || editorState === void 0 ? void 0 : editorState.formula) || getDisplayColumnHeader(finalColumnHeader);
    const oldColumnHeader = getDisplayColumnHeader(finalColumnHeader);
    if (newColumnHeader !== oldColumnHeader) {
        const levelIndex = isPrimitiveColumnHeader(columnHeader) ? undefined : rowIndexToColumnHeaderLevel(columnHeader, -1);
        void mitoAPI.editRenameColumn(sheetIndex, columnID, newColumnHeader, levelIndex);
        // Close the taskpane if you do a rename, so that we don't get errors
        // with live updating (e.g. editing a pivot, do a rename, try to edit
        // the same pivot).
        setUIState(prevUIState => {
            if (prevUIState.currOpenTaskpane.type !== TaskpaneType.CONTROL_PANEL) {
                return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.NONE } });
            }
            return prevUIState;
        });
    }
};
//# sourceMappingURL=columnHeaderUtils.js.map