# line-bot-tool
LINEBot用の便利ツール

## PIP
pipからインストール可能
```sh
$ pip install line-bot-tool
```

## Usage
LINEBotで使用するコマンドを生成

```sh
$ lb-tool gen:command help
Generate success! commands/help_command.py
```

デフォルトで `./commands` 配下に生成される。

環境変数 `COMMAND_OUTPUT_PATH` に設定することで、生成されるファイルの保存場所を変更できる。

生成されたファイル

```python
# Generated by CommandGenerator on 2021-06-23 20:55:00

from typing import Optional, Tuple
from line_bot_tool.base.commnad import BaseCommand
from . import settings


class HelpCommand(BaseCommand):
    prefixes: Optional[Tuple[str, ...]] = settings.PREFIXES
    cmd: str = 'help'
    description: str = 'Please input here command description.'
```

同じ階層のディレクトリに `settings.py` が生成される。

```python
# Generated by CommandGenerator on 2021-06-23 20:55:00

from typing import Optional, Tuple
PREFIXES: Optional[Tuple[str, ...]] = ('/', '@')
```

`PREFIXES` の値を書き換えることでコマンドの接頭辞を設定できる。

接頭辞が費用な場合は、`None` を入れる。

```python
from commands.help_command import HelpCommand

HelpCommand.is_executable('/help')  # True
HelpCommand.is_executable('@help')  # True
HelpCommand.is_executable('help')  # False
```

**引数があるコマンドの場合**

例えば、`/name:引数` というコマンド（引数にユーザーIDを指定し、名前を返す）がある場合、以下のようにコマンドの生成、判定を行う。

また、接頭辞は `/` のみとする。

```sh
$ lb-tool gen:command name
Generate success! commands/name_command.py
```

`commands/name_command.py` を少し書き換え。

```diff
# Generated by CommandGenerator on 2021-06-23 21:34:39

from typing import Optional, Tuple
from line_bot_tool.base.commnad import BaseCommand
from . import settings


class NameCommand(BaseCommand):
-   prefixes: Optional[Tuple[str, ...]] = settings.PREFIXES
-   cmd: str = 'name'
+   prefixes: Optional[Tuple[str, ...]] = ('/')
+   cmd: str = 'name:'
    description: str = 'Please input here command description.'
```

```python
from commands.name_command import NameCommand

NameCommand.is_executable_with_arg('/name:UXXXXXXXXXX')  # True, UXXXXXXXXXX

# セイウチ演算子を使って書く
if (result := NameCommand.is_executable_with_arg('/name:UXXXXXXXXXX'))[0]:
    print(result[1])  # UXXXXXXXXXX
```
