"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlureeConn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const flureenjs = require("@fluree/flureenjs");
const globalAny = global;
globalAny.XMLHttpRequest = require("xhr2");
globalAny.WebSocket = require("ws");
/**
 * @experimental
 */
class FlureeConn {
    /**
     * @experimental
     */
    constructor(props) {
        this.url = props.url;
        this.conn = this.connect();
    }
    /**
     * @experimental
     */
    connect() {
        const conn = flureenjs.connect_p(this.url, {}).then((c) => { return c; }).catch((e) => { return e; });
        return conn;
    }
    /**
     * @experimental
     */
    async getDb(ledger) {
        const conn = await this.conn;
        return flureenjs.db_p(conn, ledger).then((d) => { return d; });
    }
    /**
     * @experimental
     */
    async query(ledger, query) {
        await this.waitUntilReady(ledger);
        const db = await this.getDb(ledger);
        const results = await flureenjs.query(db, query).then((resp) => { return resp; }).catch((e) => console.log(e));
        return results;
    }
    /**
     * @experimental
     */
    async transact(ledger, transaction) {
        const conn = await this.conn;
        await this.waitUntilReady(ledger);
        const results = await flureenjs.transact(conn, ledger, transaction).then((resp) => { return resp; }).catch((e) => console.log(e));
        return results;
    }
    /**
     * @experimental
     */
    async waitUntilReady(name) {
        try {
            const conn = await this.conn;
            var results = await flureenjs.ledger_info(conn, name);
            var retries = 0;
            var ready = (results["status"] === "ready");
            while (retries < 10 && !ready) {
                retries++;
                await new Promise(resolve => setTimeout(resolve, 500));
                results = await flureenjs.ledger_info(conn, name);
                ready = (results["status"] === "ready");
            }
            if (ready) {
                console.log(`${name} is ready`);
            }
            else {
                throw new Error(`Timeout ${name} not ready`);
            }
        }
        catch (error) {
            console.log(error);
        }
    }
    /**
     * @experimental
     */
    async newLedger(name) {
        try {
            const conn = await this.conn;
            const result = await flureenjs.new_ledger(conn, name);
            await this.waitUntilReady(name);
            return result;
        }
        catch (error) {
            console.log(error);
        }
    }
    /**
     * @experimental
     */
    async ledgerList() {
        try {
            const conn = await this.conn;
            const results = await flureenjs.ledger_list(conn);
            return results;
        }
        catch (error) {
            console.log(error);
        }
    }
}
exports.FlureeConn = FlureeConn;
_a = JSII_RTTI_SYMBOL_1;
FlureeConn[_a] = { fqn: "fluree-jsii.FlureeConn", version: "1.0.3" };
//# sourceMappingURL=data:application/json;base64,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