declare module "@fluree/flureenjs" {

		type LedgerName = string;
	
		type Conn = object;
	
		type Db = object;
	
		type ServerString = string;
	
		type KeepAliveFn = () => void;
	
		type QueryOpts = object;
	
		type Results = string | number;
	
		type ResultsObject = {
			[index: string]: any;
		};
	
		type ConnOptions = {
			keepAlive?: boolean;
			"keep-alive-fn"?: KeepAliveFn;
		};
	
		type BaseQuery = {
			from?: string | string[] | number;
			where?: string | string[] | string[][] | object;
			block?: number | string;
			prefixes?: object;
			vars?: object;
			opts?: object;
		};
	
		type SelectQuery = BaseQuery & { select: string | string[] | object };
	
		type SelectOneQuery = BaseQuery & { selectOne: string | string[] | object };
	
		type Query = SelectQuery | SelectOneQuery;
	
		type MultiQuery = {
			[index: string]: SelectQuery;
		};

		type LoggingLevel = {
			level: string;
		}
	
		type TransactionArray = Array<string | unknown>;
	
		export function db_p(conn: Conn, ledger: LedgerName): Promise<Db>;
	
		export function connect_p(
			server: ServerString,
			opts: ConnOptions
		): Promise<Conn>;
	
		export function query(
			db: Db,
			query: Query,
			options?: QueryOpts
		): Promise<any>;
	
		export function password_login(
			conn: Conn,
			ledger: LedgerName,
			pwd: string,
			user: string,
			expire: number
		): Promise<string>;
	
		export function multi_query(
			db: Db,
			query: object,
			options?: QueryOpts
		): ResultsObject;
	
		export function set_logging(level: LoggingLevel): any;
	
		export function transact(
			conn: Conn,
			ledger: LedgerName,
			txArray: TransactionArray,
			opts?: object
		): Promise<ResultsObject>;
	
		export function new_ledger(
			conn: Conn,
			ledger: LedgerName,
			opts?: object
		): Promise<any>;

		export function ledger_list(
			conn: Conn
		): Promise<any>;

		export function ledger_info(
			conn: Conn,
			ledger: LedgerName,
		): Promise<any>;
	
		export function password_generate(
			conn: Conn,
			ledger: LedgerName,
			password: string,
			username: string,
			opts?: object
		): Promise<ResultsObject>;
	
		export {
			QueryOpts,
			Results,
			Conn,
			Db,
			ConnOptions,
			ServerString,
			LedgerName,
			Query,
			MultiQuery,
			TransactionArray,
			ResultsObject,
			SelectQuery
		};
}
