# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dexteritysdk',
 'dexteritysdk.bots',
 'dexteritysdk.codegen',
 'dexteritysdk.codegen.alpha_risk_engine',
 'dexteritysdk.codegen.alpha_risk_engine.instructions',
 'dexteritysdk.codegen.alpha_risk_engine.types',
 'dexteritysdk.codegen.dex',
 'dexteritysdk.codegen.dex.instructions',
 'dexteritysdk.codegen.dex.types',
 'dexteritysdk.codegen.instruments',
 'dexteritysdk.codegen.instruments.instructions',
 'dexteritysdk.codegen.instruments.types',
 'dexteritysdk.codegen.noop_risk_engine',
 'dexteritysdk.codegen.noop_risk_engine.instructions',
 'dexteritysdk.codegen.risk_engine',
 'dexteritysdk.codegen.risk_engine.instructions',
 'dexteritysdk.codegen.risk_engine.types',
 'dexteritysdk.constant_fees',
 'dexteritysdk.dex',
 'dexteritysdk.dummy_oracle',
 'dexteritysdk.dummy_oracle.instructions',
 'dexteritysdk.dummy_oracle.state',
 'dexteritysdk.instruments',
 'dexteritysdk.instruments.instructions',
 'dexteritysdk.pyserum',
 'dexteritysdk.pyserum.layouts',
 'dexteritysdk.pyserum.structs',
 'dexteritysdk.risk',
 'dexteritysdk.scripts',
 'dexteritysdk.solmate',
 'dexteritysdk.solmate.anchor',
 'dexteritysdk.utils',
 'dexteritysdk.utils.aob',
 'dexteritysdk.utils.aob.state']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.0.3,<4.0.0',
 'MarkupSafe>=2.0.1,<3.0.0',
 'OSlash>=0.6.3,<0.7.0',
 'Pillow>=9.0.1,<10.0.0',
 'PyNaCl>=1.5.0,<2.0.0',
 'Pygments>=2.11.2,<3.0.0',
 'QtPy>=2.0.1,<3.0.0',
 'Send2Trash>=1.8.0,<2.0.0',
 'aiodns>=3.0.0,<4.0.0',
 'aiohttp>=3.8.1,<4.0.0',
 'aiosignal>=1.2.0,<2.0.0',
 'anyio>=3.5.0,<4.0.0',
 'appnope>=0.1.2,<0.2.0',
 'argon2-cffi>=21.3.0,<22.0.0',
 'argparse>=1.4.0,<2.0.0',
 'async-timeout>=4.0.2,<5.0.0',
 'attrs>=21.4.0,<22.0.0',
 'backcall>=0.2.0,<0.3.0',
 'backoff>=1.11.1,<2.0.0',
 'base58>=2.1.1,<3.0.0',
 'bleach>=4.1.0,<5.0.0',
 'borsh-construct>=0.1.0,<0.2.0',
 'certifi>=2021.10.8,<2022.0.0',
 'cffi>=1.15.0,<2.0.0',
 'charset-normalizer>=2.0.12,<3.0.0',
 'construct-typing>=0.5.2,<0.6.0',
 'construct>=2.10.67,<3.0.0',
 'cryptography>=36.0.1,<37.0.0',
 'cycler>=0.11.0,<0.12.0',
 'debugpy>=1.5.1,<2.0.0',
 'decorator>=5.1.1,<6.0.0',
 'defusedxml>=0.7.1,<0.8.0',
 'dnspython>=2.2.0,<3.0.0',
 'entrypoints>=0.4,<0.5',
 'flake8>=4.0.1,<5.0.0',
 'frozenlist>=1.3.0,<2.0.0',
 'h11==0.12.0',
 'idna>=3.3,<4.0',
 'ipykernel>=6.9.0,<7.0.0',
 'ipython>=8.0.1,<9.0.0',
 'ipython_genutils>=0.2.0,<0.3.0',
 'ipywidgets>=7.6.5,<8.0.0',
 'jedi>=0.18.1,<0.19.0',
 'jsonrpcclient>=4.0.2,<5.0.0',
 'jsonrpcserver>=5.0.6,<6.0.0',
 'jsonschema==3.2.0',
 'jupyter-client>=7.1.2,<8.0.0',
 'jupyter-console>=6.4.0,<7.0.0',
 'jupyter-core>=4.9.1,<5.0.0',
 'jupyter>=1.0.0,<2.0.0',
 'jupyterlab-pygments>=0.1.2,<0.2.0',
 'jupyterlab-widgets>=1.0.2,<2.0.0',
 'kiwisolver>=1.3.2,<2.0.0',
 'loguru>=0.6.0,<0.7.0',
 'matplotlib-inline>=0.1.3,<0.2.0',
 'matplotlib>=3.5.1,<4.0.0',
 'mccabe==0.6.1',
 'mistune==0.8.4',
 'multidict>=6.0.2,<7.0.0',
 'nbclient>=0.5.10,<0.6.0',
 'nbconvert==6.2',
 'nbformat>=5.1.3,<6.0.0',
 'nest-asyncio>=1.5.4,<2.0.0',
 'notebook>=6.4.8,<7.0.0',
 'numpy>=1.22.2,<2.0.0',
 'packaging>=21.3,<22.0',
 'pandas>=1.4.1,<2.0.0',
 'pandocfilters>=1.5.0,<2.0.0',
 'parso>=0.8.3,<0.9.0',
 'pexpect>=4.8.0,<5.0.0',
 'pickleshare>=0.7.5,<0.8.0',
 'podite==0.1.2',
 'prometheus-client>=0.13.1,<0.14.0',
 'prompt-toolkit>=3.0.28,<4.0.0',
 'ptyprocess>=0.7.0,<0.8.0',
 'pycares>=4.1.2,<5.0.0',
 'pycodestyle>=2.8.0,<3.0.0',
 'pycparser>=2.21,<3.0',
 'pyflakes>=2.4.0,<3.0.0',
 'pyparsing>=3.0.7,<4.0.0',
 'pyrsistent>=0.18.1,<0.19.0',
 'pythclient>=0.1.2,<0.2.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'pytz>=2022.1,<2023.0',
 'pyzmq>=22.3.0,<23.0.0',
 'qtconsole>=5.2.2,<6.0.0',
 'requests>=2.27.1,<3.0.0',
 'rfc3986==1.5',
 'six>=1.16.0,<2.0.0',
 'sniffio>=1.2.0,<2.0.0',
 'solana>=0.28.0,<0.29.0',
 'terminado>=0.13.1,<0.14.0',
 'testpath>=0.5.0,<0.6.0',
 'tornado>=6.1,<7.0',
 'traitlets>=5.1.1,<6.0.0',
 'types-cachetools>=4.2.9,<5.0.0',
 'typing-extensions==4.2.0',
 'urllib3>=1.26.8,<2.0.0',
 'wcwidth>=0.2.5,<0.3.0',
 'webencodings>=0.5.1,<0.6.0',
 'websockets>=10.1,<11.0',
 'widgetsnbextension>=3.5.2,<4.0.0',
 'yarl>=1.7.2,<2.0.0']

entry_points = \
{'console_scripts': ['bootstrap = dexteritysdk.bots.bootstrap:main',
                     'connect = dexteritysdk.bots.new_connect:main',
                     'discriminant = dexteritysdk.scripts.discriminant:main',
                     'extract-program-ids = '
                     'dexteritysdk.scripts.extract_program_ids:main',
                     'generate-code = dexteritysdk.scripts.generate_code:main',
                     'get-trader-risk-groups = '
                     'dexteritysdk.scripts.get_trader_risk_groups:main',
                     'keypair-to-b58 = '
                     'dexteritysdk.scripts.keypair_to_b58:main',
                     'local-validator = '
                     'dexteritysdk.scripts.start_test_validator:main']}

setup_kwargs = {
    'name': 'dexteritysdk',
    'version': '0.2.3',
    'description': 'Client for Dexterity - a modular derivatives decentralized exchange reference implementation',
    'long_description': '# Dexterity client SDK\n**Dexterity** is a derivatives decentralized exchange running on Solana.\nThis package provides the basic blocks in order to integrate and trade on Dexterity.\n\nYou can learn more about Dexterity [here](https://docs.hxro.network/market-protocols/derivatives-protocol/dexterity).\n\n## Prerequisites\n* [Solana.py](https://pypi.org/project/solana/)\n\n## Creating the client\nFirst, an instance of a Solana client is required.\n```python\nfrom dexteritysdk.dex.sdk_context import SDKContext, SDKTrader\nfrom solana.rpc.api import Client\nfrom solana.keypair import Keypair\nfrom solana.publickey import PublicKey\n\ndef main():\n\t# use "https://api.mainnet-beta.solana.com" for mainnet\n\tnetwork = "https://api.devnet.solana.com"\n\tclient = Client(network)\n```\n\nA Keypair for the payer has to also be provided.\n```python\nkeypair = Keypair.from_secret_key(keypair_bytes)\n```\nThe SDK also requires the **Market Product Group (MPG)** that we\'re going to trade on.\n\nThe public key of the default MPG is **`HiCy6vzuN3yLXD3z35D6nV7bzNLcyrvGLf3uSKuutSLo`** for mainnet or **`HyWxreWnng9ZBDPYpuYugAfpCMkRkJ1oz93oyoybDFLB`** for devnet.\n```python\n# mainnet MPG\nmpg = PublicKey("HiCy6vzuN3yLXD3z35D6nV7bzNLcyrvGLf3uSKuutSLo")\n\n# ** OR **\n# devnet MPG\nmpg = PublicKey("HyWxreWnng9ZBDPYpuYugAfpCMkRkJ1oz93oyoybDFLB")\n```\nNow, we\'re ready to get an instance of `SDKContext` for this MPG.\n```python\nctx = SDKContext.connect(\n\tclient=client,\n\tmarket_product_group_key=mpg,\n\tpayer=keypair,\n\traise_on_error=True\n)\n```\n\n## Registering new trader / TRG\nIf you\'re a new trader, creation of a trading account is required.\n```python\ntrader = ctx.register_trader(keypair)\ntrg_key = trader.account\n```\n\nThe **Trader Risk Group (TRG)** is your trading account, that you can now use.\n\n## Using an existing TRG\nIf you already have a trader set up, you need to provide the TRG public key for it.\nThe SDK allows you to list all your registered TRGs.\n```python\n# this will return a list of your all your TRG public keys\n# for example: [HeykeQWRh6DC2Tz5X3WBuWdMHicyECDEFGMjomV6LBye, HeyZNJ9gQVAEqHeCFFQ781E53d66DATKXHeynwnCFBye]\ntrg_keys = ctx.list_trader_risk_groups()\n```\n\nAfter finding your TRG, you can initialise the `SDKTrader` instance.\n```python\nfrom dexteritysdk.codegen.dex.types import TraderRiskGroup\nfrom dexteritysdk.program_ids import *\nfrom dexteritysdk.utils.solana import explore\n\n# ...\ntrader = SDKTrader.connect(ctx, trg_pubkey, keypair)\n```\n\n## Funding the TRG\nTo start trading, you need to deposit funds.\nThe tokens deposited have to be MPG vault mint tokens (e.g. USDC).\nThe wallet you provided will be debited.\n```python\n# this will deposit 733.1 USDC\ntrader.deposit(ctx, 733.1)\n```\n\nYou can also withdraw in a similar fashion.\n```python\n# this will withdraw 0.1 USDC back to your wallet\ntrader.withdraw(ctx, 0.1)\n```\n\nYou can check your balance at any time.\n```python\ntrader.get_trader_risk_group().cash_balance\n```\n\n## Trading on Dexterity\n\n### Listing trading products and order books\nThe `products` field of a `SDKContext` instance, is a list of the available trading products (`SDKProduct`).\nEvery `SDKProduct` has a `name` and a `get_orderbook(ctx)` function that will return its order book (`SDKOrderBook`).\nThe `SDKOrderBook` contains all `SDKOrders` on each side of the book.\n\nHere\'s an example:\n```python\nfor product in ctx.products:\n\tbook = product.get_orderbook(ctx, refresh=True)\n\tprint(f"Printing the order book of {product.name}")\n\tfor order in book.bids:\n\t\tprint(f"Bid of size {order.qty} at {order.price}")\n\tfor order in book.asks:\n\t\tprint(f"Ask of size {order.qty} at {order.price}")\n```\n\n### Placing an order\n\nPlacing an order is straightforward.\n```python\nfrom dexteritysdk.utils.aob import Side\n# ...\norder_summary = trader.place_order(ctx, product, Side.ASK, size, price)\n```\nThe returned `SDKOrderSummary` contains the `order_id` of the new order, as well as the `remaining_qty` and `filled_qty` if your order has been filled. If the order is immediately fully filled, `order_id` will be `None`.\n\nIf there\'s any error, an exception will be raised.\n\n### Cancelling orders\nTo cancel a previous order you can call `trader.cancel(ctx, product, order_id)`.\nFollowing the previous example:\n```python\ntrader.cancel(ctx, product, order_summary.order_id)\n```\n\nYou can also cancel all your open orders for multiple products.\n```python\n# products is a list of SDKProduct\n# if products list is empty or None, then all your open orders will be cancelled\nproducts = [ctx.products[0], ctx.products[2]]\ntrader.cancel_all_orders(ctx, products)\n```\nIf any cancel fails, an exception will be raised.\n\n### Positions\nPositions can also be listed, by iterating the `trader_positions` array:\n```python\ntrader.get_trader_risk_group().trader_positions\n```\n',
    'author': 'Joe Howarth',
    'author_email': 'josephehowarth@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
