# ded

<center><img src="grumpy.png" alt="Grumpy Ded"/></center>
<center>Helm dependency deduplication post-renderer</center>

## Installation

```shell
pip install ded
```

## Usage

This program collects all pre-rendered manifests from Helm and post-renders only those unique amongst them.

The uniqueness is determined based on the default or supplied YAML keys. The keys must exist in all of the supplied documents.

Invoke as `--post-renderer` during helm install/upgrade.

`ded` determines uniquiness based on values of the `kind` and `metadata.name` fields of each manifests. You can specify non-default keys by which the pre-rendered manifests from helm must be deduplicated:

```shell
  ded --key metadata.namespace
```

**IMPORTANT**: The keys used to determine uniquiness must be present in every manifest or `ded` will exit with code 1 and `helm install` or `helm upgrade` will consequently fail.

## Examples

The example below will filter all manifests based on values of `kind` and `metadata.name` fields.

```shell
helm install release-name your-chart/ --post-renderer ded
```

So, if there are 2 manifests in your Helm chart release with the same values on these fields, then only one of them will be left.

Manifest A:

```Yaml
apiVersion: v1
kind: ConfigMap
metadata:
  name: foo-cm
data:
  onedata: test
```

Manifest B:

```yaml
apiVersion: v1
kind: ConfigMap
metadata:
  name: foo-cm
data:
  twodata: test-test
```

In the example above only the first occuring manifest will make it to the output of the post-renderer.

Or invoke with a different set of keys:

```shell
helm install release-name your-chart/ --post-renderer ded --key metadata.name
```

More keys:

```shell
helm install release-name your-chart/ --post-renderer ded -k metadata.name --k data.onedata
```

## Why `ded`?

1. Because it's a shorthand for `deduplication`
2. Because *"ded"* means grandpa in *Russian*. And I was grumpy as hell when I was trying to deduplicate manifests generated by Helm.
3. Because dealing with subcharts and dependencies in Helm makes you a little *dead* inside.

Helm is ❤️
